/*
 * CmdINTERP.c --
 *
 * 	This file contains the dispatch tables for layout commands.
 *
 *     ********************************************************************* 
 *     * Copyright (C) 1985, 1990 Regents of the University of California. * 
 *     * Permission to use, copy, modify, and distribute this              * 
 *     * software and its documentation for any purpose and without        * 
 *     * fee is hereby granted, provided that the above copyright          * 
 *     * notice appear in all copies.  The University of California        * 
 *     * makes no representations about the suitability of this            * 
 *     * software for any purpose.  It is provided "as is" without         * 
 *     * express or implied warranty.  Export of this software outside     * 
 *     * of the United States of America may require an export license.    * 
 *     *********************************************************************
 */

#ifndef lint
static char rcsid[] = "$Header: /ufs/repository/magic/commands/CmdINTERP.c,v 1.8 2001/03/29 19:50:05 tim Exp $";
#endif  not lint

#include <stdio.h>
#include "misc/magic.h"
#include "utils/geometry.h"
#include "tiles/tile.h"
#include "utils/hash.h"
#include "database/database.h"
#include "windows/windows.h"
#include "dbwind/dbwind.h"
#include "main/main.h"
#include "commands/commands.h"
#include "textio/textio.h"
#include "textio/txcommands.h"

/*
 * User commands
 */

extern Void CmdAddPath(), CmdArray();
extern Void CmdBox(), CmdCalma(), CmdCellname(), CmdCif(), CmdChannel();
extern Void CmdClockwise(), CmdCopy(), CmdCorner();
extern Void CmdDelete(), CmdDown(), CmdDrc(), CmdDump();
extern Void CmdEdit(), CmdElement(), CmdErase(), CmdExpand(), CmdExtract();
extern Void CmdFeedback(), CmdFill(), CmdFindBox(), CmdFindLabel(), CmdFlush();
extern Void CmdGaRoute(), CmdGetcell(), CmdGetnode();
extern Void CmdGrid(), CmdIdentify(), CmdIRoute();
extern Void CmdLabel(), CmdLoad();
extern Void CmdMove(), CmdPaint(), CmdPath(), CmdPlow(), CmdAutoPlow();
extern Void CmdPlot(), CmdAutoPlot();
extern Void CmdRoute(), CmdAutoRoute();
extern Void CmdRsim(), CmdSave(), CmdScaleGrid(), CmdSee();
extern Void CmdSelect(), CmdSidewalk(), CmdSideways(), CmdSimCmd();
extern Void CmdShell(), CmdSnap(), CmdStartRsim();
extern Void CmdStretch(), CmdStraighten();
#ifdef NONMANHATTAN
extern Void CmdSplit(), CmdSplitErase();
#endif
extern Void CmdTech(), CmdTool(), CmdUnexpand();
extern Void CmdUpsidedown(), CmdWhat(), CmdWire(), CmdWriteall();
extern Void CmdGoto(), CmdFlatten(), CmdXload();

/*
 * Wizard commands
 */

extern Void CmdCoord();
extern Void CmdExtractTest();
extern Void CmdExtResis();
extern Void CmdIRouterTest();
extern Void CmdGARouterTest();
extern Void CmdGRouterTest();
extern Void CmdMZRouterTest();
extern Void CmdPsearch();
extern Void CmdPlowTest();
extern Void CmdExtResis();
extern Void CmdSeeFlags();
extern Void CmdShowtech();
extern Void CmdTilestats();
extern Void CmdTsearch();
extern Void CmdWatch();

#ifdef USE_READLINE
extern Void CmdHistory();
#endif

/*
 * Commands only in the Lawrence Livermore Version 
 */
#ifdef	LLNL
extern Void CmdMakeSW();
extern Void CmdSgraph();
#endif	LLNL

global char *CmdLongCommands[] =
{
    "*coord			show coordinates of various things",
    "*extract [args]	debug the circuit extractor",
#if defined(ROUTE_MODULE) || defined(ROUTE_AUTO)
    "*garoute [cmd [args]]	debug the gate-array router",
    "*groute [cmd [args]]	debug the global router",
    "*iroute [cmd [args]]	debug the interactive router",
    "*mzroute [cmd [args]]	debug the maze router",
#endif
#if defined(PLOW_MODULE) || defined(PLOW_AUTO)
    "*plow cmd [args]	debug plowing",
#endif
    "*psearch plane count	invoke point search over box area",
#if defined(ROUTE_MODULE) || defined(ROUTE_AUTO)
    "*seeflags [flag]	display channel flags over channel",
#endif
    "*showtech [file]	print internal technology tables",
    "*tilestats [file]	print statistics on tile utilization",
    "*tsearch plane count	invoke area search over box area",
    "*watch [plane]		enable verbose tile plane redisplay",
    "addpath [path]		append to current search path",
    "arraycell xsize ysize	OR\n"
    "arraycell xlo xhi ylo yhi\n\
			array everything in selection",
    "box [dir [amount]]	move box dist units in direction or (with\n\
			no arguments) show box size",
#ifdef CALMA_MODULE
    "calma option		Calma GDS-II stream file processor; type\n\
			\":calma help\" for information on options",
#endif
    "cellname [list] children|parents|exists|self [name]	OR\n"
    "cellname [list] allcells|topcells\n\
			list cells by relationship to cell \"name\", or\n\
			the current selection if no name given.  \"list\"\n\
			returns result as a list. \"exists + name\" returns\n\
			true or false (also see command instance)",
#if defined(ROUTE_MODULE) || defined(ROUTE_AUTO)
    "channels		see channels (feedback) without doing routing",
#endif
#ifdef CIF_MODULE
    "cif option		CIF processor; type \":cif help\"\n\
			for information on options",
#endif
    "clockwise [deg]		rotate selection and box clockwise",
    "copy [dir [amount]]	OR\n"
    "copy to x y		copy selection:  what used to be at box\n\
			lower-left will be copied at cursor location (or,\n\
			copy will appear amount units in dir from original);\n\
			second form will copy to location x y",
    "corner d1 d2 [layers]	make L-shaped wires inside box, filling\n\
			first in direction d1, then in d2",
    "delete			delete everything in selection",
    "down			load selected cell into a window",
    "drc option		design rule checker; type \":drc help\"\n\
			for information on options",
    "dump cell [child refPointC] [parent refPointP]\n\
			copy contents of cell into edit cell, so that\n\
			refPointC (or lower left) of cell is at refPointP\n\
			(or box lower-left); refPoints are either labels\n\
			or a pair of coordinates (e.g, 100 200)",
    "editcell		use selected cell as new edit cell",
    "element option	add a generic drawing element to the layout",
    "erase [layers]		erase mask information",
    "expand [toggle]		expand everything under box, or toggle\n\
			expanded/unexpanded cells in selection",
    "ext option		OR",
    "extract option		circuit extractor; type \":extract help\"\n\
			for information on options",
    "extresist [args]	patch .ext file with resistance info",
    "feedback option		find out about problems; type \":feedback help\"\n\
			for information on options",
    "fill dir [layers]	fill layers from one side of box to other",
    "findbox [zoom]		center the window on the box and optionally zoom in",
    "findlabel lab		set the box to the location of this label",
    "flatten destname	flatten edit cell into cell destname",
    "flushcell [cellname]	flush changes to cellname (edit cell default)",
#if defined(ROUTE_MODULE) || defined(ROUTE_AUTO)
    "garoute [cmd [args]]	gate-array router",
#endif
    "get	OR",
    "getcell cell [child refPointC] [parent refPointP]\n\
			get cell as a subcell of the edit cell, so that\n\
			refPointC (or lower left) of cell is at refPointP\n\
			(or box lower-left); refPoints are either labels\n\
			or a pair of coordinates (e.g, 100 200)",
#ifndef NO_SIM_MODULE
    "getnode option		get node names of all selected paint",
#endif
    "goto nodename		goto the node named nodename",
    "gridspace [xSpacing [ySpacing [xOrigin yOrigin]]]\n\
			toggle grid on/off (and set parameters)",
#ifdef USE_READLINE
    "history print out the command history list",
#endif
    "identify use_id		set the use identifier of the selected cell",
    "instance [list] children|parents|exists|self [name]	OR\n"
    "instance [list] allcells|topcells\n\
			List cells by relationship to cell \"name\", or\n\
			the current selection if no name given.  \"list\"\n\
			returns result as a list. \"exists + name\" returns\n\
			true or false (also see command cellname)",
#if defined(ROUTE_MODULE) || defined(ROUTE_AUTO)
    "iroute [cmd [args]]	do interactive point to point route",
#endif
    "labelpaint str [pos [layer]]\n\
			place a label",
    "loadcell [cellname]	load a cell into a window",
#ifdef	LLNL
    "makesw options		generate scan window for LP apparatus",
#endif	LLNL
    "move [dir [amount]]	OR\n"
    "move to x y		move box and selection, either by amount\n\
			in dir, or pick up by box lower-left and put\n\
			down at cursor position; second form will\n\
			put box at location x y",
    "paint layers		paint mask information",
    "path [search|cell|sys] [[+]path]\n\
			set or print search paths",
#if defined(PLOT_MODULE) || defined(PLOT_AUTO)
    "plot type [args]	hardcopy plotting; type \"plot help\"\n\
			for information on types and args",
#endif
#if defined(PLOW_MODULE) || defined(PLOW_AUTO)
    "plow option [args]	stretching and compaction; type \":plow help\"\n\
			for information on options",
#endif
    "rotate [+/-][deg]	rotate selection and box (counter)clockwise",
#if defined(ROUTE_MODULE) || defined(ROUTE_AUTO)
    "route			route the current cell",
#endif
#if !defined(NO_SIM_MODULE) && defined(RSIM_MODULE)
    "rsim [options] filename		run Rsim under Magic",
#endif
    "save [filename]		save edit cell on disk",
    "scalegrid a b		scale magic units vs. lambda by a / b",
    "see [no] layers|allSame	change what's displayed in the window",
    "select [option]		change selection; type \":select help\"\n\
			for information on options",
    "shell [command]		execute a command in a subshell",
    "sideways		flip selection and box sideways",
#if !defined(NO_SIM_MODULE) && defined(RSIM_MODULE)
    "simcmd cmd	        send a command to Rsim, applying it to selected paint",
#endif
    "snap [internal|lambda|user]\n\
			cause box to snap to the selected grid when moved\n\
			by the cursor",
#ifdef NONMANHATTAN 
    "splitpaint dir layer [layer2]\n\
			split box diagonally with layer in corner dir and\n\
			layer2 in the opposite corner (default layer2 is space)",
    "spliterase dir [layer]	erase layers from diagonal corner dir of the\n\
			edit box",
#endif
#if defined(PLOW_MODULE) || defined(PLOW_AUTO)
    "straighten direction	straighten jogs by pulling in direction",
#endif
#ifdef	LLNL
    "sgraph [options]	manipulate a cell's stretch graphs",
#endif	LLNL
#if !defined(NO_SIM_MODULE) && defined(RSIM_MODULE)
    "startrsim [options] file    start Rsim and return to Magic",
#endif
    "stretch [dir [amount]]	stretch box and selection",
    "tech option	technology handling; type \":techinfo help\"\n\
			for information on options",
    "tool [name|info]	change layout tool or print info about what\n\
			buttons mean for current tool",
    "unexpand		unexpand subcells under box",
    "upsidedown		flip selection and box upside down",
    "what			print out information about what's selected",
    "wire option [args]	wiring-style user interface; type\n\
			\":wire help\" for information on options",
    "writeall [force]	write out all modified cells to disk",
    "xload [cellname]	load a cell into a window unexpanded",
   0
};

Void (*CmdFuncs[])() =
{
    CmdCoord,
    CmdExtractTest,
#ifdef ROUTE_MODULE
    CmdGARouterTest,
    CmdGRouterTest,
    CmdIRouterTest,
    CmdMZRouterTest,
#endif
#ifdef ROUTE_AUTO
    CmdAutoRoute,
    CmdAutoRoute,
    CmdAutoRoute,
    CmdAutoRoute,
#endif
#ifdef PLOW_MODULE
    CmdPlowTest,
#endif
#ifdef PLOW_AUTO
    CmdAutoPlow,
#endif
    CmdPsearch,
#ifdef ROUTE_MODULE
    CmdSeeFlags,
#endif
#ifdef ROUTE_AUTO
    CmdAutoRoute,
#endif
    CmdShowtech,
    CmdTilestats,
    CmdTsearch,
    CmdWatch,
    CmdAddPath,
    CmdArray,
    CmdBox,
#ifdef CALMA_MODULE
    CmdCalma,
#endif
    CmdCellname,
#ifdef ROUTE_MODULE
    CmdChannel,
#endif
#ifdef ROUTE_AUTO
    CmdAutoRoute,
#endif
#ifdef CIF_MODULE
    CmdCif,
#endif
    CmdClockwise,
    CmdCopy,
    CmdCorner,
    CmdDelete,
    CmdDown,
    CmdDrc,
    CmdDump,
    CmdEdit,
    CmdElement,
    CmdErase,
    CmdExpand,
    CmdExtract,		/* For "ext" abbreviation */
    CmdExtract,		/* For "extract" */
    CmdExtResis,
    CmdFeedback,
    CmdFill,
    CmdFindBox,
    CmdFindLabel,
    CmdFlatten,
    CmdFlush,
#ifdef ROUTE_MODULE
    CmdGaRoute,
#endif
#ifdef ROUTE_AUTO
    CmdAutoRoute,
#endif
    CmdGetcell,
    CmdGetcell,
#ifndef NO_SIM_MODULE
    CmdGetnode,
#endif
    CmdGoto,
    CmdGrid,
#ifdef USE_READLINE
    CmdHistory,
#endif
    CmdIdentify,
    CmdCellname,
#ifdef ROUTE_MODULE
    CmdIRoute,
#endif
#ifdef ROUTE_AUTO
    CmdAutoRoute,
#endif
    CmdLabel,
    CmdLoad,
#ifdef	LLNL
    CmdMakeSW,
#endif	LLNL
    CmdMove,
    CmdPaint,
    CmdPath,
#ifdef PLOT_MODULE
    CmdPlot,
#endif
#ifdef PLOT_AUTO
    CmdAutoPlot,
#endif
#ifdef PLOW_MODULE
    CmdPlow,
#endif
#ifdef PLOW_AUTO
    CmdAutoPlow,
#endif
    CmdClockwise,		/* "rotate" is alias for "clockwise" */
#ifdef ROUTE_MODULE
    CmdRoute,
#endif
#ifdef ROUTE_AUTO
    CmdAutoRoute,
#endif
#if !defined(NO_SIM_MODULE) && defined(RSIM_MODULE)
    CmdRsim,
#endif
    CmdSave,
    CmdScaleGrid,
    CmdSee,
    CmdSelect,
    CmdShell,
    CmdSideways,
#if !defined(NO_SIM_MODULE) && defined(RSIM_MODULE)
    CmdSimCmd,
#endif
    CmdSnap,
#ifdef NONMANHATTAN 
    CmdSplit,
    CmdSplitErase,      
#endif
#ifdef PLOW_MODULE
    CmdStraighten,
#endif
#ifdef PLOW_AUTO
    CmdAutoPlow,
#endif
#ifdef	LLNL
    CmdSgraph,
#endif	LLNL
#if !defined(NO_SIM_MODULE) && defined(RSIM_MODULE)
    CmdStartRsim,
#endif
    CmdStretch,
    CmdTech,
    CmdTool,
    CmdUnexpand,
    CmdUpsidedown,
    CmdWhat,
    CmdWire,
    CmdWriteall,
    CmdXload
};
