/*
 * Copyright (c) 2002 Tony Bybell.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef _LIBVCDWRITE_H
#define _LIBVCDWRITE_H

#include "splay.h"

#define VCD_VERSION_STRING "libvcddump.a v0.1"

struct vcd_scope
{
struct vcd_scope *prev, *next;
char *name;
int len;
};

struct vcd_namehier
{
struct vcd_namehier *next;
char *name;
char not_final;
};


struct vcd_context
{
FILE *handle;
int timebase;
ds_Tree *tree_vcdid;

struct vcd_scope *scope_head, *scope_curr;
int scope_depth;
int curr_vcdid;
struct vcd_symbol *vcdsym_head, *vcdsym_curr;
int numsyms;

long long curr_time;

char *version_text;
struct vcd_namehier *nhold;

char vcdid_converted[33];

char is_finalized : 1;
char vcd_port_style_ids : 1;
};

enum vcd_timebase_exponents
	{
	VCD_TIMEBASE_S,
	VCD_TIMEBASE_MS,
	VCD_TIMEBASE_US,
	VCD_TIMEBASE_NS,
	VCD_TIMEBASE_PS,
	VCD_TIMEBASE_FS,
	VCD_TIMEBASE_INVALID
	};

enum vcd_symtype
	{
	VCD_SYM_INVALID0,

	VCD_SYM_MODULE,
	VCD_SYM_BEGIN,
	VCD_SYM_TASK,
	VCD_SYM_FUNCTION,
	VCD_SYM_FORK,

	VCD_SYM_EVENT,
	VCD_SYM_PARAMETER,
	VCD_SYM_INTEGER,
	VCD_SYM_REAL,

	VCD_SYM_REG,
	VCD_SYM_SUPPLY0,
	VCD_SYM_SUPPLY1,
	VCD_SYM_TRI,
	VCD_SYM_TRIAND,
	VCD_SYM_TRIOR,
	VCD_SYM_TRIREG,
	VCD_SYM_TRI0,
	VCD_SYM_TRI1,
	VCD_SYM_WAND,
	VCD_SYM_WIRE,
	VCD_SYM_WOR,
	VCD_SYM_PORT,

	VCD_SYM_INVALID1
	};


struct vcd_symbol
{
struct vcd_symbol *next;

char *flatname;
int msb, lsb, siz;
int symtype;
int vcdid;
};


/* 
 * create/destroy vcd context
 */
struct vcd_context *	vcd_open(const char *name);
int 			vcd_close(struct vcd_context *context);

/*
 * scope manipulations..note that these (if present) are prepended
 * onto the names for add/alias
 */
int			vcd_push_scope(struct vcd_context *context, const char *name, int symtype);
int			vcd_pop_scope(struct vcd_context *context);
char *			vcd_query_scope(struct vcd_context *context);
int			vcd_query_scope_depth(struct vcd_context *context);

/*
 * header maintenance
 */
int 			vcd_set_header_version_information(struct vcd_context *context, char *text);
int			vcd_set_timebase(struct vcd_context *context, int exponent);
int 			vcd_use_port_style_identifiers(struct vcd_context *context, int truth_value);

/*
 * symbol creation
 */
int			vcd_symbol_add(struct vcd_context *context, const char *name, int msb, int lsb, int symtype);
int			vcd_symbol_alias(struct vcd_context *context, const char *name, int msb, int lsb, int symtype, int old_vcdid);

/*
 * finalizer...once called, none of the above except for vcd_close() is useful
 */
int			vcd_header_finalize(struct vcd_context *context);

/*
 * callable after vcd_header_finalize()
 */
int 			vcd_set_time(struct vcd_context *context, long long timval);
int 			vcd_emit_value_bit_string(struct vcd_context *context, int vcdid, const char *value);
int 			vcd_emit_value_integer(struct vcd_context *context, int vcdid, int value);
int 			vcd_emit_value_port_string(struct vcd_context *context, int vcdid, const char *value, int str0, int str1);
int 			vcd_emit_value_real(struct vcd_context *context, int vcdid, double value);

int			vcd_emit_arbitrary_string(struct vcd_context *context, char *string);
int			vcd_emit_arbitrary_string_with_linefeed(struct vcd_context *context, char *string);

const char *		vcd_convert_vcdid(struct vcd_context *context, int vcdid);

#endif
