#include <stdio.h>
#include "vcd_write.h"

int main(int argc, char **argv)
{
struct vcd_context *context = vcd_open("zzz.vcd");
int clk, r;
int i, int0;
int p;

vcd_push_scope(context, "main", VCD_SYM_MODULE);
vcd_push_scope(context, "a", VCD_SYM_MODULE);
vcd_push_scope(context, "achild", VCD_SYM_MODULE);
vcd_symbol_add(context, "sym1", 1, 8, VCD_SYM_REG);
vcd_symbol_add(context, "sym2", 7, 0, VCD_SYM_REG);
vcd_symbol_add(context, "sym3", 4, 4, VCD_SYM_REG);
vcd_symbol_add(context, "sym4", -1, -1, VCD_SYM_REG);
clk = vcd_symbol_add(context, "clk", -1, -1, VCD_SYM_REG);
r=vcd_symbol_add(context, "symreal", -1, -1, VCD_SYM_REAL);
int0=vcd_symbol_add(context, "symint", -1, -1, VCD_SYM_PARAMETER);
p=vcd_symbol_add(context, "symport", -1, -1, VCD_SYM_PORT);

vcd_push_scope(context, "get_lost", VCD_SYM_MODULE);
vcd_pop_scope(context);

for(i=0;i<32;i++)
	{
	vcd_symbol_add(context, "v", 31-i, 31-i, VCD_SYM_REG);
	}

vcd_pop_scope(context);
vcd_pop_scope(context);
vcd_push_scope(context, "b", VCD_SYM_TASK);
vcd_pop_scope(context);
vcd_pop_scope(context);

vcd_symbol_add(context, "this.is.yet.another.module.of.horror", -1, -1, VCD_SYM_TRI);
vcd_symbol_add(context, "this.sucks", 127, 0, VCD_SYM_TRI);
vcd_symbol_alias(context, "this.clk2", 2, 2, VCD_SYM_REG, clk);

vcd_set_header_version_information(context, "TEST SIMULATOR");
vcd_set_timebase(context, VCD_TIMEBASE_NS);
vcd_use_port_style_identifiers(context, 0);
vcd_header_finalize(context);

vcd_emit_arbitrary_string(context, "$dumpvars\n");
vcd_emit_arbitrary_string_with_linefeed(context, "$end");

for(i=0;i<100;i++)
	{
	char str[2];
	vcd_set_time(context, i);
	sprintf(str, "%d", i&1);
	vcd_emit_value_bit_string(context, clk, str);
	vcd_emit_value_real(context, r, (double)i/10.0);
	vcd_emit_value_integer(context, int0, i);
	vcd_emit_value_port_string(context, p, str, 4, 7);
	}

vcd_close(context);
exit(0);
}
