#
# HADLOP Pro written by Guido Grimm and Marko Degenkolb
#

REMARKS {
}

OPTIONS {
  GRID {
    VISIBLE:   ON
    DIMENSION: (15,15)
    RASTERIZE: ON
  }
}

GLOBAL_ARCHITECTURE_DATA {
  DIMENSION:        (64,64)
  CLOCKS {
    NUMBER: 2
    CLOCK {
      TIME:   100
      OFFSET: 0
    }
    CLOCK {
      TIME:   100
      OFFSET: 50
    }
  }
  SIMULATION_DATA {
    MODE:     CLOCKS
    CLOCK_NR: 1
    CLOCKS:   100
  }
}

ARCHITECTURE_ELEMENTS {
  NUMBER: 4
  ELEMENTS {
    ARCHITECTURE_ELEMENT {
      TYPE: PERM
      INTERNAL_DATA {
        NAME:       PERM
        COMMENT:    broadcast
        INPUTS:     1
        OUTPUTS:    1
        INPUT_DIM:  (64,64)
        OUTPUT_DIM: (64,64)
        CLOCK:      0
        TIME:       0
      }
      LOGICAL_DATA {
        CONNECTIONS {
          (0,0)   -> (1,0)(0,1)
          (0,1)   -> (1,1)(0,2)(0,0)
          (0,2)   -> (1,2)(0,3)(0,1)
          (0,3)   -> (1,3)(0,4)(0,2)
          (0,4)   -> (1,4)(0,5)(0,3)
          (0,5)   -> (1,5)(0,6)(0,4)
          (0,6)   -> (1,6)(0,7)(0,5)
          (0,7)   -> (1,7)(0,8)(0,6)
          (0,8)   -> (1,8)(0,9)(0,7)
          (0,9)   -> (1,9)(0,10)(0,8)
          (0,10)  -> (1,10)(0,11)(0,9)
          (0,11)  -> (1,11)(0,12)(0,10)
          (0,12)  -> (1,12)(0,13)(0,11)
          (0,13)  -> (1,13)(0,14)(0,12)
          (0,14)  -> (1,14)(0,15)(0,13)
          (0,15)  -> (1,15)(0,16)(0,14)
          (0,16)  -> (1,16)(0,17)(0,15)
          (0,17)  -> (1,17)(0,18)(0,16)
          (0,18)  -> (1,18)(0,19)(0,17)
          (0,19)  -> (1,19)(0,20)(0,18)
          (0,20)  -> (1,20)(0,21)(0,19)
          (0,21)  -> (1,21)(0,22)(0,20)
          (0,22)  -> (1,22)(0,23)(0,21)
          (0,23)  -> (1,23)(0,24)(0,22)
          (0,24)  -> (1,24)(0,25)(0,23)
          (0,25)  -> (1,25)(0,26)(0,24)
          (0,26)  -> (1,26)(0,27)(0,25)
          (0,27)  -> (1,27)(0,28)(0,26)
          (0,28)  -> (1,28)(0,29)(0,27)
          (0,29)  -> (1,29)(0,30)(0,28)
          (0,30)  -> (1,30)(0,31)(0,29)
          (0,31)  -> (1,31)(0,32)(0,30)
          (0,32)  -> (1,32)(0,33)(0,31)
          (0,33)  -> (1,33)(0,34)(0,32)
          (0,34)  -> (1,34)(0,35)(0,33)
          (0,35)  -> (1,35)(0,36)(0,34)
          (0,36)  -> (1,36)(0,37)(0,35)
          (0,37)  -> (1,37)(0,38)(0,36)
          (0,38)  -> (1,38)(0,39)(0,37)
          (0,39)  -> (1,39)(0,40)(0,38)
          (0,40)  -> (1,40)(0,41)(0,39)
          (0,41)  -> (1,41)(0,42)(0,40)
          (0,42)  -> (1,42)(0,43)(0,41)
          (0,43)  -> (1,43)(0,44)(0,42)
          (0,44)  -> (1,44)(0,45)(0,43)
          (0,45)  -> (1,45)(0,46)(0,44)
          (0,46)  -> (1,46)(0,47)(0,45)
          (0,47)  -> (1,47)(0,48)(0,46)
          (0,48)  -> (1,48)(0,49)(0,47)
          (0,49)  -> (1,49)(0,50)(0,48)
          (0,50)  -> (1,50)(0,51)(0,49)
          (0,51)  -> (1,51)(0,52)(0,50)
          (0,52)  -> (1,52)(0,53)(0,51)
          (0,53)  -> (1,53)(0,54)(0,52)
          (0,54)  -> (1,54)(0,55)(0,53)
          (0,55)  -> (1,55)(0,56)(0,54)
          (0,56)  -> (1,56)(0,57)(0,55)
          (0,57)  -> (1,57)(0,58)(0,56)
          (0,58)  -> (1,58)(0,59)(0,57)
          (0,59)  -> (1,59)(0,60)(0,58)
          (0,60)  -> (1,60)(0,61)(0,59)
          (0,61)  -> (1,61)(0,62)(0,60)
          (0,62)  -> (1,62)(0,63)(0,61)
          (0,63)  -> (1,63)(0,62)
          (1,0)   -> (0,0)(2,0)(1,1)
          (1,1)   -> (0,1)(2,1)(1,2)(1,0)
          (1,2)   -> (0,2)(2,2)(1,3)(1,1)
          (1,3)   -> (0,3)(2,3)(1,4)(1,2)
          (1,4)   -> (0,4)(2,4)(1,5)(1,3)
          (1,5)   -> (0,5)(2,5)(1,6)(1,4)
          (1,6)   -> (0,6)(2,6)(1,7)(1,5)
          (1,7)   -> (0,7)(2,7)(1,8)(1,6)
          (1,8)   -> (0,8)(2,8)(1,9)(1,7)
          (1,9)   -> (0,9)(2,9)(1,10)(1,8)
          (1,10)  -> (0,10)(2,10)(1,11)(1,9)
          (1,11)  -> (0,11)(2,11)(1,12)(1,10)
          (1,12)  -> (0,12)(2,12)(1,13)(1,11)
          (1,13)  -> (0,13)(2,13)(1,14)(1,12)
          (1,14)  -> (0,14)(2,14)(1,15)(1,13)
          (1,15)  -> (0,15)(2,15)(1,16)(1,14)
          (1,16)  -> (0,16)(2,16)(1,17)(1,15)
          (1,17)  -> (0,17)(2,17)(1,18)(1,16)
          (1,18)  -> (0,18)(2,18)(1,19)(1,17)
          (1,19)  -> (0,19)(2,19)(1,20)(1,18)
          (1,20)  -> (0,20)(2,20)(1,21)(1,19)
          (1,21)  -> (0,21)(2,21)(1,22)(1,20)
          (1,22)  -> (0,22)(2,22)(1,23)(1,21)
          (1,23)  -> (0,23)(2,23)(1,24)(1,22)
          (1,24)  -> (0,24)(2,24)(1,25)(1,23)
          (1,25)  -> (0,25)(2,25)(1,26)(1,24)
          (1,26)  -> (0,26)(2,26)(1,27)(1,25)
          (1,27)  -> (0,27)(2,27)(1,28)(1,26)
          (1,28)  -> (0,28)(2,28)(1,29)(1,27)
          (1,29)  -> (0,29)(2,29)(1,30)(1,28)
          (1,30)  -> (0,30)(2,30)(1,31)(1,29)
          (1,31)  -> (0,31)(2,31)(1,32)(1,30)
          (1,32)  -> (0,32)(2,32)(1,33)(1,31)
          (1,33)  -> (0,33)(2,33)(1,34)(1,32)
          (1,34)  -> (0,34)(2,34)(1,35)(1,33)
          (1,35)  -> (0,35)(2,35)(1,36)(1,34)
          (1,36)  -> (0,36)(2,36)(1,37)(1,35)
          (1,37)  -> (0,37)(2,37)(1,38)(1,36)
          (1,38)  -> (0,38)(2,38)(1,39)(1,37)
          (1,39)  -> (0,39)(2,39)(1,40)(1,38)
          (1,40)  -> (0,40)(2,40)(1,41)(1,39)
          (1,41)  -> (0,41)(2,41)(1,42)(1,40)
          (1,42)  -> (0,42)(2,42)(1,43)(1,41)
          (1,43)  -> (0,43)(2,43)(1,44)(1,42)
          (1,44)  -> (0,44)(2,44)(1,45)(1,43)
          (1,45)  -> (0,45)(2,45)(1,46)(1,44)
          (1,46)  -> (0,46)(2,46)(1,47)(1,45)
          (1,47)  -> (0,47)(2,47)(1,48)(1,46)
          (1,48)  -> (0,48)(2,48)(1,49)(1,47)
          (1,49)  -> (0,49)(2,49)(1,50)(1,48)
          (1,50)  -> (0,50)(2,50)(1,51)(1,49)
          (1,51)  -> (0,51)(2,51)(1,52)(1,50)
          (1,52)  -> (0,52)(2,52)(1,53)(1,51)
          (1,53)  -> (0,53)(2,53)(1,54)(1,52)
          (1,54)  -> (0,54)(2,54)(1,55)(1,53)
          (1,55)  -> (0,55)(2,55)(1,56)(1,54)
          (1,56)  -> (0,56)(2,56)(1,57)(1,55)
          (1,57)  -> (0,57)(2,57)(1,58)(1,56)
          (1,58)  -> (0,58)(2,58)(1,59)(1,57)
          (1,59)  -> (0,59)(2,59)(1,60)(1,58)
          (1,60)  -> (0,60)(2,60)(1,61)(1,59)
          (1,61)  -> (0,61)(2,61)(1,62)(1,60)
          (1,62)  -> (0,62)(2,62)(1,63)(1,61)
          (1,63)  -> (0,63)(2,63)(1,62)
          (2,0)   -> (1,0)(3,0)(2,1)
          (2,1)   -> (1,1)(3,1)(2,2)(2,0)
          (2,2)   -> (1,2)(3,2)(2,3)(2,1)
          (2,3)   -> (1,3)(3,3)(2,4)(2,2)
          (2,4)   -> (1,4)(3,4)(2,5)(2,3)
          (2,5)   -> (1,5)(3,5)(2,6)(2,4)
          (2,6)   -> (1,6)(3,6)(2,7)(2,5)
          (2,7)   -> (1,7)(3,7)(2,8)(2,6)
          (2,8)   -> (1,8)(3,8)(2,9)(2,7)
          (2,9)   -> (1,9)(3,9)(2,10)(2,8)
          (2,10)  -> (1,10)(3,10)(2,11)(2,9)
          (2,11)  -> (1,11)(3,11)(2,12)(2,10)
          (2,12)  -> (1,12)(3,12)(2,13)(2,11)
          (2,13)  -> (1,13)(3,13)(2,14)(2,12)
          (2,14)  -> (1,14)(3,14)(2,15)(2,13)
          (2,15)  -> (1,15)(3,15)(2,16)(2,14)
          (2,16)  -> (1,16)(3,16)(2,17)(2,15)
          (2,17)  -> (1,17)(3,17)(2,18)(2,16)
          (2,18)  -> (1,18)(3,18)(2,19)(2,17)
          (2,19)  -> (1,19)(3,19)(2,20)(2,18)
          (2,20)  -> (1,20)(3,20)(2,21)(2,19)
          (2,21)  -> (1,21)(3,21)(2,22)(2,20)
          (2,22)  -> (1,22)(3,22)(2,23)(2,21)
          (2,23)  -> (1,23)(3,23)(2,24)(2,22)
          (2,24)  -> (1,24)(3,24)(2,25)(2,23)
          (2,25)  -> (1,25)(3,25)(2,26)(2,24)
          (2,26)  -> (1,26)(3,26)(2,27)(2,25)
          (2,27)  -> (1,27)(3,27)(2,28)(2,26)
          (2,28)  -> (1,28)(3,28)(2,29)(2,27)
          (2,29)  -> (1,29)(3,29)(2,30)(2,28)
          (2,30)  -> (1,30)(3,30)(2,31)(2,29)
          (2,31)  -> (1,31)(3,31)(2,32)(2,30)
          (2,32)  -> (1,32)(3,32)(2,33)(2,31)
          (2,33)  -> (1,33)(3,33)(2,34)(2,32)
          (2,34)  -> (1,34)(3,34)(2,35)(2,33)
          (2,35)  -> (1,35)(3,35)(2,36)(2,34)
          (2,36)  -> (1,36)(3,36)(2,37)(2,35)
          (2,37)  -> (1,37)(3,37)(2,38)(2,36)
          (2,38)  -> (1,38)(3,38)(2,39)(2,37)
          (2,39)  -> (1,39)(3,39)(2,40)(2,38)
          (2,40)  -> (1,40)(3,40)(2,41)(2,39)
          (2,41)  -> (1,41)(3,41)(2,42)(2,40)
          (2,42)  -> (1,42)(3,42)(2,43)(2,41)
          (2,43)  -> (1,43)(3,43)(2,44)(2,42)
          (2,44)  -> (1,44)(3,44)(2,45)(2,43)
          (2,45)  -> (1,45)(3,45)(2,46)(2,44)
          (2,46)  -> (1,46)(3,46)(2,47)(2,45)
          (2,47)  -> (1,47)(3,47)(2,48)(2,46)
          (2,48)  -> (1,48)(3,48)(2,49)(2,47)
          (2,49)  -> (1,49)(3,49)(2,50)(2,48)
          (2,50)  -> (1,50)(3,50)(2,51)(2,49)
          (2,51)  -> (1,51)(3,51)(2,52)(2,50)
          (2,52)  -> (1,52)(3,52)(2,53)(2,51)
          (2,53)  -> (1,53)(3,53)(2,54)(2,52)
          (2,54)  -> (1,54)(3,54)(2,55)(2,53)
          (2,55)  -> (1,55)(3,55)(2,56)(2,54)
          (2,56)  -> (1,56)(3,56)(2,57)(2,55)
          (2,57)  -> (1,57)(3,57)(2,58)(2,56)
          (2,58)  -> (1,58)(3,58)(2,59)(2,57)
          (2,59)  -> (1,59)(3,59)(2,60)(2,58)
          (2,60)  -> (1,60)(3,60)(2,61)(2,59)
          (2,61)  -> (1,61)(3,61)(2,62)(2,60)
          (2,62)  -> (1,62)(3,62)(2,63)(2,61)
          (2,63)  -> (1,63)(3,63)(2,62)
          (3,0)   -> (2,0)(4,0)(3,1)
          (3,1)   -> (2,1)(4,1)(3,2)(3,0)
          (3,2)   -> (2,2)(4,2)(3,3)(3,1)
          (3,3)   -> (2,3)(4,3)(3,4)(3,2)
          (3,4)   -> (2,4)(4,4)(3,5)(3,3)
          (3,5)   -> (2,5)(4,5)(3,6)(3,4)
          (3,6)   -> (2,6)(4,6)(3,7)(3,5)
          (3,7)   -> (2,7)(4,7)(3,8)(3,6)
          (3,8)   -> (2,8)(4,8)(3,9)(3,7)
          (3,9)   -> (2,9)(4,9)(3,10)(3,8)
          (3,10)  -> (2,10)(4,10)(3,11)(3,9)
          (3,11)  -> (2,11)(4,11)(3,12)(3,10)
          (3,12)  -> (2,12)(4,12)(3,13)(3,11)
          (3,13)  -> (2,13)(4,13)(3,14)(3,12)
          (3,14)  -> (2,14)(4,14)(3,15)(3,13)
          (3,15)  -> (2,15)(4,15)(3,16)(3,14)
          (3,16)  -> (2,16)(4,16)(3,17)(3,15)
          (3,17)  -> (2,17)(4,17)(3,18)(3,16)
          (3,18)  -> (2,18)(4,18)(3,19)(3,17)
          (3,19)  -> (2,19)(4,19)(3,20)(3,18)
          (3,20)  -> (2,20)(4,20)(3,21)(3,19)
          (3,21)  -> (2,21)(4,21)(3,22)(3,20)
          (3,22)  -> (2,22)(4,22)(3,23)(3,21)
          (3,23)  -> (2,23)(4,23)(3,24)(3,22)
          (3,24)  -> (2,24)(4,24)(3,25)(3,23)
          (3,25)  -> (2,25)(4,25)(3,26)(3,24)
          (3,26)  -> (2,26)(4,26)(3,27)(3,25)
          (3,27)  -> (2,27)(4,27)(3,28)(3,26)
          (3,28)  -> (2,28)(4,28)(3,29)(3,27)
          (3,29)  -> (2,29)(4,29)(3,30)(3,28)
          (3,30)  -> (2,30)(4,30)(3,31)(3,29)
          (3,31)  -> (2,31)(4,31)(3,32)(3,30)
          (3,32)  -> (2,32)(4,32)(3,33)(3,31)
          (3,33)  -> (2,33)(4,33)(3,34)(3,32)
          (3,34)  -> (2,34)(4,34)(3,35)(3,33)
          (3,35)  -> (2,35)(4,35)(3,36)(3,34)
          (3,36)  -> (2,36)(4,36)(3,37)(3,35)
          (3,37)  -> (2,37)(4,37)(3,38)(3,36)
          (3,38)  -> (2,38)(4,38)(3,39)(3,37)
          (3,39)  -> (2,39)(4,39)(3,40)(3,38)
          (3,40)  -> (2,40)(4,40)(3,41)(3,39)
          (3,41)  -> (2,41)(4,41)(3,42)(3,40)
          (3,42)  -> (2,42)(4,42)(3,43)(3,41)
          (3,43)  -> (2,43)(4,43)(3,44)(3,42)
          (3,44)  -> (2,44)(4,44)(3,45)(3,43)
          (3,45)  -> (2,45)(4,45)(3,46)(3,44)
          (3,46)  -> (2,46)(4,46)(3,47)(3,45)
          (3,47)  -> (2,47)(4,47)(3,48)(3,46)
          (3,48)  -> (2,48)(4,48)(3,49)(3,47)
          (3,49)  -> (2,49)(4,49)(3,50)(3,48)
          (3,50)  -> (2,50)(4,50)(3,51)(3,49)
          (3,51)  -> (2,51)(4,51)(3,52)(3,50)
          (3,52)  -> (2,52)(4,52)(3,53)(3,51)
          (3,53)  -> (2,53)(4,53)(3,54)(3,52)
          (3,54)  -> (2,54)(4,54)(3,55)(3,53)
          (3,55)  -> (2,55)(4,55)(3,56)(3,54)
          (3,56)  -> (2,56)(4,56)(3,57)(3,55)
          (3,57)  -> (2,57)(4,57)(3,58)(3,56)
          (3,58)  -> (2,58)(4,58)(3,59)(3,57)
          (3,59)  -> (2,59)(4,59)(3,60)(3,58)
          (3,60)  -> (2,60)(4,60)(3,61)(3,59)
          (3,61)  -> (2,61)(4,61)(3,62)(3,60)
          (3,62)  -> (2,62)(4,62)(3,63)(3,61)
          (3,63)  -> (2,63)(4,63)(3,62)
          (4,0)   -> (3,0)(5,0)(4,1)
          (4,1)   -> (3,1)(5,1)(4,2)(4,0)
          (4,2)   -> (3,2)(5,2)(4,3)(4,1)
          (4,3)   -> (3,3)(5,3)(4,4)(4,2)
          (4,4)   -> (3,4)(5,4)(4,5)(4,3)
          (4,5)   -> (3,5)(5,5)(4,6)(4,4)
          (4,6)   -> (3,6)(5,6)(4,7)(4,5)
          (4,7)   -> (3,7)(5,7)(4,8)(4,6)
          (4,8)   -> (3,8)(5,8)(4,9)(4,7)
          (4,9)   -> (3,9)(5,9)(4,10)(4,8)
          (4,10)  -> (3,10)(5,10)(4,11)(4,9)
          (4,11)  -> (3,11)(5,11)(4,12)(4,10)
          (4,12)  -> (3,12)(5,12)(4,13)(4,11)
          (4,13)  -> (3,13)(5,13)(4,14)(4,12)
          (4,14)  -> (3,14)(5,14)(4,15)(4,13)
          (4,15)  -> (3,15)(5,15)(4,16)(4,14)
          (4,16)  -> (3,16)(5,16)(4,17)(4,15)
          (4,17)  -> (3,17)(5,17)(4,18)(4,16)
          (4,18)  -> (3,18)(5,18)(4,19)(4,17)
          (4,19)  -> (3,19)(5,19)(4,20)(4,18)
          (4,20)  -> (3,20)(5,20)(4,21)(4,19)
          (4,21)  -> (3,21)(5,21)(4,22)(4,20)
          (4,22)  -> (3,22)(5,22)(4,23)(4,21)
          (4,23)  -> (3,23)(5,23)(4,24)(4,22)
          (4,24)  -> (3,24)(5,24)(4,25)(4,23)
          (4,25)  -> (3,25)(5,25)(4,26)(4,24)
          (4,26)  -> (3,26)(5,26)(4,27)(4,25)
          (4,27)  -> (3,27)(5,27)(4,28)(4,26)
          (4,28)  -> (3,28)(5,28)(4,29)(4,27)
          (4,29)  -> (3,29)(5,29)(4,30)(4,28)
          (4,30)  -> (3,30)(5,30)(4,31)(4,29)
          (4,31)  -> (3,31)(5,31)(4,32)(4,30)
          (4,32)  -> (3,32)(5,32)(4,33)(4,31)
          (4,33)  -> (3,33)(5,33)(4,34)(4,32)
          (4,34)  -> (3,34)(5,34)(4,35)(4,33)
          (4,35)  -> (3,35)(5,35)(4,36)(4,34)
          (4,36)  -> (3,36)(5,36)(4,37)(4,35)
          (4,37)  -> (3,37)(5,37)(4,38)(4,36)
          (4,38)  -> (3,38)(5,38)(4,39)(4,37)
          (4,39)  -> (3,39)(5,39)(4,40)(4,38)
          (4,40)  -> (3,40)(5,40)(4,41)(4,39)
          (4,41)  -> (3,41)(5,41)(4,42)(4,40)
          (4,42)  -> (3,42)(5,42)(4,43)(4,41)
          (4,43)  -> (3,43)(5,43)(4,44)(4,42)
          (4,44)  -> (3,44)(5,44)(4,45)(4,43)
          (4,45)  -> (3,45)(5,45)(4,46)(4,44)
          (4,46)  -> (3,46)(5,46)(4,47)(4,45)
          (4,47)  -> (3,47)(5,47)(4,48)(4,46)
          (4,48)  -> (3,48)(5,48)(4,49)(4,47)
          (4,49)  -> (3,49)(5,49)(4,50)(4,48)
          (4,50)  -> (3,50)(5,50)(4,51)(4,49)
          (4,51)  -> (3,51)(5,51)(4,52)(4,50)
          (4,52)  -> (3,52)(5,52)(4,53)(4,51)
          (4,53)  -> (3,53)(5,53)(4,54)(4,52)
          (4,54)  -> (3,54)(5,54)(4,55)(4,53)
          (4,55)  -> (3,55)(5,55)(4,56)(4,54)
          (4,56)  -> (3,56)(5,56)(4,57)(4,55)
          (4,57)  -> (3,57)(5,57)(4,58)(4,56)
          (4,58)  -> (3,58)(5,58)(4,59)(4,57)
          (4,59)  -> (3,59)(5,59)(4,60)(4,58)
          (4,60)  -> (3,60)(5,60)(4,61)(4,59)
          (4,61)  -> (3,61)(5,61)(4,62)(4,60)
          (4,62)  -> (3,62)(5,62)(4,63)(4,61)
          (4,63)  -> (3,63)(5,63)(4,62)
          (5,0)   -> (4,0)(6,0)(5,1)
          (5,1)   -> (4,1)(6,1)(5,2)(5,0)
          (5,2)   -> (4,2)(6,2)(5,3)(5,1)
          (5,3)   -> (4,3)(6,3)(5,4)(5,2)
          (5,4)   -> (4,4)(6,4)(5,5)(5,3)
          (5,5)   -> (4,5)(6,5)(5,6)(5,4)
          (5,6)   -> (4,6)(6,6)(5,7)(5,5)
          (5,7)   -> (4,7)(6,7)(5,8)(5,6)
          (5,8)   -> (4,8)(6,8)(5,9)(5,7)
          (5,9)   -> (4,9)(6,9)(5,10)(5,8)
          (5,10)  -> (4,10)(6,10)(5,11)(5,9)
          (5,11)  -> (4,11)(6,11)(5,12)(5,10)
          (5,12)  -> (4,12)(6,12)(5,13)(5,11)
          (5,13)  -> (4,13)(6,13)(5,14)(5,12)
          (5,14)  -> (4,14)(6,14)(5,15)(5,13)
          (5,15)  -> (4,15)(6,15)(5,16)(5,14)
          (5,16)  -> (4,16)(6,16)(5,17)(5,15)
          (5,17)  -> (4,17)(6,17)(5,18)(5,16)
          (5,18)  -> (4,18)(6,18)(5,19)(5,17)
          (5,19)  -> (4,19)(6,19)(5,20)(5,18)
          (5,20)  -> (4,20)(6,20)(5,21)(5,19)
          (5,21)  -> (4,21)(6,21)(5,22)(5,20)
          (5,22)  -> (4,22)(6,22)(5,23)(5,21)
          (5,23)  -> (4,23)(6,23)(5,24)(5,22)
          (5,24)  -> (4,24)(6,24)(5,25)(5,23)
          (5,25)  -> (4,25)(6,25)(5,26)(5,24)
          (5,26)  -> (4,26)(6,26)(5,27)(5,25)
          (5,27)  -> (4,27)(6,27)(5,28)(5,26)
          (5,28)  -> (4,28)(6,28)(5,29)(5,27)
          (5,29)  -> (4,29)(6,29)(5,30)(5,28)
          (5,30)  -> (4,30)(6,30)(5,31)(5,29)
          (5,31)  -> (4,31)(6,31)(5,32)(5,30)
          (5,32)  -> (4,32)(6,32)(5,33)(5,31)
          (5,33)  -> (4,33)(6,33)(5,34)(5,32)
          (5,34)  -> (4,34)(6,34)(5,35)(5,33)
          (5,35)  -> (4,35)(6,35)(5,36)(5,34)
          (5,36)  -> (4,36)(6,36)(5,37)(5,35)
          (5,37)  -> (4,37)(6,37)(5,38)(5,36)
          (5,38)  -> (4,38)(6,38)(5,39)(5,37)
          (5,39)  -> (4,39)(6,39)(5,40)(5,38)
          (5,40)  -> (4,40)(6,40)(5,41)(5,39)
          (5,41)  -> (4,41)(6,41)(5,42)(5,40)
          (5,42)  -> (4,42)(6,42)(5,43)(5,41)
          (5,43)  -> (4,43)(6,43)(5,44)(5,42)
          (5,44)  -> (4,44)(6,44)(5,45)(5,43)
          (5,45)  -> (4,45)(6,45)(5,46)(5,44)
          (5,46)  -> (4,46)(6,46)(5,47)(5,45)
          (5,47)  -> (4,47)(6,47)(5,48)(5,46)
          (5,48)  -> (4,48)(6,48)(5,49)(5,47)
          (5,49)  -> (4,49)(6,49)(5,50)(5,48)
          (5,50)  -> (4,50)(6,50)(5,51)(5,49)
          (5,51)  -> (4,51)(6,51)(5,52)(5,50)
          (5,52)  -> (4,52)(6,52)(5,53)(5,51)
          (5,53)  -> (4,53)(6,53)(5,54)(5,52)
          (5,54)  -> (4,54)(6,54)(5,55)(5,53)
          (5,55)  -> (4,55)(6,55)(5,56)(5,54)
          (5,56)  -> (4,56)(6,56)(5,57)(5,55)
          (5,57)  -> (4,57)(6,57)(5,58)(5,56)
          (5,58)  -> (4,58)(6,58)(5,59)(5,57)
          (5,59)  -> (4,59)(6,59)(5,60)(5,58)
          (5,60)  -> (4,60)(6,60)(5,61)(5,59)
          (5,61)  -> (4,61)(6,61)(5,62)(5,60)
          (5,62)  -> (4,62)(6,62)(5,63)(5,61)
          (5,63)  -> (4,63)(6,63)(5,62)
          (6,0)   -> (5,0)(7,0)(6,1)
          (6,1)   -> (5,1)(7,1)(6,2)(6,0)
          (6,2)   -> (5,2)(7,2)(6,3)(6,1)
          (6,3)   -> (5,3)(7,3)(6,4)(6,2)
          (6,4)   -> (5,4)(7,4)(6,5)(6,3)
          (6,5)   -> (5,5)(7,5)(6,6)(6,4)
          (6,6)   -> (5,6)(7,6)(6,7)(6,5)
          (6,7)   -> (5,7)(7,7)(6,8)(6,6)
          (6,8)   -> (5,8)(7,8)(6,9)(6,7)
          (6,9)   -> (5,9)(7,9)(6,10)(6,8)
          (6,10)  -> (5,10)(7,10)(6,11)(6,9)
          (6,11)  -> (5,11)(7,11)(6,12)(6,10)
          (6,12)  -> (5,12)(7,12)(6,13)(6,11)
          (6,13)  -> (5,13)(7,13)(6,14)(6,12)
          (6,14)  -> (5,14)(7,14)(6,15)(6,13)
          (6,15)  -> (5,15)(7,15)(6,16)(6,14)
          (6,16)  -> (5,16)(7,16)(6,17)(6,15)
          (6,17)  -> (5,17)(7,17)(6,18)(6,16)
          (6,18)  -> (5,18)(7,18)(6,19)(6,17)
          (6,19)  -> (5,19)(7,19)(6,20)(6,18)
          (6,20)  -> (5,20)(7,20)(6,21)(6,19)
          (6,21)  -> (5,21)(7,21)(6,22)(6,20)
          (6,22)  -> (5,22)(7,22)(6,23)(6,21)
          (6,23)  -> (5,23)(7,23)(6,24)(6,22)
          (6,24)  -> (5,24)(7,24)(6,25)(6,23)
          (6,25)  -> (5,25)(7,25)(6,26)(6,24)
          (6,26)  -> (5,26)(7,26)(6,27)(6,25)
          (6,27)  -> (5,27)(7,27)(6,28)(6,26)
          (6,28)  -> (5,28)(7,28)(6,29)(6,27)
          (6,29)  -> (5,29)(7,29)(6,30)(6,28)
          (6,30)  -> (5,30)(7,30)(6,31)(6,29)
          (6,31)  -> (5,31)(7,31)(6,32)(6,30)
          (6,32)  -> (5,32)(7,32)(6,33)(6,31)
          (6,33)  -> (5,33)(7,33)(6,34)(6,32)
          (6,34)  -> (5,34)(7,34)(6,35)(6,33)
          (6,35)  -> (5,35)(7,35)(6,36)(6,34)
          (6,36)  -> (5,36)(7,36)(6,37)(6,35)
          (6,37)  -> (5,37)(7,37)(6,38)(6,36)
          (6,38)  -> (5,38)(7,38)(6,39)(6,37)
          (6,39)  -> (5,39)(7,39)(6,40)(6,38)
          (6,40)  -> (5,40)(7,40)(6,41)(6,39)
          (6,41)  -> (5,41)(7,41)(6,42)(6,40)
          (6,42)  -> (5,42)(7,42)(6,43)(6,41)
          (6,43)  -> (5,43)(7,43)(6,44)(6,42)
          (6,44)  -> (5,44)(7,44)(6,45)(6,43)
          (6,45)  -> (5,45)(7,45)(6,46)(6,44)
          (6,46)  -> (5,46)(7,46)(6,47)(6,45)
          (6,47)  -> (5,47)(7,47)(6,48)(6,46)
          (6,48)  -> (5,48)(7,48)(6,49)(6,47)
          (6,49)  -> (5,49)(7,49)(6,50)(6,48)
          (6,50)  -> (5,50)(7,50)(6,51)(6,49)
          (6,51)  -> (5,51)(7,51)(6,52)(6,50)
          (6,52)  -> (5,52)(7,52)(6,53)(6,51)
          (6,53)  -> (5,53)(7,53)(6,54)(6,52)
          (6,54)  -> (5,54)(7,54)(6,55)(6,53)
          (6,55)  -> (5,55)(7,55)(6,56)(6,54)
          (6,56)  -> (5,56)(7,56)(6,57)(6,55)
          (6,57)  -> (5,57)(7,57)(6,58)(6,56)
          (6,58)  -> (5,58)(7,58)(6,59)(6,57)
          (6,59)  -> (5,59)(7,59)(6,60)(6,58)
          (6,60)  -> (5,60)(7,60)(6,61)(6,59)
          (6,61)  -> (5,61)(7,61)(6,62)(6,60)
          (6,62)  -> (5,62)(7,62)(6,63)(6,61)
          (6,63)  -> (5,63)(7,63)(6,62)
          (7,0)   -> (6,0)(8,0)(7,1)
          (7,1)   -> (6,1)(8,1)(7,2)(7,0)
          (7,2)   -> (6,2)(8,2)(7,3)(7,1)
          (7,3)   -> (6,3)(8,3)(7,4)(7,2)
          (7,4)   -> (6,4)(8,4)(7,5)(7,3)
          (7,5)   -> (6,5)(8,5)(7,6)(7,4)
          (7,6)   -> (6,6)(8,6)(7,7)(7,5)
          (7,7)   -> (6,7)(8,7)(7,8)(7,6)
          (7,8)   -> (6,8)(8,8)(7,9)(7,7)
          (7,9)   -> (6,9)(8,9)(7,10)(7,8)
          (7,10)  -> (6,10)(8,10)(7,11)(7,9)
          (7,11)  -> (6,11)(8,11)(7,12)(7,10)
          (7,12)  -> (6,12)(8,12)(7,13)(7,11)
          (7,13)  -> (6,13)(8,13)(7,14)(7,12)
          (7,14)  -> (6,14)(8,14)(7,15)(7,13)
          (7,15)  -> (6,15)(8,15)(7,16)(7,14)
          (7,16)  -> (6,16)(8,16)(7,17)(7,15)
          (7,17)  -> (6,17)(8,17)(7,18)(7,16)
          (7,18)  -> (6,18)(8,18)(7,19)(7,17)
          (7,19)  -> (6,19)(8,19)(7,20)(7,18)
          (7,20)  -> (6,20)(8,20)(7,21)(7,19)
          (7,21)  -> (6,21)(8,21)(7,22)(7,20)
          (7,22)  -> (6,22)(8,22)(7,23)(7,21)
          (7,23)  -> (6,23)(8,23)(7,24)(7,22)
          (7,24)  -> (6,24)(8,24)(7,25)(7,23)
          (7,25)  -> (6,25)(8,25)(7,26)(7,24)
          (7,26)  -> (6,26)(8,26)(7,27)(7,25)
          (7,27)  -> (6,27)(8,27)(7,28)(7,26)
          (7,28)  -> (6,28)(8,28)(7,29)(7,27)
          (7,29)  -> (6,29)(8,29)(7,30)(7,28)
          (7,30)  -> (6,30)(8,30)(7,31)(7,29)
          (7,31)  -> (6,31)(8,31)(7,32)(7,30)
          (7,32)  -> (6,32)(8,32)(7,33)(7,31)
          (7,33)  -> (6,33)(8,33)(7,34)(7,32)
          (7,34)  -> (6,34)(8,34)(7,35)(7,33)
          (7,35)  -> (6,35)(8,35)(7,36)(7,34)
          (7,36)  -> (6,36)(8,36)(7,37)(7,35)
          (7,37)  -> (6,37)(8,37)(7,38)(7,36)
          (7,38)  -> (6,38)(8,38)(7,39)(7,37)
          (7,39)  -> (6,39)(8,39)(7,40)(7,38)
          (7,40)  -> (6,40)(8,40)(7,41)(7,39)
          (7,41)  -> (6,41)(8,41)(7,42)(7,40)
          (7,42)  -> (6,42)(8,42)(7,43)(7,41)
          (7,43)  -> (6,43)(8,43)(7,44)(7,42)
          (7,44)  -> (6,44)(8,44)(7,45)(7,43)
          (7,45)  -> (6,45)(8,45)(7,46)(7,44)
          (7,46)  -> (6,46)(8,46)(7,47)(7,45)
          (7,47)  -> (6,47)(8,47)(7,48)(7,46)
          (7,48)  -> (6,48)(8,48)(7,49)(7,47)
          (7,49)  -> (6,49)(8,49)(7,50)(7,48)
          (7,50)  -> (6,50)(8,50)(7,51)(7,49)
          (7,51)  -> (6,51)(8,51)(7,52)(7,50)
          (7,52)  -> (6,52)(8,52)(7,53)(7,51)
          (7,53)  -> (6,53)(8,53)(7,54)(7,52)
          (7,54)  -> (6,54)(8,54)(7,55)(7,53)
          (7,55)  -> (6,55)(8,55)(7,56)(7,54)
          (7,56)  -> (6,56)(8,56)(7,57)(7,55)
          (7,57)  -> (6,57)(8,57)(7,58)(7,56)
          (7,58)  -> (6,58)(8,58)(7,59)(7,57)
          (7,59)  -> (6,59)(8,59)(7,60)(7,58)
          (7,60)  -> (6,60)(8,60)(7,61)(7,59)
          (7,61)  -> (6,61)(8,61)(7,62)(7,60)
          (7,62)  -> (6,62)(8,62)(7,63)(7,61)
          (7,63)  -> (6,63)(8,63)(7,62)
          (8,0)   -> (7,0)(9,0)(8,1)
          (8,1)   -> (7,1)(9,1)(8,2)(8,0)
          (8,2)   -> (7,2)(9,2)(8,3)(8,1)
          (8,3)   -> (7,3)(9,3)(8,4)(8,2)
          (8,4)   -> (7,4)(9,4)(8,5)(8,3)
          (8,5)   -> (7,5)(9,5)(8,6)(8,4)
          (8,6)   -> (7,6)(9,6)(8,7)(8,5)
          (8,7)   -> (7,7)(9,7)(8,8)(8,6)
          (8,8)   -> (7,8)(9,8)(8,9)(8,7)
          (8,9)   -> (7,9)(9,9)(8,10)(8,8)
          (8,10)  -> (7,10)(9,10)(8,11)(8,9)
          (8,11)  -> (7,11)(9,11)(8,12)(8,10)
          (8,12)  -> (7,12)(9,12)(8,13)(8,11)
          (8,13)  -> (7,13)(9,13)(8,14)(8,12)
          (8,14)  -> (7,14)(9,14)(8,15)(8,13)
          (8,15)  -> (7,15)(9,15)(8,16)(8,14)
          (8,16)  -> (7,16)(9,16)(8,17)(8,15)
          (8,17)  -> (7,17)(9,17)(8,18)(8,16)
          (8,18)  -> (7,18)(9,18)(8,19)(8,17)
          (8,19)  -> (7,19)(9,19)(8,20)(8,18)
          (8,20)  -> (7,20)(9,20)(8,21)(8,19)
          (8,21)  -> (7,21)(9,21)(8,22)(8,20)
          (8,22)  -> (7,22)(9,22)(8,23)(8,21)
          (8,23)  -> (7,23)(9,23)(8,24)(8,22)
          (8,24)  -> (7,24)(9,24)(8,25)(8,23)
          (8,25)  -> (7,25)(9,25)(8,26)(8,24)
          (8,26)  -> (7,26)(9,26)(8,27)(8,25)
          (8,27)  -> (7,27)(9,27)(8,28)(8,26)
          (8,28)  -> (7,28)(9,28)(8,29)(8,27)
          (8,29)  -> (7,29)(9,29)(8,30)(8,28)
          (8,30)  -> (7,30)(9,30)(8,31)(8,29)
          (8,31)  -> (7,31)(9,31)(8,32)(8,30)
          (8,32)  -> (7,32)(9,32)(8,33)(8,31)
          (8,33)  -> (7,33)(9,33)(8,34)(8,32)
          (8,34)  -> (7,34)(9,34)(8,35)(8,33)
          (8,35)  -> (7,35)(9,35)(8,36)(8,34)
          (8,36)  -> (7,36)(9,36)(8,37)(8,35)
          (8,37)  -> (7,37)(9,37)(8,38)(8,36)
          (8,38)  -> (7,38)(9,38)(8,39)(8,37)
          (8,39)  -> (7,39)(9,39)(8,40)(8,38)
          (8,40)  -> (7,40)(9,40)(8,41)(8,39)
          (8,41)  -> (7,41)(9,41)(8,42)(8,40)
          (8,42)  -> (7,42)(9,42)(8,43)(8,41)
          (8,43)  -> (7,43)(9,43)(8,44)(8,42)
          (8,44)  -> (7,44)(9,44)(8,45)(8,43)
          (8,45)  -> (7,45)(9,45)(8,46)(8,44)
          (8,46)  -> (7,46)(9,46)(8,47)(8,45)
          (8,47)  -> (7,47)(9,47)(8,48)(8,46)
          (8,48)  -> (7,48)(9,48)(8,49)(8,47)
          (8,49)  -> (7,49)(9,49)(8,50)(8,48)
          (8,50)  -> (7,50)(9,50)(8,51)(8,49)
          (8,51)  -> (7,51)(9,51)(8,52)(8,50)
          (8,52)  -> (7,52)(9,52)(8,53)(8,51)
          (8,53)  -> (7,53)(9,53)(8,54)(8,52)
          (8,54)  -> (7,54)(9,54)(8,55)(8,53)
          (8,55)  -> (7,55)(9,55)(8,56)(8,54)
          (8,56)  -> (7,56)(9,56)(8,57)(8,55)
          (8,57)  -> (7,57)(9,57)(8,58)(8,56)
          (8,58)  -> (7,58)(9,58)(8,59)(8,57)
          (8,59)  -> (7,59)(9,59)(8,60)(8,58)
          (8,60)  -> (7,60)(9,60)(8,61)(8,59)
          (8,61)  -> (7,61)(9,61)(8,62)(8,60)
          (8,62)  -> (7,62)(9,62)(8,63)(8,61)
          (8,63)  -> (7,63)(9,63)(8,62)
          (9,0)   -> (8,0)(10,0)(9,1)
          (9,1)   -> (8,1)(10,1)(9,2)(9,0)
          (9,2)   -> (8,2)(10,2)(9,3)(9,1)
          (9,3)   -> (8,3)(10,3)(9,4)(9,2)
          (9,4)   -> (8,4)(10,4)(9,5)(9,3)
          (9,5)   -> (8,5)(10,5)(9,6)(9,4)
          (9,6)   -> (8,6)(10,6)(9,7)(9,5)
          (9,7)   -> (8,7)(10,7)(9,8)(9,6)
          (9,8)   -> (8,8)(10,8)(9,9)(9,7)
          (9,9)   -> (8,9)(10,9)(9,10)(9,8)
          (9,10)  -> (8,10)(10,10)(9,11)(9,9)
          (9,11)  -> (8,11)(10,11)(9,12)(9,10)
          (9,12)  -> (8,12)(10,12)(9,13)(9,11)
          (9,13)  -> (8,13)(10,13)(9,14)(9,12)
          (9,14)  -> (8,14)(10,14)(9,15)(9,13)
          (9,15)  -> (8,15)(10,15)(9,16)(9,14)
          (9,16)  -> (8,16)(10,16)(9,17)(9,15)
          (9,17)  -> (8,17)(10,17)(9,18)(9,16)
          (9,18)  -> (8,18)(10,18)(9,19)(9,17)
          (9,19)  -> (8,19)(10,19)(9,20)(9,18)
          (9,20)  -> (8,20)(10,20)(9,21)(9,19)
          (9,21)  -> (8,21)(10,21)(9,22)(9,20)
          (9,22)  -> (8,22)(10,22)(9,23)(9,21)
          (9,23)  -> (8,23)(10,23)(9,24)(9,22)
          (9,24)  -> (8,24)(10,24)(9,25)(9,23)
          (9,25)  -> (8,25)(10,25)(9,26)(9,24)
          (9,26)  -> (8,26)(10,26)(9,27)(9,25)
          (9,27)  -> (8,27)(10,27)(9,28)(9,26)
          (9,28)  -> (8,28)(10,28)(9,29)(9,27)
          (9,29)  -> (8,29)(10,29)(9,30)(9,28)
          (9,30)  -> (8,30)(10,30)(9,31)(9,29)
          (9,31)  -> (8,31)(10,31)(9,32)(9,30)
          (9,32)  -> (8,32)(10,32)(9,33)(9,31)
          (9,33)  -> (8,33)(10,33)(9,34)(9,32)
          (9,34)  -> (8,34)(10,34)(9,35)(9,33)
          (9,35)  -> (8,35)(10,35)(9,36)(9,34)
          (9,36)  -> (8,36)(10,36)(9,37)(9,35)
          (9,37)  -> (8,37)(10,37)(9,38)(9,36)
          (9,38)  -> (8,38)(10,38)(9,39)(9,37)
          (9,39)  -> (8,39)(10,39)(9,40)(9,38)
          (9,40)  -> (8,40)(10,40)(9,41)(9,39)
          (9,41)  -> (8,41)(10,41)(9,42)(9,40)
          (9,42)  -> (8,42)(10,42)(9,43)(9,41)
          (9,43)  -> (8,43)(10,43)(9,44)(9,42)
          (9,44)  -> (8,44)(10,44)(9,45)(9,43)
          (9,45)  -> (8,45)(10,45)(9,46)(9,44)
          (9,46)  -> (8,46)(10,46)(9,47)(9,45)
          (9,47)  -> (8,47)(10,47)(9,48)(9,46)
          (9,48)  -> (8,48)(10,48)(9,49)(9,47)
          (9,49)  -> (8,49)(10,49)(9,50)(9,48)
          (9,50)  -> (8,50)(10,50)(9,51)(9,49)
          (9,51)  -> (8,51)(10,51)(9,52)(9,50)
          (9,52)  -> (8,52)(10,52)(9,53)(9,51)
          (9,53)  -> (8,53)(10,53)(9,54)(9,52)
          (9,54)  -> (8,54)(10,54)(9,55)(9,53)
          (9,55)  -> (8,55)(10,55)(9,56)(9,54)
          (9,56)  -> (8,56)(10,56)(9,57)(9,55)
          (9,57)  -> (8,57)(10,57)(9,58)(9,56)
          (9,58)  -> (8,58)(10,58)(9,59)(9,57)
          (9,59)  -> (8,59)(10,59)(9,60)(9,58)
          (9,60)  -> (8,60)(10,60)(9,61)(9,59)
          (9,61)  -> (8,61)(10,61)(9,62)(9,60)
          (9,62)  -> (8,62)(10,62)(9,63)(9,61)
          (9,63)  -> (8,63)(10,63)(9,62)
          (10,0)  -> (9,0)(11,0)(10,1)
          (10,1)  -> (9,1)(11,1)(10,2)(10,0)
          (10,2)  -> (9,2)(11,2)(10,3)(10,1)
          (10,3)  -> (9,3)(11,3)(10,4)(10,2)
          (10,4)  -> (9,4)(11,4)(10,5)(10,3)
          (10,5)  -> (9,5)(11,5)(10,6)(10,4)
          (10,6)  -> (9,6)(11,6)(10,7)(10,5)
          (10,7)  -> (9,7)(11,7)(10,8)(10,6)
          (10,8)  -> (9,8)(11,8)(10,9)(10,7)
          (10,9)  -> (9,9)(11,9)(10,10)(10,8)
          (10,10) -> (9,10)(11,10)(10,11)(10,9)
          (10,11) -> (9,11)(11,11)(10,12)(10,10)
          (10,12) -> (9,12)(11,12)(10,13)(10,11)
          (10,13) -> (9,13)(11,13)(10,14)(10,12)
          (10,14) -> (9,14)(11,14)(10,15)(10,13)
          (10,15) -> (9,15)(11,15)(10,16)(10,14)
          (10,16) -> (9,16)(11,16)(10,17)(10,15)
          (10,17) -> (9,17)(11,17)(10,18)(10,16)
          (10,18) -> (9,18)(11,18)(10,19)(10,17)
          (10,19) -> (9,19)(11,19)(10,20)(10,18)
          (10,20) -> (9,20)(11,20)(10,21)(10,19)
          (10,21) -> (9,21)(11,21)(10,22)(10,20)
          (10,22) -> (9,22)(11,22)(10,23)(10,21)
          (10,23) -> (9,23)(11,23)(10,24)(10,22)
          (10,24) -> (9,24)(11,24)(10,25)(10,23)
          (10,25) -> (9,25)(11,25)(10,26)(10,24)
          (10,26) -> (9,26)(11,26)(10,27)(10,25)
          (10,27) -> (9,27)(11,27)(10,28)(10,26)
          (10,28) -> (9,28)(11,28)(10,29)(10,27)
          (10,29) -> (9,29)(11,29)(10,30)(10,28)
          (10,30) -> (9,30)(11,30)(10,31)(10,29)
          (10,31) -> (9,31)(11,31)(10,32)(10,30)
          (10,32) -> (9,32)(11,32)(10,33)(10,31)
          (10,33) -> (9,33)(11,33)(10,34)(10,32)
          (10,34) -> (9,34)(11,34)(10,35)(10,33)
          (10,35) -> (9,35)(11,35)(10,36)(10,34)
          (10,36) -> (9,36)(11,36)(10,37)(10,35)
          (10,37) -> (9,37)(11,37)(10,38)(10,36)
          (10,38) -> (9,38)(11,38)(10,39)(10,37)
          (10,39) -> (9,39)(11,39)(10,40)(10,38)
          (10,40) -> (9,40)(11,40)(10,41)(10,39)
          (10,41) -> (9,41)(11,41)(10,42)(10,40)
          (10,42) -> (9,42)(11,42)(10,43)(10,41)
          (10,43) -> (9,43)(11,43)(10,44)(10,42)
          (10,44) -> (9,44)(11,44)(10,45)(10,43)
          (10,45) -> (9,45)(11,45)(10,46)(10,44)
          (10,46) -> (9,46)(11,46)(10,47)(10,45)
          (10,47) -> (9,47)(11,47)(10,48)(10,46)
          (10,48) -> (9,48)(11,48)(10,49)(10,47)
          (10,49) -> (9,49)(11,49)(10,50)(10,48)
          (10,50) -> (9,50)(11,50)(10,51)(10,49)
          (10,51) -> (9,51)(11,51)(10,52)(10,50)
          (10,52) -> (9,52)(11,52)(10,53)(10,51)
          (10,53) -> (9,53)(11,53)(10,54)(10,52)
          (10,54) -> (9,54)(11,54)(10,55)(10,53)
          (10,55) -> (9,55)(11,55)(10,56)(10,54)
          (10,56) -> (9,56)(11,56)(10,57)(10,55)
          (10,57) -> (9,57)(11,57)(10,58)(10,56)
          (10,58) -> (9,58)(11,58)(10,59)(10,57)
          (10,59) -> (9,59)(11,59)(10,60)(10,58)
          (10,60) -> (9,60)(11,60)(10,61)(10,59)
          (10,61) -> (9,61)(11,61)(10,62)(10,60)
          (10,62) -> (9,62)(11,62)(10,63)(10,61)
          (10,63) -> (9,63)(11,63)(10,62)
          (11,0)  -> (10,0)(12,0)(11,1)
          (11,1)  -> (10,1)(12,1)(11,2)(11,0)
          (11,2)  -> (10,2)(12,2)(11,3)(11,1)
          (11,3)  -> (10,3)(12,3)(11,4)(11,2)
          (11,4)  -> (10,4)(12,4)(11,5)(11,3)
          (11,5)  -> (10,5)(12,5)(11,6)(11,4)
          (11,6)  -> (10,6)(12,6)(11,7)(11,5)
          (11,7)  -> (10,7)(12,7)(11,8)(11,6)
          (11,8)  -> (10,8)(12,8)(11,9)(11,7)
          (11,9)  -> (10,9)(12,9)(11,10)(11,8)
          (11,10) -> (10,10)(12,10)(11,11)(11,9)
          (11,11) -> (10,11)(12,11)(11,12)(11,10)
          (11,12) -> (10,12)(12,12)(11,13)(11,11)
          (11,13) -> (10,13)(12,13)(11,14)(11,12)
          (11,14) -> (10,14)(12,14)(11,15)(11,13)
          (11,15) -> (10,15)(12,15)(11,16)(11,14)
          (11,16) -> (10,16)(12,16)(11,17)(11,15)
          (11,17) -> (10,17)(12,17)(11,18)(11,16)
          (11,18) -> (10,18)(12,18)(11,19)(11,17)
          (11,19) -> (10,19)(12,19)(11,20)(11,18)
          (11,20) -> (10,20)(12,20)(11,21)(11,19)
          (11,21) -> (10,21)(12,21)(11,22)(11,20)
          (11,22) -> (10,22)(12,22)(11,23)(11,21)
          (11,23) -> (10,23)(12,23)(11,24)(11,22)
          (11,24) -> (10,24)(12,24)(11,25)(11,23)
          (11,25) -> (10,25)(12,25)(11,26)(11,24)
          (11,26) -> (10,26)(12,26)(11,27)(11,25)
          (11,27) -> (10,27)(12,27)(11,28)(11,26)
          (11,28) -> (10,28)(12,28)(11,29)(11,27)
          (11,29) -> (10,29)(12,29)(11,30)(11,28)
          (11,30) -> (10,30)(12,30)(11,31)(11,29)
          (11,31) -> (10,31)(12,31)(11,32)(11,30)
          (11,32) -> (10,32)(12,32)(11,33)(11,31)
          (11,33) -> (10,33)(12,33)(11,34)(11,32)
          (11,34) -> (10,34)(12,34)(11,35)(11,33)
          (11,35) -> (10,35)(12,35)(11,36)(11,34)
          (11,36) -> (10,36)(12,36)(11,37)(11,35)
          (11,37) -> (10,37)(12,37)(11,38)(11,36)
          (11,38) -> (10,38)(12,38)(11,39)(11,37)
          (11,39) -> (10,39)(12,39)(11,40)(11,38)
          (11,40) -> (10,40)(12,40)(11,41)(11,39)
          (11,41) -> (10,41)(12,41)(11,42)(11,40)
          (11,42) -> (10,42)(12,42)(11,43)(11,41)
          (11,43) -> (10,43)(12,43)(11,44)(11,42)
          (11,44) -> (10,44)(12,44)(11,45)(11,43)
          (11,45) -> (10,45)(12,45)(11,46)(11,44)
          (11,46) -> (10,46)(12,46)(11,47)(11,45)
          (11,47) -> (10,47)(12,47)(11,48)(11,46)
          (11,48) -> (10,48)(12,48)(11,49)(11,47)
          (11,49) -> (10,49)(12,49)(11,50)(11,48)
          (11,50) -> (10,50)(12,50)(11,51)(11,49)
          (11,51) -> (10,51)(12,51)(11,52)(11,50)
          (11,52) -> (10,52)(12,52)(11,53)(11,51)
          (11,53) -> (10,53)(12,53)(11,54)(11,52)
          (11,54) -> (10,54)(12,54)(11,55)(11,53)
          (11,55) -> (10,55)(12,55)(11,56)(11,54)
          (11,56) -> (10,56)(12,56)(11,57)(11,55)
          (11,57) -> (10,57)(12,57)(11,58)(11,56)
          (11,58) -> (10,58)(12,58)(11,59)(11,57)
          (11,59) -> (10,59)(12,59)(11,60)(11,58)
          (11,60) -> (10,60)(12,60)(11,61)(11,59)
          (11,61) -> (10,61)(12,61)(11,62)(11,60)
          (11,62) -> (10,62)(12,62)(11,63)(11,61)
          (11,63) -> (10,63)(12,63)(11,62)
          (12,0)  -> (11,0)(13,0)(12,1)
          (12,1)  -> (11,1)(13,1)(12,2)(12,0)
          (12,2)  -> (11,2)(13,2)(12,3)(12,1)
          (12,3)  -> (11,3)(13,3)(12,4)(12,2)
          (12,4)  -> (11,4)(13,4)(12,5)(12,3)
          (12,5)  -> (11,5)(13,5)(12,6)(12,4)
          (12,6)  -> (11,6)(13,6)(12,7)(12,5)
          (12,7)  -> (11,7)(13,7)(12,8)(12,6)
          (12,8)  -> (11,8)(13,8)(12,9)(12,7)
          (12,9)  -> (11,9)(13,9)(12,10)(12,8)
          (12,10) -> (11,10)(13,10)(12,11)(12,9)
          (12,11) -> (11,11)(13,11)(12,12)(12,10)
          (12,12) -> (11,12)(13,12)(12,13)(12,11)
          (12,13) -> (11,13)(13,13)(12,14)(12,12)
          (12,14) -> (11,14)(13,14)(12,15)(12,13)
          (12,15) -> (11,15)(13,15)(12,16)(12,14)
          (12,16) -> (11,16)(13,16)(12,17)(12,15)
          (12,17) -> (11,17)(13,17)(12,18)(12,16)
          (12,18) -> (11,18)(13,18)(12,19)(12,17)
          (12,19) -> (11,19)(13,19)(12,20)(12,18)
          (12,20) -> (11,20)(13,20)(12,21)(12,19)
          (12,21) -> (11,21)(13,21)(12,22)(12,20)
          (12,22) -> (11,22)(13,22)(12,23)(12,21)
          (12,23) -> (11,23)(13,23)(12,24)(12,22)
          (12,24) -> (11,24)(13,24)(12,25)(12,23)
          (12,25) -> (11,25)(13,25)(12,26)(12,24)
          (12,26) -> (11,26)(13,26)(12,27)(12,25)
          (12,27) -> (11,27)(13,27)(12,28)(12,26)
          (12,28) -> (11,28)(13,28)(12,29)(12,27)
          (12,29) -> (11,29)(13,29)(12,30)(12,28)
          (12,30) -> (11,30)(13,30)(12,31)(12,29)
          (12,31) -> (11,31)(13,31)(12,32)(12,30)
          (12,32) -> (11,32)(13,32)(12,33)(12,31)
          (12,33) -> (11,33)(13,33)(12,34)(12,32)
          (12,34) -> (11,34)(13,34)(12,35)(12,33)
          (12,35) -> (11,35)(13,35)(12,36)(12,34)
          (12,36) -> (11,36)(13,36)(12,37)(12,35)
          (12,37) -> (11,37)(13,37)(12,38)(12,36)
          (12,38) -> (11,38)(13,38)(12,39)(12,37)
          (12,39) -> (11,39)(13,39)(12,40)(12,38)
          (12,40) -> (11,40)(13,40)(12,41)(12,39)
          (12,41) -> (11,41)(13,41)(12,42)(12,40)
          (12,42) -> (11,42)(13,42)(12,43)(12,41)
          (12,43) -> (11,43)(13,43)(12,44)(12,42)
          (12,44) -> (11,44)(13,44)(12,45)(12,43)
          (12,45) -> (11,45)(13,45)(12,46)(12,44)
          (12,46) -> (11,46)(13,46)(12,47)(12,45)
          (12,47) -> (11,47)(13,47)(12,48)(12,46)
          (12,48) -> (11,48)(13,48)(12,49)(12,47)
          (12,49) -> (11,49)(13,49)(12,50)(12,48)
          (12,50) -> (11,50)(13,50)(12,51)(12,49)
          (12,51) -> (11,51)(13,51)(12,52)(12,50)
          (12,52) -> (11,52)(13,52)(12,53)(12,51)
          (12,53) -> (11,53)(13,53)(12,54)(12,52)
          (12,54) -> (11,54)(13,54)(12,55)(12,53)
          (12,55) -> (11,55)(13,55)(12,56)(12,54)
          (12,56) -> (11,56)(13,56)(12,57)(12,55)
          (12,57) -> (11,57)(13,57)(12,58)(12,56)
          (12,58) -> (11,58)(13,58)(12,59)(12,57)
          (12,59) -> (11,59)(13,59)(12,60)(12,58)
          (12,60) -> (11,60)(13,60)(12,61)(12,59)
          (12,61) -> (11,61)(13,61)(12,62)(12,60)
          (12,62) -> (11,62)(13,62)(12,63)(12,61)
          (12,63) -> (11,63)(13,63)(12,62)
          (13,0)  -> (12,0)(14,0)(13,1)
          (13,1)  -> (12,1)(14,1)(13,2)(13,0)
          (13,2)  -> (12,2)(14,2)(13,3)(13,1)
          (13,3)  -> (12,3)(14,3)(13,4)(13,2)
          (13,4)  -> (12,4)(14,4)(13,5)(13,3)
          (13,5)  -> (12,5)(14,5)(13,6)(13,4)
          (13,6)  -> (12,6)(14,6)(13,7)(13,5)
          (13,7)  -> (12,7)(14,7)(13,8)(13,6)
          (13,8)  -> (12,8)(14,8)(13,9)(13,7)
          (13,9)  -> (12,9)(14,9)(13,10)(13,8)
          (13,10) -> (12,10)(14,10)(13,11)(13,9)
          (13,11) -> (12,11)(14,11)(13,12)(13,10)
          (13,12) -> (12,12)(14,12)(13,13)(13,11)
          (13,13) -> (12,13)(14,13)(13,14)(13,12)
          (13,14) -> (12,14)(14,14)(13,15)(13,13)
          (13,15) -> (12,15)(14,15)(13,16)(13,14)
          (13,16) -> (12,16)(14,16)(13,17)(13,15)
          (13,17) -> (12,17)(14,17)(13,18)(13,16)
          (13,18) -> (12,18)(14,18)(13,19)(13,17)
          (13,19) -> (12,19)(14,19)(13,20)(13,18)
          (13,20) -> (12,20)(14,20)(13,21)(13,19)
          (13,21) -> (12,21)(14,21)(13,22)(13,20)
          (13,22) -> (12,22)(14,22)(13,23)(13,21)
          (13,23) -> (12,23)(14,23)(13,24)(13,22)
          (13,24) -> (12,24)(14,24)(13,25)(13,23)
          (13,25) -> (12,25)(14,25)(13,26)(13,24)
          (13,26) -> (12,26)(14,26)(13,27)(13,25)
          (13,27) -> (12,27)(14,27)(13,28)(13,26)
          (13,28) -> (12,28)(14,28)(13,29)(13,27)
          (13,29) -> (12,29)(14,29)(13,30)(13,28)
          (13,30) -> (12,30)(14,30)(13,31)(13,29)
          (13,31) -> (12,31)(14,31)(13,32)(13,30)
          (13,32) -> (12,32)(14,32)(13,33)(13,31)
          (13,33) -> (12,33)(14,33)(13,34)(13,32)
          (13,34) -> (12,34)(14,34)(13,35)(13,33)
          (13,35) -> (12,35)(14,35)(13,36)(13,34)
          (13,36) -> (12,36)(14,36)(13,37)(13,35)
          (13,37) -> (12,37)(14,37)(13,38)(13,36)
          (13,38) -> (12,38)(14,38)(13,39)(13,37)
          (13,39) -> (12,39)(14,39)(13,40)(13,38)
          (13,40) -> (12,40)(14,40)(13,41)(13,39)
          (13,41) -> (12,41)(14,41)(13,42)(13,40)
          (13,42) -> (12,42)(14,42)(13,43)(13,41)
          (13,43) -> (12,43)(14,43)(13,44)(13,42)
          (13,44) -> (12,44)(14,44)(13,45)(13,43)
          (13,45) -> (12,45)(14,45)(13,46)(13,44)
          (13,46) -> (12,46)(14,46)(13,47)(13,45)
          (13,47) -> (12,47)(14,47)(13,48)(13,46)
          (13,48) -> (12,48)(14,48)(13,49)(13,47)
          (13,49) -> (12,49)(14,49)(13,50)(13,48)
          (13,50) -> (12,50)(14,50)(13,51)(13,49)
          (13,51) -> (12,51)(14,51)(13,52)(13,50)
          (13,52) -> (12,52)(14,52)(13,53)(13,51)
          (13,53) -> (12,53)(14,53)(13,54)(13,52)
          (13,54) -> (12,54)(14,54)(13,55)(13,53)
          (13,55) -> (12,55)(14,55)(13,56)(13,54)
          (13,56) -> (12,56)(14,56)(13,57)(13,55)
          (13,57) -> (12,57)(14,57)(13,58)(13,56)
          (13,58) -> (12,58)(14,58)(13,59)(13,57)
          (13,59) -> (12,59)(14,59)(13,60)(13,58)
          (13,60) -> (12,60)(14,60)(13,61)(13,59)
          (13,61) -> (12,61)(14,61)(13,62)(13,60)
          (13,62) -> (12,62)(14,62)(13,63)(13,61)
          (13,63) -> (12,63)(14,63)(13,62)
          (14,0)  -> (13,0)(15,0)(14,1)
          (14,1)  -> (13,1)(15,1)(14,2)(14,0)
          (14,2)  -> (13,2)(15,2)(14,3)(14,1)
          (14,3)  -> (13,3)(15,3)(14,4)(14,2)
          (14,4)  -> (13,4)(15,4)(14,5)(14,3)
          (14,5)  -> (13,5)(15,5)(14,6)(14,4)
          (14,6)  -> (13,6)(15,6)(14,7)(14,5)
          (14,7)  -> (13,7)(15,7)(14,8)(14,6)
          (14,8)  -> (13,8)(15,8)(14,9)(14,7)
          (14,9)  -> (13,9)(15,9)(14,10)(14,8)
          (14,10) -> (13,10)(15,10)(14,11)(14,9)
          (14,11) -> (13,11)(15,11)(14,12)(14,10)
          (14,12) -> (13,12)(15,12)(14,13)(14,11)
          (14,13) -> (13,13)(15,13)(14,14)(14,12)
          (14,14) -> (13,14)(15,14)(14,15)(14,13)
          (14,15) -> (13,15)(15,15)(14,16)(14,14)
          (14,16) -> (13,16)(15,16)(14,17)(14,15)
          (14,17) -> (13,17)(15,17)(14,18)(14,16)
          (14,18) -> (13,18)(15,18)(14,19)(14,17)
          (14,19) -> (13,19)(15,19)(14,20)(14,18)
          (14,20) -> (13,20)(15,20)(14,21)(14,19)
          (14,21) -> (13,21)(15,21)(14,22)(14,20)
          (14,22) -> (13,22)(15,22)(14,23)(14,21)
          (14,23) -> (13,23)(15,23)(14,24)(14,22)
          (14,24) -> (13,24)(15,24)(14,25)(14,23)
          (14,25) -> (13,25)(15,25)(14,26)(14,24)
          (14,26) -> (13,26)(15,26)(14,27)(14,25)
          (14,27) -> (13,27)(15,27)(14,28)(14,26)
          (14,28) -> (13,28)(15,28)(14,29)(14,27)
          (14,29) -> (13,29)(15,29)(14,30)(14,28)
          (14,30) -> (13,30)(15,30)(14,31)(14,29)
          (14,31) -> (13,31)(15,31)(14,32)(14,30)
          (14,32) -> (13,32)(15,32)(14,33)(14,31)
          (14,33) -> (13,33)(15,33)(14,34)(14,32)
          (14,34) -> (13,34)(15,34)(14,35)(14,33)
          (14,35) -> (13,35)(15,35)(14,36)(14,34)
          (14,36) -> (13,36)(15,36)(14,37)(14,35)
          (14,37) -> (13,37)(15,37)(14,38)(14,36)
          (14,38) -> (13,38)(15,38)(14,39)(14,37)
          (14,39) -> (13,39)(15,39)(14,40)(14,38)
          (14,40) -> (13,40)(15,40)(14,41)(14,39)
          (14,41) -> (13,41)(15,41)(14,42)(14,40)
          (14,42) -> (13,42)(15,42)(14,43)(14,41)
          (14,43) -> (13,43)(15,43)(14,44)(14,42)
          (14,44) -> (13,44)(15,44)(14,45)(14,43)
          (14,45) -> (13,45)(15,45)(14,46)(14,44)
          (14,46) -> (13,46)(15,46)(14,47)(14,45)
          (14,47) -> (13,47)(15,47)(14,48)(14,46)
          (14,48) -> (13,48)(15,48)(14,49)(14,47)
          (14,49) -> (13,49)(15,49)(14,50)(14,48)
          (14,50) -> (13,50)(15,50)(14,51)(14,49)
          (14,51) -> (13,51)(15,51)(14,52)(14,50)
          (14,52) -> (13,52)(15,52)(14,53)(14,51)
          (14,53) -> (13,53)(15,53)(14,54)(14,52)
          (14,54) -> (13,54)(15,54)(14,55)(14,53)
          (14,55) -> (13,55)(15,55)(14,56)(14,54)
          (14,56) -> (13,56)(15,56)(14,57)(14,55)
          (14,57) -> (13,57)(15,57)(14,58)(14,56)
          (14,58) -> (13,58)(15,58)(14,59)(14,57)
          (14,59) -> (13,59)(15,59)(14,60)(14,58)
          (14,60) -> (13,60)(15,60)(14,61)(14,59)
          (14,61) -> (13,61)(15,61)(14,62)(14,60)
          (14,62) -> (13,62)(15,62)(14,63)(14,61)
          (14,63) -> (13,63)(15,63)(14,62)
          (15,0)  -> (14,0)(16,0)(15,1)
          (15,1)  -> (14,1)(16,1)(15,2)(15,0)
          (15,2)  -> (14,2)(16,2)(15,3)(15,1)
          (15,3)  -> (14,3)(16,3)(15,4)(15,2)
          (15,4)  -> (14,4)(16,4)(15,5)(15,3)
          (15,5)  -> (14,5)(16,5)(15,6)(15,4)
          (15,6)  -> (14,6)(16,6)(15,7)(15,5)
          (15,7)  -> (14,7)(16,7)(15,8)(15,6)
          (15,8)  -> (14,8)(16,8)(15,9)(15,7)
          (15,9)  -> (14,9)(16,9)(15,10)(15,8)
          (15,10) -> (14,10)(16,10)(15,11)(15,9)
          (15,11) -> (14,11)(16,11)(15,12)(15,10)
          (15,12) -> (14,12)(16,12)(15,13)(15,11)
          (15,13) -> (14,13)(16,13)(15,14)(15,12)
          (15,14) -> (14,14)(16,14)(15,15)(15,13)
          (15,15) -> (14,15)(16,15)(15,16)(15,14)
          (15,16) -> (14,16)(16,16)(15,17)(15,15)
          (15,17) -> (14,17)(16,17)(15,18)(15,16)
          (15,18) -> (14,18)(16,18)(15,19)(15,17)
          (15,19) -> (14,19)(16,19)(15,20)(15,18)
          (15,20) -> (14,20)(16,20)(15,21)(15,19)
          (15,21) -> (14,21)(16,21)(15,22)(15,20)
          (15,22) -> (14,22)(16,22)(15,23)(15,21)
          (15,23) -> (14,23)(16,23)(15,24)(15,22)
          (15,24) -> (14,24)(16,24)(15,25)(15,23)
          (15,25) -> (14,25)(16,25)(15,26)(15,24)
          (15,26) -> (14,26)(16,26)(15,27)(15,25)
          (15,27) -> (14,27)(16,27)(15,28)(15,26)
          (15,28) -> (14,28)(16,28)(15,29)(15,27)
          (15,29) -> (14,29)(16,29)(15,30)(15,28)
          (15,30) -> (14,30)(16,30)(15,31)(15,29)
          (15,31) -> (14,31)(16,31)(15,32)(15,30)
          (15,32) -> (14,32)(16,32)(15,33)(15,31)
          (15,33) -> (14,33)(16,33)(15,34)(15,32)
          (15,34) -> (14,34)(16,34)(15,35)(15,33)
          (15,35) -> (14,35)(16,35)(15,36)(15,34)
          (15,36) -> (14,36)(16,36)(15,37)(15,35)
          (15,37) -> (14,37)(16,37)(15,38)(15,36)
          (15,38) -> (14,38)(16,38)(15,39)(15,37)
          (15,39) -> (14,39)(16,39)(15,40)(15,38)
          (15,40) -> (14,40)(16,40)(15,41)(15,39)
          (15,41) -> (14,41)(16,41)(15,42)(15,40)
          (15,42) -> (14,42)(16,42)(15,43)(15,41)
          (15,43) -> (14,43)(16,43)(15,44)(15,42)
          (15,44) -> (14,44)(16,44)(15,45)(15,43)
          (15,45) -> (14,45)(16,45)(15,46)(15,44)
          (15,46) -> (14,46)(16,46)(15,47)(15,45)
          (15,47) -> (14,47)(16,47)(15,48)(15,46)
          (15,48) -> (14,48)(16,48)(15,49)(15,47)
          (15,49) -> (14,49)(16,49)(15,50)(15,48)
          (15,50) -> (14,50)(16,50)(15,51)(15,49)
          (15,51) -> (14,51)(16,51)(15,52)(15,50)
          (15,52) -> (14,52)(16,52)(15,53)(15,51)
          (15,53) -> (14,53)(16,53)(15,54)(15,52)
          (15,54) -> (14,54)(16,54)(15,55)(15,53)
          (15,55) -> (14,55)(16,55)(15,56)(15,54)
          (15,56) -> (14,56)(16,56)(15,57)(15,55)
          (15,57) -> (14,57)(16,57)(15,58)(15,56)
          (15,58) -> (14,58)(16,58)(15,59)(15,57)
          (15,59) -> (14,59)(16,59)(15,60)(15,58)
          (15,60) -> (14,60)(16,60)(15,61)(15,59)
          (15,61) -> (14,61)(16,61)(15,62)(15,60)
          (15,62) -> (14,62)(16,62)(15,63)(15,61)
          (15,63) -> (14,63)(16,63)(15,62)
          (16,0)  -> (15,0)(17,0)(16,1)
          (16,1)  -> (15,1)(17,1)(16,2)(16,0)
          (16,2)  -> (15,2)(17,2)(16,3)(16,1)
          (16,3)  -> (15,3)(17,3)(16,4)(16,2)
          (16,4)  -> (15,4)(17,4)(16,5)(16,3)
          (16,5)  -> (15,5)(17,5)(16,6)(16,4)
          (16,6)  -> (15,6)(17,6)(16,7)(16,5)
          (16,7)  -> (15,7)(17,7)(16,8)(16,6)
          (16,8)  -> (15,8)(17,8)(16,9)(16,7)
          (16,9)  -> (15,9)(17,9)(16,10)(16,8)
          (16,10) -> (15,10)(17,10)(16,11)(16,9)
          (16,11) -> (15,11)(17,11)(16,12)(16,10)
          (16,12) -> (15,12)(17,12)(16,13)(16,11)
          (16,13) -> (15,13)(17,13)(16,14)(16,12)
          (16,14) -> (15,14)(17,14)(16,15)(16,13)
          (16,15) -> (15,15)(17,15)(16,16)(16,14)
          (16,16) -> (15,16)(17,16)(16,17)(16,15)
          (16,17) -> (15,17)(17,17)(16,18)(16,16)
          (16,18) -> (15,18)(17,18)(16,19)(16,17)
          (16,19) -> (15,19)(17,19)(16,20)(16,18)
          (16,20) -> (15,20)(17,20)(16,21)(16,19)
          (16,21) -> (15,21)(17,21)(16,22)(16,20)
          (16,22) -> (15,22)(17,22)(16,23)(16,21)
          (16,23) -> (15,23)(17,23)(16,24)(16,22)
          (16,24) -> (15,24)(17,24)(16,25)(16,23)
          (16,25) -> (15,25)(17,25)(16,26)(16,24)
          (16,26) -> (15,26)(17,26)(16,27)(16,25)
          (16,27) -> (15,27)(17,27)(16,28)(16,26)
          (16,28) -> (15,28)(17,28)(16,29)(16,27)
          (16,29) -> (15,29)(17,29)(16,30)(16,28)
          (16,30) -> (15,30)(17,30)(16,31)(16,29)
          (16,31) -> (15,31)(17,31)(16,32)(16,30)
          (16,32) -> (15,32)(17,32)(16,33)(16,31)
          (16,33) -> (15,33)(17,33)(16,34)(16,32)
          (16,34) -> (15,34)(17,34)(16,35)(16,33)
          (16,35) -> (15,35)(17,35)(16,36)(16,34)
          (16,36) -> (15,36)(17,36)(16,37)(16,35)
          (16,37) -> (15,37)(17,37)(16,38)(16,36)
          (16,38) -> (15,38)(17,38)(16,39)(16,37)
          (16,39) -> (15,39)(17,39)(16,40)(16,38)
          (16,40) -> (15,40)(17,40)(16,41)(16,39)
          (16,41) -> (15,41)(17,41)(16,42)(16,40)
          (16,42) -> (15,42)(17,42)(16,43)(16,41)
          (16,43) -> (15,43)(17,43)(16,44)(16,42)
          (16,44) -> (15,44)(17,44)(16,45)(16,43)
          (16,45) -> (15,45)(17,45)(16,46)(16,44)
          (16,46) -> (15,46)(17,46)(16,47)(16,45)
          (16,47) -> (15,47)(17,47)(16,48)(16,46)
          (16,48) -> (15,48)(17,48)(16,49)(16,47)
          (16,49) -> (15,49)(17,49)(16,50)(16,48)
          (16,50) -> (15,50)(17,50)(16,51)(16,49)
          (16,51) -> (15,51)(17,51)(16,52)(16,50)
          (16,52) -> (15,52)(17,52)(16,53)(16,51)
          (16,53) -> (15,53)(17,53)(16,54)(16,52)
          (16,54) -> (15,54)(17,54)(16,55)(16,53)
          (16,55) -> (15,55)(17,55)(16,56)(16,54)
          (16,56) -> (15,56)(17,56)(16,57)(16,55)
          (16,57) -> (15,57)(17,57)(16,58)(16,56)
          (16,58) -> (15,58)(17,58)(16,59)(16,57)
          (16,59) -> (15,59)(17,59)(16,60)(16,58)
          (16,60) -> (15,60)(17,60)(16,61)(16,59)
          (16,61) -> (15,61)(17,61)(16,62)(16,60)
          (16,62) -> (15,62)(17,62)(16,63)(16,61)
          (16,63) -> (15,63)(17,63)(16,62)
          (17,0)  -> (16,0)(18,0)(17,1)
          (17,1)  -> (16,1)(18,1)(17,2)(17,0)
          (17,2)  -> (16,2)(18,2)(17,3)(17,1)
          (17,3)  -> (16,3)(18,3)(17,4)(17,2)
          (17,4)  -> (16,4)(18,4)(17,5)(17,3)
          (17,5)  -> (16,5)(18,5)(17,6)(17,4)
          (17,6)  -> (16,6)(18,6)(17,7)(17,5)
          (17,7)  -> (16,7)(18,7)(17,8)(17,6)
          (17,8)  -> (16,8)(18,8)(17,9)(17,7)
          (17,9)  -> (16,9)(18,9)(17,10)(17,8)
          (17,10) -> (16,10)(18,10)(17,11)(17,9)
          (17,11) -> (16,11)(18,11)(17,12)(17,10)
          (17,12) -> (16,12)(18,12)(17,13)(17,11)
          (17,13) -> (16,13)(18,13)(17,14)(17,12)
          (17,14) -> (16,14)(18,14)(17,15)(17,13)
          (17,15) -> (16,15)(18,15)(17,16)(17,14)
          (17,16) -> (16,16)(18,16)(17,17)(17,15)
          (17,17) -> (16,17)(18,17)(17,18)(17,16)
          (17,18) -> (16,18)(18,18)(17,19)(17,17)
          (17,19) -> (16,19)(18,19)(17,20)(17,18)
          (17,20) -> (16,20)(18,20)(17,21)(17,19)
          (17,21) -> (16,21)(18,21)(17,22)(17,20)
          (17,22) -> (16,22)(18,22)(17,23)(17,21)
          (17,23) -> (16,23)(18,23)(17,24)(17,22)
          (17,24) -> (16,24)(18,24)(17,25)(17,23)
          (17,25) -> (16,25)(18,25)(17,26)(17,24)
          (17,26) -> (16,26)(18,26)(17,27)(17,25)
          (17,27) -> (16,27)(18,27)(17,28)(17,26)
          (17,28) -> (16,28)(18,28)(17,29)(17,27)
          (17,29) -> (16,29)(18,29)(17,30)(17,28)
          (17,30) -> (16,30)(18,30)(17,31)(17,29)
          (17,31) -> (16,31)(18,31)(17,32)(17,30)
          (17,32) -> (16,32)(18,32)(17,33)(17,31)
          (17,33) -> (16,33)(18,33)(17,34)(17,32)
          (17,34) -> (16,34)(18,34)(17,35)(17,33)
          (17,35) -> (16,35)(18,35)(17,36)(17,34)
          (17,36) -> (16,36)(18,36)(17,37)(17,35)
          (17,37) -> (16,37)(18,37)(17,38)(17,36)
          (17,38) -> (16,38)(18,38)(17,39)(17,37)
          (17,39) -> (16,39)(18,39)(17,40)(17,38)
          (17,40) -> (16,40)(18,40)(17,41)(17,39)
          (17,41) -> (16,41)(18,41)(17,42)(17,40)
          (17,42) -> (16,42)(18,42)(17,43)(17,41)
          (17,43) -> (16,43)(18,43)(17,44)(17,42)
          (17,44) -> (16,44)(18,44)(17,45)(17,43)
          (17,45) -> (16,45)(18,45)(17,46)(17,44)
          (17,46) -> (16,46)(18,46)(17,47)(17,45)
          (17,47) -> (16,47)(18,47)(17,48)(17,46)
          (17,48) -> (16,48)(18,48)(17,49)(17,47)
          (17,49) -> (16,49)(18,49)(17,50)(17,48)
          (17,50) -> (16,50)(18,50)(17,51)(17,49)
          (17,51) -> (16,51)(18,51)(17,52)(17,50)
          (17,52) -> (16,52)(18,52)(17,53)(17,51)
          (17,53) -> (16,53)(18,53)(17,54)(17,52)
          (17,54) -> (16,54)(18,54)(17,55)(17,53)
          (17,55) -> (16,55)(18,55)(17,56)(17,54)
          (17,56) -> (16,56)(18,56)(17,57)(17,55)
          (17,57) -> (16,57)(18,57)(17,58)(17,56)
          (17,58) -> (16,58)(18,58)(17,59)(17,57)
          (17,59) -> (16,59)(18,59)(17,60)(17,58)
          (17,60) -> (16,60)(18,60)(17,61)(17,59)
          (17,61) -> (16,61)(18,61)(17,62)(17,60)
          (17,62) -> (16,62)(18,62)(17,63)(17,61)
          (17,63) -> (16,63)(18,63)(17,62)
          (18,0)  -> (17,0)(19,0)(18,1)
          (18,1)  -> (17,1)(19,1)(18,2)(18,0)
          (18,2)  -> (17,2)(19,2)(18,3)(18,1)
          (18,3)  -> (17,3)(19,3)(18,4)(18,2)
          (18,4)  -> (17,4)(19,4)(18,5)(18,3)
          (18,5)  -> (17,5)(19,5)(18,6)(18,4)
          (18,6)  -> (17,6)(19,6)(18,7)(18,5)
          (18,7)  -> (17,7)(19,7)(18,8)(18,6)
          (18,8)  -> (17,8)(19,8)(18,9)(18,7)
          (18,9)  -> (17,9)(19,9)(18,10)(18,8)
          (18,10) -> (17,10)(19,10)(18,11)(18,9)
          (18,11) -> (17,11)(19,11)(18,12)(18,10)
          (18,12) -> (17,12)(19,12)(18,13)(18,11)
          (18,13) -> (17,13)(19,13)(18,14)(18,12)
          (18,14) -> (17,14)(19,14)(18,15)(18,13)
          (18,15) -> (17,15)(19,15)(18,16)(18,14)
          (18,16) -> (17,16)(19,16)(18,17)(18,15)
          (18,17) -> (17,17)(19,17)(18,18)(18,16)
          (18,18) -> (17,18)(19,18)(18,19)(18,17)
          (18,19) -> (17,19)(19,19)(18,20)(18,18)
          (18,20) -> (17,20)(19,20)(18,21)(18,19)
          (18,21) -> (17,21)(19,21)(18,22)(18,20)
          (18,22) -> (17,22)(19,22)(18,23)(18,21)
          (18,23) -> (17,23)(19,23)(18,24)(18,22)
          (18,24) -> (17,24)(19,24)(18,25)(18,23)
          (18,25) -> (17,25)(19,25)(18,26)(18,24)
          (18,26) -> (17,26)(19,26)(18,27)(18,25)
          (18,27) -> (17,27)(19,27)(18,28)(18,26)
          (18,28) -> (17,28)(19,28)(18,29)(18,27)
          (18,29) -> (17,29)(19,29)(18,30)(18,28)
          (18,30) -> (17,30)(19,30)(18,31)(18,29)
          (18,31) -> (17,31)(19,31)(18,32)(18,30)
          (18,32) -> (17,32)(19,32)(18,33)(18,31)
          (18,33) -> (17,33)(19,33)(18,34)(18,32)
          (18,34) -> (17,34)(19,34)(18,35)(18,33)
          (18,35) -> (17,35)(19,35)(18,36)(18,34)
          (18,36) -> (17,36)(19,36)(18,37)(18,35)
          (18,37) -> (17,37)(19,37)(18,38)(18,36)
          (18,38) -> (17,38)(19,38)(18,39)(18,37)
          (18,39) -> (17,39)(19,39)(18,40)(18,38)
          (18,40) -> (17,40)(19,40)(18,41)(18,39)
          (18,41) -> (17,41)(19,41)(18,42)(18,40)
          (18,42) -> (17,42)(19,42)(18,43)(18,41)
          (18,43) -> (17,43)(19,43)(18,44)(18,42)
          (18,44) -> (17,44)(19,44)(18,45)(18,43)
          (18,45) -> (17,45)(19,45)(18,46)(18,44)
          (18,46) -> (17,46)(19,46)(18,47)(18,45)
          (18,47) -> (17,47)(19,47)(18,48)(18,46)
          (18,48) -> (17,48)(19,48)(18,49)(18,47)
          (18,49) -> (17,49)(19,49)(18,50)(18,48)
          (18,50) -> (17,50)(19,50)(18,51)(18,49)
          (18,51) -> (17,51)(19,51)(18,52)(18,50)
          (18,52) -> (17,52)(19,52)(18,53)(18,51)
          (18,53) -> (17,53)(19,53)(18,54)(18,52)
          (18,54) -> (17,54)(19,54)(18,55)(18,53)
          (18,55) -> (17,55)(19,55)(18,56)(18,54)
          (18,56) -> (17,56)(19,56)(18,57)(18,55)
          (18,57) -> (17,57)(19,57)(18,58)(18,56)
          (18,58) -> (17,58)(19,58)(18,59)(18,57)
          (18,59) -> (17,59)(19,59)(18,60)(18,58)
          (18,60) -> (17,60)(19,60)(18,61)(18,59)
          (18,61) -> (17,61)(19,61)(18,62)(18,60)
          (18,62) -> (17,62)(19,62)(18,63)(18,61)
          (18,63) -> (17,63)(19,63)(18,62)
          (19,0)  -> (18,0)(20,0)(19,1)
          (19,1)  -> (18,1)(20,1)(19,2)(19,0)
          (19,2)  -> (18,2)(20,2)(19,3)(19,1)
          (19,3)  -> (18,3)(20,3)(19,4)(19,2)
          (19,4)  -> (18,4)(20,4)(19,5)(19,3)
          (19,5)  -> (18,5)(20,5)(19,6)(19,4)
          (19,6)  -> (18,6)(20,6)(19,7)(19,5)
          (19,7)  -> (18,7)(20,7)(19,8)(19,6)
          (19,8)  -> (18,8)(20,8)(19,9)(19,7)
          (19,9)  -> (18,9)(20,9)(19,10)(19,8)
          (19,10) -> (18,10)(20,10)(19,11)(19,9)
          (19,11) -> (18,11)(20,11)(19,12)(19,10)
          (19,12) -> (18,12)(20,12)(19,13)(19,11)
          (19,13) -> (18,13)(20,13)(19,14)(19,12)
          (19,14) -> (18,14)(20,14)(19,15)(19,13)
          (19,15) -> (18,15)(20,15)(19,16)(19,14)
          (19,16) -> (18,16)(20,16)(19,17)(19,15)
          (19,17) -> (18,17)(20,17)(19,18)(19,16)
          (19,18) -> (18,18)(20,18)(19,19)(19,17)
          (19,19) -> (18,19)(20,19)(19,20)(19,18)
          (19,20) -> (18,20)(20,20)(19,21)(19,19)
          (19,21) -> (18,21)(20,21)(19,22)(19,20)
          (19,22) -> (18,22)(20,22)(19,23)(19,21)
          (19,23) -> (18,23)(20,23)(19,24)(19,22)
          (19,24) -> (18,24)(20,24)(19,25)(19,23)
          (19,25) -> (18,25)(20,25)(19,26)(19,24)
          (19,26) -> (18,26)(20,26)(19,27)(19,25)
          (19,27) -> (18,27)(20,27)(19,28)(19,26)
          (19,28) -> (18,28)(20,28)(19,29)(19,27)
          (19,29) -> (18,29)(20,29)(19,30)(19,28)
          (19,30) -> (18,30)(20,30)(19,31)(19,29)
          (19,31) -> (18,31)(20,31)(19,32)(19,30)
          (19,32) -> (18,32)(20,32)(19,33)(19,31)
          (19,33) -> (18,33)(20,33)(19,34)(19,32)
          (19,34) -> (18,34)(20,34)(19,35)(19,33)
          (19,35) -> (18,35)(20,35)(19,36)(19,34)
          (19,36) -> (18,36)(20,36)(19,37)(19,35)
          (19,37) -> (18,37)(20,37)(19,38)(19,36)
          (19,38) -> (18,38)(20,38)(19,39)(19,37)
          (19,39) -> (18,39)(20,39)(19,40)(19,38)
          (19,40) -> (18,40)(20,40)(19,41)(19,39)
          (19,41) -> (18,41)(20,41)(19,42)(19,40)
          (19,42) -> (18,42)(20,42)(19,43)(19,41)
          (19,43) -> (18,43)(20,43)(19,44)(19,42)
          (19,44) -> (18,44)(20,44)(19,45)(19,43)
          (19,45) -> (18,45)(20,45)(19,46)(19,44)
          (19,46) -> (18,46)(20,46)(19,47)(19,45)
          (19,47) -> (18,47)(20,47)(19,48)(19,46)
          (19,48) -> (18,48)(20,48)(19,49)(19,47)
          (19,49) -> (18,49)(20,49)(19,50)(19,48)
          (19,50) -> (18,50)(20,50)(19,51)(19,49)
          (19,51) -> (18,51)(20,51)(19,52)(19,50)
          (19,52) -> (18,52)(20,52)(19,53)(19,51)
          (19,53) -> (18,53)(20,53)(19,54)(19,52)
          (19,54) -> (18,54)(20,54)(19,55)(19,53)
          (19,55) -> (18,55)(20,55)(19,56)(19,54)
          (19,56) -> (18,56)(20,56)(19,57)(19,55)
          (19,57) -> (18,57)(20,57)(19,58)(19,56)
          (19,58) -> (18,58)(20,58)(19,59)(19,57)
          (19,59) -> (18,59)(20,59)(19,60)(19,58)
          (19,60) -> (18,60)(20,60)(19,61)(19,59)
          (19,61) -> (18,61)(20,61)(19,62)(19,60)
          (19,62) -> (18,62)(20,62)(19,63)(19,61)
          (19,63) -> (18,63)(20,63)(19,62)
          (20,0)  -> (19,0)(21,0)(20,1)
          (20,1)  -> (19,1)(21,1)(20,2)(20,0)
          (20,2)  -> (19,2)(21,2)(20,3)(20,1)
          (20,3)  -> (19,3)(21,3)(20,4)(20,2)
          (20,4)  -> (19,4)(21,4)(20,5)(20,3)
          (20,5)  -> (19,5)(21,5)(20,6)(20,4)
          (20,6)  -> (19,6)(21,6)(20,7)(20,5)
          (20,7)  -> (19,7)(21,7)(20,8)(20,6)
          (20,8)  -> (19,8)(21,8)(20,9)(20,7)
          (20,9)  -> (19,9)(21,9)(20,10)(20,8)
          (20,10) -> (19,10)(21,10)(20,11)(20,9)
          (20,11) -> (19,11)(21,11)(20,12)(20,10)
          (20,12) -> (19,12)(21,12)(20,13)(20,11)
          (20,13) -> (19,13)(21,13)(20,14)(20,12)
          (20,14) -> (19,14)(21,14)(20,15)(20,13)
          (20,15) -> (19,15)(21,15)(20,16)(20,14)
          (20,16) -> (19,16)(21,16)(20,17)(20,15)
          (20,17) -> (19,17)(21,17)(20,18)(20,16)
          (20,18) -> (19,18)(21,18)(20,19)(20,17)
          (20,19) -> (19,19)(21,19)(20,20)(20,18)
          (20,20) -> (19,20)(21,20)(20,21)(20,19)
          (20,21) -> (19,21)(21,21)(20,22)(20,20)
          (20,22) -> (19,22)(21,22)(20,23)(20,21)
          (20,23) -> (19,23)(21,23)(20,24)(20,22)
          (20,24) -> (19,24)(21,24)(20,25)(20,23)
          (20,25) -> (19,25)(21,25)(20,26)(20,24)
          (20,26) -> (19,26)(21,26)(20,27)(20,25)
          (20,27) -> (19,27)(21,27)(20,28)(20,26)
          (20,28) -> (19,28)(21,28)(20,29)(20,27)
          (20,29) -> (19,29)(21,29)(20,30)(20,28)
          (20,30) -> (19,30)(21,30)(20,31)(20,29)
          (20,31) -> (19,31)(21,31)(20,32)(20,30)
          (20,32) -> (19,32)(21,32)(20,33)(20,31)
          (20,33) -> (19,33)(21,33)(20,34)(20,32)
          (20,34) -> (19,34)(21,34)(20,35)(20,33)
          (20,35) -> (19,35)(21,35)(20,36)(20,34)
          (20,36) -> (19,36)(21,36)(20,37)(20,35)
          (20,37) -> (19,37)(21,37)(20,38)(20,36)
          (20,38) -> (19,38)(21,38)(20,39)(20,37)
          (20,39) -> (19,39)(21,39)(20,40)(20,38)
          (20,40) -> (19,40)(21,40)(20,41)(20,39)
          (20,41) -> (19,41)(21,41)(20,42)(20,40)
          (20,42) -> (19,42)(21,42)(20,43)(20,41)
          (20,43) -> (19,43)(21,43)(20,44)(20,42)
          (20,44) -> (19,44)(21,44)(20,45)(20,43)
          (20,45) -> (19,45)(21,45)(20,46)(20,44)
          (20,46) -> (19,46)(21,46)(20,47)(20,45)
          (20,47) -> (19,47)(21,47)(20,48)(20,46)
          (20,48) -> (19,48)(21,48)(20,49)(20,47)
          (20,49) -> (19,49)(21,49)(20,50)(20,48)
          (20,50) -> (19,50)(21,50)(20,51)(20,49)
          (20,51) -> (19,51)(21,51)(20,52)(20,50)
          (20,52) -> (19,52)(21,52)(20,53)(20,51)
          (20,53) -> (19,53)(21,53)(20,54)(20,52)
          (20,54) -> (19,54)(21,54)(20,55)(20,53)
          (20,55) -> (19,55)(21,55)(20,56)(20,54)
          (20,56) -> (19,56)(21,56)(20,57)(20,55)
          (20,57) -> (19,57)(21,57)(20,58)(20,56)
          (20,58) -> (19,58)(21,58)(20,59)(20,57)
          (20,59) -> (19,59)(21,59)(20,60)(20,58)
          (20,60) -> (19,60)(21,60)(20,61)(20,59)
          (20,61) -> (19,61)(21,61)(20,62)(20,60)
          (20,62) -> (19,62)(21,62)(20,63)(20,61)
          (20,63) -> (19,63)(21,63)(20,62)
          (21,0)  -> (20,0)(22,0)(21,1)
          (21,1)  -> (20,1)(22,1)(21,2)(21,0)
          (21,2)  -> (20,2)(22,2)(21,3)(21,1)
          (21,3)  -> (20,3)(22,3)(21,4)(21,2)
          (21,4)  -> (20,4)(22,4)(21,5)(21,3)
          (21,5)  -> (20,5)(22,5)(21,6)(21,4)
          (21,6)  -> (20,6)(22,6)(21,7)(21,5)
          (21,7)  -> (20,7)(22,7)(21,8)(21,6)
          (21,8)  -> (20,8)(22,8)(21,9)(21,7)
          (21,9)  -> (20,9)(22,9)(21,10)(21,8)
          (21,10) -> (20,10)(22,10)(21,11)(21,9)
          (21,11) -> (20,11)(22,11)(21,12)(21,10)
          (21,12) -> (20,12)(22,12)(21,13)(21,11)
          (21,13) -> (20,13)(22,13)(21,14)(21,12)
          (21,14) -> (20,14)(22,14)(21,15)(21,13)
          (21,15) -> (20,15)(22,15)(21,16)(21,14)
          (21,16) -> (20,16)(22,16)(21,17)(21,15)
          (21,17) -> (20,17)(22,17)(21,18)(21,16)
          (21,18) -> (20,18)(22,18)(21,19)(21,17)
          (21,19) -> (20,19)(22,19)(21,20)(21,18)
          (21,20) -> (20,20)(22,20)(21,21)(21,19)
          (21,21) -> (20,21)(22,21)(21,22)(21,20)
          (21,22) -> (20,22)(22,22)(21,23)(21,21)
          (21,23) -> (20,23)(22,23)(21,24)(21,22)
          (21,24) -> (20,24)(22,24)(21,25)(21,23)
          (21,25) -> (20,25)(22,25)(21,26)(21,24)
          (21,26) -> (20,26)(22,26)(21,27)(21,25)
          (21,27) -> (20,27)(22,27)(21,28)(21,26)
          (21,28) -> (20,28)(22,28)(21,29)(21,27)
          (21,29) -> (20,29)(22,29)(21,30)(21,28)
          (21,30) -> (20,30)(22,30)(21,31)(21,29)
          (21,31) -> (20,31)(22,31)(21,32)(21,30)
          (21,32) -> (20,32)(22,32)(21,33)(21,31)
          (21,33) -> (20,33)(22,33)(21,34)(21,32)
          (21,34) -> (20,34)(22,34)(21,35)(21,33)
          (21,35) -> (20,35)(22,35)(21,36)(21,34)
          (21,36) -> (20,36)(22,36)(21,37)(21,35)
          (21,37) -> (20,37)(22,37)(21,38)(21,36)
          (21,38) -> (20,38)(22,38)(21,39)(21,37)
          (21,39) -> (20,39)(22,39)(21,40)(21,38)
          (21,40) -> (20,40)(22,40)(21,41)(21,39)
          (21,41) -> (20,41)(22,41)(21,42)(21,40)
          (21,42) -> (20,42)(22,42)(21,43)(21,41)
          (21,43) -> (20,43)(22,43)(21,44)(21,42)
          (21,44) -> (20,44)(22,44)(21,45)(21,43)
          (21,45) -> (20,45)(22,45)(21,46)(21,44)
          (21,46) -> (20,46)(22,46)(21,47)(21,45)
          (21,47) -> (20,47)(22,47)(21,48)(21,46)
          (21,48) -> (20,48)(22,48)(21,49)(21,47)
          (21,49) -> (20,49)(22,49)(21,50)(21,48)
          (21,50) -> (20,50)(22,50)(21,51)(21,49)
          (21,51) -> (20,51)(22,51)(21,52)(21,50)
          (21,52) -> (20,52)(22,52)(21,53)(21,51)
          (21,53) -> (20,53)(22,53)(21,54)(21,52)
          (21,54) -> (20,54)(22,54)(21,55)(21,53)
          (21,55) -> (20,55)(22,55)(21,56)(21,54)
          (21,56) -> (20,56)(22,56)(21,57)(21,55)
          (21,57) -> (20,57)(22,57)(21,58)(21,56)
          (21,58) -> (20,58)(22,58)(21,59)(21,57)
          (21,59) -> (20,59)(22,59)(21,60)(21,58)
          (21,60) -> (20,60)(22,60)(21,61)(21,59)
          (21,61) -> (20,61)(22,61)(21,62)(21,60)
          (21,62) -> (20,62)(22,62)(21,63)(21,61)
          (21,63) -> (20,63)(22,63)(21,62)
          (22,0)  -> (21,0)(23,0)(22,1)
          (22,1)  -> (21,1)(23,1)(22,2)(22,0)
          (22,2)  -> (21,2)(23,2)(22,3)(22,1)
          (22,3)  -> (21,3)(23,3)(22,4)(22,2)
          (22,4)  -> (21,4)(23,4)(22,5)(22,3)
          (22,5)  -> (21,5)(23,5)(22,6)(22,4)
          (22,6)  -> (21,6)(23,6)(22,7)(22,5)
          (22,7)  -> (21,7)(23,7)(22,8)(22,6)
          (22,8)  -> (21,8)(23,8)(22,9)(22,7)
          (22,9)  -> (21,9)(23,9)(22,10)(22,8)
          (22,10) -> (21,10)(23,10)(22,11)(22,9)
          (22,11) -> (21,11)(23,11)(22,12)(22,10)
          (22,12) -> (21,12)(23,12)(22,13)(22,11)
          (22,13) -> (21,13)(23,13)(22,14)(22,12)
          (22,14) -> (21,14)(23,14)(22,15)(22,13)
          (22,15) -> (21,15)(23,15)(22,16)(22,14)
          (22,16) -> (21,16)(23,16)(22,17)(22,15)
          (22,17) -> (21,17)(23,17)(22,18)(22,16)
          (22,18) -> (21,18)(23,18)(22,19)(22,17)
          (22,19) -> (21,19)(23,19)(22,20)(22,18)
          (22,20) -> (21,20)(23,20)(22,21)(22,19)
          (22,21) -> (21,21)(23,21)(22,22)(22,20)
          (22,22) -> (21,22)(23,22)(22,23)(22,21)
          (22,23) -> (21,23)(23,23)(22,24)(22,22)
          (22,24) -> (21,24)(23,24)(22,25)(22,23)
          (22,25) -> (21,25)(23,25)(22,26)(22,24)
          (22,26) -> (21,26)(23,26)(22,27)(22,25)
          (22,27) -> (21,27)(23,27)(22,28)(22,26)
          (22,28) -> (21,28)(23,28)(22,29)(22,27)
          (22,29) -> (21,29)(23,29)(22,30)(22,28)
          (22,30) -> (21,30)(23,30)(22,31)(22,29)
          (22,31) -> (21,31)(23,31)(22,32)(22,30)
          (22,32) -> (21,32)(23,32)(22,33)(22,31)
          (22,33) -> (21,33)(23,33)(22,34)(22,32)
          (22,34) -> (21,34)(23,34)(22,35)(22,33)
          (22,35) -> (21,35)(23,35)(22,36)(22,34)
          (22,36) -> (21,36)(23,36)(22,37)(22,35)
          (22,37) -> (21,37)(23,37)(22,38)(22,36)
          (22,38) -> (21,38)(23,38)(22,39)(22,37)
          (22,39) -> (21,39)(23,39)(22,40)(22,38)
          (22,40) -> (21,40)(23,40)(22,41)(22,39)
          (22,41) -> (21,41)(23,41)(22,42)(22,40)
          (22,42) -> (21,42)(23,42)(22,43)(22,41)
          (22,43) -> (21,43)(23,43)(22,44)(22,42)
          (22,44) -> (21,44)(23,44)(22,45)(22,43)
          (22,45) -> (21,45)(23,45)(22,46)(22,44)
          (22,46) -> (21,46)(23,46)(22,47)(22,45)
          (22,47) -> (21,47)(23,47)(22,48)(22,46)
          (22,48) -> (21,48)(23,48)(22,49)(22,47)
          (22,49) -> (21,49)(23,49)(22,50)(22,48)
          (22,50) -> (21,50)(23,50)(22,51)(22,49)
          (22,51) -> (21,51)(23,51)(22,52)(22,50)
          (22,52) -> (21,52)(23,52)(22,53)(22,51)
          (22,53) -> (21,53)(23,53)(22,54)(22,52)
          (22,54) -> (21,54)(23,54)(22,55)(22,53)
          (22,55) -> (21,55)(23,55)(22,56)(22,54)
          (22,56) -> (21,56)(23,56)(22,57)(22,55)
          (22,57) -> (21,57)(23,57)(22,58)(22,56)
          (22,58) -> (21,58)(23,58)(22,59)(22,57)
          (22,59) -> (21,59)(23,59)(22,60)(22,58)
          (22,60) -> (21,60)(23,60)(22,61)(22,59)
          (22,61) -> (21,61)(23,61)(22,62)(22,60)
          (22,62) -> (21,62)(23,62)(22,63)(22,61)
          (22,63) -> (21,63)(23,63)(22,62)
          (23,0)  -> (22,0)(24,0)(23,1)
          (23,1)  -> (22,1)(24,1)(23,2)(23,0)
          (23,2)  -> (22,2)(24,2)(23,3)(23,1)
          (23,3)  -> (22,3)(24,3)(23,4)(23,2)
          (23,4)  -> (22,4)(24,4)(23,5)(23,3)
          (23,5)  -> (22,5)(24,5)(23,6)(23,4)
          (23,6)  -> (22,6)(24,6)(23,7)(23,5)
          (23,7)  -> (22,7)(24,7)(23,8)(23,6)
          (23,8)  -> (22,8)(24,8)(23,9)(23,7)
          (23,9)  -> (22,9)(24,9)(23,10)(23,8)
          (23,10) -> (22,10)(24,10)(23,11)(23,9)
          (23,11) -> (22,11)(24,11)(23,12)(23,10)
          (23,12) -> (22,12)(24,12)(23,13)(23,11)
          (23,13) -> (22,13)(24,13)(23,14)(23,12)
          (23,14) -> (22,14)(24,14)(23,15)(23,13)
          (23,15) -> (22,15)(24,15)(23,16)(23,14)
          (23,16) -> (22,16)(24,16)(23,17)(23,15)
          (23,17) -> (22,17)(24,17)(23,18)(23,16)
          (23,18) -> (22,18)(24,18)(23,19)(23,17)
          (23,19) -> (22,19)(24,19)(23,20)(23,18)
          (23,20) -> (22,20)(24,20)(23,21)(23,19)
          (23,21) -> (22,21)(24,21)(23,22)(23,20)
          (23,22) -> (22,22)(24,22)(23,23)(23,21)
          (23,23) -> (22,23)(24,23)(23,24)(23,22)
          (23,24) -> (22,24)(24,24)(23,25)(23,23)
          (23,25) -> (22,25)(24,25)(23,26)(23,24)
          (23,26) -> (22,26)(24,26)(23,27)(23,25)
          (23,27) -> (22,27)(24,27)(23,28)(23,26)
          (23,28) -> (22,28)(24,28)(23,29)(23,27)
          (23,29) -> (22,29)(24,29)(23,30)(23,28)
          (23,30) -> (22,30)(24,30)(23,31)(23,29)
          (23,31) -> (22,31)(24,31)(23,32)(23,30)
          (23,32) -> (22,32)(24,32)(23,33)(23,31)
          (23,33) -> (22,33)(24,33)(23,34)(23,32)
          (23,34) -> (22,34)(24,34)(23,35)(23,33)
          (23,35) -> (22,35)(24,35)(23,36)(23,34)
          (23,36) -> (22,36)(24,36)(23,37)(23,35)
          (23,37) -> (22,37)(24,37)(23,38)(23,36)
          (23,38) -> (22,38)(24,38)(23,39)(23,37)
          (23,39) -> (22,39)(24,39)(23,40)(23,38)
          (23,40) -> (22,40)(24,40)(23,41)(23,39)
          (23,41) -> (22,41)(24,41)(23,42)(23,40)
          (23,42) -> (22,42)(24,42)(23,43)(23,41)
          (23,43) -> (22,43)(24,43)(23,44)(23,42)
          (23,44) -> (22,44)(24,44)(23,45)(23,43)
          (23,45) -> (22,45)(24,45)(23,46)(23,44)
          (23,46) -> (22,46)(24,46)(23,47)(23,45)
          (23,47) -> (22,47)(24,47)(23,48)(23,46)
          (23,48) -> (22,48)(24,48)(23,49)(23,47)
          (23,49) -> (22,49)(24,49)(23,50)(23,48)
          (23,50) -> (22,50)(24,50)(23,51)(23,49)
          (23,51) -> (22,51)(24,51)(23,52)(23,50)
          (23,52) -> (22,52)(24,52)(23,53)(23,51)
          (23,53) -> (22,53)(24,53)(23,54)(23,52)
          (23,54) -> (22,54)(24,54)(23,55)(23,53)
          (23,55) -> (22,55)(24,55)(23,56)(23,54)
          (23,56) -> (22,56)(24,56)(23,57)(23,55)
          (23,57) -> (22,57)(24,57)(23,58)(23,56)
          (23,58) -> (22,58)(24,58)(23,59)(23,57)
          (23,59) -> (22,59)(24,59)(23,60)(23,58)
          (23,60) -> (22,60)(24,60)(23,61)(23,59)
          (23,61) -> (22,61)(24,61)(23,62)(23,60)
          (23,62) -> (22,62)(24,62)(23,63)(23,61)
          (23,63) -> (22,63)(24,63)(23,62)
          (24,0)  -> (23,0)(25,0)(24,1)
          (24,1)  -> (23,1)(25,1)(24,2)(24,0)
          (24,2)  -> (23,2)(25,2)(24,3)(24,1)
          (24,3)  -> (23,3)(25,3)(24,4)(24,2)
          (24,4)  -> (23,4)(25,4)(24,5)(24,3)
          (24,5)  -> (23,5)(25,5)(24,6)(24,4)
          (24,6)  -> (23,6)(25,6)(24,7)(24,5)
          (24,7)  -> (23,7)(25,7)(24,8)(24,6)
          (24,8)  -> (23,8)(25,8)(24,9)(24,7)
          (24,9)  -> (23,9)(25,9)(24,10)(24,8)
          (24,10) -> (23,10)(25,10)(24,11)(24,9)
          (24,11) -> (23,11)(25,11)(24,12)(24,10)
          (24,12) -> (23,12)(25,12)(24,13)(24,11)
          (24,13) -> (23,13)(25,13)(24,14)(24,12)
          (24,14) -> (23,14)(25,14)(24,15)(24,13)
          (24,15) -> (23,15)(25,15)(24,16)(24,14)
          (24,16) -> (23,16)(25,16)(24,17)(24,15)
          (24,17) -> (23,17)(25,17)(24,18)(24,16)
          (24,18) -> (23,18)(25,18)(24,19)(24,17)
          (24,19) -> (23,19)(25,19)(24,20)(24,18)
          (24,20) -> (23,20)(25,20)(24,21)(24,19)
          (24,21) -> (23,21)(25,21)(24,22)(24,20)
          (24,22) -> (23,22)(25,22)(24,23)(24,21)
          (24,23) -> (23,23)(25,23)(24,24)(24,22)
          (24,24) -> (23,24)(25,24)(24,25)(24,23)
          (24,25) -> (23,25)(25,25)(24,26)(24,24)
          (24,26) -> (23,26)(25,26)(24,27)(24,25)
          (24,27) -> (23,27)(25,27)(24,28)(24,26)
          (24,28) -> (23,28)(25,28)(24,29)(24,27)
          (24,29) -> (23,29)(25,29)(24,30)(24,28)
          (24,30) -> (23,30)(25,30)(24,31)(24,29)
          (24,31) -> (23,31)(25,31)(24,32)(24,30)
          (24,32) -> (23,32)(25,32)(24,33)(24,31)
          (24,33) -> (23,33)(25,33)(24,34)(24,32)
          (24,34) -> (23,34)(25,34)(24,35)(24,33)
          (24,35) -> (23,35)(25,35)(24,36)(24,34)
          (24,36) -> (23,36)(25,36)(24,37)(24,35)
          (24,37) -> (23,37)(25,37)(24,38)(24,36)
          (24,38) -> (23,38)(25,38)(24,39)(24,37)
          (24,39) -> (23,39)(25,39)(24,40)(24,38)
          (24,40) -> (23,40)(25,40)(24,41)(24,39)
          (24,41) -> (23,41)(25,41)(24,42)(24,40)
          (24,42) -> (23,42)(25,42)(24,43)(24,41)
          (24,43) -> (23,43)(25,43)(24,44)(24,42)
          (24,44) -> (23,44)(25,44)(24,45)(24,43)
          (24,45) -> (23,45)(25,45)(24,46)(24,44)
          (24,46) -> (23,46)(25,46)(24,47)(24,45)
          (24,47) -> (23,47)(25,47)(24,48)(24,46)
          (24,48) -> (23,48)(25,48)(24,49)(24,47)
          (24,49) -> (23,49)(25,49)(24,50)(24,48)
          (24,50) -> (23,50)(25,50)(24,51)(24,49)
          (24,51) -> (23,51)(25,51)(24,52)(24,50)
          (24,52) -> (23,52)(25,52)(24,53)(24,51)
          (24,53) -> (23,53)(25,53)(24,54)(24,52)
          (24,54) -> (23,54)(25,54)(24,55)(24,53)
          (24,55) -> (23,55)(25,55)(24,56)(24,54)
          (24,56) -> (23,56)(25,56)(24,57)(24,55)
          (24,57) -> (23,57)(25,57)(24,58)(24,56)
          (24,58) -> (23,58)(25,58)(24,59)(24,57)
          (24,59) -> (23,59)(25,59)(24,60)(24,58)
          (24,60) -> (23,60)(25,60)(24,61)(24,59)
          (24,61) -> (23,61)(25,61)(24,62)(24,60)
          (24,62) -> (23,62)(25,62)(24,63)(24,61)
          (24,63) -> (23,63)(25,63)(24,62)
          (25,0)  -> (24,0)(26,0)(25,1)
          (25,1)  -> (24,1)(26,1)(25,2)(25,0)
          (25,2)  -> (24,2)(26,2)(25,3)(25,1)
          (25,3)  -> (24,3)(26,3)(25,4)(25,2)
          (25,4)  -> (24,4)(26,4)(25,5)(25,3)
          (25,5)  -> (24,5)(26,5)(25,6)(25,4)
          (25,6)  -> (24,6)(26,6)(25,7)(25,5)
          (25,7)  -> (24,7)(26,7)(25,8)(25,6)
          (25,8)  -> (24,8)(26,8)(25,9)(25,7)
          (25,9)  -> (24,9)(26,9)(25,10)(25,8)
          (25,10) -> (24,10)(26,10)(25,11)(25,9)
          (25,11) -> (24,11)(26,11)(25,12)(25,10)
          (25,12) -> (24,12)(26,12)(25,13)(25,11)
          (25,13) -> (24,13)(26,13)(25,14)(25,12)
          (25,14) -> (24,14)(26,14)(25,15)(25,13)
          (25,15) -> (24,15)(26,15)(25,16)(25,14)
          (25,16) -> (24,16)(26,16)(25,17)(25,15)
          (25,17) -> (24,17)(26,17)(25,18)(25,16)
          (25,18) -> (24,18)(26,18)(25,19)(25,17)
          (25,19) -> (24,19)(26,19)(25,20)(25,18)
          (25,20) -> (24,20)(26,20)(25,21)(25,19)
          (25,21) -> (24,21)(26,21)(25,22)(25,20)
          (25,22) -> (24,22)(26,22)(25,23)(25,21)
          (25,23) -> (24,23)(26,23)(25,24)(25,22)
          (25,24) -> (24,24)(26,24)(25,25)(25,23)
          (25,25) -> (24,25)(26,25)(25,26)(25,24)
          (25,26) -> (24,26)(26,26)(25,27)(25,25)
          (25,27) -> (24,27)(26,27)(25,28)(25,26)
          (25,28) -> (24,28)(26,28)(25,29)(25,27)
          (25,29) -> (24,29)(26,29)(25,30)(25,28)
          (25,30) -> (24,30)(26,30)(25,31)(25,29)
          (25,31) -> (24,31)(26,31)(25,32)(25,30)
          (25,32) -> (24,32)(26,32)(25,33)(25,31)
          (25,33) -> (24,33)(26,33)(25,34)(25,32)
          (25,34) -> (24,34)(26,34)(25,35)(25,33)
          (25,35) -> (24,35)(26,35)(25,36)(25,34)
          (25,36) -> (24,36)(26,36)(25,37)(25,35)
          (25,37) -> (24,37)(26,37)(25,38)(25,36)
          (25,38) -> (24,38)(26,38)(25,39)(25,37)
          (25,39) -> (24,39)(26,39)(25,40)(25,38)
          (25,40) -> (24,40)(26,40)(25,41)(25,39)
          (25,41) -> (24,41)(26,41)(25,42)(25,40)
          (25,42) -> (24,42)(26,42)(25,43)(25,41)
          (25,43) -> (24,43)(26,43)(25,44)(25,42)
          (25,44) -> (24,44)(26,44)(25,45)(25,43)
          (25,45) -> (24,45)(26,45)(25,46)(25,44)
          (25,46) -> (24,46)(26,46)(25,47)(25,45)
          (25,47) -> (24,47)(26,47)(25,48)(25,46)
          (25,48) -> (24,48)(26,48)(25,49)(25,47)
          (25,49) -> (24,49)(26,49)(25,50)(25,48)
          (25,50) -> (24,50)(26,50)(25,51)(25,49)
          (25,51) -> (24,51)(26,51)(25,52)(25,50)
          (25,52) -> (24,52)(26,52)(25,53)(25,51)
          (25,53) -> (24,53)(26,53)(25,54)(25,52)
          (25,54) -> (24,54)(26,54)(25,55)(25,53)
          (25,55) -> (24,55)(26,55)(25,56)(25,54)
          (25,56) -> (24,56)(26,56)(25,57)(25,55)
          (25,57) -> (24,57)(26,57)(25,58)(25,56)
          (25,58) -> (24,58)(26,58)(25,59)(25,57)
          (25,59) -> (24,59)(26,59)(25,60)(25,58)
          (25,60) -> (24,60)(26,60)(25,61)(25,59)
          (25,61) -> (24,61)(26,61)(25,62)(25,60)
          (25,62) -> (24,62)(26,62)(25,63)(25,61)
          (25,63) -> (24,63)(26,63)(25,62)
          (26,0)  -> (25,0)(27,0)(26,1)
          (26,1)  -> (25,1)(27,1)(26,2)(26,0)
          (26,2)  -> (25,2)(27,2)(26,3)(26,1)
          (26,3)  -> (25,3)(27,3)(26,4)(26,2)
          (26,4)  -> (25,4)(27,4)(26,5)(26,3)
          (26,5)  -> (25,5)(27,5)(26,6)(26,4)
          (26,6)  -> (25,6)(27,6)(26,7)(26,5)
          (26,7)  -> (25,7)(27,7)(26,8)(26,6)
          (26,8)  -> (25,8)(27,8)(26,9)(26,7)
          (26,9)  -> (25,9)(27,9)(26,10)(26,8)
          (26,10) -> (25,10)(27,10)(26,11)(26,9)
          (26,11) -> (25,11)(27,11)(26,12)(26,10)
          (26,12) -> (25,12)(27,12)(26,13)(26,11)
          (26,13) -> (25,13)(27,13)(26,14)(26,12)
          (26,14) -> (25,14)(27,14)(26,15)(26,13)
          (26,15) -> (25,15)(27,15)(26,16)(26,14)
          (26,16) -> (25,16)(27,16)(26,17)(26,15)
          (26,17) -> (25,17)(27,17)(26,18)(26,16)
          (26,18) -> (25,18)(27,18)(26,19)(26,17)
          (26,19) -> (25,19)(27,19)(26,20)(26,18)
          (26,20) -> (25,20)(27,20)(26,21)(26,19)
          (26,21) -> (25,21)(27,21)(26,22)(26,20)
          (26,22) -> (25,22)(27,22)(26,23)(26,21)
          (26,23) -> (25,23)(27,23)(26,24)(26,22)
          (26,24) -> (25,24)(27,24)(26,25)(26,23)
          (26,25) -> (25,25)(27,25)(26,26)(26,24)
          (26,26) -> (25,26)(27,26)(26,27)(26,25)
          (26,27) -> (25,27)(27,27)(26,28)(26,26)
          (26,28) -> (25,28)(27,28)(26,29)(26,27)
          (26,29) -> (25,29)(27,29)(26,30)(26,28)
          (26,30) -> (25,30)(27,30)(26,31)(26,29)
          (26,31) -> (25,31)(27,31)(26,32)(26,30)
          (26,32) -> (25,32)(27,32)(26,33)(26,31)
          (26,33) -> (25,33)(27,33)(26,34)(26,32)
          (26,34) -> (25,34)(27,34)(26,35)(26,33)
          (26,35) -> (25,35)(27,35)(26,36)(26,34)
          (26,36) -> (25,36)(27,36)(26,37)(26,35)
          (26,37) -> (25,37)(27,37)(26,38)(26,36)
          (26,38) -> (25,38)(27,38)(26,39)(26,37)
          (26,39) -> (25,39)(27,39)(26,40)(26,38)
          (26,40) -> (25,40)(27,40)(26,41)(26,39)
          (26,41) -> (25,41)(27,41)(26,42)(26,40)
          (26,42) -> (25,42)(27,42)(26,43)(26,41)
          (26,43) -> (25,43)(27,43)(26,44)(26,42)
          (26,44) -> (25,44)(27,44)(26,45)(26,43)
          (26,45) -> (25,45)(27,45)(26,46)(26,44)
          (26,46) -> (25,46)(27,46)(26,47)(26,45)
          (26,47) -> (25,47)(27,47)(26,48)(26,46)
          (26,48) -> (25,48)(27,48)(26,49)(26,47)
          (26,49) -> (25,49)(27,49)(26,50)(26,48)
          (26,50) -> (25,50)(27,50)(26,51)(26,49)
          (26,51) -> (25,51)(27,51)(26,52)(26,50)
          (26,52) -> (25,52)(27,52)(26,53)(26,51)
          (26,53) -> (25,53)(27,53)(26,54)(26,52)
          (26,54) -> (25,54)(27,54)(26,55)(26,53)
          (26,55) -> (25,55)(27,55)(26,56)(26,54)
          (26,56) -> (25,56)(27,56)(26,57)(26,55)
          (26,57) -> (25,57)(27,57)(26,58)(26,56)
          (26,58) -> (25,58)(27,58)(26,59)(26,57)
          (26,59) -> (25,59)(27,59)(26,60)(26,58)
          (26,60) -> (25,60)(27,60)(26,61)(26,59)
          (26,61) -> (25,61)(27,61)(26,62)(26,60)
          (26,62) -> (25,62)(27,62)(26,63)(26,61)
          (26,63) -> (25,63)(27,63)(26,62)
          (27,0)  -> (26,0)(28,0)(27,1)
          (27,1)  -> (26,1)(28,1)(27,2)(27,0)
          (27,2)  -> (26,2)(28,2)(27,3)(27,1)
          (27,3)  -> (26,3)(28,3)(27,4)(27,2)
          (27,4)  -> (26,4)(28,4)(27,5)(27,3)
          (27,5)  -> (26,5)(28,5)(27,6)(27,4)
          (27,6)  -> (26,6)(28,6)(27,7)(27,5)
          (27,7)  -> (26,7)(28,7)(27,8)(27,6)
          (27,8)  -> (26,8)(28,8)(27,9)(27,7)
          (27,9)  -> (26,9)(28,9)(27,10)(27,8)
          (27,10) -> (26,10)(28,10)(27,11)(27,9)
          (27,11) -> (26,11)(28,11)(27,12)(27,10)
          (27,12) -> (26,12)(28,12)(27,13)(27,11)
          (27,13) -> (26,13)(28,13)(27,14)(27,12)
          (27,14) -> (26,14)(28,14)(27,15)(27,13)
          (27,15) -> (26,15)(28,15)(27,16)(27,14)
          (27,16) -> (26,16)(28,16)(27,17)(27,15)
          (27,17) -> (26,17)(28,17)(27,18)(27,16)
          (27,18) -> (26,18)(28,18)(27,19)(27,17)
          (27,19) -> (26,19)(28,19)(27,20)(27,18)
          (27,20) -> (26,20)(28,20)(27,21)(27,19)
          (27,21) -> (26,21)(28,21)(27,22)(27,20)
          (27,22) -> (26,22)(28,22)(27,23)(27,21)
          (27,23) -> (26,23)(28,23)(27,24)(27,22)
          (27,24) -> (26,24)(28,24)(27,25)(27,23)
          (27,25) -> (26,25)(28,25)(27,26)(27,24)
          (27,26) -> (26,26)(28,26)(27,27)(27,25)
          (27,27) -> (26,27)(28,27)(27,28)(27,26)
          (27,28) -> (26,28)(28,28)(27,29)(27,27)
          (27,29) -> (26,29)(28,29)(27,30)(27,28)
          (27,30) -> (26,30)(28,30)(27,31)(27,29)
          (27,31) -> (26,31)(28,31)(27,32)(27,30)
          (27,32) -> (26,32)(28,32)(27,33)(27,31)
          (27,33) -> (26,33)(28,33)(27,34)(27,32)
          (27,34) -> (26,34)(28,34)(27,35)(27,33)
          (27,35) -> (26,35)(28,35)(27,36)(27,34)
          (27,36) -> (26,36)(28,36)(27,37)(27,35)
          (27,37) -> (26,37)(28,37)(27,38)(27,36)
          (27,38) -> (26,38)(28,38)(27,39)(27,37)
          (27,39) -> (26,39)(28,39)(27,40)(27,38)
          (27,40) -> (26,40)(28,40)(27,41)(27,39)
          (27,41) -> (26,41)(28,41)(27,42)(27,40)
          (27,42) -> (26,42)(28,42)(27,43)(27,41)
          (27,43) -> (26,43)(28,43)(27,44)(27,42)
          (27,44) -> (26,44)(28,44)(27,45)(27,43)
          (27,45) -> (26,45)(28,45)(27,46)(27,44)
          (27,46) -> (26,46)(28,46)(27,47)(27,45)
          (27,47) -> (26,47)(28,47)(27,48)(27,46)
          (27,48) -> (26,48)(28,48)(27,49)(27,47)
          (27,49) -> (26,49)(28,49)(27,50)(27,48)
          (27,50) -> (26,50)(28,50)(27,51)(27,49)
          (27,51) -> (26,51)(28,51)(27,52)(27,50)
          (27,52) -> (26,52)(28,52)(27,53)(27,51)
          (27,53) -> (26,53)(28,53)(27,54)(27,52)
          (27,54) -> (26,54)(28,54)(27,55)(27,53)
          (27,55) -> (26,55)(28,55)(27,56)(27,54)
          (27,56) -> (26,56)(28,56)(27,57)(27,55)
          (27,57) -> (26,57)(28,57)(27,58)(27,56)
          (27,58) -> (26,58)(28,58)(27,59)(27,57)
          (27,59) -> (26,59)(28,59)(27,60)(27,58)
          (27,60) -> (26,60)(28,60)(27,61)(27,59)
          (27,61) -> (26,61)(28,61)(27,62)(27,60)
          (27,62) -> (26,62)(28,62)(27,63)(27,61)
          (27,63) -> (26,63)(28,63)(27,62)
          (28,0)  -> (27,0)(29,0)(28,1)
          (28,1)  -> (27,1)(29,1)(28,2)(28,0)
          (28,2)  -> (27,2)(29,2)(28,3)(28,1)
          (28,3)  -> (27,3)(29,3)(28,4)(28,2)
          (28,4)  -> (27,4)(29,4)(28,5)(28,3)
          (28,5)  -> (27,5)(29,5)(28,6)(28,4)
          (28,6)  -> (27,6)(29,6)(28,7)(28,5)
          (28,7)  -> (27,7)(29,7)(28,8)(28,6)
          (28,8)  -> (27,8)(29,8)(28,9)(28,7)
          (28,9)  -> (27,9)(29,9)(28,10)(28,8)
          (28,10) -> (27,10)(29,10)(28,11)(28,9)
          (28,11) -> (27,11)(29,11)(28,12)(28,10)
          (28,12) -> (27,12)(29,12)(28,13)(28,11)
          (28,13) -> (27,13)(29,13)(28,14)(28,12)
          (28,14) -> (27,14)(29,14)(28,15)(28,13)
          (28,15) -> (27,15)(29,15)(28,16)(28,14)
          (28,16) -> (27,16)(29,16)(28,17)(28,15)
          (28,17) -> (27,17)(29,17)(28,18)(28,16)
          (28,18) -> (27,18)(29,18)(28,19)(28,17)
          (28,19) -> (27,19)(29,19)(28,20)(28,18)
          (28,20) -> (27,20)(29,20)(28,21)(28,19)
          (28,21) -> (27,21)(29,21)(28,22)(28,20)
          (28,22) -> (27,22)(29,22)(28,23)(28,21)
          (28,23) -> (27,23)(29,23)(28,24)(28,22)
          (28,24) -> (27,24)(29,24)(28,25)(28,23)
          (28,25) -> (27,25)(29,25)(28,26)(28,24)
          (28,26) -> (27,26)(29,26)(28,27)(28,25)
          (28,27) -> (27,27)(29,27)(28,28)(28,26)
          (28,28) -> (27,28)(29,28)(28,29)(28,27)
          (28,29) -> (27,29)(29,29)(28,30)(28,28)
          (28,30) -> (27,30)(29,30)(28,31)(28,29)
          (28,31) -> (27,31)(29,31)(28,32)(28,30)
          (28,32) -> (27,32)(29,32)(28,33)(28,31)
          (28,33) -> (27,33)(29,33)(28,34)(28,32)
          (28,34) -> (27,34)(29,34)(28,35)(28,33)
          (28,35) -> (27,35)(29,35)(28,36)(28,34)
          (28,36) -> (27,36)(29,36)(28,37)(28,35)
          (28,37) -> (27,37)(29,37)(28,38)(28,36)
          (28,38) -> (27,38)(29,38)(28,39)(28,37)
          (28,39) -> (27,39)(29,39)(28,40)(28,38)
          (28,40) -> (27,40)(29,40)(28,41)(28,39)
          (28,41) -> (27,41)(29,41)(28,42)(28,40)
          (28,42) -> (27,42)(29,42)(28,43)(28,41)
          (28,43) -> (27,43)(29,43)(28,44)(28,42)
          (28,44) -> (27,44)(29,44)(28,45)(28,43)
          (28,45) -> (27,45)(29,45)(28,46)(28,44)
          (28,46) -> (27,46)(29,46)(28,47)(28,45)
          (28,47) -> (27,47)(29,47)(28,48)(28,46)
          (28,48) -> (27,48)(29,48)(28,49)(28,47)
          (28,49) -> (27,49)(29,49)(28,50)(28,48)
          (28,50) -> (27,50)(29,50)(28,51)(28,49)
          (28,51) -> (27,51)(29,51)(28,52)(28,50)
          (28,52) -> (27,52)(29,52)(28,53)(28,51)
          (28,53) -> (27,53)(29,53)(28,54)(28,52)
          (28,54) -> (27,54)(29,54)(28,55)(28,53)
          (28,55) -> (27,55)(29,55)(28,56)(28,54)
          (28,56) -> (27,56)(29,56)(28,57)(28,55)
          (28,57) -> (27,57)(29,57)(28,58)(28,56)
          (28,58) -> (27,58)(29,58)(28,59)(28,57)
          (28,59) -> (27,59)(29,59)(28,60)(28,58)
          (28,60) -> (27,60)(29,60)(28,61)(28,59)
          (28,61) -> (27,61)(29,61)(28,62)(28,60)
          (28,62) -> (27,62)(29,62)(28,63)(28,61)
          (28,63) -> (27,63)(29,63)(28,62)
          (29,0)  -> (28,0)(30,0)(29,1)
          (29,1)  -> (28,1)(30,1)(29,2)(29,0)
          (29,2)  -> (28,2)(30,2)(29,3)(29,1)
          (29,3)  -> (28,3)(30,3)(29,4)(29,2)
          (29,4)  -> (28,4)(30,4)(29,5)(29,3)
          (29,5)  -> (28,5)(30,5)(29,6)(29,4)
          (29,6)  -> (28,6)(30,6)(29,7)(29,5)
          (29,7)  -> (28,7)(30,7)(29,8)(29,6)
          (29,8)  -> (28,8)(30,8)(29,9)(29,7)
          (29,9)  -> (28,9)(30,9)(29,10)(29,8)
          (29,10) -> (28,10)(30,10)(29,11)(29,9)
          (29,11) -> (28,11)(30,11)(29,12)(29,10)
          (29,12) -> (28,12)(30,12)(29,13)(29,11)
          (29,13) -> (28,13)(30,13)(29,14)(29,12)
          (29,14) -> (28,14)(30,14)(29,15)(29,13)
          (29,15) -> (28,15)(30,15)(29,16)(29,14)
          (29,16) -> (28,16)(30,16)(29,17)(29,15)
          (29,17) -> (28,17)(30,17)(29,18)(29,16)
          (29,18) -> (28,18)(30,18)(29,19)(29,17)
          (29,19) -> (28,19)(30,19)(29,20)(29,18)
          (29,20) -> (28,20)(30,20)(29,21)(29,19)
          (29,21) -> (28,21)(30,21)(29,22)(29,20)
          (29,22) -> (28,22)(30,22)(29,23)(29,21)
          (29,23) -> (28,23)(30,23)(29,24)(29,22)
          (29,24) -> (28,24)(30,24)(29,25)(29,23)
          (29,25) -> (28,25)(30,25)(29,26)(29,24)
          (29,26) -> (28,26)(30,26)(29,27)(29,25)
          (29,27) -> (28,27)(30,27)(29,28)(29,26)
          (29,28) -> (28,28)(30,28)(29,29)(29,27)
          (29,29) -> (28,29)(30,29)(29,30)(29,28)
          (29,30) -> (28,30)(30,30)(29,31)(29,29)
          (29,31) -> (28,31)(30,31)(29,32)(29,30)
          (29,32) -> (28,32)(30,32)(29,33)(29,31)
          (29,33) -> (28,33)(30,33)(29,34)(29,32)
          (29,34) -> (28,34)(30,34)(29,35)(29,33)
          (29,35) -> (28,35)(30,35)(29,36)(29,34)
          (29,36) -> (28,36)(30,36)(29,37)(29,35)
          (29,37) -> (28,37)(30,37)(29,38)(29,36)
          (29,38) -> (28,38)(30,38)(29,39)(29,37)
          (29,39) -> (28,39)(30,39)(29,40)(29,38)
          (29,40) -> (28,40)(30,40)(29,41)(29,39)
          (29,41) -> (28,41)(30,41)(29,42)(29,40)
          (29,42) -> (28,42)(30,42)(29,43)(29,41)
          (29,43) -> (28,43)(30,43)(29,44)(29,42)
          (29,44) -> (28,44)(30,44)(29,45)(29,43)
          (29,45) -> (28,45)(30,45)(29,46)(29,44)
          (29,46) -> (28,46)(30,46)(29,47)(29,45)
          (29,47) -> (28,47)(30,47)(29,48)(29,46)
          (29,48) -> (28,48)(30,48)(29,49)(29,47)
          (29,49) -> (28,49)(30,49)(29,50)(29,48)
          (29,50) -> (28,50)(30,50)(29,51)(29,49)
          (29,51) -> (28,51)(30,51)(29,52)(29,50)
          (29,52) -> (28,52)(30,52)(29,53)(29,51)
          (29,53) -> (28,53)(30,53)(29,54)(29,52)
          (29,54) -> (28,54)(30,54)(29,55)(29,53)
          (29,55) -> (28,55)(30,55)(29,56)(29,54)
          (29,56) -> (28,56)(30,56)(29,57)(29,55)
          (29,57) -> (28,57)(30,57)(29,58)(29,56)
          (29,58) -> (28,58)(30,58)(29,59)(29,57)
          (29,59) -> (28,59)(30,59)(29,60)(29,58)
          (29,60) -> (28,60)(30,60)(29,61)(29,59)
          (29,61) -> (28,61)(30,61)(29,62)(29,60)
          (29,62) -> (28,62)(30,62)(29,63)(29,61)
          (29,63) -> (28,63)(30,63)(29,62)
          (30,0)  -> (29,0)(31,0)(30,1)
          (30,1)  -> (29,1)(31,1)(30,2)(30,0)
          (30,2)  -> (29,2)(31,2)(30,3)(30,1)
          (30,3)  -> (29,3)(31,3)(30,4)(30,2)
          (30,4)  -> (29,4)(31,4)(30,5)(30,3)
          (30,5)  -> (29,5)(31,5)(30,6)(30,4)
          (30,6)  -> (29,6)(31,6)(30,7)(30,5)
          (30,7)  -> (29,7)(31,7)(30,8)(30,6)
          (30,8)  -> (29,8)(31,8)(30,9)(30,7)
          (30,9)  -> (29,9)(31,9)(30,10)(30,8)
          (30,10) -> (29,10)(31,10)(30,11)(30,9)
          (30,11) -> (29,11)(31,11)(30,12)(30,10)
          (30,12) -> (29,12)(31,12)(30,13)(30,11)
          (30,13) -> (29,13)(31,13)(30,14)(30,12)
          (30,14) -> (29,14)(31,14)(30,15)(30,13)
          (30,15) -> (29,15)(31,15)(30,16)(30,14)
          (30,16) -> (29,16)(31,16)(30,17)(30,15)
          (30,17) -> (29,17)(31,17)(30,18)(30,16)
          (30,18) -> (29,18)(31,18)(30,19)(30,17)
          (30,19) -> (29,19)(31,19)(30,20)(30,18)
          (30,20) -> (29,20)(31,20)(30,21)(30,19)
          (30,21) -> (29,21)(31,21)(30,22)(30,20)
          (30,22) -> (29,22)(31,22)(30,23)(30,21)
          (30,23) -> (29,23)(31,23)(30,24)(30,22)
          (30,24) -> (29,24)(31,24)(30,25)(30,23)
          (30,25) -> (29,25)(31,25)(30,26)(30,24)
          (30,26) -> (29,26)(31,26)(30,27)(30,25)
          (30,27) -> (29,27)(31,27)(30,28)(30,26)
          (30,28) -> (29,28)(31,28)(30,29)(30,27)
          (30,29) -> (29,29)(31,29)(30,30)(30,28)
          (30,30) -> (29,30)(31,30)(30,31)(30,29)
          (30,31) -> (29,31)(31,31)(30,32)(30,30)
          (30,32) -> (29,32)(31,32)(30,33)(30,31)
          (30,33) -> (29,33)(31,33)(30,34)(30,32)
          (30,34) -> (29,34)(31,34)(30,35)(30,33)
          (30,35) -> (29,35)(31,35)(30,36)(30,34)
          (30,36) -> (29,36)(31,36)(30,37)(30,35)
          (30,37) -> (29,37)(31,37)(30,38)(30,36)
          (30,38) -> (29,38)(31,38)(30,39)(30,37)
          (30,39) -> (29,39)(31,39)(30,40)(30,38)
          (30,40) -> (29,40)(31,40)(30,41)(30,39)
          (30,41) -> (29,41)(31,41)(30,42)(30,40)
          (30,42) -> (29,42)(31,42)(30,43)(30,41)
          (30,43) -> (29,43)(31,43)(30,44)(30,42)
          (30,44) -> (29,44)(31,44)(30,45)(30,43)
          (30,45) -> (29,45)(31,45)(30,46)(30,44)
          (30,46) -> (29,46)(31,46)(30,47)(30,45)
          (30,47) -> (29,47)(31,47)(30,48)(30,46)
          (30,48) -> (29,48)(31,48)(30,49)(30,47)
          (30,49) -> (29,49)(31,49)(30,50)(30,48)
          (30,50) -> (29,50)(31,50)(30,51)(30,49)
          (30,51) -> (29,51)(31,51)(30,52)(30,50)
          (30,52) -> (29,52)(31,52)(30,53)(30,51)
          (30,53) -> (29,53)(31,53)(30,54)(30,52)
          (30,54) -> (29,54)(31,54)(30,55)(30,53)
          (30,55) -> (29,55)(31,55)(30,56)(30,54)
          (30,56) -> (29,56)(31,56)(30,57)(30,55)
          (30,57) -> (29,57)(31,57)(30,58)(30,56)
          (30,58) -> (29,58)(31,58)(30,59)(30,57)
          (30,59) -> (29,59)(31,59)(30,60)(30,58)
          (30,60) -> (29,60)(31,60)(30,61)(30,59)
          (30,61) -> (29,61)(31,61)(30,62)(30,60)
          (30,62) -> (29,62)(31,62)(30,63)(30,61)
          (30,63) -> (29,63)(31,63)(30,62)
          (31,0)  -> (30,0)(32,0)(31,1)
          (31,1)  -> (30,1)(32,1)(31,2)(31,0)
          (31,2)  -> (30,2)(32,2)(31,3)(31,1)
          (31,3)  -> (30,3)(32,3)(31,4)(31,2)
          (31,4)  -> (30,4)(32,4)(31,5)(31,3)
          (31,5)  -> (30,5)(32,5)(31,6)(31,4)
          (31,6)  -> (30,6)(32,6)(31,7)(31,5)
          (31,7)  -> (30,7)(32,7)(31,8)(31,6)
          (31,8)  -> (30,8)(32,8)(31,9)(31,7)
          (31,9)  -> (30,9)(32,9)(31,10)(31,8)
          (31,10) -> (30,10)(32,10)(31,11)(31,9)
          (31,11) -> (30,11)(32,11)(31,12)(31,10)
          (31,12) -> (30,12)(32,12)(31,13)(31,11)
          (31,13) -> (30,13)(32,13)(31,14)(31,12)
          (31,14) -> (30,14)(32,14)(31,15)(31,13)
          (31,15) -> (30,15)(32,15)(31,16)(31,14)
          (31,16) -> (30,16)(32,16)(31,17)(31,15)
          (31,17) -> (30,17)(32,17)(31,18)(31,16)
          (31,18) -> (30,18)(32,18)(31,19)(31,17)
          (31,19) -> (30,19)(32,19)(31,20)(31,18)
          (31,20) -> (30,20)(32,20)(31,21)(31,19)
          (31,21) -> (30,21)(32,21)(31,22)(31,20)
          (31,22) -> (30,22)(32,22)(31,23)(31,21)
          (31,23) -> (30,23)(32,23)(31,24)(31,22)
          (31,24) -> (30,24)(32,24)(31,25)(31,23)
          (31,25) -> (30,25)(32,25)(31,26)(31,24)
          (31,26) -> (30,26)(32,26)(31,27)(31,25)
          (31,27) -> (30,27)(32,27)(31,28)(31,26)
          (31,28) -> (30,28)(32,28)(31,29)(31,27)
          (31,29) -> (30,29)(32,29)(31,30)(31,28)
          (31,30) -> (30,30)(32,30)(31,31)(31,29)
          (31,31) -> (30,31)(32,31)(31,32)(31,30)
          (31,32) -> (30,32)(32,32)(31,33)(31,31)
          (31,33) -> (30,33)(32,33)(31,34)(31,32)
          (31,34) -> (30,34)(32,34)(31,35)(31,33)
          (31,35) -> (30,35)(32,35)(31,36)(31,34)
          (31,36) -> (30,36)(32,36)(31,37)(31,35)
          (31,37) -> (30,37)(32,37)(31,38)(31,36)
          (31,38) -> (30,38)(32,38)(31,39)(31,37)
          (31,39) -> (30,39)(32,39)(31,40)(31,38)
          (31,40) -> (30,40)(32,40)(31,41)(31,39)
          (31,41) -> (30,41)(32,41)(31,42)(31,40)
          (31,42) -> (30,42)(32,42)(31,43)(31,41)
          (31,43) -> (30,43)(32,43)(31,44)(31,42)
          (31,44) -> (30,44)(32,44)(31,45)(31,43)
          (31,45) -> (30,45)(32,45)(31,46)(31,44)
          (31,46) -> (30,46)(32,46)(31,47)(31,45)
          (31,47) -> (30,47)(32,47)(31,48)(31,46)
          (31,48) -> (30,48)(32,48)(31,49)(31,47)
          (31,49) -> (30,49)(32,49)(31,50)(31,48)
          (31,50) -> (30,50)(32,50)(31,51)(31,49)
          (31,51) -> (30,51)(32,51)(31,52)(31,50)
          (31,52) -> (30,52)(32,52)(31,53)(31,51)
          (31,53) -> (30,53)(32,53)(31,54)(31,52)
          (31,54) -> (30,54)(32,54)(31,55)(31,53)
          (31,55) -> (30,55)(32,55)(31,56)(31,54)
          (31,56) -> (30,56)(32,56)(31,57)(31,55)
          (31,57) -> (30,57)(32,57)(31,58)(31,56)
          (31,58) -> (30,58)(32,58)(31,59)(31,57)
          (31,59) -> (30,59)(32,59)(31,60)(31,58)
          (31,60) -> (30,60)(32,60)(31,61)(31,59)
          (31,61) -> (30,61)(32,61)(31,62)(31,60)
          (31,62) -> (30,62)(32,62)(31,63)(31,61)
          (31,63) -> (30,63)(32,63)(31,62)
          (32,0)  -> (31,0)(33,0)(32,1)
          (32,1)  -> (31,1)(33,1)(32,2)(32,0)
          (32,2)  -> (31,2)(33,2)(32,3)(32,1)
          (32,3)  -> (31,3)(33,3)(32,4)(32,2)
          (32,4)  -> (31,4)(33,4)(32,5)(32,3)
          (32,5)  -> (31,5)(33,5)(32,6)(32,4)
          (32,6)  -> (31,6)(33,6)(32,7)(32,5)
          (32,7)  -> (31,7)(33,7)(32,8)(32,6)
          (32,8)  -> (31,8)(33,8)(32,9)(32,7)
          (32,9)  -> (31,9)(33,9)(32,10)(32,8)
          (32,10) -> (31,10)(33,10)(32,11)(32,9)
          (32,11) -> (31,11)(33,11)(32,12)(32,10)
          (32,12) -> (31,12)(33,12)(32,13)(32,11)
          (32,13) -> (31,13)(33,13)(32,14)(32,12)
          (32,14) -> (31,14)(33,14)(32,15)(32,13)
          (32,15) -> (31,15)(33,15)(32,16)(32,14)
          (32,16) -> (31,16)(33,16)(32,17)(32,15)
          (32,17) -> (31,17)(33,17)(32,18)(32,16)
          (32,18) -> (31,18)(33,18)(32,19)(32,17)
          (32,19) -> (31,19)(33,19)(32,20)(32,18)
          (32,20) -> (31,20)(33,20)(32,21)(32,19)
          (32,21) -> (31,21)(33,21)(32,22)(32,20)
          (32,22) -> (31,22)(33,22)(32,23)(32,21)
          (32,23) -> (31,23)(33,23)(32,24)(32,22)
          (32,24) -> (31,24)(33,24)(32,25)(32,23)
          (32,25) -> (31,25)(33,25)(32,26)(32,24)
          (32,26) -> (31,26)(33,26)(32,27)(32,25)
          (32,27) -> (31,27)(33,27)(32,28)(32,26)
          (32,28) -> (31,28)(33,28)(32,29)(32,27)
          (32,29) -> (31,29)(33,29)(32,30)(32,28)
          (32,30) -> (31,30)(33,30)(32,31)(32,29)
          (32,31) -> (31,31)(33,31)(32,32)(32,30)
          (32,32) -> (31,32)(33,32)(32,33)(32,31)
          (32,33) -> (31,33)(33,33)(32,34)(32,32)
          (32,34) -> (31,34)(33,34)(32,35)(32,33)
          (32,35) -> (31,35)(33,35)(32,36)(32,34)
          (32,36) -> (31,36)(33,36)(32,37)(32,35)
          (32,37) -> (31,37)(33,37)(32,38)(32,36)
          (32,38) -> (31,38)(33,38)(32,39)(32,37)
          (32,39) -> (31,39)(33,39)(32,40)(32,38)
          (32,40) -> (31,40)(33,40)(32,41)(32,39)
          (32,41) -> (31,41)(33,41)(32,42)(32,40)
          (32,42) -> (31,42)(33,42)(32,43)(32,41)
          (32,43) -> (31,43)(33,43)(32,44)(32,42)
          (32,44) -> (31,44)(33,44)(32,45)(32,43)
          (32,45) -> (31,45)(33,45)(32,46)(32,44)
          (32,46) -> (31,46)(33,46)(32,47)(32,45)
          (32,47) -> (31,47)(33,47)(32,48)(32,46)
          (32,48) -> (31,48)(33,48)(32,49)(32,47)
          (32,49) -> (31,49)(33,49)(32,50)(32,48)
          (32,50) -> (31,50)(33,50)(32,51)(32,49)
          (32,51) -> (31,51)(33,51)(32,52)(32,50)
          (32,52) -> (31,52)(33,52)(32,53)(32,51)
          (32,53) -> (31,53)(33,53)(32,54)(32,52)
          (32,54) -> (31,54)(33,54)(32,55)(32,53)
          (32,55) -> (31,55)(33,55)(32,56)(32,54)
          (32,56) -> (31,56)(33,56)(32,57)(32,55)
          (32,57) -> (31,57)(33,57)(32,58)(32,56)
          (32,58) -> (31,58)(33,58)(32,59)(32,57)
          (32,59) -> (31,59)(33,59)(32,60)(32,58)
          (32,60) -> (31,60)(33,60)(32,61)(32,59)
          (32,61) -> (31,61)(33,61)(32,62)(32,60)
          (32,62) -> (31,62)(33,62)(32,63)(32,61)
          (32,63) -> (31,63)(33,63)(32,62)
          (33,0)  -> (32,0)(34,0)(33,1)
          (33,1)  -> (32,1)(34,1)(33,2)(33,0)
          (33,2)  -> (32,2)(34,2)(33,3)(33,1)
          (33,3)  -> (32,3)(34,3)(33,4)(33,2)
          (33,4)  -> (32,4)(34,4)(33,5)(33,3)
          (33,5)  -> (32,5)(34,5)(33,6)(33,4)
          (33,6)  -> (32,6)(34,6)(33,7)(33,5)
          (33,7)  -> (32,7)(34,7)(33,8)(33,6)
          (33,8)  -> (32,8)(34,8)(33,9)(33,7)
          (33,9)  -> (32,9)(34,9)(33,10)(33,8)
          (33,10) -> (32,10)(34,10)(33,11)(33,9)
          (33,11) -> (32,11)(34,11)(33,12)(33,10)
          (33,12) -> (32,12)(34,12)(33,13)(33,11)
          (33,13) -> (32,13)(34,13)(33,14)(33,12)
          (33,14) -> (32,14)(34,14)(33,15)(33,13)
          (33,15) -> (32,15)(34,15)(33,16)(33,14)
          (33,16) -> (32,16)(34,16)(33,17)(33,15)
          (33,17) -> (32,17)(34,17)(33,18)(33,16)
          (33,18) -> (32,18)(34,18)(33,19)(33,17)
          (33,19) -> (32,19)(34,19)(33,20)(33,18)
          (33,20) -> (32,20)(34,20)(33,21)(33,19)
          (33,21) -> (32,21)(34,21)(33,22)(33,20)
          (33,22) -> (32,22)(34,22)(33,23)(33,21)
          (33,23) -> (32,23)(34,23)(33,24)(33,22)
          (33,24) -> (32,24)(34,24)(33,25)(33,23)
          (33,25) -> (32,25)(34,25)(33,26)(33,24)
          (33,26) -> (32,26)(34,26)(33,27)(33,25)
          (33,27) -> (32,27)(34,27)(33,28)(33,26)
          (33,28) -> (32,28)(34,28)(33,29)(33,27)
          (33,29) -> (32,29)(34,29)(33,30)(33,28)
          (33,30) -> (32,30)(34,30)(33,31)(33,29)
          (33,31) -> (32,31)(34,31)(33,32)(33,30)
          (33,32) -> (32,32)(34,32)(33,33)(33,31)
          (33,33) -> (32,33)(34,33)(33,34)(33,32)
          (33,34) -> (32,34)(34,34)(33,35)(33,33)
          (33,35) -> (32,35)(34,35)(33,36)(33,34)
          (33,36) -> (32,36)(34,36)(33,37)(33,35)
          (33,37) -> (32,37)(34,37)(33,38)(33,36)
          (33,38) -> (32,38)(34,38)(33,39)(33,37)
          (33,39) -> (32,39)(34,39)(33,40)(33,38)
          (33,40) -> (32,40)(34,40)(33,41)(33,39)
          (33,41) -> (32,41)(34,41)(33,42)(33,40)
          (33,42) -> (32,42)(34,42)(33,43)(33,41)
          (33,43) -> (32,43)(34,43)(33,44)(33,42)
          (33,44) -> (32,44)(34,44)(33,45)(33,43)
          (33,45) -> (32,45)(34,45)(33,46)(33,44)
          (33,46) -> (32,46)(34,46)(33,47)(33,45)
          (33,47) -> (32,47)(34,47)(33,48)(33,46)
          (33,48) -> (32,48)(34,48)(33,49)(33,47)
          (33,49) -> (32,49)(34,49)(33,50)(33,48)
          (33,50) -> (32,50)(34,50)(33,51)(33,49)
          (33,51) -> (32,51)(34,51)(33,52)(33,50)
          (33,52) -> (32,52)(34,52)(33,53)(33,51)
          (33,53) -> (32,53)(34,53)(33,54)(33,52)
          (33,54) -> (32,54)(34,54)(33,55)(33,53)
          (33,55) -> (32,55)(34,55)(33,56)(33,54)
          (33,56) -> (32,56)(34,56)(33,57)(33,55)
          (33,57) -> (32,57)(34,57)(33,58)(33,56)
          (33,58) -> (32,58)(34,58)(33,59)(33,57)
          (33,59) -> (32,59)(34,59)(33,60)(33,58)
          (33,60) -> (32,60)(34,60)(33,61)(33,59)
          (33,61) -> (32,61)(34,61)(33,62)(33,60)
          (33,62) -> (32,62)(34,62)(33,63)(33,61)
          (33,63) -> (32,63)(34,63)(33,62)
          (34,0)  -> (33,0)(35,0)(34,1)
          (34,1)  -> (33,1)(35,1)(34,2)(34,0)
          (34,2)  -> (33,2)(35,2)(34,3)(34,1)
          (34,3)  -> (33,3)(35,3)(34,4)(34,2)
          (34,4)  -> (33,4)(35,4)(34,5)(34,3)
          (34,5)  -> (33,5)(35,5)(34,6)(34,4)
          (34,6)  -> (33,6)(35,6)(34,7)(34,5)
          (34,7)  -> (33,7)(35,7)(34,8)(34,6)
          (34,8)  -> (33,8)(35,8)(34,9)(34,7)
          (34,9)  -> (33,9)(35,9)(34,10)(34,8)
          (34,10) -> (33,10)(35,10)(34,11)(34,9)
          (34,11) -> (33,11)(35,11)(34,12)(34,10)
          (34,12) -> (33,12)(35,12)(34,13)(34,11)
          (34,13) -> (33,13)(35,13)(34,14)(34,12)
          (34,14) -> (33,14)(35,14)(34,15)(34,13)
          (34,15) -> (33,15)(35,15)(34,16)(34,14)
          (34,16) -> (33,16)(35,16)(34,17)(34,15)
          (34,17) -> (33,17)(35,17)(34,18)(34,16)
          (34,18) -> (33,18)(35,18)(34,19)(34,17)
          (34,19) -> (33,19)(35,19)(34,20)(34,18)
          (34,20) -> (33,20)(35,20)(34,21)(34,19)
          (34,21) -> (33,21)(35,21)(34,22)(34,20)
          (34,22) -> (33,22)(35,22)(34,23)(34,21)
          (34,23) -> (33,23)(35,23)(34,24)(34,22)
          (34,24) -> (33,24)(35,24)(34,25)(34,23)
          (34,25) -> (33,25)(35,25)(34,26)(34,24)
          (34,26) -> (33,26)(35,26)(34,27)(34,25)
          (34,27) -> (33,27)(35,27)(34,28)(34,26)
          (34,28) -> (33,28)(35,28)(34,29)(34,27)
          (34,29) -> (33,29)(35,29)(34,30)(34,28)
          (34,30) -> (33,30)(35,30)(34,31)(34,29)
          (34,31) -> (33,31)(35,31)(34,32)(34,30)
          (34,32) -> (33,32)(35,32)(34,33)(34,31)
          (34,33) -> (33,33)(35,33)(34,34)(34,32)
          (34,34) -> (33,34)(35,34)(34,35)(34,33)
          (34,35) -> (33,35)(35,35)(34,36)(34,34)
          (34,36) -> (33,36)(35,36)(34,37)(34,35)
          (34,37) -> (33,37)(35,37)(34,38)(34,36)
          (34,38) -> (33,38)(35,38)(34,39)(34,37)
          (34,39) -> (33,39)(35,39)(34,40)(34,38)
          (34,40) -> (33,40)(35,40)(34,41)(34,39)
          (34,41) -> (33,41)(35,41)(34,42)(34,40)
          (34,42) -> (33,42)(35,42)(34,43)(34,41)
          (34,43) -> (33,43)(35,43)(34,44)(34,42)
          (34,44) -> (33,44)(35,44)(34,45)(34,43)
          (34,45) -> (33,45)(35,45)(34,46)(34,44)
          (34,46) -> (33,46)(35,46)(34,47)(34,45)
          (34,47) -> (33,47)(35,47)(34,48)(34,46)
          (34,48) -> (33,48)(35,48)(34,49)(34,47)
          (34,49) -> (33,49)(35,49)(34,50)(34,48)
          (34,50) -> (33,50)(35,50)(34,51)(34,49)
          (34,51) -> (33,51)(35,51)(34,52)(34,50)
          (34,52) -> (33,52)(35,52)(34,53)(34,51)
          (34,53) -> (33,53)(35,53)(34,54)(34,52)
          (34,54) -> (33,54)(35,54)(34,55)(34,53)
          (34,55) -> (33,55)(35,55)(34,56)(34,54)
          (34,56) -> (33,56)(35,56)(34,57)(34,55)
          (34,57) -> (33,57)(35,57)(34,58)(34,56)
          (34,58) -> (33,58)(35,58)(34,59)(34,57)
          (34,59) -> (33,59)(35,59)(34,60)(34,58)
          (34,60) -> (33,60)(35,60)(34,61)(34,59)
          (34,61) -> (33,61)(35,61)(34,62)(34,60)
          (34,62) -> (33,62)(35,62)(34,63)(34,61)
          (34,63) -> (33,63)(35,63)(34,62)
          (35,0)  -> (34,0)(36,0)(35,1)
          (35,1)  -> (34,1)(36,1)(35,2)(35,0)
          (35,2)  -> (34,2)(36,2)(35,3)(35,1)
          (35,3)  -> (34,3)(36,3)(35,4)(35,2)
          (35,4)  -> (34,4)(36,4)(35,5)(35,3)
          (35,5)  -> (34,5)(36,5)(35,6)(35,4)
          (35,6)  -> (34,6)(36,6)(35,7)(35,5)
          (35,7)  -> (34,7)(36,7)(35,8)(35,6)
          (35,8)  -> (34,8)(36,8)(35,9)(35,7)
          (35,9)  -> (34,9)(36,9)(35,10)(35,8)
          (35,10) -> (34,10)(36,10)(35,11)(35,9)
          (35,11) -> (34,11)(36,11)(35,12)(35,10)
          (35,12) -> (34,12)(36,12)(35,13)(35,11)
          (35,13) -> (34,13)(36,13)(35,14)(35,12)
          (35,14) -> (34,14)(36,14)(35,15)(35,13)
          (35,15) -> (34,15)(36,15)(35,16)(35,14)
          (35,16) -> (34,16)(36,16)(35,17)(35,15)
          (35,17) -> (34,17)(36,17)(35,18)(35,16)
          (35,18) -> (34,18)(36,18)(35,19)(35,17)
          (35,19) -> (34,19)(36,19)(35,20)(35,18)
          (35,20) -> (34,20)(36,20)(35,21)(35,19)
          (35,21) -> (34,21)(36,21)(35,22)(35,20)
          (35,22) -> (34,22)(36,22)(35,23)(35,21)
          (35,23) -> (34,23)(36,23)(35,24)(35,22)
          (35,24) -> (34,24)(36,24)(35,25)(35,23)
          (35,25) -> (34,25)(36,25)(35,26)(35,24)
          (35,26) -> (34,26)(36,26)(35,27)(35,25)
          (35,27) -> (34,27)(36,27)(35,28)(35,26)
          (35,28) -> (34,28)(36,28)(35,29)(35,27)
          (35,29) -> (34,29)(36,29)(35,30)(35,28)
          (35,30) -> (34,30)(36,30)(35,31)(35,29)
          (35,31) -> (34,31)(36,31)(35,32)(35,30)
          (35,32) -> (34,32)(36,32)(35,33)(35,31)
          (35,33) -> (34,33)(36,33)(35,34)(35,32)
          (35,34) -> (34,34)(36,34)(35,35)(35,33)
          (35,35) -> (34,35)(36,35)(35,36)(35,34)
          (35,36) -> (34,36)(36,36)(35,37)(35,35)
          (35,37) -> (34,37)(36,37)(35,38)(35,36)
          (35,38) -> (34,38)(36,38)(35,39)(35,37)
          (35,39) -> (34,39)(36,39)(35,40)(35,38)
          (35,40) -> (34,40)(36,40)(35,41)(35,39)
          (35,41) -> (34,41)(36,41)(35,42)(35,40)
          (35,42) -> (34,42)(36,42)(35,43)(35,41)
          (35,43) -> (34,43)(36,43)(35,44)(35,42)
          (35,44) -> (34,44)(36,44)(35,45)(35,43)
          (35,45) -> (34,45)(36,45)(35,46)(35,44)
          (35,46) -> (34,46)(36,46)(35,47)(35,45)
          (35,47) -> (34,47)(36,47)(35,48)(35,46)
          (35,48) -> (34,48)(36,48)(35,49)(35,47)
          (35,49) -> (34,49)(36,49)(35,50)(35,48)
          (35,50) -> (34,50)(36,50)(35,51)(35,49)
          (35,51) -> (34,51)(36,51)(35,52)(35,50)
          (35,52) -> (34,52)(36,52)(35,53)(35,51)
          (35,53) -> (34,53)(36,53)(35,54)(35,52)
          (35,54) -> (34,54)(36,54)(35,55)(35,53)
          (35,55) -> (34,55)(36,55)(35,56)(35,54)
          (35,56) -> (34,56)(36,56)(35,57)(35,55)
          (35,57) -> (34,57)(36,57)(35,58)(35,56)
          (35,58) -> (34,58)(36,58)(35,59)(35,57)
          (35,59) -> (34,59)(36,59)(35,60)(35,58)
          (35,60) -> (34,60)(36,60)(35,61)(35,59)
          (35,61) -> (34,61)(36,61)(35,62)(35,60)
          (35,62) -> (34,62)(36,62)(35,63)(35,61)
          (35,63) -> (34,63)(36,63)(35,62)
          (36,0)  -> (35,0)(37,0)(36,1)
          (36,1)  -> (35,1)(37,1)(36,2)(36,0)
          (36,2)  -> (35,2)(37,2)(36,3)(36,1)
          (36,3)  -> (35,3)(37,3)(36,4)(36,2)
          (36,4)  -> (35,4)(37,4)(36,5)(36,3)
          (36,5)  -> (35,5)(37,5)(36,6)(36,4)
          (36,6)  -> (35,6)(37,6)(36,7)(36,5)
          (36,7)  -> (35,7)(37,7)(36,8)(36,6)
          (36,8)  -> (35,8)(37,8)(36,9)(36,7)
          (36,9)  -> (35,9)(37,9)(36,10)(36,8)
          (36,10) -> (35,10)(37,10)(36,11)(36,9)
          (36,11) -> (35,11)(37,11)(36,12)(36,10)
          (36,12) -> (35,12)(37,12)(36,13)(36,11)
          (36,13) -> (35,13)(37,13)(36,14)(36,12)
          (36,14) -> (35,14)(37,14)(36,15)(36,13)
          (36,15) -> (35,15)(37,15)(36,16)(36,14)
          (36,16) -> (35,16)(37,16)(36,17)(36,15)
          (36,17) -> (35,17)(37,17)(36,18)(36,16)
          (36,18) -> (35,18)(37,18)(36,19)(36,17)
          (36,19) -> (35,19)(37,19)(36,20)(36,18)
          (36,20) -> (35,20)(37,20)(36,21)(36,19)
          (36,21) -> (35,21)(37,21)(36,22)(36,20)
          (36,22) -> (35,22)(37,22)(36,23)(36,21)
          (36,23) -> (35,23)(37,23)(36,24)(36,22)
          (36,24) -> (35,24)(37,24)(36,25)(36,23)
          (36,25) -> (35,25)(37,25)(36,26)(36,24)
          (36,26) -> (35,26)(37,26)(36,27)(36,25)
          (36,27) -> (35,27)(37,27)(36,28)(36,26)
          (36,28) -> (35,28)(37,28)(36,29)(36,27)
          (36,29) -> (35,29)(37,29)(36,30)(36,28)
          (36,30) -> (35,30)(37,30)(36,31)(36,29)
          (36,31) -> (35,31)(37,31)(36,32)(36,30)
          (36,32) -> (35,32)(37,32)(36,33)(36,31)
          (36,33) -> (35,33)(37,33)(36,34)(36,32)
          (36,34) -> (35,34)(37,34)(36,35)(36,33)
          (36,35) -> (35,35)(37,35)(36,36)(36,34)
          (36,36) -> (35,36)(37,36)(36,37)(36,35)
          (36,37) -> (35,37)(37,37)(36,38)(36,36)
          (36,38) -> (35,38)(37,38)(36,39)(36,37)
          (36,39) -> (35,39)(37,39)(36,40)(36,38)
          (36,40) -> (35,40)(37,40)(36,41)(36,39)
          (36,41) -> (35,41)(37,41)(36,42)(36,40)
          (36,42) -> (35,42)(37,42)(36,43)(36,41)
          (36,43) -> (35,43)(37,43)(36,44)(36,42)
          (36,44) -> (35,44)(37,44)(36,45)(36,43)
          (36,45) -> (35,45)(37,45)(36,46)(36,44)
          (36,46) -> (35,46)(37,46)(36,47)(36,45)
          (36,47) -> (35,47)(37,47)(36,48)(36,46)
          (36,48) -> (35,48)(37,48)(36,49)(36,47)
          (36,49) -> (35,49)(37,49)(36,50)(36,48)
          (36,50) -> (35,50)(37,50)(36,51)(36,49)
          (36,51) -> (35,51)(37,51)(36,52)(36,50)
          (36,52) -> (35,52)(37,52)(36,53)(36,51)
          (36,53) -> (35,53)(37,53)(36,54)(36,52)
          (36,54) -> (35,54)(37,54)(36,55)(36,53)
          (36,55) -> (35,55)(37,55)(36,56)(36,54)
          (36,56) -> (35,56)(37,56)(36,57)(36,55)
          (36,57) -> (35,57)(37,57)(36,58)(36,56)
          (36,58) -> (35,58)(37,58)(36,59)(36,57)
          (36,59) -> (35,59)(37,59)(36,60)(36,58)
          (36,60) -> (35,60)(37,60)(36,61)(36,59)
          (36,61) -> (35,61)(37,61)(36,62)(36,60)
          (36,62) -> (35,62)(37,62)(36,63)(36,61)
          (36,63) -> (35,63)(37,63)(36,62)
          (37,0)  -> (36,0)(38,0)(37,1)
          (37,1)  -> (36,1)(38,1)(37,2)(37,0)
          (37,2)  -> (36,2)(38,2)(37,3)(37,1)
          (37,3)  -> (36,3)(38,3)(37,4)(37,2)
          (37,4)  -> (36,4)(38,4)(37,5)(37,3)
          (37,5)  -> (36,5)(38,5)(37,6)(37,4)
          (37,6)  -> (36,6)(38,6)(37,7)(37,5)
          (37,7)  -> (36,7)(38,7)(37,8)(37,6)
          (37,8)  -> (36,8)(38,8)(37,9)(37,7)
          (37,9)  -> (36,9)(38,9)(37,10)(37,8)
          (37,10) -> (36,10)(38,10)(37,11)(37,9)
          (37,11) -> (36,11)(38,11)(37,12)(37,10)
          (37,12) -> (36,12)(38,12)(37,13)(37,11)
          (37,13) -> (36,13)(38,13)(37,14)(37,12)
          (37,14) -> (36,14)(38,14)(37,15)(37,13)
          (37,15) -> (36,15)(38,15)(37,16)(37,14)
          (37,16) -> (36,16)(38,16)(37,17)(37,15)
          (37,17) -> (36,17)(38,17)(37,18)(37,16)
          (37,18) -> (36,18)(38,18)(37,19)(37,17)
          (37,19) -> (36,19)(38,19)(37,20)(37,18)
          (37,20) -> (36,20)(38,20)(37,21)(37,19)
          (37,21) -> (36,21)(38,21)(37,22)(37,20)
          (37,22) -> (36,22)(38,22)(37,23)(37,21)
          (37,23) -> (36,23)(38,23)(37,24)(37,22)
          (37,24) -> (36,24)(38,24)(37,25)(37,23)
          (37,25) -> (36,25)(38,25)(37,26)(37,24)
          (37,26) -> (36,26)(38,26)(37,27)(37,25)
          (37,27) -> (36,27)(38,27)(37,28)(37,26)
          (37,28) -> (36,28)(38,28)(37,29)(37,27)
          (37,29) -> (36,29)(38,29)(37,30)(37,28)
          (37,30) -> (36,30)(38,30)(37,31)(37,29)
          (37,31) -> (36,31)(38,31)(37,32)(37,30)
          (37,32) -> (36,32)(38,32)(37,33)(37,31)
          (37,33) -> (36,33)(38,33)(37,34)(37,32)
          (37,34) -> (36,34)(38,34)(37,35)(37,33)
          (37,35) -> (36,35)(38,35)(37,36)(37,34)
          (37,36) -> (36,36)(38,36)(37,37)(37,35)
          (37,37) -> (36,37)(38,37)(37,38)(37,36)
          (37,38) -> (36,38)(38,38)(37,39)(37,37)
          (37,39) -> (36,39)(38,39)(37,40)(37,38)
          (37,40) -> (36,40)(38,40)(37,41)(37,39)
          (37,41) -> (36,41)(38,41)(37,42)(37,40)
          (37,42) -> (36,42)(38,42)(37,43)(37,41)
          (37,43) -> (36,43)(38,43)(37,44)(37,42)
          (37,44) -> (36,44)(38,44)(37,45)(37,43)
          (37,45) -> (36,45)(38,45)(37,46)(37,44)
          (37,46) -> (36,46)(38,46)(37,47)(37,45)
          (37,47) -> (36,47)(38,47)(37,48)(37,46)
          (37,48) -> (36,48)(38,48)(37,49)(37,47)
          (37,49) -> (36,49)(38,49)(37,50)(37,48)
          (37,50) -> (36,50)(38,50)(37,51)(37,49)
          (37,51) -> (36,51)(38,51)(37,52)(37,50)
          (37,52) -> (36,52)(38,52)(37,53)(37,51)
          (37,53) -> (36,53)(38,53)(37,54)(37,52)
          (37,54) -> (36,54)(38,54)(37,55)(37,53)
          (37,55) -> (36,55)(38,55)(37,56)(37,54)
          (37,56) -> (36,56)(38,56)(37,57)(37,55)
          (37,57) -> (36,57)(38,57)(37,58)(37,56)
          (37,58) -> (36,58)(38,58)(37,59)(37,57)
          (37,59) -> (36,59)(38,59)(37,60)(37,58)
          (37,60) -> (36,60)(38,60)(37,61)(37,59)
          (37,61) -> (36,61)(38,61)(37,62)(37,60)
          (37,62) -> (36,62)(38,62)(37,63)(37,61)
          (37,63) -> (36,63)(38,63)(37,62)
          (38,0)  -> (37,0)(39,0)(38,1)
          (38,1)  -> (37,1)(39,1)(38,2)(38,0)
          (38,2)  -> (37,2)(39,2)(38,3)(38,1)
          (38,3)  -> (37,3)(39,3)(38,4)(38,2)
          (38,4)  -> (37,4)(39,4)(38,5)(38,3)
          (38,5)  -> (37,5)(39,5)(38,6)(38,4)
          (38,6)  -> (37,6)(39,6)(38,7)(38,5)
          (38,7)  -> (37,7)(39,7)(38,8)(38,6)
          (38,8)  -> (37,8)(39,8)(38,9)(38,7)
          (38,9)  -> (37,9)(39,9)(38,10)(38,8)
          (38,10) -> (37,10)(39,10)(38,11)(38,9)
          (38,11) -> (37,11)(39,11)(38,12)(38,10)
          (38,12) -> (37,12)(39,12)(38,13)(38,11)
          (38,13) -> (37,13)(39,13)(38,14)(38,12)
          (38,14) -> (37,14)(39,14)(38,15)(38,13)
          (38,15) -> (37,15)(39,15)(38,16)(38,14)
          (38,16) -> (37,16)(39,16)(38,17)(38,15)
          (38,17) -> (37,17)(39,17)(38,18)(38,16)
          (38,18) -> (37,18)(39,18)(38,19)(38,17)
          (38,19) -> (37,19)(39,19)(38,20)(38,18)
          (38,20) -> (37,20)(39,20)(38,21)(38,19)
          (38,21) -> (37,21)(39,21)(38,22)(38,20)
          (38,22) -> (37,22)(39,22)(38,23)(38,21)
          (38,23) -> (37,23)(39,23)(38,24)(38,22)
          (38,24) -> (37,24)(39,24)(38,25)(38,23)
          (38,25) -> (37,25)(39,25)(38,26)(38,24)
          (38,26) -> (37,26)(39,26)(38,27)(38,25)
          (38,27) -> (37,27)(39,27)(38,28)(38,26)
          (38,28) -> (37,28)(39,28)(38,29)(38,27)
          (38,29) -> (37,29)(39,29)(38,30)(38,28)
          (38,30) -> (37,30)(39,30)(38,31)(38,29)
          (38,31) -> (37,31)(39,31)(38,32)(38,30)
          (38,32) -> (37,32)(39,32)(38,33)(38,31)
          (38,33) -> (37,33)(39,33)(38,34)(38,32)
          (38,34) -> (37,34)(39,34)(38,35)(38,33)
          (38,35) -> (37,35)(39,35)(38,36)(38,34)
          (38,36) -> (37,36)(39,36)(38,37)(38,35)
          (38,37) -> (37,37)(39,37)(38,38)(38,36)
          (38,38) -> (37,38)(39,38)(38,39)(38,37)
          (38,39) -> (37,39)(39,39)(38,40)(38,38)
          (38,40) -> (37,40)(39,40)(38,41)(38,39)
          (38,41) -> (37,41)(39,41)(38,42)(38,40)
          (38,42) -> (37,42)(39,42)(38,43)(38,41)
          (38,43) -> (37,43)(39,43)(38,44)(38,42)
          (38,44) -> (37,44)(39,44)(38,45)(38,43)
          (38,45) -> (37,45)(39,45)(38,46)(38,44)
          (38,46) -> (37,46)(39,46)(38,47)(38,45)
          (38,47) -> (37,47)(39,47)(38,48)(38,46)
          (38,48) -> (37,48)(39,48)(38,49)(38,47)
          (38,49) -> (37,49)(39,49)(38,50)(38,48)
          (38,50) -> (37,50)(39,50)(38,51)(38,49)
          (38,51) -> (37,51)(39,51)(38,52)(38,50)
          (38,52) -> (37,52)(39,52)(38,53)(38,51)
          (38,53) -> (37,53)(39,53)(38,54)(38,52)
          (38,54) -> (37,54)(39,54)(38,55)(38,53)
          (38,55) -> (37,55)(39,55)(38,56)(38,54)
          (38,56) -> (37,56)(39,56)(38,57)(38,55)
          (38,57) -> (37,57)(39,57)(38,58)(38,56)
          (38,58) -> (37,58)(39,58)(38,59)(38,57)
          (38,59) -> (37,59)(39,59)(38,60)(38,58)
          (38,60) -> (37,60)(39,60)(38,61)(38,59)
          (38,61) -> (37,61)(39,61)(38,62)(38,60)
          (38,62) -> (37,62)(39,62)(38,63)(38,61)
          (38,63) -> (37,63)(39,63)(38,62)
          (39,0)  -> (38,0)(40,0)(39,1)
          (39,1)  -> (38,1)(40,1)(39,2)(39,0)
          (39,2)  -> (38,2)(40,2)(39,3)(39,1)
          (39,3)  -> (38,3)(40,3)(39,4)(39,2)
          (39,4)  -> (38,4)(40,4)(39,5)(39,3)
          (39,5)  -> (38,5)(40,5)(39,6)(39,4)
          (39,6)  -> (38,6)(40,6)(39,7)(39,5)
          (39,7)  -> (38,7)(40,7)(39,8)(39,6)
          (39,8)  -> (38,8)(40,8)(39,9)(39,7)
          (39,9)  -> (38,9)(40,9)(39,10)(39,8)
          (39,10) -> (38,10)(40,10)(39,11)(39,9)
          (39,11) -> (38,11)(40,11)(39,12)(39,10)
          (39,12) -> (38,12)(40,12)(39,13)(39,11)
          (39,13) -> (38,13)(40,13)(39,14)(39,12)
          (39,14) -> (38,14)(40,14)(39,15)(39,13)
          (39,15) -> (38,15)(40,15)(39,16)(39,14)
          (39,16) -> (38,16)(40,16)(39,17)(39,15)
          (39,17) -> (38,17)(40,17)(39,18)(39,16)
          (39,18) -> (38,18)(40,18)(39,19)(39,17)
          (39,19) -> (38,19)(40,19)(39,20)(39,18)
          (39,20) -> (38,20)(40,20)(39,21)(39,19)
          (39,21) -> (38,21)(40,21)(39,22)(39,20)
          (39,22) -> (38,22)(40,22)(39,23)(39,21)
          (39,23) -> (38,23)(40,23)(39,24)(39,22)
          (39,24) -> (38,24)(40,24)(39,25)(39,23)
          (39,25) -> (38,25)(40,25)(39,26)(39,24)
          (39,26) -> (38,26)(40,26)(39,27)(39,25)
          (39,27) -> (38,27)(40,27)(39,28)(39,26)
          (39,28) -> (38,28)(40,28)(39,29)(39,27)
          (39,29) -> (38,29)(40,29)(39,30)(39,28)
          (39,30) -> (38,30)(40,30)(39,31)(39,29)
          (39,31) -> (38,31)(40,31)(39,32)(39,30)
          (39,32) -> (38,32)(40,32)(39,33)(39,31)
          (39,33) -> (38,33)(40,33)(39,34)(39,32)
          (39,34) -> (38,34)(40,34)(39,35)(39,33)
          (39,35) -> (38,35)(40,35)(39,36)(39,34)
          (39,36) -> (38,36)(40,36)(39,37)(39,35)
          (39,37) -> (38,37)(40,37)(39,38)(39,36)
          (39,38) -> (38,38)(40,38)(39,39)(39,37)
          (39,39) -> (38,39)(40,39)(39,40)(39,38)
          (39,40) -> (38,40)(40,40)(39,41)(39,39)
          (39,41) -> (38,41)(40,41)(39,42)(39,40)
          (39,42) -> (38,42)(40,42)(39,43)(39,41)
          (39,43) -> (38,43)(40,43)(39,44)(39,42)
          (39,44) -> (38,44)(40,44)(39,45)(39,43)
          (39,45) -> (38,45)(40,45)(39,46)(39,44)
          (39,46) -> (38,46)(40,46)(39,47)(39,45)
          (39,47) -> (38,47)(40,47)(39,48)(39,46)
          (39,48) -> (38,48)(40,48)(39,49)(39,47)
          (39,49) -> (38,49)(40,49)(39,50)(39,48)
          (39,50) -> (38,50)(40,50)(39,51)(39,49)
          (39,51) -> (38,51)(40,51)(39,52)(39,50)
          (39,52) -> (38,52)(40,52)(39,53)(39,51)
          (39,53) -> (38,53)(40,53)(39,54)(39,52)
          (39,54) -> (38,54)(40,54)(39,55)(39,53)
          (39,55) -> (38,55)(40,55)(39,56)(39,54)
          (39,56) -> (38,56)(40,56)(39,57)(39,55)
          (39,57) -> (38,57)(40,57)(39,58)(39,56)
          (39,58) -> (38,58)(40,58)(39,59)(39,57)
          (39,59) -> (38,59)(40,59)(39,60)(39,58)
          (39,60) -> (38,60)(40,60)(39,61)(39,59)
          (39,61) -> (38,61)(40,61)(39,62)(39,60)
          (39,62) -> (38,62)(40,62)(39,63)(39,61)
          (39,63) -> (38,63)(40,63)(39,62)
          (40,0)  -> (39,0)(41,0)(40,1)
          (40,1)  -> (39,1)(41,1)(40,2)(40,0)
          (40,2)  -> (39,2)(41,2)(40,3)(40,1)
          (40,3)  -> (39,3)(41,3)(40,4)(40,2)
          (40,4)  -> (39,4)(41,4)(40,5)(40,3)
          (40,5)  -> (39,5)(41,5)(40,6)(40,4)
          (40,6)  -> (39,6)(41,6)(40,7)(40,5)
          (40,7)  -> (39,7)(41,7)(40,8)(40,6)
          (40,8)  -> (39,8)(41,8)(40,9)(40,7)
          (40,9)  -> (39,9)(41,9)(40,10)(40,8)
          (40,10) -> (39,10)(41,10)(40,11)(40,9)
          (40,11) -> (39,11)(41,11)(40,12)(40,10)
          (40,12) -> (39,12)(41,12)(40,13)(40,11)
          (40,13) -> (39,13)(41,13)(40,14)(40,12)
          (40,14) -> (39,14)(41,14)(40,15)(40,13)
          (40,15) -> (39,15)(41,15)(40,16)(40,14)
          (40,16) -> (39,16)(41,16)(40,17)(40,15)
          (40,17) -> (39,17)(41,17)(40,18)(40,16)
          (40,18) -> (39,18)(41,18)(40,19)(40,17)
          (40,19) -> (39,19)(41,19)(40,20)(40,18)
          (40,20) -> (39,20)(41,20)(40,21)(40,19)
          (40,21) -> (39,21)(41,21)(40,22)(40,20)
          (40,22) -> (39,22)(41,22)(40,23)(40,21)
          (40,23) -> (39,23)(41,23)(40,24)(40,22)
          (40,24) -> (39,24)(41,24)(40,25)(40,23)
          (40,25) -> (39,25)(41,25)(40,26)(40,24)
          (40,26) -> (39,26)(41,26)(40,27)(40,25)
          (40,27) -> (39,27)(41,27)(40,28)(40,26)
          (40,28) -> (39,28)(41,28)(40,29)(40,27)
          (40,29) -> (39,29)(41,29)(40,30)(40,28)
          (40,30) -> (39,30)(41,30)(40,31)(40,29)
          (40,31) -> (39,31)(41,31)(40,32)(40,30)
          (40,32) -> (39,32)(41,32)(40,33)(40,31)
          (40,33) -> (39,33)(41,33)(40,34)(40,32)
          (40,34) -> (39,34)(41,34)(40,35)(40,33)
          (40,35) -> (39,35)(41,35)(40,36)(40,34)
          (40,36) -> (39,36)(41,36)(40,37)(40,35)
          (40,37) -> (39,37)(41,37)(40,38)(40,36)
          (40,38) -> (39,38)(41,38)(40,39)(40,37)
          (40,39) -> (39,39)(41,39)(40,40)(40,38)
          (40,40) -> (39,40)(41,40)(40,41)(40,39)
          (40,41) -> (39,41)(41,41)(40,42)(40,40)
          (40,42) -> (39,42)(41,42)(40,43)(40,41)
          (40,43) -> (39,43)(41,43)(40,44)(40,42)
          (40,44) -> (39,44)(41,44)(40,45)(40,43)
          (40,45) -> (39,45)(41,45)(40,46)(40,44)
          (40,46) -> (39,46)(41,46)(40,47)(40,45)
          (40,47) -> (39,47)(41,47)(40,48)(40,46)
          (40,48) -> (39,48)(41,48)(40,49)(40,47)
          (40,49) -> (39,49)(41,49)(40,50)(40,48)
          (40,50) -> (39,50)(41,50)(40,51)(40,49)
          (40,51) -> (39,51)(41,51)(40,52)(40,50)
          (40,52) -> (39,52)(41,52)(40,53)(40,51)
          (40,53) -> (39,53)(41,53)(40,54)(40,52)
          (40,54) -> (39,54)(41,54)(40,55)(40,53)
          (40,55) -> (39,55)(41,55)(40,56)(40,54)
          (40,56) -> (39,56)(41,56)(40,57)(40,55)
          (40,57) -> (39,57)(41,57)(40,58)(40,56)
          (40,58) -> (39,58)(41,58)(40,59)(40,57)
          (40,59) -> (39,59)(41,59)(40,60)(40,58)
          (40,60) -> (39,60)(41,60)(40,61)(40,59)
          (40,61) -> (39,61)(41,61)(40,62)(40,60)
          (40,62) -> (39,62)(41,62)(40,63)(40,61)
          (40,63) -> (39,63)(41,63)(40,62)
          (41,0)  -> (40,0)(42,0)(41,1)
          (41,1)  -> (40,1)(42,1)(41,2)(41,0)
          (41,2)  -> (40,2)(42,2)(41,3)(41,1)
          (41,3)  -> (40,3)(42,3)(41,4)(41,2)
          (41,4)  -> (40,4)(42,4)(41,5)(41,3)
          (41,5)  -> (40,5)(42,5)(41,6)(41,4)
          (41,6)  -> (40,6)(42,6)(41,7)(41,5)
          (41,7)  -> (40,7)(42,7)(41,8)(41,6)
          (41,8)  -> (40,8)(42,8)(41,9)(41,7)
          (41,9)  -> (40,9)(42,9)(41,10)(41,8)
          (41,10) -> (40,10)(42,10)(41,11)(41,9)
          (41,11) -> (40,11)(42,11)(41,12)(41,10)
          (41,12) -> (40,12)(42,12)(41,13)(41,11)
          (41,13) -> (40,13)(42,13)(41,14)(41,12)
          (41,14) -> (40,14)(42,14)(41,15)(41,13)
          (41,15) -> (40,15)(42,15)(41,16)(41,14)
          (41,16) -> (40,16)(42,16)(41,17)(41,15)
          (41,17) -> (40,17)(42,17)(41,18)(41,16)
          (41,18) -> (40,18)(42,18)(41,19)(41,17)
          (41,19) -> (40,19)(42,19)(41,20)(41,18)
          (41,20) -> (40,20)(42,20)(41,21)(41,19)
          (41,21) -> (40,21)(42,21)(41,22)(41,20)
          (41,22) -> (40,22)(42,22)(41,23)(41,21)
          (41,23) -> (40,23)(42,23)(41,24)(41,22)
          (41,24) -> (40,24)(42,24)(41,25)(41,23)
          (41,25) -> (40,25)(42,25)(41,26)(41,24)
          (41,26) -> (40,26)(42,26)(41,27)(41,25)
          (41,27) -> (40,27)(42,27)(41,28)(41,26)
          (41,28) -> (40,28)(42,28)(41,29)(41,27)
          (41,29) -> (40,29)(42,29)(41,30)(41,28)
          (41,30) -> (40,30)(42,30)(41,31)(41,29)
          (41,31) -> (40,31)(42,31)(41,32)(41,30)
          (41,32) -> (40,32)(42,32)(41,33)(41,31)
          (41,33) -> (40,33)(42,33)(41,34)(41,32)
          (41,34) -> (40,34)(42,34)(41,35)(41,33)
          (41,35) -> (40,35)(42,35)(41,36)(41,34)
          (41,36) -> (40,36)(42,36)(41,37)(41,35)
          (41,37) -> (40,37)(42,37)(41,38)(41,36)
          (41,38) -> (40,38)(42,38)(41,39)(41,37)
          (41,39) -> (40,39)(42,39)(41,40)(41,38)
          (41,40) -> (40,40)(42,40)(41,41)(41,39)
          (41,41) -> (40,41)(42,41)(41,42)(41,40)
          (41,42) -> (40,42)(42,42)(41,43)(41,41)
          (41,43) -> (40,43)(42,43)(41,44)(41,42)
          (41,44) -> (40,44)(42,44)(41,45)(41,43)
          (41,45) -> (40,45)(42,45)(41,46)(41,44)
          (41,46) -> (40,46)(42,46)(41,47)(41,45)
          (41,47) -> (40,47)(42,47)(41,48)(41,46)
          (41,48) -> (40,48)(42,48)(41,49)(41,47)
          (41,49) -> (40,49)(42,49)(41,50)(41,48)
          (41,50) -> (40,50)(42,50)(41,51)(41,49)
          (41,51) -> (40,51)(42,51)(41,52)(41,50)
          (41,52) -> (40,52)(42,52)(41,53)(41,51)
          (41,53) -> (40,53)(42,53)(41,54)(41,52)
          (41,54) -> (40,54)(42,54)(41,55)(41,53)
          (41,55) -> (40,55)(42,55)(41,56)(41,54)
          (41,56) -> (40,56)(42,56)(41,57)(41,55)
          (41,57) -> (40,57)(42,57)(41,58)(41,56)
          (41,58) -> (40,58)(42,58)(41,59)(41,57)
          (41,59) -> (40,59)(42,59)(41,60)(41,58)
          (41,60) -> (40,60)(42,60)(41,61)(41,59)
          (41,61) -> (40,61)(42,61)(41,62)(41,60)
          (41,62) -> (40,62)(42,62)(41,63)(41,61)
          (41,63) -> (40,63)(42,63)(41,62)
          (42,0)  -> (41,0)(43,0)(42,1)
          (42,1)  -> (41,1)(43,1)(42,2)(42,0)
          (42,2)  -> (41,2)(43,2)(42,3)(42,1)
          (42,3)  -> (41,3)(43,3)(42,4)(42,2)
          (42,4)  -> (41,4)(43,4)(42,5)(42,3)
          (42,5)  -> (41,5)(43,5)(42,6)(42,4)
          (42,6)  -> (41,6)(43,6)(42,7)(42,5)
          (42,7)  -> (41,7)(43,7)(42,8)(42,6)
          (42,8)  -> (41,8)(43,8)(42,9)(42,7)
          (42,9)  -> (41,9)(43,9)(42,10)(42,8)
          (42,10) -> (41,10)(43,10)(42,11)(42,9)
          (42,11) -> (41,11)(43,11)(42,12)(42,10)
          (42,12) -> (41,12)(43,12)(42,13)(42,11)
          (42,13) -> (41,13)(43,13)(42,14)(42,12)
          (42,14) -> (41,14)(43,14)(42,15)(42,13)
          (42,15) -> (41,15)(43,15)(42,16)(42,14)
          (42,16) -> (41,16)(43,16)(42,17)(42,15)
          (42,17) -> (41,17)(43,17)(42,18)(42,16)
          (42,18) -> (41,18)(43,18)(42,19)(42,17)
          (42,19) -> (41,19)(43,19)(42,20)(42,18)
          (42,20) -> (41,20)(43,20)(42,21)(42,19)
          (42,21) -> (41,21)(43,21)(42,22)(42,20)
          (42,22) -> (41,22)(43,22)(42,23)(42,21)
          (42,23) -> (41,23)(43,23)(42,24)(42,22)
          (42,24) -> (41,24)(43,24)(42,25)(42,23)
          (42,25) -> (41,25)(43,25)(42,26)(42,24)
          (42,26) -> (41,26)(43,26)(42,27)(42,25)
          (42,27) -> (41,27)(43,27)(42,28)(42,26)
          (42,28) -> (41,28)(43,28)(42,29)(42,27)
          (42,29) -> (41,29)(43,29)(42,30)(42,28)
          (42,30) -> (41,30)(43,30)(42,31)(42,29)
          (42,31) -> (41,31)(43,31)(42,32)(42,30)
          (42,32) -> (41,32)(43,32)(42,33)(42,31)
          (42,33) -> (41,33)(43,33)(42,34)(42,32)
          (42,34) -> (41,34)(43,34)(42,35)(42,33)
          (42,35) -> (41,35)(43,35)(42,36)(42,34)
          (42,36) -> (41,36)(43,36)(42,37)(42,35)
          (42,37) -> (41,37)(43,37)(42,38)(42,36)
          (42,38) -> (41,38)(43,38)(42,39)(42,37)
          (42,39) -> (41,39)(43,39)(42,40)(42,38)
          (42,40) -> (41,40)(43,40)(42,41)(42,39)
          (42,41) -> (41,41)(43,41)(42,42)(42,40)
          (42,42) -> (41,42)(43,42)(42,43)(42,41)
          (42,43) -> (41,43)(43,43)(42,44)(42,42)
          (42,44) -> (41,44)(43,44)(42,45)(42,43)
          (42,45) -> (41,45)(43,45)(42,46)(42,44)
          (42,46) -> (41,46)(43,46)(42,47)(42,45)
          (42,47) -> (41,47)(43,47)(42,48)(42,46)
          (42,48) -> (41,48)(43,48)(42,49)(42,47)
          (42,49) -> (41,49)(43,49)(42,50)(42,48)
          (42,50) -> (41,50)(43,50)(42,51)(42,49)
          (42,51) -> (41,51)(43,51)(42,52)(42,50)
          (42,52) -> (41,52)(43,52)(42,53)(42,51)
          (42,53) -> (41,53)(43,53)(42,54)(42,52)
          (42,54) -> (41,54)(43,54)(42,55)(42,53)
          (42,55) -> (41,55)(43,55)(42,56)(42,54)
          (42,56) -> (41,56)(43,56)(42,57)(42,55)
          (42,57) -> (41,57)(43,57)(42,58)(42,56)
          (42,58) -> (41,58)(43,58)(42,59)(42,57)
          (42,59) -> (41,59)(43,59)(42,60)(42,58)
          (42,60) -> (41,60)(43,60)(42,61)(42,59)
          (42,61) -> (41,61)(43,61)(42,62)(42,60)
          (42,62) -> (41,62)(43,62)(42,63)(42,61)
          (42,63) -> (41,63)(43,63)(42,62)
          (43,0)  -> (42,0)(44,0)(43,1)
          (43,1)  -> (42,1)(44,1)(43,2)(43,0)
          (43,2)  -> (42,2)(44,2)(43,3)(43,1)
          (43,3)  -> (42,3)(44,3)(43,4)(43,2)
          (43,4)  -> (42,4)(44,4)(43,5)(43,3)
          (43,5)  -> (42,5)(44,5)(43,6)(43,4)
          (43,6)  -> (42,6)(44,6)(43,7)(43,5)
          (43,7)  -> (42,7)(44,7)(43,8)(43,6)
          (43,8)  -> (42,8)(44,8)(43,9)(43,7)
          (43,9)  -> (42,9)(44,9)(43,10)(43,8)
          (43,10) -> (42,10)(44,10)(43,11)(43,9)
          (43,11) -> (42,11)(44,11)(43,12)(43,10)
          (43,12) -> (42,12)(44,12)(43,13)(43,11)
          (43,13) -> (42,13)(44,13)(43,14)(43,12)
          (43,14) -> (42,14)(44,14)(43,15)(43,13)
          (43,15) -> (42,15)(44,15)(43,16)(43,14)
          (43,16) -> (42,16)(44,16)(43,17)(43,15)
          (43,17) -> (42,17)(44,17)(43,18)(43,16)
          (43,18) -> (42,18)(44,18)(43,19)(43,17)
          (43,19) -> (42,19)(44,19)(43,20)(43,18)
          (43,20) -> (42,20)(44,20)(43,21)(43,19)
          (43,21) -> (42,21)(44,21)(43,22)(43,20)
          (43,22) -> (42,22)(44,22)(43,23)(43,21)
          (43,23) -> (42,23)(44,23)(43,24)(43,22)
          (43,24) -> (42,24)(44,24)(43,25)(43,23)
          (43,25) -> (42,25)(44,25)(43,26)(43,24)
          (43,26) -> (42,26)(44,26)(43,27)(43,25)
          (43,27) -> (42,27)(44,27)(43,28)(43,26)
          (43,28) -> (42,28)(44,28)(43,29)(43,27)
          (43,29) -> (42,29)(44,29)(43,30)(43,28)
          (43,30) -> (42,30)(44,30)(43,31)(43,29)
          (43,31) -> (42,31)(44,31)(43,32)(43,30)
          (43,32) -> (42,32)(44,32)(43,33)(43,31)
          (43,33) -> (42,33)(44,33)(43,34)(43,32)
          (43,34) -> (42,34)(44,34)(43,35)(43,33)
          (43,35) -> (42,35)(44,35)(43,36)(43,34)
          (43,36) -> (42,36)(44,36)(43,37)(43,35)
          (43,37) -> (42,37)(44,37)(43,38)(43,36)
          (43,38) -> (42,38)(44,38)(43,39)(43,37)
          (43,39) -> (42,39)(44,39)(43,40)(43,38)
          (43,40) -> (42,40)(44,40)(43,41)(43,39)
          (43,41) -> (42,41)(44,41)(43,42)(43,40)
          (43,42) -> (42,42)(44,42)(43,43)(43,41)
          (43,43) -> (42,43)(44,43)(43,44)(43,42)
          (43,44) -> (42,44)(44,44)(43,45)(43,43)
          (43,45) -> (42,45)(44,45)(43,46)(43,44)
          (43,46) -> (42,46)(44,46)(43,47)(43,45)
          (43,47) -> (42,47)(44,47)(43,48)(43,46)
          (43,48) -> (42,48)(44,48)(43,49)(43,47)
          (43,49) -> (42,49)(44,49)(43,50)(43,48)
          (43,50) -> (42,50)(44,50)(43,51)(43,49)
          (43,51) -> (42,51)(44,51)(43,52)(43,50)
          (43,52) -> (42,52)(44,52)(43,53)(43,51)
          (43,53) -> (42,53)(44,53)(43,54)(43,52)
          (43,54) -> (42,54)(44,54)(43,55)(43,53)
          (43,55) -> (42,55)(44,55)(43,56)(43,54)
          (43,56) -> (42,56)(44,56)(43,57)(43,55)
          (43,57) -> (42,57)(44,57)(43,58)(43,56)
          (43,58) -> (42,58)(44,58)(43,59)(43,57)
          (43,59) -> (42,59)(44,59)(43,60)(43,58)
          (43,60) -> (42,60)(44,60)(43,61)(43,59)
          (43,61) -> (42,61)(44,61)(43,62)(43,60)
          (43,62) -> (42,62)(44,62)(43,63)(43,61)
          (43,63) -> (42,63)(44,63)(43,62)
          (44,0)  -> (43,0)(45,0)(44,1)
          (44,1)  -> (43,1)(45,1)(44,2)(44,0)
          (44,2)  -> (43,2)(45,2)(44,3)(44,1)
          (44,3)  -> (43,3)(45,3)(44,4)(44,2)
          (44,4)  -> (43,4)(45,4)(44,5)(44,3)
          (44,5)  -> (43,5)(45,5)(44,6)(44,4)
          (44,6)  -> (43,6)(45,6)(44,7)(44,5)
          (44,7)  -> (43,7)(45,7)(44,8)(44,6)
          (44,8)  -> (43,8)(45,8)(44,9)(44,7)
          (44,9)  -> (43,9)(45,9)(44,10)(44,8)
          (44,10) -> (43,10)(45,10)(44,11)(44,9)
          (44,11) -> (43,11)(45,11)(44,12)(44,10)
          (44,12) -> (43,12)(45,12)(44,13)(44,11)
          (44,13) -> (43,13)(45,13)(44,14)(44,12)
          (44,14) -> (43,14)(45,14)(44,15)(44,13)
          (44,15) -> (43,15)(45,15)(44,16)(44,14)
          (44,16) -> (43,16)(45,16)(44,17)(44,15)
          (44,17) -> (43,17)(45,17)(44,18)(44,16)
          (44,18) -> (43,18)(45,18)(44,19)(44,17)
          (44,19) -> (43,19)(45,19)(44,20)(44,18)
          (44,20) -> (43,20)(45,20)(44,21)(44,19)
          (44,21) -> (43,21)(45,21)(44,22)(44,20)
          (44,22) -> (43,22)(45,22)(44,23)(44,21)
          (44,23) -> (43,23)(45,23)(44,24)(44,22)
          (44,24) -> (43,24)(45,24)(44,25)(44,23)
          (44,25) -> (43,25)(45,25)(44,26)(44,24)
          (44,26) -> (43,26)(45,26)(44,27)(44,25)
          (44,27) -> (43,27)(45,27)(44,28)(44,26)
          (44,28) -> (43,28)(45,28)(44,29)(44,27)
          (44,29) -> (43,29)(45,29)(44,30)(44,28)
          (44,30) -> (43,30)(45,30)(44,31)(44,29)
          (44,31) -> (43,31)(45,31)(44,32)(44,30)
          (44,32) -> (43,32)(45,32)(44,33)(44,31)
          (44,33) -> (43,33)(45,33)(44,34)(44,32)
          (44,34) -> (43,34)(45,34)(44,35)(44,33)
          (44,35) -> (43,35)(45,35)(44,36)(44,34)
          (44,36) -> (43,36)(45,36)(44,37)(44,35)
          (44,37) -> (43,37)(45,37)(44,38)(44,36)
          (44,38) -> (43,38)(45,38)(44,39)(44,37)
          (44,39) -> (43,39)(45,39)(44,40)(44,38)
          (44,40) -> (43,40)(45,40)(44,41)(44,39)
          (44,41) -> (43,41)(45,41)(44,42)(44,40)
          (44,42) -> (43,42)(45,42)(44,43)(44,41)
          (44,43) -> (43,43)(45,43)(44,44)(44,42)
          (44,44) -> (43,44)(45,44)(44,45)(44,43)
          (44,45) -> (43,45)(45,45)(44,46)(44,44)
          (44,46) -> (43,46)(45,46)(44,47)(44,45)
          (44,47) -> (43,47)(45,47)(44,48)(44,46)
          (44,48) -> (43,48)(45,48)(44,49)(44,47)
          (44,49) -> (43,49)(45,49)(44,50)(44,48)
          (44,50) -> (43,50)(45,50)(44,51)(44,49)
          (44,51) -> (43,51)(45,51)(44,52)(44,50)
          (44,52) -> (43,52)(45,52)(44,53)(44,51)
          (44,53) -> (43,53)(45,53)(44,54)(44,52)
          (44,54) -> (43,54)(45,54)(44,55)(44,53)
          (44,55) -> (43,55)(45,55)(44,56)(44,54)
          (44,56) -> (43,56)(45,56)(44,57)(44,55)
          (44,57) -> (43,57)(45,57)(44,58)(44,56)
          (44,58) -> (43,58)(45,58)(44,59)(44,57)
          (44,59) -> (43,59)(45,59)(44,60)(44,58)
          (44,60) -> (43,60)(45,60)(44,61)(44,59)
          (44,61) -> (43,61)(45,61)(44,62)(44,60)
          (44,62) -> (43,62)(45,62)(44,63)(44,61)
          (44,63) -> (43,63)(45,63)(44,62)
          (45,0)  -> (44,0)(46,0)(45,1)
          (45,1)  -> (44,1)(46,1)(45,2)(45,0)
          (45,2)  -> (44,2)(46,2)(45,3)(45,1)
          (45,3)  -> (44,3)(46,3)(45,4)(45,2)
          (45,4)  -> (44,4)(46,4)(45,5)(45,3)
          (45,5)  -> (44,5)(46,5)(45,6)(45,4)
          (45,6)  -> (44,6)(46,6)(45,7)(45,5)
          (45,7)  -> (44,7)(46,7)(45,8)(45,6)
          (45,8)  -> (44,8)(46,8)(45,9)(45,7)
          (45,9)  -> (44,9)(46,9)(45,10)(45,8)
          (45,10) -> (44,10)(46,10)(45,11)(45,9)
          (45,11) -> (44,11)(46,11)(45,12)(45,10)
          (45,12) -> (44,12)(46,12)(45,13)(45,11)
          (45,13) -> (44,13)(46,13)(45,14)(45,12)
          (45,14) -> (44,14)(46,14)(45,15)(45,13)
          (45,15) -> (44,15)(46,15)(45,16)(45,14)
          (45,16) -> (44,16)(46,16)(45,17)(45,15)
          (45,17) -> (44,17)(46,17)(45,18)(45,16)
          (45,18) -> (44,18)(46,18)(45,19)(45,17)
          (45,19) -> (44,19)(46,19)(45,20)(45,18)
          (45,20) -> (44,20)(46,20)(45,21)(45,19)
          (45,21) -> (44,21)(46,21)(45,22)(45,20)
          (45,22) -> (44,22)(46,22)(45,23)(45,21)
          (45,23) -> (44,23)(46,23)(45,24)(45,22)
          (45,24) -> (44,24)(46,24)(45,25)(45,23)
          (45,25) -> (44,25)(46,25)(45,26)(45,24)
          (45,26) -> (44,26)(46,26)(45,27)(45,25)
          (45,27) -> (44,27)(46,27)(45,28)(45,26)
          (45,28) -> (44,28)(46,28)(45,29)(45,27)
          (45,29) -> (44,29)(46,29)(45,30)(45,28)
          (45,30) -> (44,30)(46,30)(45,31)(45,29)
          (45,31) -> (44,31)(46,31)(45,32)(45,30)
          (45,32) -> (44,32)(46,32)(45,33)(45,31)
          (45,33) -> (44,33)(46,33)(45,34)(45,32)
          (45,34) -> (44,34)(46,34)(45,35)(45,33)
          (45,35) -> (44,35)(46,35)(45,36)(45,34)
          (45,36) -> (44,36)(46,36)(45,37)(45,35)
          (45,37) -> (44,37)(46,37)(45,38)(45,36)
          (45,38) -> (44,38)(46,38)(45,39)(45,37)
          (45,39) -> (44,39)(46,39)(45,40)(45,38)
          (45,40) -> (44,40)(46,40)(45,41)(45,39)
          (45,41) -> (44,41)(46,41)(45,42)(45,40)
          (45,42) -> (44,42)(46,42)(45,43)(45,41)
          (45,43) -> (44,43)(46,43)(45,44)(45,42)
          (45,44) -> (44,44)(46,44)(45,45)(45,43)
          (45,45) -> (44,45)(46,45)(45,46)(45,44)
          (45,46) -> (44,46)(46,46)(45,47)(45,45)
          (45,47) -> (44,47)(46,47)(45,48)(45,46)
          (45,48) -> (44,48)(46,48)(45,49)(45,47)
          (45,49) -> (44,49)(46,49)(45,50)(45,48)
          (45,50) -> (44,50)(46,50)(45,51)(45,49)
          (45,51) -> (44,51)(46,51)(45,52)(45,50)
          (45,52) -> (44,52)(46,52)(45,53)(45,51)
          (45,53) -> (44,53)(46,53)(45,54)(45,52)
          (45,54) -> (44,54)(46,54)(45,55)(45,53)
          (45,55) -> (44,55)(46,55)(45,56)(45,54)
          (45,56) -> (44,56)(46,56)(45,57)(45,55)
          (45,57) -> (44,57)(46,57)(45,58)(45,56)
          (45,58) -> (44,58)(46,58)(45,59)(45,57)
          (45,59) -> (44,59)(46,59)(45,60)(45,58)
          (45,60) -> (44,60)(46,60)(45,61)(45,59)
          (45,61) -> (44,61)(46,61)(45,62)(45,60)
          (45,62) -> (44,62)(46,62)(45,63)(45,61)
          (45,63) -> (44,63)(46,63)(45,62)
          (46,0)  -> (45,0)(47,0)(46,1)
          (46,1)  -> (45,1)(47,1)(46,2)(46,0)
          (46,2)  -> (45,2)(47,2)(46,3)(46,1)
          (46,3)  -> (45,3)(47,3)(46,4)(46,2)
          (46,4)  -> (45,4)(47,4)(46,5)(46,3)
          (46,5)  -> (45,5)(47,5)(46,6)(46,4)
          (46,6)  -> (45,6)(47,6)(46,7)(46,5)
          (46,7)  -> (45,7)(47,7)(46,8)(46,6)
          (46,8)  -> (45,8)(47,8)(46,9)(46,7)
          (46,9)  -> (45,9)(47,9)(46,10)(46,8)
          (46,10) -> (45,10)(47,10)(46,11)(46,9)
          (46,11) -> (45,11)(47,11)(46,12)(46,10)
          (46,12) -> (45,12)(47,12)(46,13)(46,11)
          (46,13) -> (45,13)(47,13)(46,14)(46,12)
          (46,14) -> (45,14)(47,14)(46,15)(46,13)
          (46,15) -> (45,15)(47,15)(46,16)(46,14)
          (46,16) -> (45,16)(47,16)(46,17)(46,15)
          (46,17) -> (45,17)(47,17)(46,18)(46,16)
          (46,18) -> (45,18)(47,18)(46,19)(46,17)
          (46,19) -> (45,19)(47,19)(46,20)(46,18)
          (46,20) -> (45,20)(47,20)(46,21)(46,19)
          (46,21) -> (45,21)(47,21)(46,22)(46,20)
          (46,22) -> (45,22)(47,22)(46,23)(46,21)
          (46,23) -> (45,23)(47,23)(46,24)(46,22)
          (46,24) -> (45,24)(47,24)(46,25)(46,23)
          (46,25) -> (45,25)(47,25)(46,26)(46,24)
          (46,26) -> (45,26)(47,26)(46,27)(46,25)
          (46,27) -> (45,27)(47,27)(46,28)(46,26)
          (46,28) -> (45,28)(47,28)(46,29)(46,27)
          (46,29) -> (45,29)(47,29)(46,30)(46,28)
          (46,30) -> (45,30)(47,30)(46,31)(46,29)
          (46,31) -> (45,31)(47,31)(46,32)(46,30)
          (46,32) -> (45,32)(47,32)(46,33)(46,31)
          (46,33) -> (45,33)(47,33)(46,34)(46,32)
          (46,34) -> (45,34)(47,34)(46,35)(46,33)
          (46,35) -> (45,35)(47,35)(46,36)(46,34)
          (46,36) -> (45,36)(47,36)(46,37)(46,35)
          (46,37) -> (45,37)(47,37)(46,38)(46,36)
          (46,38) -> (45,38)(47,38)(46,39)(46,37)
          (46,39) -> (45,39)(47,39)(46,40)(46,38)
          (46,40) -> (45,40)(47,40)(46,41)(46,39)
          (46,41) -> (45,41)(47,41)(46,42)(46,40)
          (46,42) -> (45,42)(47,42)(46,43)(46,41)
          (46,43) -> (45,43)(47,43)(46,44)(46,42)
          (46,44) -> (45,44)(47,44)(46,45)(46,43)
          (46,45) -> (45,45)(47,45)(46,46)(46,44)
          (46,46) -> (45,46)(47,46)(46,47)(46,45)
          (46,47) -> (45,47)(47,47)(46,48)(46,46)
          (46,48) -> (45,48)(47,48)(46,49)(46,47)
          (46,49) -> (45,49)(47,49)(46,50)(46,48)
          (46,50) -> (45,50)(47,50)(46,51)(46,49)
          (46,51) -> (45,51)(47,51)(46,52)(46,50)
          (46,52) -> (45,52)(47,52)(46,53)(46,51)
          (46,53) -> (45,53)(47,53)(46,54)(46,52)
          (46,54) -> (45,54)(47,54)(46,55)(46,53)
          (46,55) -> (45,55)(47,55)(46,56)(46,54)
          (46,56) -> (45,56)(47,56)(46,57)(46,55)
          (46,57) -> (45,57)(47,57)(46,58)(46,56)
          (46,58) -> (45,58)(47,58)(46,59)(46,57)
          (46,59) -> (45,59)(47,59)(46,60)(46,58)
          (46,60) -> (45,60)(47,60)(46,61)(46,59)
          (46,61) -> (45,61)(47,61)(46,62)(46,60)
          (46,62) -> (45,62)(47,62)(46,63)(46,61)
          (46,63) -> (45,63)(47,63)(46,62)
          (47,0)  -> (46,0)(48,0)(47,1)
          (47,1)  -> (46,1)(48,1)(47,2)(47,0)
          (47,2)  -> (46,2)(48,2)(47,3)(47,1)
          (47,3)  -> (46,3)(48,3)(47,4)(47,2)
          (47,4)  -> (46,4)(48,4)(47,5)(47,3)
          (47,5)  -> (46,5)(48,5)(47,6)(47,4)
          (47,6)  -> (46,6)(48,6)(47,7)(47,5)
          (47,7)  -> (46,7)(48,7)(47,8)(47,6)
          (47,8)  -> (46,8)(48,8)(47,9)(47,7)
          (47,9)  -> (46,9)(48,9)(47,10)(47,8)
          (47,10) -> (46,10)(48,10)(47,11)(47,9)
          (47,11) -> (46,11)(48,11)(47,12)(47,10)
          (47,12) -> (46,12)(48,12)(47,13)(47,11)
          (47,13) -> (46,13)(48,13)(47,14)(47,12)
          (47,14) -> (46,14)(48,14)(47,15)(47,13)
          (47,15) -> (46,15)(48,15)(47,16)(47,14)
          (47,16) -> (46,16)(48,16)(47,17)(47,15)
          (47,17) -> (46,17)(48,17)(47,18)(47,16)
          (47,18) -> (46,18)(48,18)(47,19)(47,17)
          (47,19) -> (46,19)(48,19)(47,20)(47,18)
          (47,20) -> (46,20)(48,20)(47,21)(47,19)
          (47,21) -> (46,21)(48,21)(47,22)(47,20)
          (47,22) -> (46,22)(48,22)(47,23)(47,21)
          (47,23) -> (46,23)(48,23)(47,24)(47,22)
          (47,24) -> (46,24)(48,24)(47,25)(47,23)
          (47,25) -> (46,25)(48,25)(47,26)(47,24)
          (47,26) -> (46,26)(48,26)(47,27)(47,25)
          (47,27) -> (46,27)(48,27)(47,28)(47,26)
          (47,28) -> (46,28)(48,28)(47,29)(47,27)
          (47,29) -> (46,29)(48,29)(47,30)(47,28)
          (47,30) -> (46,30)(48,30)(47,31)(47,29)
          (47,31) -> (46,31)(48,31)(47,32)(47,30)
          (47,32) -> (46,32)(48,32)(47,33)(47,31)
          (47,33) -> (46,33)(48,33)(47,34)(47,32)
          (47,34) -> (46,34)(48,34)(47,35)(47,33)
          (47,35) -> (46,35)(48,35)(47,36)(47,34)
          (47,36) -> (46,36)(48,36)(47,37)(47,35)
          (47,37) -> (46,37)(48,37)(47,38)(47,36)
          (47,38) -> (46,38)(48,38)(47,39)(47,37)
          (47,39) -> (46,39)(48,39)(47,40)(47,38)
          (47,40) -> (46,40)(48,40)(47,41)(47,39)
          (47,41) -> (46,41)(48,41)(47,42)(47,40)
          (47,42) -> (46,42)(48,42)(47,43)(47,41)
          (47,43) -> (46,43)(48,43)(47,44)(47,42)
          (47,44) -> (46,44)(48,44)(47,45)(47,43)
          (47,45) -> (46,45)(48,45)(47,46)(47,44)
          (47,46) -> (46,46)(48,46)(47,47)(47,45)
          (47,47) -> (46,47)(48,47)(47,48)(47,46)
          (47,48) -> (46,48)(48,48)(47,49)(47,47)
          (47,49) -> (46,49)(48,49)(47,50)(47,48)
          (47,50) -> (46,50)(48,50)(47,51)(47,49)
          (47,51) -> (46,51)(48,51)(47,52)(47,50)
          (47,52) -> (46,52)(48,52)(47,53)(47,51)
          (47,53) -> (46,53)(48,53)(47,54)(47,52)
          (47,54) -> (46,54)(48,54)(47,55)(47,53)
          (47,55) -> (46,55)(48,55)(47,56)(47,54)
          (47,56) -> (46,56)(48,56)(47,57)(47,55)
          (47,57) -> (46,57)(48,57)(47,58)(47,56)
          (47,58) -> (46,58)(48,58)(47,59)(47,57)
          (47,59) -> (46,59)(48,59)(47,60)(47,58)
          (47,60) -> (46,60)(48,60)(47,61)(47,59)
          (47,61) -> (46,61)(48,61)(47,62)(47,60)
          (47,62) -> (46,62)(48,62)(47,63)(47,61)
          (47,63) -> (46,63)(48,63)(47,62)
          (48,0)  -> (47,0)(49,0)(48,1)
          (48,1)  -> (47,1)(49,1)(48,2)(48,0)
          (48,2)  -> (47,2)(49,2)(48,3)(48,1)
          (48,3)  -> (47,3)(49,3)(48,4)(48,2)
          (48,4)  -> (47,4)(49,4)(48,5)(48,3)
          (48,5)  -> (47,5)(49,5)(48,6)(48,4)
          (48,6)  -> (47,6)(49,6)(48,7)(48,5)
          (48,7)  -> (47,7)(49,7)(48,8)(48,6)
          (48,8)  -> (47,8)(49,8)(48,9)(48,7)
          (48,9)  -> (47,9)(49,9)(48,10)(48,8)
          (48,10) -> (47,10)(49,10)(48,11)(48,9)
          (48,11) -> (47,11)(49,11)(48,12)(48,10)
          (48,12) -> (47,12)(49,12)(48,13)(48,11)
          (48,13) -> (47,13)(49,13)(48,14)(48,12)
          (48,14) -> (47,14)(49,14)(48,15)(48,13)
          (48,15) -> (47,15)(49,15)(48,16)(48,14)
          (48,16) -> (47,16)(49,16)(48,17)(48,15)
          (48,17) -> (47,17)(49,17)(48,18)(48,16)
          (48,18) -> (47,18)(49,18)(48,19)(48,17)
          (48,19) -> (47,19)(49,19)(48,20)(48,18)
          (48,20) -> (47,20)(49,20)(48,21)(48,19)
          (48,21) -> (47,21)(49,21)(48,22)(48,20)
          (48,22) -> (47,22)(49,22)(48,23)(48,21)
          (48,23) -> (47,23)(49,23)(48,24)(48,22)
          (48,24) -> (47,24)(49,24)(48,25)(48,23)
          (48,25) -> (47,25)(49,25)(48,26)(48,24)
          (48,26) -> (47,26)(49,26)(48,27)(48,25)
          (48,27) -> (47,27)(49,27)(48,28)(48,26)
          (48,28) -> (47,28)(49,28)(48,29)(48,27)
          (48,29) -> (47,29)(49,29)(48,30)(48,28)
          (48,30) -> (47,30)(49,30)(48,31)(48,29)
          (48,31) -> (47,31)(49,31)(48,32)(48,30)
          (48,32) -> (47,32)(49,32)(48,33)(48,31)
          (48,33) -> (47,33)(49,33)(48,34)(48,32)
          (48,34) -> (47,34)(49,34)(48,35)(48,33)
          (48,35) -> (47,35)(49,35)(48,36)(48,34)
          (48,36) -> (47,36)(49,36)(48,37)(48,35)
          (48,37) -> (47,37)(49,37)(48,38)(48,36)
          (48,38) -> (47,38)(49,38)(48,39)(48,37)
          (48,39) -> (47,39)(49,39)(48,40)(48,38)
          (48,40) -> (47,40)(49,40)(48,41)(48,39)
          (48,41) -> (47,41)(49,41)(48,42)(48,40)
          (48,42) -> (47,42)(49,42)(48,43)(48,41)
          (48,43) -> (47,43)(49,43)(48,44)(48,42)
          (48,44) -> (47,44)(49,44)(48,45)(48,43)
          (48,45) -> (47,45)(49,45)(48,46)(48,44)
          (48,46) -> (47,46)(49,46)(48,47)(48,45)
          (48,47) -> (47,47)(49,47)(48,48)(48,46)
          (48,48) -> (47,48)(49,48)(48,49)(48,47)
          (48,49) -> (47,49)(49,49)(48,50)(48,48)
          (48,50) -> (47,50)(49,50)(48,51)(48,49)
          (48,51) -> (47,51)(49,51)(48,52)(48,50)
          (48,52) -> (47,52)(49,52)(48,53)(48,51)
          (48,53) -> (47,53)(49,53)(48,54)(48,52)
          (48,54) -> (47,54)(49,54)(48,55)(48,53)
          (48,55) -> (47,55)(49,55)(48,56)(48,54)
          (48,56) -> (47,56)(49,56)(48,57)(48,55)
          (48,57) -> (47,57)(49,57)(48,58)(48,56)
          (48,58) -> (47,58)(49,58)(48,59)(48,57)
          (48,59) -> (47,59)(49,59)(48,60)(48,58)
          (48,60) -> (47,60)(49,60)(48,61)(48,59)
          (48,61) -> (47,61)(49,61)(48,62)(48,60)
          (48,62) -> (47,62)(49,62)(48,63)(48,61)
          (48,63) -> (47,63)(49,63)(48,62)
          (49,0)  -> (48,0)(50,0)(49,1)
          (49,1)  -> (48,1)(50,1)(49,2)(49,0)
          (49,2)  -> (48,2)(50,2)(49,3)(49,1)
          (49,3)  -> (48,3)(50,3)(49,4)(49,2)
          (49,4)  -> (48,4)(50,4)(49,5)(49,3)
          (49,5)  -> (48,5)(50,5)(49,6)(49,4)
          (49,6)  -> (48,6)(50,6)(49,7)(49,5)
          (49,7)  -> (48,7)(50,7)(49,8)(49,6)
          (49,8)  -> (48,8)(50,8)(49,9)(49,7)
          (49,9)  -> (48,9)(50,9)(49,10)(49,8)
          (49,10) -> (48,10)(50,10)(49,11)(49,9)
          (49,11) -> (48,11)(50,11)(49,12)(49,10)
          (49,12) -> (48,12)(50,12)(49,13)(49,11)
          (49,13) -> (48,13)(50,13)(49,14)(49,12)
          (49,14) -> (48,14)(50,14)(49,15)(49,13)
          (49,15) -> (48,15)(50,15)(49,16)(49,14)
          (49,16) -> (48,16)(50,16)(49,17)(49,15)
          (49,17) -> (48,17)(50,17)(49,18)(49,16)
          (49,18) -> (48,18)(50,18)(49,19)(49,17)
          (49,19) -> (48,19)(50,19)(49,20)(49,18)
          (49,20) -> (48,20)(50,20)(49,21)(49,19)
          (49,21) -> (48,21)(50,21)(49,22)(49,20)
          (49,22) -> (48,22)(50,22)(49,23)(49,21)
          (49,23) -> (48,23)(50,23)(49,24)(49,22)
          (49,24) -> (48,24)(50,24)(49,25)(49,23)
          (49,25) -> (48,25)(50,25)(49,26)(49,24)
          (49,26) -> (48,26)(50,26)(49,27)(49,25)
          (49,27) -> (48,27)(50,27)(49,28)(49,26)
          (49,28) -> (48,28)(50,28)(49,29)(49,27)
          (49,29) -> (48,29)(50,29)(49,30)(49,28)
          (49,30) -> (48,30)(50,30)(49,31)(49,29)
          (49,31) -> (48,31)(50,31)(49,32)(49,30)
          (49,32) -> (48,32)(50,32)(49,33)(49,31)
          (49,33) -> (48,33)(50,33)(49,34)(49,32)
          (49,34) -> (48,34)(50,34)(49,35)(49,33)
          (49,35) -> (48,35)(50,35)(49,36)(49,34)
          (49,36) -> (48,36)(50,36)(49,37)(49,35)
          (49,37) -> (48,37)(50,37)(49,38)(49,36)
          (49,38) -> (48,38)(50,38)(49,39)(49,37)
          (49,39) -> (48,39)(50,39)(49,40)(49,38)
          (49,40) -> (48,40)(50,40)(49,41)(49,39)
          (49,41) -> (48,41)(50,41)(49,42)(49,40)
          (49,42) -> (48,42)(50,42)(49,43)(49,41)
          (49,43) -> (48,43)(50,43)(49,44)(49,42)
          (49,44) -> (48,44)(50,44)(49,45)(49,43)
          (49,45) -> (48,45)(50,45)(49,46)(49,44)
          (49,46) -> (48,46)(50,46)(49,47)(49,45)
          (49,47) -> (48,47)(50,47)(49,48)(49,46)
          (49,48) -> (48,48)(50,48)(49,49)(49,47)
          (49,49) -> (48,49)(50,49)(49,50)(49,48)
          (49,50) -> (48,50)(50,50)(49,51)(49,49)
          (49,51) -> (48,51)(50,51)(49,52)(49,50)
          (49,52) -> (48,52)(50,52)(49,53)(49,51)
          (49,53) -> (48,53)(50,53)(49,54)(49,52)
          (49,54) -> (48,54)(50,54)(49,55)(49,53)
          (49,55) -> (48,55)(50,55)(49,56)(49,54)
          (49,56) -> (48,56)(50,56)(49,57)(49,55)
          (49,57) -> (48,57)(50,57)(49,58)(49,56)
          (49,58) -> (48,58)(50,58)(49,59)(49,57)
          (49,59) -> (48,59)(50,59)(49,60)(49,58)
          (49,60) -> (48,60)(50,60)(49,61)(49,59)
          (49,61) -> (48,61)(50,61)(49,62)(49,60)
          (49,62) -> (48,62)(50,62)(49,63)(49,61)
          (49,63) -> (48,63)(50,63)(49,62)
          (50,0)  -> (49,0)(51,0)(50,1)
          (50,1)  -> (49,1)(51,1)(50,2)(50,0)
          (50,2)  -> (49,2)(51,2)(50,3)(50,1)
          (50,3)  -> (49,3)(51,3)(50,4)(50,2)
          (50,4)  -> (49,4)(51,4)(50,5)(50,3)
          (50,5)  -> (49,5)(51,5)(50,6)(50,4)
          (50,6)  -> (49,6)(51,6)(50,7)(50,5)
          (50,7)  -> (49,7)(51,7)(50,8)(50,6)
          (50,8)  -> (49,8)(51,8)(50,9)(50,7)
          (50,9)  -> (49,9)(51,9)(50,10)(50,8)
          (50,10) -> (49,10)(51,10)(50,11)(50,9)
          (50,11) -> (49,11)(51,11)(50,12)(50,10)
          (50,12) -> (49,12)(51,12)(50,13)(50,11)
          (50,13) -> (49,13)(51,13)(50,14)(50,12)
          (50,14) -> (49,14)(51,14)(50,15)(50,13)
          (50,15) -> (49,15)(51,15)(50,16)(50,14)
          (50,16) -> (49,16)(51,16)(50,17)(50,15)
          (50,17) -> (49,17)(51,17)(50,18)(50,16)
          (50,18) -> (49,18)(51,18)(50,19)(50,17)
          (50,19) -> (49,19)(51,19)(50,20)(50,18)
          (50,20) -> (49,20)(51,20)(50,21)(50,19)
          (50,21) -> (49,21)(51,21)(50,22)(50,20)
          (50,22) -> (49,22)(51,22)(50,23)(50,21)
          (50,23) -> (49,23)(51,23)(50,24)(50,22)
          (50,24) -> (49,24)(51,24)(50,25)(50,23)
          (50,25) -> (49,25)(51,25)(50,26)(50,24)
          (50,26) -> (49,26)(51,26)(50,27)(50,25)
          (50,27) -> (49,27)(51,27)(50,28)(50,26)
          (50,28) -> (49,28)(51,28)(50,29)(50,27)
          (50,29) -> (49,29)(51,29)(50,30)(50,28)
          (50,30) -> (49,30)(51,30)(50,31)(50,29)
          (50,31) -> (49,31)(51,31)(50,32)(50,30)
          (50,32) -> (49,32)(51,32)(50,33)(50,31)
          (50,33) -> (49,33)(51,33)(50,34)(50,32)
          (50,34) -> (49,34)(51,34)(50,35)(50,33)
          (50,35) -> (49,35)(51,35)(50,36)(50,34)
          (50,36) -> (49,36)(51,36)(50,37)(50,35)
          (50,37) -> (49,37)(51,37)(50,38)(50,36)
          (50,38) -> (49,38)(51,38)(50,39)(50,37)
          (50,39) -> (49,39)(51,39)(50,40)(50,38)
          (50,40) -> (49,40)(51,40)(50,41)(50,39)
          (50,41) -> (49,41)(51,41)(50,42)(50,40)
          (50,42) -> (49,42)(51,42)(50,43)(50,41)
          (50,43) -> (49,43)(51,43)(50,44)(50,42)
          (50,44) -> (49,44)(51,44)(50,45)(50,43)
          (50,45) -> (49,45)(51,45)(50,46)(50,44)
          (50,46) -> (49,46)(51,46)(50,47)(50,45)
          (50,47) -> (49,47)(51,47)(50,48)(50,46)
          (50,48) -> (49,48)(51,48)(50,49)(50,47)
          (50,49) -> (49,49)(51,49)(50,50)(50,48)
          (50,50) -> (49,50)(51,50)(50,51)(50,49)
          (50,51) -> (49,51)(51,51)(50,52)(50,50)
          (50,52) -> (49,52)(51,52)(50,53)(50,51)
          (50,53) -> (49,53)(51,53)(50,54)(50,52)
          (50,54) -> (49,54)(51,54)(50,55)(50,53)
          (50,55) -> (49,55)(51,55)(50,56)(50,54)
          (50,56) -> (49,56)(51,56)(50,57)(50,55)
          (50,57) -> (49,57)(51,57)(50,58)(50,56)
          (50,58) -> (49,58)(51,58)(50,59)(50,57)
          (50,59) -> (49,59)(51,59)(50,60)(50,58)
          (50,60) -> (49,60)(51,60)(50,61)(50,59)
          (50,61) -> (49,61)(51,61)(50,62)(50,60)
          (50,62) -> (49,62)(51,62)(50,63)(50,61)
          (50,63) -> (49,63)(51,63)(50,62)
          (51,0)  -> (50,0)(52,0)(51,1)
          (51,1)  -> (50,1)(52,1)(51,2)(51,0)
          (51,2)  -> (50,2)(52,2)(51,3)(51,1)
          (51,3)  -> (50,3)(52,3)(51,4)(51,2)
          (51,4)  -> (50,4)(52,4)(51,5)(51,3)
          (51,5)  -> (50,5)(52,5)(51,6)(51,4)
          (51,6)  -> (50,6)(52,6)(51,7)(51,5)
          (51,7)  -> (50,7)(52,7)(51,8)(51,6)
          (51,8)  -> (50,8)(52,8)(51,9)(51,7)
          (51,9)  -> (50,9)(52,9)(51,10)(51,8)
          (51,10) -> (50,10)(52,10)(51,11)(51,9)
          (51,11) -> (50,11)(52,11)(51,12)(51,10)
          (51,12) -> (50,12)(52,12)(51,13)(51,11)
          (51,13) -> (50,13)(52,13)(51,14)(51,12)
          (51,14) -> (50,14)(52,14)(51,15)(51,13)
          (51,15) -> (50,15)(52,15)(51,16)(51,14)
          (51,16) -> (50,16)(52,16)(51,17)(51,15)
          (51,17) -> (50,17)(52,17)(51,18)(51,16)
          (51,18) -> (50,18)(52,18)(51,19)(51,17)
          (51,19) -> (50,19)(52,19)(51,20)(51,18)
          (51,20) -> (50,20)(52,20)(51,21)(51,19)
          (51,21) -> (50,21)(52,21)(51,22)(51,20)
          (51,22) -> (50,22)(52,22)(51,23)(51,21)
          (51,23) -> (50,23)(52,23)(51,24)(51,22)
          (51,24) -> (50,24)(52,24)(51,25)(51,23)
          (51,25) -> (50,25)(52,25)(51,26)(51,24)
          (51,26) -> (50,26)(52,26)(51,27)(51,25)
          (51,27) -> (50,27)(52,27)(51,28)(51,26)
          (51,28) -> (50,28)(52,28)(51,29)(51,27)
          (51,29) -> (50,29)(52,29)(51,30)(51,28)
          (51,30) -> (50,30)(52,30)(51,31)(51,29)
          (51,31) -> (50,31)(52,31)(51,32)(51,30)
          (51,32) -> (50,32)(52,32)(51,33)(51,31)
          (51,33) -> (50,33)(52,33)(51,34)(51,32)
          (51,34) -> (50,34)(52,34)(51,35)(51,33)
          (51,35) -> (50,35)(52,35)(51,36)(51,34)
          (51,36) -> (50,36)(52,36)(51,37)(51,35)
          (51,37) -> (50,37)(52,37)(51,38)(51,36)
          (51,38) -> (50,38)(52,38)(51,39)(51,37)
          (51,39) -> (50,39)(52,39)(51,40)(51,38)
          (51,40) -> (50,40)(52,40)(51,41)(51,39)
          (51,41) -> (50,41)(52,41)(51,42)(51,40)
          (51,42) -> (50,42)(52,42)(51,43)(51,41)
          (51,43) -> (50,43)(52,43)(51,44)(51,42)
          (51,44) -> (50,44)(52,44)(51,45)(51,43)
          (51,45) -> (50,45)(52,45)(51,46)(51,44)
          (51,46) -> (50,46)(52,46)(51,47)(51,45)
          (51,47) -> (50,47)(52,47)(51,48)(51,46)
          (51,48) -> (50,48)(52,48)(51,49)(51,47)
          (51,49) -> (50,49)(52,49)(51,50)(51,48)
          (51,50) -> (50,50)(52,50)(51,51)(51,49)
          (51,51) -> (50,51)(52,51)(51,52)(51,50)
          (51,52) -> (50,52)(52,52)(51,53)(51,51)
          (51,53) -> (50,53)(52,53)(51,54)(51,52)
          (51,54) -> (50,54)(52,54)(51,55)(51,53)
          (51,55) -> (50,55)(52,55)(51,56)(51,54)
          (51,56) -> (50,56)(52,56)(51,57)(51,55)
          (51,57) -> (50,57)(52,57)(51,58)(51,56)
          (51,58) -> (50,58)(52,58)(51,59)(51,57)
          (51,59) -> (50,59)(52,59)(51,60)(51,58)
          (51,60) -> (50,60)(52,60)(51,61)(51,59)
          (51,61) -> (50,61)(52,61)(51,62)(51,60)
          (51,62) -> (50,62)(52,62)(51,63)(51,61)
          (51,63) -> (50,63)(52,63)(51,62)
          (52,0)  -> (51,0)(53,0)(52,1)
          (52,1)  -> (51,1)(53,1)(52,2)(52,0)
          (52,2)  -> (51,2)(53,2)(52,3)(52,1)
          (52,3)  -> (51,3)(53,3)(52,4)(52,2)
          (52,4)  -> (51,4)(53,4)(52,5)(52,3)
          (52,5)  -> (51,5)(53,5)(52,6)(52,4)
          (52,6)  -> (51,6)(53,6)(52,7)(52,5)
          (52,7)  -> (51,7)(53,7)(52,8)(52,6)
          (52,8)  -> (51,8)(53,8)(52,9)(52,7)
          (52,9)  -> (51,9)(53,9)(52,10)(52,8)
          (52,10) -> (51,10)(53,10)(52,11)(52,9)
          (52,11) -> (51,11)(53,11)(52,12)(52,10)
          (52,12) -> (51,12)(53,12)(52,13)(52,11)
          (52,13) -> (51,13)(53,13)(52,14)(52,12)
          (52,14) -> (51,14)(53,14)(52,15)(52,13)
          (52,15) -> (51,15)(53,15)(52,16)(52,14)
          (52,16) -> (51,16)(53,16)(52,17)(52,15)
          (52,17) -> (51,17)(53,17)(52,18)(52,16)
          (52,18) -> (51,18)(53,18)(52,19)(52,17)
          (52,19) -> (51,19)(53,19)(52,20)(52,18)
          (52,20) -> (51,20)(53,20)(52,21)(52,19)
          (52,21) -> (51,21)(53,21)(52,22)(52,20)
          (52,22) -> (51,22)(53,22)(52,23)(52,21)
          (52,23) -> (51,23)(53,23)(52,24)(52,22)
          (52,24) -> (51,24)(53,24)(52,25)(52,23)
          (52,25) -> (51,25)(53,25)(52,26)(52,24)
          (52,26) -> (51,26)(53,26)(52,27)(52,25)
          (52,27) -> (51,27)(53,27)(52,28)(52,26)
          (52,28) -> (51,28)(53,28)(52,29)(52,27)
          (52,29) -> (51,29)(53,29)(52,30)(52,28)
          (52,30) -> (51,30)(53,30)(52,31)(52,29)
          (52,31) -> (51,31)(53,31)(52,32)(52,30)
          (52,32) -> (51,32)(53,32)(52,33)(52,31)
          (52,33) -> (51,33)(53,33)(52,34)(52,32)
          (52,34) -> (51,34)(53,34)(52,35)(52,33)
          (52,35) -> (51,35)(53,35)(52,36)(52,34)
          (52,36) -> (51,36)(53,36)(52,37)(52,35)
          (52,37) -> (51,37)(53,37)(52,38)(52,36)
          (52,38) -> (51,38)(53,38)(52,39)(52,37)
          (52,39) -> (51,39)(53,39)(52,40)(52,38)
          (52,40) -> (51,40)(53,40)(52,41)(52,39)
          (52,41) -> (51,41)(53,41)(52,42)(52,40)
          (52,42) -> (51,42)(53,42)(52,43)(52,41)
          (52,43) -> (51,43)(53,43)(52,44)(52,42)
          (52,44) -> (51,44)(53,44)(52,45)(52,43)
          (52,45) -> (51,45)(53,45)(52,46)(52,44)
          (52,46) -> (51,46)(53,46)(52,47)(52,45)
          (52,47) -> (51,47)(53,47)(52,48)(52,46)
          (52,48) -> (51,48)(53,48)(52,49)(52,47)
          (52,49) -> (51,49)(53,49)(52,50)(52,48)
          (52,50) -> (51,50)(53,50)(52,51)(52,49)
          (52,51) -> (51,51)(53,51)(52,52)(52,50)
          (52,52) -> (51,52)(53,52)(52,53)(52,51)
          (52,53) -> (51,53)(53,53)(52,54)(52,52)
          (52,54) -> (51,54)(53,54)(52,55)(52,53)
          (52,55) -> (51,55)(53,55)(52,56)(52,54)
          (52,56) -> (51,56)(53,56)(52,57)(52,55)
          (52,57) -> (51,57)(53,57)(52,58)(52,56)
          (52,58) -> (51,58)(53,58)(52,59)(52,57)
          (52,59) -> (51,59)(53,59)(52,60)(52,58)
          (52,60) -> (51,60)(53,60)(52,61)(52,59)
          (52,61) -> (51,61)(53,61)(52,62)(52,60)
          (52,62) -> (51,62)(53,62)(52,63)(52,61)
          (52,63) -> (51,63)(53,63)(52,62)
          (53,0)  -> (52,0)(54,0)(53,1)
          (53,1)  -> (52,1)(54,1)(53,2)(53,0)
          (53,2)  -> (52,2)(54,2)(53,3)(53,1)
          (53,3)  -> (52,3)(54,3)(53,4)(53,2)
          (53,4)  -> (52,4)(54,4)(53,5)(53,3)
          (53,5)  -> (52,5)(54,5)(53,6)(53,4)
          (53,6)  -> (52,6)(54,6)(53,7)(53,5)
          (53,7)  -> (52,7)(54,7)(53,8)(53,6)
          (53,8)  -> (52,8)(54,8)(53,9)(53,7)
          (53,9)  -> (52,9)(54,9)(53,10)(53,8)
          (53,10) -> (52,10)(54,10)(53,11)(53,9)
          (53,11) -> (52,11)(54,11)(53,12)(53,10)
          (53,12) -> (52,12)(54,12)(53,13)(53,11)
          (53,13) -> (52,13)(54,13)(53,14)(53,12)
          (53,14) -> (52,14)(54,14)(53,15)(53,13)
          (53,15) -> (52,15)(54,15)(53,16)(53,14)
          (53,16) -> (52,16)(54,16)(53,17)(53,15)
          (53,17) -> (52,17)(54,17)(53,18)(53,16)
          (53,18) -> (52,18)(54,18)(53,19)(53,17)
          (53,19) -> (52,19)(54,19)(53,20)(53,18)
          (53,20) -> (52,20)(54,20)(53,21)(53,19)
          (53,21) -> (52,21)(54,21)(53,22)(53,20)
          (53,22) -> (52,22)(54,22)(53,23)(53,21)
          (53,23) -> (52,23)(54,23)(53,24)(53,22)
          (53,24) -> (52,24)(54,24)(53,25)(53,23)
          (53,25) -> (52,25)(54,25)(53,26)(53,24)
          (53,26) -> (52,26)(54,26)(53,27)(53,25)
          (53,27) -> (52,27)(54,27)(53,28)(53,26)
          (53,28) -> (52,28)(54,28)(53,29)(53,27)
          (53,29) -> (52,29)(54,29)(53,30)(53,28)
          (53,30) -> (52,30)(54,30)(53,31)(53,29)
          (53,31) -> (52,31)(54,31)(53,32)(53,30)
          (53,32) -> (52,32)(54,32)(53,33)(53,31)
          (53,33) -> (52,33)(54,33)(53,34)(53,32)
          (53,34) -> (52,34)(54,34)(53,35)(53,33)
          (53,35) -> (52,35)(54,35)(53,36)(53,34)
          (53,36) -> (52,36)(54,36)(53,37)(53,35)
          (53,37) -> (52,37)(54,37)(53,38)(53,36)
          (53,38) -> (52,38)(54,38)(53,39)(53,37)
          (53,39) -> (52,39)(54,39)(53,40)(53,38)
          (53,40) -> (52,40)(54,40)(53,41)(53,39)
          (53,41) -> (52,41)(54,41)(53,42)(53,40)
          (53,42) -> (52,42)(54,42)(53,43)(53,41)
          (53,43) -> (52,43)(54,43)(53,44)(53,42)
          (53,44) -> (52,44)(54,44)(53,45)(53,43)
          (53,45) -> (52,45)(54,45)(53,46)(53,44)
          (53,46) -> (52,46)(54,46)(53,47)(53,45)
          (53,47) -> (52,47)(54,47)(53,48)(53,46)
          (53,48) -> (52,48)(54,48)(53,49)(53,47)
          (53,49) -> (52,49)(54,49)(53,50)(53,48)
          (53,50) -> (52,50)(54,50)(53,51)(53,49)
          (53,51) -> (52,51)(54,51)(53,52)(53,50)
          (53,52) -> (52,52)(54,52)(53,53)(53,51)
          (53,53) -> (52,53)(54,53)(53,54)(53,52)
          (53,54) -> (52,54)(54,54)(53,55)(53,53)
          (53,55) -> (52,55)(54,55)(53,56)(53,54)
          (53,56) -> (52,56)(54,56)(53,57)(53,55)
          (53,57) -> (52,57)(54,57)(53,58)(53,56)
          (53,58) -> (52,58)(54,58)(53,59)(53,57)
          (53,59) -> (52,59)(54,59)(53,60)(53,58)
          (53,60) -> (52,60)(54,60)(53,61)(53,59)
          (53,61) -> (52,61)(54,61)(53,62)(53,60)
          (53,62) -> (52,62)(54,62)(53,63)(53,61)
          (53,63) -> (52,63)(54,63)(53,62)
          (54,0)  -> (53,0)(55,0)(54,1)
          (54,1)  -> (53,1)(55,1)(54,2)(54,0)
          (54,2)  -> (53,2)(55,2)(54,3)(54,1)
          (54,3)  -> (53,3)(55,3)(54,4)(54,2)
          (54,4)  -> (53,4)(55,4)(54,5)(54,3)
          (54,5)  -> (53,5)(55,5)(54,6)(54,4)
          (54,6)  -> (53,6)(55,6)(54,7)(54,5)
          (54,7)  -> (53,7)(55,7)(54,8)(54,6)
          (54,8)  -> (53,8)(55,8)(54,9)(54,7)
          (54,9)  -> (53,9)(55,9)(54,10)(54,8)
          (54,10) -> (53,10)(55,10)(54,11)(54,9)
          (54,11) -> (53,11)(55,11)(54,12)(54,10)
          (54,12) -> (53,12)(55,12)(54,13)(54,11)
          (54,13) -> (53,13)(55,13)(54,14)(54,12)
          (54,14) -> (53,14)(55,14)(54,15)(54,13)
          (54,15) -> (53,15)(55,15)(54,16)(54,14)
          (54,16) -> (53,16)(55,16)(54,17)(54,15)
          (54,17) -> (53,17)(55,17)(54,18)(54,16)
          (54,18) -> (53,18)(55,18)(54,19)(54,17)
          (54,19) -> (53,19)(55,19)(54,20)(54,18)
          (54,20) -> (53,20)(55,20)(54,21)(54,19)
          (54,21) -> (53,21)(55,21)(54,22)(54,20)
          (54,22) -> (53,22)(55,22)(54,23)(54,21)
          (54,23) -> (53,23)(55,23)(54,24)(54,22)
          (54,24) -> (53,24)(55,24)(54,25)(54,23)
          (54,25) -> (53,25)(55,25)(54,26)(54,24)
          (54,26) -> (53,26)(55,26)(54,27)(54,25)
          (54,27) -> (53,27)(55,27)(54,28)(54,26)
          (54,28) -> (53,28)(55,28)(54,29)(54,27)
          (54,29) -> (53,29)(55,29)(54,30)(54,28)
          (54,30) -> (53,30)(55,30)(54,31)(54,29)
          (54,31) -> (53,31)(55,31)(54,32)(54,30)
          (54,32) -> (53,32)(55,32)(54,33)(54,31)
          (54,33) -> (53,33)(55,33)(54,34)(54,32)
          (54,34) -> (53,34)(55,34)(54,35)(54,33)
          (54,35) -> (53,35)(55,35)(54,36)(54,34)
          (54,36) -> (53,36)(55,36)(54,37)(54,35)
          (54,37) -> (53,37)(55,37)(54,38)(54,36)
          (54,38) -> (53,38)(55,38)(54,39)(54,37)
          (54,39) -> (53,39)(55,39)(54,40)(54,38)
          (54,40) -> (53,40)(55,40)(54,41)(54,39)
          (54,41) -> (53,41)(55,41)(54,42)(54,40)
          (54,42) -> (53,42)(55,42)(54,43)(54,41)
          (54,43) -> (53,43)(55,43)(54,44)(54,42)
          (54,44) -> (53,44)(55,44)(54,45)(54,43)
          (54,45) -> (53,45)(55,45)(54,46)(54,44)
          (54,46) -> (53,46)(55,46)(54,47)(54,45)
          (54,47) -> (53,47)(55,47)(54,48)(54,46)
          (54,48) -> (53,48)(55,48)(54,49)(54,47)
          (54,49) -> (53,49)(55,49)(54,50)(54,48)
          (54,50) -> (53,50)(55,50)(54,51)(54,49)
          (54,51) -> (53,51)(55,51)(54,52)(54,50)
          (54,52) -> (53,52)(55,52)(54,53)(54,51)
          (54,53) -> (53,53)(55,53)(54,54)(54,52)
          (54,54) -> (53,54)(55,54)(54,55)(54,53)
          (54,55) -> (53,55)(55,55)(54,56)(54,54)
          (54,56) -> (53,56)(55,56)(54,57)(54,55)
          (54,57) -> (53,57)(55,57)(54,58)(54,56)
          (54,58) -> (53,58)(55,58)(54,59)(54,57)
          (54,59) -> (53,59)(55,59)(54,60)(54,58)
          (54,60) -> (53,60)(55,60)(54,61)(54,59)
          (54,61) -> (53,61)(55,61)(54,62)(54,60)
          (54,62) -> (53,62)(55,62)(54,63)(54,61)
          (54,63) -> (53,63)(55,63)(54,62)
          (55,0)  -> (54,0)(56,0)(55,1)
          (55,1)  -> (54,1)(56,1)(55,2)(55,0)
          (55,2)  -> (54,2)(56,2)(55,3)(55,1)
          (55,3)  -> (54,3)(56,3)(55,4)(55,2)
          (55,4)  -> (54,4)(56,4)(55,5)(55,3)
          (55,5)  -> (54,5)(56,5)(55,6)(55,4)
          (55,6)  -> (54,6)(56,6)(55,7)(55,5)
          (55,7)  -> (54,7)(56,7)(55,8)(55,6)
          (55,8)  -> (54,8)(56,8)(55,9)(55,7)
          (55,9)  -> (54,9)(56,9)(55,10)(55,8)
          (55,10) -> (54,10)(56,10)(55,11)(55,9)
          (55,11) -> (54,11)(56,11)(55,12)(55,10)
          (55,12) -> (54,12)(56,12)(55,13)(55,11)
          (55,13) -> (54,13)(56,13)(55,14)(55,12)
          (55,14) -> (54,14)(56,14)(55,15)(55,13)
          (55,15) -> (54,15)(56,15)(55,16)(55,14)
          (55,16) -> (54,16)(56,16)(55,17)(55,15)
          (55,17) -> (54,17)(56,17)(55,18)(55,16)
          (55,18) -> (54,18)(56,18)(55,19)(55,17)
          (55,19) -> (54,19)(56,19)(55,20)(55,18)
          (55,20) -> (54,20)(56,20)(55,21)(55,19)
          (55,21) -> (54,21)(56,21)(55,22)(55,20)
          (55,22) -> (54,22)(56,22)(55,23)(55,21)
          (55,23) -> (54,23)(56,23)(55,24)(55,22)
          (55,24) -> (54,24)(56,24)(55,25)(55,23)
          (55,25) -> (54,25)(56,25)(55,26)(55,24)
          (55,26) -> (54,26)(56,26)(55,27)(55,25)
          (55,27) -> (54,27)(56,27)(55,28)(55,26)
          (55,28) -> (54,28)(56,28)(55,29)(55,27)
          (55,29) -> (54,29)(56,29)(55,30)(55,28)
          (55,30) -> (54,30)(56,30)(55,31)(55,29)
          (55,31) -> (54,31)(56,31)(55,32)(55,30)
          (55,32) -> (54,32)(56,32)(55,33)(55,31)
          (55,33) -> (54,33)(56,33)(55,34)(55,32)
          (55,34) -> (54,34)(56,34)(55,35)(55,33)
          (55,35) -> (54,35)(56,35)(55,36)(55,34)
          (55,36) -> (54,36)(56,36)(55,37)(55,35)
          (55,37) -> (54,37)(56,37)(55,38)(55,36)
          (55,38) -> (54,38)(56,38)(55,39)(55,37)
          (55,39) -> (54,39)(56,39)(55,40)(55,38)
          (55,40) -> (54,40)(56,40)(55,41)(55,39)
          (55,41) -> (54,41)(56,41)(55,42)(55,40)
          (55,42) -> (54,42)(56,42)(55,43)(55,41)
          (55,43) -> (54,43)(56,43)(55,44)(55,42)
          (55,44) -> (54,44)(56,44)(55,45)(55,43)
          (55,45) -> (54,45)(56,45)(55,46)(55,44)
          (55,46) -> (54,46)(56,46)(55,47)(55,45)
          (55,47) -> (54,47)(56,47)(55,48)(55,46)
          (55,48) -> (54,48)(56,48)(55,49)(55,47)
          (55,49) -> (54,49)(56,49)(55,50)(55,48)
          (55,50) -> (54,50)(56,50)(55,51)(55,49)
          (55,51) -> (54,51)(56,51)(55,52)(55,50)
          (55,52) -> (54,52)(56,52)(55,53)(55,51)
          (55,53) -> (54,53)(56,53)(55,54)(55,52)
          (55,54) -> (54,54)(56,54)(55,55)(55,53)
          (55,55) -> (54,55)(56,55)(55,56)(55,54)
          (55,56) -> (54,56)(56,56)(55,57)(55,55)
          (55,57) -> (54,57)(56,57)(55,58)(55,56)
          (55,58) -> (54,58)(56,58)(55,59)(55,57)
          (55,59) -> (54,59)(56,59)(55,60)(55,58)
          (55,60) -> (54,60)(56,60)(55,61)(55,59)
          (55,61) -> (54,61)(56,61)(55,62)(55,60)
          (55,62) -> (54,62)(56,62)(55,63)(55,61)
          (55,63) -> (54,63)(56,63)(55,62)
          (56,0)  -> (55,0)(57,0)(56,1)
          (56,1)  -> (55,1)(57,1)(56,2)(56,0)
          (56,2)  -> (55,2)(57,2)(56,3)(56,1)
          (56,3)  -> (55,3)(57,3)(56,4)(56,2)
          (56,4)  -> (55,4)(57,4)(56,5)(56,3)
          (56,5)  -> (55,5)(57,5)(56,6)(56,4)
          (56,6)  -> (55,6)(57,6)(56,7)(56,5)
          (56,7)  -> (55,7)(57,7)(56,8)(56,6)
          (56,8)  -> (55,8)(57,8)(56,9)(56,7)
          (56,9)  -> (55,9)(57,9)(56,10)(56,8)
          (56,10) -> (55,10)(57,10)(56,11)(56,9)
          (56,11) -> (55,11)(57,11)(56,12)(56,10)
          (56,12) -> (55,12)(57,12)(56,13)(56,11)
          (56,13) -> (55,13)(57,13)(56,14)(56,12)
          (56,14) -> (55,14)(57,14)(56,15)(56,13)
          (56,15) -> (55,15)(57,15)(56,16)(56,14)
          (56,16) -> (55,16)(57,16)(56,17)(56,15)
          (56,17) -> (55,17)(57,17)(56,18)(56,16)
          (56,18) -> (55,18)(57,18)(56,19)(56,17)
          (56,19) -> (55,19)(57,19)(56,20)(56,18)
          (56,20) -> (55,20)(57,20)(56,21)(56,19)
          (56,21) -> (55,21)(57,21)(56,22)(56,20)
          (56,22) -> (55,22)(57,22)(56,23)(56,21)
          (56,23) -> (55,23)(57,23)(56,24)(56,22)
          (56,24) -> (55,24)(57,24)(56,25)(56,23)
          (56,25) -> (55,25)(57,25)(56,26)(56,24)
          (56,26) -> (55,26)(57,26)(56,27)(56,25)
          (56,27) -> (55,27)(57,27)(56,28)(56,26)
          (56,28) -> (55,28)(57,28)(56,29)(56,27)
          (56,29) -> (55,29)(57,29)(56,30)(56,28)
          (56,30) -> (55,30)(57,30)(56,31)(56,29)
          (56,31) -> (55,31)(57,31)(56,32)(56,30)
          (56,32) -> (55,32)(57,32)(56,33)(56,31)
          (56,33) -> (55,33)(57,33)(56,34)(56,32)
          (56,34) -> (55,34)(57,34)(56,35)(56,33)
          (56,35) -> (55,35)(57,35)(56,36)(56,34)
          (56,36) -> (55,36)(57,36)(56,37)(56,35)
          (56,37) -> (55,37)(57,37)(56,38)(56,36)
          (56,38) -> (55,38)(57,38)(56,39)(56,37)
          (56,39) -> (55,39)(57,39)(56,40)(56,38)
          (56,40) -> (55,40)(57,40)(56,41)(56,39)
          (56,41) -> (55,41)(57,41)(56,42)(56,40)
          (56,42) -> (55,42)(57,42)(56,43)(56,41)
          (56,43) -> (55,43)(57,43)(56,44)(56,42)
          (56,44) -> (55,44)(57,44)(56,45)(56,43)
          (56,45) -> (55,45)(57,45)(56,46)(56,44)
          (56,46) -> (55,46)(57,46)(56,47)(56,45)
          (56,47) -> (55,47)(57,47)(56,48)(56,46)
          (56,48) -> (55,48)(57,48)(56,49)(56,47)
          (56,49) -> (55,49)(57,49)(56,50)(56,48)
          (56,50) -> (55,50)(57,50)(56,51)(56,49)
          (56,51) -> (55,51)(57,51)(56,52)(56,50)
          (56,52) -> (55,52)(57,52)(56,53)(56,51)
          (56,53) -> (55,53)(57,53)(56,54)(56,52)
          (56,54) -> (55,54)(57,54)(56,55)(56,53)
          (56,55) -> (55,55)(57,55)(56,56)(56,54)
          (56,56) -> (55,56)(57,56)(56,57)(56,55)
          (56,57) -> (55,57)(57,57)(56,58)(56,56)
          (56,58) -> (55,58)(57,58)(56,59)(56,57)
          (56,59) -> (55,59)(57,59)(56,60)(56,58)
          (56,60) -> (55,60)(57,60)(56,61)(56,59)
          (56,61) -> (55,61)(57,61)(56,62)(56,60)
          (56,62) -> (55,62)(57,62)(56,63)(56,61)
          (56,63) -> (55,63)(57,63)(56,62)
          (57,0)  -> (56,0)(58,0)(57,1)
          (57,1)  -> (56,1)(58,1)(57,2)(57,0)
          (57,2)  -> (56,2)(58,2)(57,3)(57,1)
          (57,3)  -> (56,3)(58,3)(57,4)(57,2)
          (57,4)  -> (56,4)(58,4)(57,5)(57,3)
          (57,5)  -> (56,5)(58,5)(57,6)(57,4)
          (57,6)  -> (56,6)(58,6)(57,7)(57,5)
          (57,7)  -> (56,7)(58,7)(57,8)(57,6)
          (57,8)  -> (56,8)(58,8)(57,9)(57,7)
          (57,9)  -> (56,9)(58,9)(57,10)(57,8)
          (57,10) -> (56,10)(58,10)(57,11)(57,9)
          (57,11) -> (56,11)(58,11)(57,12)(57,10)
          (57,12) -> (56,12)(58,12)(57,13)(57,11)
          (57,13) -> (56,13)(58,13)(57,14)(57,12)
          (57,14) -> (56,14)(58,14)(57,15)(57,13)
          (57,15) -> (56,15)(58,15)(57,16)(57,14)
          (57,16) -> (56,16)(58,16)(57,17)(57,15)
          (57,17) -> (56,17)(58,17)(57,18)(57,16)
          (57,18) -> (56,18)(58,18)(57,19)(57,17)
          (57,19) -> (56,19)(58,19)(57,20)(57,18)
          (57,20) -> (56,20)(58,20)(57,21)(57,19)
          (57,21) -> (56,21)(58,21)(57,22)(57,20)
          (57,22) -> (56,22)(58,22)(57,23)(57,21)
          (57,23) -> (56,23)(58,23)(57,24)(57,22)
          (57,24) -> (56,24)(58,24)(57,25)(57,23)
          (57,25) -> (56,25)(58,25)(57,26)(57,24)
          (57,26) -> (56,26)(58,26)(57,27)(57,25)
          (57,27) -> (56,27)(58,27)(57,28)(57,26)
          (57,28) -> (56,28)(58,28)(57,29)(57,27)
          (57,29) -> (56,29)(58,29)(57,30)(57,28)
          (57,30) -> (56,30)(58,30)(57,31)(57,29)
          (57,31) -> (56,31)(58,31)(57,32)(57,30)
          (57,32) -> (56,32)(58,32)(57,33)(57,31)
          (57,33) -> (56,33)(58,33)(57,34)(57,32)
          (57,34) -> (56,34)(58,34)(57,35)(57,33)
          (57,35) -> (56,35)(58,35)(57,36)(57,34)
          (57,36) -> (56,36)(58,36)(57,37)(57,35)
          (57,37) -> (56,37)(58,37)(57,38)(57,36)
          (57,38) -> (56,38)(58,38)(57,39)(57,37)
          (57,39) -> (56,39)(58,39)(57,40)(57,38)
          (57,40) -> (56,40)(58,40)(57,41)(57,39)
          (57,41) -> (56,41)(58,41)(57,42)(57,40)
          (57,42) -> (56,42)(58,42)(57,43)(57,41)
          (57,43) -> (56,43)(58,43)(57,44)(57,42)
          (57,44) -> (56,44)(58,44)(57,45)(57,43)
          (57,45) -> (56,45)(58,45)(57,46)(57,44)
          (57,46) -> (56,46)(58,46)(57,47)(57,45)
          (57,47) -> (56,47)(58,47)(57,48)(57,46)
          (57,48) -> (56,48)(58,48)(57,49)(57,47)
          (57,49) -> (56,49)(58,49)(57,50)(57,48)
          (57,50) -> (56,50)(58,50)(57,51)(57,49)
          (57,51) -> (56,51)(58,51)(57,52)(57,50)
          (57,52) -> (56,52)(58,52)(57,53)(57,51)
          (57,53) -> (56,53)(58,53)(57,54)(57,52)
          (57,54) -> (56,54)(58,54)(57,55)(57,53)
          (57,55) -> (56,55)(58,55)(57,56)(57,54)
          (57,56) -> (56,56)(58,56)(57,57)(57,55)
          (57,57) -> (56,57)(58,57)(57,58)(57,56)
          (57,58) -> (56,58)(58,58)(57,59)(57,57)
          (57,59) -> (56,59)(58,59)(57,60)(57,58)
          (57,60) -> (56,60)(58,60)(57,61)(57,59)
          (57,61) -> (56,61)(58,61)(57,62)(57,60)
          (57,62) -> (56,62)(58,62)(57,63)(57,61)
          (57,63) -> (56,63)(58,63)(57,62)
          (58,0)  -> (57,0)(59,0)(58,1)
          (58,1)  -> (57,1)(59,1)(58,2)(58,0)
          (58,2)  -> (57,2)(59,2)(58,3)(58,1)
          (58,3)  -> (57,3)(59,3)(58,4)(58,2)
          (58,4)  -> (57,4)(59,4)(58,5)(58,3)
          (58,5)  -> (57,5)(59,5)(58,6)(58,4)
          (58,6)  -> (57,6)(59,6)(58,7)(58,5)
          (58,7)  -> (57,7)(59,7)(58,8)(58,6)
          (58,8)  -> (57,8)(59,8)(58,9)(58,7)
          (58,9)  -> (57,9)(59,9)(58,10)(58,8)
          (58,10) -> (57,10)(59,10)(58,11)(58,9)
          (58,11) -> (57,11)(59,11)(58,12)(58,10)
          (58,12) -> (57,12)(59,12)(58,13)(58,11)
          (58,13) -> (57,13)(59,13)(58,14)(58,12)
          (58,14) -> (57,14)(59,14)(58,15)(58,13)
          (58,15) -> (57,15)(59,15)(58,16)(58,14)
          (58,16) -> (57,16)(59,16)(58,17)(58,15)
          (58,17) -> (57,17)(59,17)(58,18)(58,16)
          (58,18) -> (57,18)(59,18)(58,19)(58,17)
          (58,19) -> (57,19)(59,19)(58,20)(58,18)
          (58,20) -> (57,20)(59,20)(58,21)(58,19)
          (58,21) -> (57,21)(59,21)(58,22)(58,20)
          (58,22) -> (57,22)(59,22)(58,23)(58,21)
          (58,23) -> (57,23)(59,23)(58,24)(58,22)
          (58,24) -> (57,24)(59,24)(58,25)(58,23)
          (58,25) -> (57,25)(59,25)(58,26)(58,24)
          (58,26) -> (57,26)(59,26)(58,27)(58,25)
          (58,27) -> (57,27)(59,27)(58,28)(58,26)
          (58,28) -> (57,28)(59,28)(58,29)(58,27)
          (58,29) -> (57,29)(59,29)(58,30)(58,28)
          (58,30) -> (57,30)(59,30)(58,31)(58,29)
          (58,31) -> (57,31)(59,31)(58,32)(58,30)
          (58,32) -> (57,32)(59,32)(58,33)(58,31)
          (58,33) -> (57,33)(59,33)(58,34)(58,32)
          (58,34) -> (57,34)(59,34)(58,35)(58,33)
          (58,35) -> (57,35)(59,35)(58,36)(58,34)
          (58,36) -> (57,36)(59,36)(58,37)(58,35)
          (58,37) -> (57,37)(59,37)(58,38)(58,36)
          (58,38) -> (57,38)(59,38)(58,39)(58,37)
          (58,39) -> (57,39)(59,39)(58,40)(58,38)
          (58,40) -> (57,40)(59,40)(58,41)(58,39)
          (58,41) -> (57,41)(59,41)(58,42)(58,40)
          (58,42) -> (57,42)(59,42)(58,43)(58,41)
          (58,43) -> (57,43)(59,43)(58,44)(58,42)
          (58,44) -> (57,44)(59,44)(58,45)(58,43)
          (58,45) -> (57,45)(59,45)(58,46)(58,44)
          (58,46) -> (57,46)(59,46)(58,47)(58,45)
          (58,47) -> (57,47)(59,47)(58,48)(58,46)
          (58,48) -> (57,48)(59,48)(58,49)(58,47)
          (58,49) -> (57,49)(59,49)(58,50)(58,48)
          (58,50) -> (57,50)(59,50)(58,51)(58,49)
          (58,51) -> (57,51)(59,51)(58,52)(58,50)
          (58,52) -> (57,52)(59,52)(58,53)(58,51)
          (58,53) -> (57,53)(59,53)(58,54)(58,52)
          (58,54) -> (57,54)(59,54)(58,55)(58,53)
          (58,55) -> (57,55)(59,55)(58,56)(58,54)
          (58,56) -> (57,56)(59,56)(58,57)(58,55)
          (58,57) -> (57,57)(59,57)(58,58)(58,56)
          (58,58) -> (57,58)(59,58)(58,59)(58,57)
          (58,59) -> (57,59)(59,59)(58,60)(58,58)
          (58,60) -> (57,60)(59,60)(58,61)(58,59)
          (58,61) -> (57,61)(59,61)(58,62)(58,60)
          (58,62) -> (57,62)(59,62)(58,63)(58,61)
          (58,63) -> (57,63)(59,63)(58,62)
          (59,0)  -> (58,0)(60,0)(59,1)
          (59,1)  -> (58,1)(60,1)(59,2)(59,0)
          (59,2)  -> (58,2)(60,2)(59,3)(59,1)
          (59,3)  -> (58,3)(60,3)(59,4)(59,2)
          (59,4)  -> (58,4)(60,4)(59,5)(59,3)
          (59,5)  -> (58,5)(60,5)(59,6)(59,4)
          (59,6)  -> (58,6)(60,6)(59,7)(59,5)
          (59,7)  -> (58,7)(60,7)(59,8)(59,6)
          (59,8)  -> (58,8)(60,8)(59,9)(59,7)
          (59,9)  -> (58,9)(60,9)(59,10)(59,8)
          (59,10) -> (58,10)(60,10)(59,11)(59,9)
          (59,11) -> (58,11)(60,11)(59,12)(59,10)
          (59,12) -> (58,12)(60,12)(59,13)(59,11)
          (59,13) -> (58,13)(60,13)(59,14)(59,12)
          (59,14) -> (58,14)(60,14)(59,15)(59,13)
          (59,15) -> (58,15)(60,15)(59,16)(59,14)
          (59,16) -> (58,16)(60,16)(59,17)(59,15)
          (59,17) -> (58,17)(60,17)(59,18)(59,16)
          (59,18) -> (58,18)(60,18)(59,19)(59,17)
          (59,19) -> (58,19)(60,19)(59,20)(59,18)
          (59,20) -> (58,20)(60,20)(59,21)(59,19)
          (59,21) -> (58,21)(60,21)(59,22)(59,20)
          (59,22) -> (58,22)(60,22)(59,23)(59,21)
          (59,23) -> (58,23)(60,23)(59,24)(59,22)
          (59,24) -> (58,24)(60,24)(59,25)(59,23)
          (59,25) -> (58,25)(60,25)(59,26)(59,24)
          (59,26) -> (58,26)(60,26)(59,27)(59,25)
          (59,27) -> (58,27)(60,27)(59,28)(59,26)
          (59,28) -> (58,28)(60,28)(59,29)(59,27)
          (59,29) -> (58,29)(60,29)(59,30)(59,28)
          (59,30) -> (58,30)(60,30)(59,31)(59,29)
          (59,31) -> (58,31)(60,31)(59,32)(59,30)
          (59,32) -> (58,32)(60,32)(59,33)(59,31)
          (59,33) -> (58,33)(60,33)(59,34)(59,32)
          (59,34) -> (58,34)(60,34)(59,35)(59,33)
          (59,35) -> (58,35)(60,35)(59,36)(59,34)
          (59,36) -> (58,36)(60,36)(59,37)(59,35)
          (59,37) -> (58,37)(60,37)(59,38)(59,36)
          (59,38) -> (58,38)(60,38)(59,39)(59,37)
          (59,39) -> (58,39)(60,39)(59,40)(59,38)
          (59,40) -> (58,40)(60,40)(59,41)(59,39)
          (59,41) -> (58,41)(60,41)(59,42)(59,40)
          (59,42) -> (58,42)(60,42)(59,43)(59,41)
          (59,43) -> (58,43)(60,43)(59,44)(59,42)
          (59,44) -> (58,44)(60,44)(59,45)(59,43)
          (59,45) -> (58,45)(60,45)(59,46)(59,44)
          (59,46) -> (58,46)(60,46)(59,47)(59,45)
          (59,47) -> (58,47)(60,47)(59,48)(59,46)
          (59,48) -> (58,48)(60,48)(59,49)(59,47)
          (59,49) -> (58,49)(60,49)(59,50)(59,48)
          (59,50) -> (58,50)(60,50)(59,51)(59,49)
          (59,51) -> (58,51)(60,51)(59,52)(59,50)
          (59,52) -> (58,52)(60,52)(59,53)(59,51)
          (59,53) -> (58,53)(60,53)(59,54)(59,52)
          (59,54) -> (58,54)(60,54)(59,55)(59,53)
          (59,55) -> (58,55)(60,55)(59,56)(59,54)
          (59,56) -> (58,56)(60,56)(59,57)(59,55)
          (59,57) -> (58,57)(60,57)(59,58)(59,56)
          (59,58) -> (58,58)(60,58)(59,59)(59,57)
          (59,59) -> (58,59)(60,59)(59,60)(59,58)
          (59,60) -> (58,60)(60,60)(59,61)(59,59)
          (59,61) -> (58,61)(60,61)(59,62)(59,60)
          (59,62) -> (58,62)(60,62)(59,63)(59,61)
          (59,63) -> (58,63)(60,63)(59,62)
          (60,0)  -> (59,0)(61,0)(60,1)
          (60,1)  -> (59,1)(61,1)(60,2)(60,0)
          (60,2)  -> (59,2)(61,2)(60,3)(60,1)
          (60,3)  -> (59,3)(61,3)(60,4)(60,2)
          (60,4)  -> (59,4)(61,4)(60,5)(60,3)
          (60,5)  -> (59,5)(61,5)(60,6)(60,4)
          (60,6)  -> (59,6)(61,6)(60,7)(60,5)
          (60,7)  -> (59,7)(61,7)(60,8)(60,6)
          (60,8)  -> (59,8)(61,8)(60,9)(60,7)
          (60,9)  -> (59,9)(61,9)(60,10)(60,8)
          (60,10) -> (59,10)(61,10)(60,11)(60,9)
          (60,11) -> (59,11)(61,11)(60,12)(60,10)
          (60,12) -> (59,12)(61,12)(60,13)(60,11)
          (60,13) -> (59,13)(61,13)(60,14)(60,12)
          (60,14) -> (59,14)(61,14)(60,15)(60,13)
          (60,15) -> (59,15)(61,15)(60,16)(60,14)
          (60,16) -> (59,16)(61,16)(60,17)(60,15)
          (60,17) -> (59,17)(61,17)(60,18)(60,16)
          (60,18) -> (59,18)(61,18)(60,19)(60,17)
          (60,19) -> (59,19)(61,19)(60,20)(60,18)
          (60,20) -> (59,20)(61,20)(60,21)(60,19)
          (60,21) -> (59,21)(61,21)(60,22)(60,20)
          (60,22) -> (59,22)(61,22)(60,23)(60,21)
          (60,23) -> (59,23)(61,23)(60,24)(60,22)
          (60,24) -> (59,24)(61,24)(60,25)(60,23)
          (60,25) -> (59,25)(61,25)(60,26)(60,24)
          (60,26) -> (59,26)(61,26)(60,27)(60,25)
          (60,27) -> (59,27)(61,27)(60,28)(60,26)
          (60,28) -> (59,28)(61,28)(60,29)(60,27)
          (60,29) -> (59,29)(61,29)(60,30)(60,28)
          (60,30) -> (59,30)(61,30)(60,31)(60,29)
          (60,31) -> (59,31)(61,31)(60,32)(60,30)
          (60,32) -> (59,32)(61,32)(60,33)(60,31)
          (60,33) -> (59,33)(61,33)(60,34)(60,32)
          (60,34) -> (59,34)(61,34)(60,35)(60,33)
          (60,35) -> (59,35)(61,35)(60,36)(60,34)
          (60,36) -> (59,36)(61,36)(60,37)(60,35)
          (60,37) -> (59,37)(61,37)(60,38)(60,36)
          (60,38) -> (59,38)(61,38)(60,39)(60,37)
          (60,39) -> (59,39)(61,39)(60,40)(60,38)
          (60,40) -> (59,40)(61,40)(60,41)(60,39)
          (60,41) -> (59,41)(61,41)(60,42)(60,40)
          (60,42) -> (59,42)(61,42)(60,43)(60,41)
          (60,43) -> (59,43)(61,43)(60,44)(60,42)
          (60,44) -> (59,44)(61,44)(60,45)(60,43)
          (60,45) -> (59,45)(61,45)(60,46)(60,44)
          (60,46) -> (59,46)(61,46)(60,47)(60,45)
          (60,47) -> (59,47)(61,47)(60,48)(60,46)
          (60,48) -> (59,48)(61,48)(60,49)(60,47)
          (60,49) -> (59,49)(61,49)(60,50)(60,48)
          (60,50) -> (59,50)(61,50)(60,51)(60,49)
          (60,51) -> (59,51)(61,51)(60,52)(60,50)
          (60,52) -> (59,52)(61,52)(60,53)(60,51)
          (60,53) -> (59,53)(61,53)(60,54)(60,52)
          (60,54) -> (59,54)(61,54)(60,55)(60,53)
          (60,55) -> (59,55)(61,55)(60,56)(60,54)
          (60,56) -> (59,56)(61,56)(60,57)(60,55)
          (60,57) -> (59,57)(61,57)(60,58)(60,56)
          (60,58) -> (59,58)(61,58)(60,59)(60,57)
          (60,59) -> (59,59)(61,59)(60,60)(60,58)
          (60,60) -> (59,60)(61,60)(60,61)(60,59)
          (60,61) -> (59,61)(61,61)(60,62)(60,60)
          (60,62) -> (59,62)(61,62)(60,63)(60,61)
          (60,63) -> (59,63)(61,63)(60,62)
          (61,0)  -> (60,0)(62,0)(61,1)
          (61,1)  -> (60,1)(62,1)(61,2)(61,0)
          (61,2)  -> (60,2)(62,2)(61,3)(61,1)
          (61,3)  -> (60,3)(62,3)(61,4)(61,2)
          (61,4)  -> (60,4)(62,4)(61,5)(61,3)
          (61,5)  -> (60,5)(62,5)(61,6)(61,4)
          (61,6)  -> (60,6)(62,6)(61,7)(61,5)
          (61,7)  -> (60,7)(62,7)(61,8)(61,6)
          (61,8)  -> (60,8)(62,8)(61,9)(61,7)
          (61,9)  -> (60,9)(62,9)(61,10)(61,8)
          (61,10) -> (60,10)(62,10)(61,11)(61,9)
          (61,11) -> (60,11)(62,11)(61,12)(61,10)
          (61,12) -> (60,12)(62,12)(61,13)(61,11)
          (61,13) -> (60,13)(62,13)(61,14)(61,12)
          (61,14) -> (60,14)(62,14)(61,15)(61,13)
          (61,15) -> (60,15)(62,15)(61,16)(61,14)
          (61,16) -> (60,16)(62,16)(61,17)(61,15)
          (61,17) -> (60,17)(62,17)(61,18)(61,16)
          (61,18) -> (60,18)(62,18)(61,19)(61,17)
          (61,19) -> (60,19)(62,19)(61,20)(61,18)
          (61,20) -> (60,20)(62,20)(61,21)(61,19)
          (61,21) -> (60,21)(62,21)(61,22)(61,20)
          (61,22) -> (60,22)(62,22)(61,23)(61,21)
          (61,23) -> (60,23)(62,23)(61,24)(61,22)
          (61,24) -> (60,24)(62,24)(61,25)(61,23)
          (61,25) -> (60,25)(62,25)(61,26)(61,24)
          (61,26) -> (60,26)(62,26)(61,27)(61,25)
          (61,27) -> (60,27)(62,27)(61,28)(61,26)
          (61,28) -> (60,28)(62,28)(61,29)(61,27)
          (61,29) -> (60,29)(62,29)(61,30)(61,28)
          (61,30) -> (60,30)(62,30)(61,31)(61,29)
          (61,31) -> (60,31)(62,31)(61,32)(61,30)
          (61,32) -> (60,32)(62,32)(61,33)(61,31)
          (61,33) -> (60,33)(62,33)(61,34)(61,32)
          (61,34) -> (60,34)(62,34)(61,35)(61,33)
          (61,35) -> (60,35)(62,35)(61,36)(61,34)
          (61,36) -> (60,36)(62,36)(61,37)(61,35)
          (61,37) -> (60,37)(62,37)(61,38)(61,36)
          (61,38) -> (60,38)(62,38)(61,39)(61,37)
          (61,39) -> (60,39)(62,39)(61,40)(61,38)
          (61,40) -> (60,40)(62,40)(61,41)(61,39)
          (61,41) -> (60,41)(62,41)(61,42)(61,40)
          (61,42) -> (60,42)(62,42)(61,43)(61,41)
          (61,43) -> (60,43)(62,43)(61,44)(61,42)
          (61,44) -> (60,44)(62,44)(61,45)(61,43)
          (61,45) -> (60,45)(62,45)(61,46)(61,44)
          (61,46) -> (60,46)(62,46)(61,47)(61,45)
          (61,47) -> (60,47)(62,47)(61,48)(61,46)
          (61,48) -> (60,48)(62,48)(61,49)(61,47)
          (61,49) -> (60,49)(62,49)(61,50)(61,48)
          (61,50) -> (60,50)(62,50)(61,51)(61,49)
          (61,51) -> (60,51)(62,51)(61,52)(61,50)
          (61,52) -> (60,52)(62,52)(61,53)(61,51)
          (61,53) -> (60,53)(62,53)(61,54)(61,52)
          (61,54) -> (60,54)(62,54)(61,55)(61,53)
          (61,55) -> (60,55)(62,55)(61,56)(61,54)
          (61,56) -> (60,56)(62,56)(61,57)(61,55)
          (61,57) -> (60,57)(62,57)(61,58)(61,56)
          (61,58) -> (60,58)(62,58)(61,59)(61,57)
          (61,59) -> (60,59)(62,59)(61,60)(61,58)
          (61,60) -> (60,60)(62,60)(61,61)(61,59)
          (61,61) -> (60,61)(62,61)(61,62)(61,60)
          (61,62) -> (60,62)(62,62)(61,63)(61,61)
          (61,63) -> (60,63)(62,63)(61,62)
          (62,0)  -> (61,0)(63,0)(62,1)
          (62,1)  -> (61,1)(63,1)(62,2)(62,0)
          (62,2)  -> (61,2)(63,2)(62,3)(62,1)
          (62,3)  -> (61,3)(63,3)(62,4)(62,2)
          (62,4)  -> (61,4)(63,4)(62,5)(62,3)
          (62,5)  -> (61,5)(63,5)(62,6)(62,4)
          (62,6)  -> (61,6)(63,6)(62,7)(62,5)
          (62,7)  -> (61,7)(63,7)(62,8)(62,6)
          (62,8)  -> (61,8)(63,8)(62,9)(62,7)
          (62,9)  -> (61,9)(63,9)(62,10)(62,8)
          (62,10) -> (61,10)(63,10)(62,11)(62,9)
          (62,11) -> (61,11)(63,11)(62,12)(62,10)
          (62,12) -> (61,12)(63,12)(62,13)(62,11)
          (62,13) -> (61,13)(63,13)(62,14)(62,12)
          (62,14) -> (61,14)(63,14)(62,15)(62,13)
          (62,15) -> (61,15)(63,15)(62,16)(62,14)
          (62,16) -> (61,16)(63,16)(62,17)(62,15)
          (62,17) -> (61,17)(63,17)(62,18)(62,16)
          (62,18) -> (61,18)(63,18)(62,19)(62,17)
          (62,19) -> (61,19)(63,19)(62,20)(62,18)
          (62,20) -> (61,20)(63,20)(62,21)(62,19)
          (62,21) -> (61,21)(63,21)(62,22)(62,20)
          (62,22) -> (61,22)(63,22)(62,23)(62,21)
          (62,23) -> (61,23)(63,23)(62,24)(62,22)
          (62,24) -> (61,24)(63,24)(62,25)(62,23)
          (62,25) -> (61,25)(63,25)(62,26)(62,24)
          (62,26) -> (61,26)(63,26)(62,27)(62,25)
          (62,27) -> (61,27)(63,27)(62,28)(62,26)
          (62,28) -> (61,28)(63,28)(62,29)(62,27)
          (62,29) -> (61,29)(63,29)(62,30)(62,28)
          (62,30) -> (61,30)(63,30)(62,31)(62,29)
          (62,31) -> (61,31)(63,31)(62,32)(62,30)
          (62,32) -> (61,32)(63,32)(62,33)(62,31)
          (62,33) -> (61,33)(63,33)(62,34)(62,32)
          (62,34) -> (61,34)(63,34)(62,35)(62,33)
          (62,35) -> (61,35)(63,35)(62,36)(62,34)
          (62,36) -> (61,36)(63,36)(62,37)(62,35)
          (62,37) -> (61,37)(63,37)(62,38)(62,36)
          (62,38) -> (61,38)(63,38)(62,39)(62,37)
          (62,39) -> (61,39)(63,39)(62,40)(62,38)
          (62,40) -> (61,40)(63,40)(62,41)(62,39)
          (62,41) -> (61,41)(63,41)(62,42)(62,40)
          (62,42) -> (61,42)(63,42)(62,43)(62,41)
          (62,43) -> (61,43)(63,43)(62,44)(62,42)
          (62,44) -> (61,44)(63,44)(62,45)(62,43)
          (62,45) -> (61,45)(63,45)(62,46)(62,44)
          (62,46) -> (61,46)(63,46)(62,47)(62,45)
          (62,47) -> (61,47)(63,47)(62,48)(62,46)
          (62,48) -> (61,48)(63,48)(62,49)(62,47)
          (62,49) -> (61,49)(63,49)(62,50)(62,48)
          (62,50) -> (61,50)(63,50)(62,51)(62,49)
          (62,51) -> (61,51)(63,51)(62,52)(62,50)
          (62,52) -> (61,52)(63,52)(62,53)(62,51)
          (62,53) -> (61,53)(63,53)(62,54)(62,52)
          (62,54) -> (61,54)(63,54)(62,55)(62,53)
          (62,55) -> (61,55)(63,55)(62,56)(62,54)
          (62,56) -> (61,56)(63,56)(62,57)(62,55)
          (62,57) -> (61,57)(63,57)(62,58)(62,56)
          (62,58) -> (61,58)(63,58)(62,59)(62,57)
          (62,59) -> (61,59)(63,59)(62,60)(62,58)
          (62,60) -> (61,60)(63,60)(62,61)(62,59)
          (62,61) -> (61,61)(63,61)(62,62)(62,60)
          (62,62) -> (61,62)(63,62)(62,63)(62,61)
          (62,63) -> (61,63)(63,63)(62,62)
          (63,0)  -> (62,0)(63,1)
          (63,1)  -> (62,1)(63,2)(63,0)
          (63,2)  -> (62,2)(63,3)(63,1)
          (63,3)  -> (62,3)(63,4)(63,2)
          (63,4)  -> (62,4)(63,5)(63,3)
          (63,5)  -> (62,5)(63,6)(63,4)
          (63,6)  -> (62,6)(63,7)(63,5)
          (63,7)  -> (62,7)(63,8)(63,6)
          (63,8)  -> (62,8)(63,9)(63,7)
          (63,9)  -> (62,9)(63,10)(63,8)
          (63,10) -> (62,10)(63,11)(63,9)
          (63,11) -> (62,11)(63,12)(63,10)
          (63,12) -> (62,12)(63,13)(63,11)
          (63,13) -> (62,13)(63,14)(63,12)
          (63,14) -> (62,14)(63,15)(63,13)
          (63,15) -> (62,15)(63,16)(63,14)
          (63,16) -> (62,16)(63,17)(63,15)
          (63,17) -> (62,17)(63,18)(63,16)
          (63,18) -> (62,18)(63,19)(63,17)
          (63,19) -> (62,19)(63,20)(63,18)
          (63,20) -> (62,20)(63,21)(63,19)
          (63,21) -> (62,21)(63,22)(63,20)
          (63,22) -> (62,22)(63,23)(63,21)
          (63,23) -> (62,23)(63,24)(63,22)
          (63,24) -> (62,24)(63,25)(63,23)
          (63,25) -> (62,25)(63,26)(63,24)
          (63,26) -> (62,26)(63,27)(63,25)
          (63,27) -> (62,27)(63,28)(63,26)
          (63,28) -> (62,28)(63,29)(63,27)
          (63,29) -> (62,29)(63,30)(63,28)
          (63,30) -> (62,30)(63,31)(63,29)
          (63,31) -> (62,31)(63,32)(63,30)
          (63,32) -> (62,32)(63,33)(63,31)
          (63,33) -> (62,33)(63,34)(63,32)
          (63,34) -> (62,34)(63,35)(63,33)
          (63,35) -> (62,35)(63,36)(63,34)
          (63,36) -> (62,36)(63,37)(63,35)
          (63,37) -> (62,37)(63,38)(63,36)
          (63,38) -> (62,38)(63,39)(63,37)
          (63,39) -> (62,39)(63,40)(63,38)
          (63,40) -> (62,40)(63,41)(63,39)
          (63,41) -> (62,41)(63,42)(63,40)
          (63,42) -> (62,42)(63,43)(63,41)
          (63,43) -> (62,43)(63,44)(63,42)
          (63,44) -> (62,44)(63,45)(63,43)
          (63,45) -> (62,45)(63,46)(63,44)
          (63,46) -> (62,46)(63,47)(63,45)
          (63,47) -> (62,47)(63,48)(63,46)
          (63,48) -> (62,48)(63,49)(63,47)
          (63,49) -> (62,49)(63,50)(63,48)
          (63,50) -> (62,50)(63,51)(63,49)
          (63,51) -> (62,51)(63,52)(63,50)
          (63,52) -> (62,52)(63,53)(63,51)
          (63,53) -> (62,53)(63,54)(63,52)
          (63,54) -> (62,54)(63,55)(63,53)
          (63,55) -> (62,55)(63,56)(63,54)
          (63,56) -> (62,56)(63,57)(63,55)
          (63,57) -> (62,57)(63,58)(63,56)
          (63,58) -> (62,58)(63,59)(63,57)
          (63,59) -> (62,59)(63,60)(63,58)
          (63,60) -> (62,60)(63,61)(63,59)
          (63,61) -> (62,61)(63,62)(63,60)
          (63,62) -> (62,62)(63,63)(63,61)
          (63,63) -> (62,63)(63,62)
        }
      }
      ARCHITECTURE_DATA {
        ID:   0
        PREV: [3,1]
        NEXT: [2,2]
        POS:  (810,390)
      }
    }
    ARCHITECTURE_ELEMENT {
      TYPE: INPUT
      INTERNAL_DATA {
        NAME:       INPUT
        COMMENT:    
        INPUTS:     1
        OUTPUTS:    1
        INPUT_DIM:  (64,64)
        OUTPUT_DIM: (64,64)
        CLOCK:      1
        TIME:       10
      }
      LOGICAL_DATA {
        XY_PLANE_DATA {
          NUMBER: 3
          PLANES {
            MATRIX {
              DIMENSION: (64,64)
              DATA {
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                1111111111111111000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
              }
            }
            MATRIX {
              DIMENSION: (64,64)
              DATA {
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                1111111111111110000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
              }
            }
            MATRIX {
              DIMENSION: (64,64)
              DATA {
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                1111111111111110000000000000000000000000000000000000000000000000
                1111111111111111000000000000000000000000000000000000000000000000
                1111111111111110000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
                0000000000000000000000000000000000000000000000000000000000000000
              }
            }
          }
        }
      }
      ARCHITECTURE_DATA {
        ID:   1
        PREV: [-,-]
        NEXT: [2,1]
        POS:  (540,420)
      }
    }
    ARCHITECTURE_ELEMENT {
      TYPE: JOIN
      INTERNAL_DATA {
        NAME:       JOIN
        COMMENT:    
        INPUTS:     2
        OUTPUTS:    1
        INPUT_DIM:  (64,64)(64,64)
        OUTPUT_DIM: (64,64)
        CLOCK:      0
        TIME:       0
      }
      LOGICAL_DATA{
        RULE: OR
      }
      ARCHITECTURE_DATA {
        ID:   2
        PREV: [1,1][0,1]
        NEXT: [3,1]
        POS:  (630,420)
      }
    }
    ARCHITECTURE_ELEMENT {
      TYPE: LOGIC
      INTERNAL_DATA {
        NAME:       LOGIC
        COMMENT:    
        INPUTS:     1
        OUTPUTS:    1
        INPUT_DIM:  (64,64)
        OUTPUT_DIM: (64,64)
        CLOCK:      2
        TIME:       20
      }
      LOGICAL_DATA {
        PE_DIMENSION: (1,1)
        PE_DATA {
          NAMES {
            Z
          }
        }
        EXTERNAL_DATA {
          NUMBER: 3
          NAMES {
            init_a
            init_e
            new
          }
          MATRIX {
            DIMENSION: (3,300)
            DATA {
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              001
              100
              010
            }
          }
        }
        INTERNAL_DATA {
          NUMBER: 3
          NAMES {
            A
            E
            tmp
          }
        }
        EQUATION_DATA {
          NUMBER: 4
          EQUATIONS {
            Z=Z&~A&~E&new
            tmp=E
            E=A&new|E&~new|Z&init_e
            A=Z&~A&~tmp&new|Z&init_a|A&~new
          }
          COMPUTE_PARALLEL: OFF
        }
      }
      ARCHITECTURE_DATA {
        ID:   3
        PREV: [2,1]
        NEXT: [0,1]
        POS:  (720,390)
      }
    }
  }
}

