#
# HADLOP Pro written by Guido Grimm and Marko Degenkolb
#

REMARKS {
}

OPTIONS {
  GRID {
    VISIBLE:   ON
    DIMENSION: (15,15)
    RASTERIZE: ON
  }
}

GLOBAL_ARCHITECTURE_DATA {
  DIMENSION:        (4,2)
  CLOCKS {
    NUMBER: 2
    CLOCK {
      TIME:   100
      OFFSET: 0
    }
    CLOCK {
      TIME:   100
      OFFSET: 50
    }
  }
  SIMULATION_DATA {
    MODE:     CLOCKS
    CLOCK_NR: 1
    CLOCKS:   56
  }
}

ARCHITECTURE_ELEMENTS {
  NUMBER: 3
  ELEMENTS {
    ARCHITECTURE_ELEMENT {
      TYPE: OUTPUT
      INTERNAL_DATA {
        NAME:       OUTPUT
        COMMENT:    
        INPUTS:     1
        OUTPUTS:    1
        INPUT_DIM:  (4,2)
        OUTPUT_DIM: (4,2)
        CLOCK:      1
        TIME:       0
      }
      LOGICAL_DATA {
        NUMBER_PLANES: 8
      }
      ARCHITECTURE_DATA {
        ID:   0
        PREV: [1,1]
        NEXT: [-,-]
        POS:  (780,405)
      }
    }
    ARCHITECTURE_ELEMENT {
      TYPE: MACRO
      INTERNAL_DATA {
        NAME:       Sorter
        COMMENT:    (4x2) perfect-shuffle interconnected bitonic sorter
        INPUTS:     1
        OUTPUTS:    1
        INPUT_DIM:  (4,2)
        OUTPUT_DIM: (4,2)
        CLOCK:      0
        TIME:       0
      }
      LOGICAL_DATA {
        REMARKS {
        }

        OPTIONS {
          GRID {
            VISIBLE:   ON
            DIMENSION: (15,15)
            RASTERIZE: ON
          }
        }

        ARCHITECTURE_ELEMENTS {
          NUMBER: 12
          ELEMENTS {
            ARCHITECTURE_ELEMENT {
              TYPE: PERM
              INTERNAL_DATA {
                NAME:       PERM
                COMMENT:    (4x2) -> (6x2)
                INPUTS:     1
                OUTPUTS:    1
                INPUT_DIM:  (4,2)
                OUTPUT_DIM: (6,2)
                CLOCK:      0
                TIME:       0
              }
              LOGICAL_DATA {
                CONNECTIONS {
                  (0,0) -> (0,0)
                  (0,1) -> (0,1)
                  (1,0) -> (1,0)
                  (1,1) -> (1,1)
                  (2,0) -> (3,0)
                  (2,1) -> (3,1)
                  (3,0) -> (4,0)
                  (3,1) -> (4,1)
                }
              }
              ARCHITECTURE_DATA {
                ID:   0
                PREV: [1,1]
                NEXT: [2,1]
                POS:  (480,525)
              }
            }
            ARCHITECTURE_ELEMENT {
              TYPE: MACRO_INPUT
              INTERNAL_DATA {
                NAME:       
                COMMENT:    
                INPUTS:     0
                OUTPUTS:    1
                INPUT_DIM:  (-,-)
                OUTPUT_DIM: (4,2)
                CLOCK:      0
                TIME:       0
              }
              LOGICAL_DATA {
                INPUT_NR: 0
              }
              ARCHITECTURE_DATA {
                ID:   1
                PREV: 
                NEXT: [0,1]
                POS:  (435,525)
              }
            }
            ARCHITECTURE_ELEMENT {
              TYPE: PERM
              INTERNAL_DATA {
                NAME:       PERM
                COMMENT:    
                INPUTS:     1
                OUTPUTS:    1
                INPUT_DIM:  (6,2)
                OUTPUT_DIM: (6,2)
                CLOCK:      0
                TIME:       0
              }
              LOGICAL_DATA {
                CONNECTIONS {
                  (0,0) -> (3,1)
                  (0,1) -> (0,1)
                  (1,0) -> (3,0)
                  (1,1) -> (0,0)
                  (2,0) -> (-,-)
                  (2,1) -> (-,-)
                  (3,0) -> (4,1)
                  (3,1) -> (1,1)
                  (4,0) -> (4,0)
                  (4,1) -> (1,0)
                  (5,0) -> (-,-)
                  (5,1) -> (-,-)
                }
              }
              ARCHITECTURE_DATA {
                ID:   2
                PREV: [0,1]
                NEXT: [3,1]
                POS:  (555,525)
              }
            }
            ARCHITECTURE_ELEMENT {
              TYPE: JOIN
              INTERNAL_DATA {
                NAME:       JOIN
                COMMENT:    
                INPUTS:     2
                OUTPUTS:    1
                INPUT_DIM:  (6,2)(6,2)
                OUTPUT_DIM: (6,2)
                CLOCK:      0
                TIME:       0
              }
              LOGICAL_DATA{
                RULE: OR
              }
              ARCHITECTURE_DATA {
                ID:   3
                PREV: [2,1][8,1]
                NEXT: [5,1]
                POS:  (630,525)
              }
            }
            ARCHITECTURE_ELEMENT {
              TYPE: INPUT
              INTERNAL_DATA {
                NAME:       INPUT
                COMMENT:    generates Mask-Bit M2
                INPUTS:     1
                OUTPUTS:    1
                INPUT_DIM:  (6,2)
                OUTPUT_DIM: (6,2)
                CLOCK:      1
                TIME:       10
              }
              LOGICAL_DATA {
                XY_PLANE_DATA {
                  NUMBER: 64
                  PLANES {
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000001
                        000001
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000001
                        000001
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000001
                        000001
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000001
                        000001
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000001
                        000001
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000001
                        000001
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000001
                        000001
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000001
                        000001
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        001001
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        001001
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        001001
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        001001
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        001001
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        001001
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        001001
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        001001
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000001
                        000001
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000001
                        000001
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000001
                        000001
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000001
                        000001
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000001
                        000001
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000001
                        000001
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000001
                        000001
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000001
                        000001
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        001001
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        001001
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        001001
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        001001
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        001001
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        001001
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        001001
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        001001
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        000000
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        000000
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        000000
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        000000
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        000000
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        000000
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        000000
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        000000
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        000000
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        000000
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        000000
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        000000
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        000000
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        000000
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        000000
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        000000
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        000000
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        000000
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        000000
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        000000
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        000000
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        000000
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        000000
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        000000
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        000000
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        000000
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        000000
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        000000
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        000000
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        000000
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        000000
                      }
                    }
                    MATRIX {
                      DIMENSION: (6,2)
                      DATA {
                        000000
                        000000
                      }
                    }
                  }
                }
              }
              ARCHITECTURE_DATA {
                ID:   4
                PREV: [-,-]
                NEXT: [6,2]
                POS:  (720,480)
              }
            }
            ARCHITECTURE_ELEMENT {
              TYPE: PERM
              INTERNAL_DATA {
                NAME:       PERM
                COMMENT:    Perfect Shuffle
                INPUTS:     1
                OUTPUTS:    1
                INPUT_DIM:  (6,2)
                OUTPUT_DIM: (6,2)
                CLOCK:      0
                TIME:       0
              }
              LOGICAL_DATA {
                CONNECTIONS {
                  (0,0) -> (1,1)
                  (0,1) -> (0,1)
                  (1,0) -> (4,1)
                  (1,1) -> (3,1)
                  (2,0) -> (-,-)
                  (2,1) -> (-,-)
                  (3,0) -> (1,0)
                  (3,1) -> (0,0)
                  (4,0) -> (4,0)
                  (4,1) -> (3,0)
                  (5,0) -> (-,-)
                  (5,1) -> (-,-)
                }
              }
              ARCHITECTURE_DATA {
                ID:   5
                PREV: [3,1]
                NEXT: [6,1]
                POS:  (720,435)
              }
            }
            ARCHITECTURE_ELEMENT {
              TYPE: JOIN
              INTERNAL_DATA {
                NAME:       JOIN
                COMMENT:    
                INPUTS:     2
                OUTPUTS:    1
                INPUT_DIM:  (6,2)(6,2)
                OUTPUT_DIM: (6,2)
                CLOCK:      0
                TIME:       0
              }
              LOGICAL_DATA{
                RULE: OR
              }
              ARCHITECTURE_DATA {
                ID:   6
                PREV: [5,1][4,1]
                NEXT: [7,1]
                POS:  (795,435)
              }
            }
            ARCHITECTURE_ELEMENT {
              TYPE: LOGIC
              INTERNAL_DATA {
                NAME:       LOGIC
                COMMENT:    Sorting Node
                INPUTS:     1
                OUTPUTS:    1
                INPUT_DIM:  (6,2)
                OUTPUT_DIM: (6,2)
                CLOCK:      2
                TIME:       20
              }
              LOGICAL_DATA {
                PE_DIMENSION: (3,1)
                PE_DATA {
                  NAMES {
                    A
                    B
                    M2
                  }
                }
                EXTERNAL_DATA {
                  NUMBER: 2
                  NAMES {
                    M1
                    RESET
                  }
                  MATRIX {
                    DIMENSION: (2,64)
                    DATA {
                      01
                      00
                      00
                      00
                      00
                      00
                      00
                      00
                      01
                      00
                      00
                      00
                      00
                      00
                      00
                      00
                      01
                      00
                      00
                      00
                      00
                      00
                      00
                      00
                      01
                      00
                      00
                      00
                      00
                      00
                      00
                      00
                      01
                      00
                      00
                      00
                      00
                      00
                      00
                      00
                      01
                      00
                      00
                      00
                      00
                      00
                      00
                      00
                      11
                      10
                      10
                      10
                      10
                      10
                      10
                      10
                      01
                      00
                      00
                      00
                      00
                      00
                      00
                      00
                    }
                  }
                }
                INTERNAL_DATA {
                  NUMBER: 2
                  NAMES {
                    AgreaterB
                    cmpd
                  }
                }
                EQUATION_DATA {
                  NUMBER: 5
                  EQUATIONS {
                    AgreaterB = ((A & ~B) & ~cmpd | AgreaterB) 
                    cmpd = ((A & ~B) | (~A & B) | cmpd) & ~RESET
                    A = (A & M1) | (~M1 & ((A & ((M2 & AgreaterB) | (~M2 & ~AgreaterB)))  |  (B & ((~M2 & AgreaterB) | (M2 & ~AgreaterB)))))
                    B = (B & M1) | (~M1 & ((B & ((M2 & AgreaterB) | (~M2 & ~AgreaterB)))  |  (A & ((~M2 & AgreaterB) | (M2 & ~AgreaterB)))))
                    AgreaterB = AgreaterB & ~RESET
                  }
                  COMPUTE_PARALLEL: OFF
                }
              }
              ARCHITECTURE_DATA {
                ID:   7
                PREV: [6,1]
                NEXT: [9,1]
                POS:  (870,435)
              }
            }
            ARCHITECTURE_ELEMENT {
              TYPE: OUTPUT
              INTERNAL_DATA {
                NAME:       OUTPUT
                COMMENT:    Memory (8 planes)
                INPUTS:     1
                OUTPUTS:    1
                INPUT_DIM:  (6,2)
                OUTPUT_DIM: (6,2)
                CLOCK:      1
                TIME:       10
              }
              LOGICAL_DATA {
                NUMBER_PLANES: 7
              }
              ARCHITECTURE_DATA {
                ID:   8
                PREV: [9,2]
                NEXT: [3,2]
                POS:  (795,585)
              }
            }
            ARCHITECTURE_ELEMENT {
              TYPE: SPLIT
              INTERNAL_DATA {
                NAME:       SPLIT
                COMMENT:    
                INPUTS:     1
                OUTPUTS:    2
                INPUT_DIM:  (6,2)
                OUTPUT_DIM: (6,2)(6,2)
                CLOCK:      0
                TIME:       0
              }
              LOGICAL_DATA {
              }
              ARCHITECTURE_DATA {
                ID:   9
                PREV: [7,1]
                NEXT: [10,1][8,1]
                POS:  (960,510)
              }
            }
            ARCHITECTURE_ELEMENT {
              TYPE: PERM
              INTERNAL_DATA {
                NAME:       PERM
                COMMENT:    (6x2) -> (4x2)
                INPUTS:     1
                OUTPUTS:    1
                INPUT_DIM:  (6,2)
                OUTPUT_DIM: (4,2)
                CLOCK:      0
                TIME:       0
              }
              LOGICAL_DATA {
                CONNECTIONS {
                  (0,0) -> (0,0)
                  (0,1) -> (0,1)
                  (1,0) -> (1,0)
                  (1,1) -> (1,1)
                  (2,0) -> (-,-)
                  (2,1) -> (-,-)
                  (3,0) -> (2,0)
                  (3,1) -> (2,1)
                  (4,0) -> (3,0)
                  (4,1) -> (3,1)
                  (5,0) -> (-,-)
                  (5,1) -> (-,-)
                }
              }
              ARCHITECTURE_DATA {
                ID:   10
                PREV: [9,1]
                NEXT: [11,1]
                POS:  (1035,510)
              }
            }
            ARCHITECTURE_ELEMENT {
              TYPE: MACRO_OUTPUT
              INTERNAL_DATA {
                NAME:       
                COMMENT:    
                INPUTS:     1
                OUTPUTS:    0
                INPUT_DIM:  (4,2)
                OUTPUT_DIM: (-,-)
                CLOCK:      0
                TIME:       0
              }
              LOGICAL_DATA {
                OUTPUT_NR: 0
              }
              ARCHITECTURE_DATA {
                ID:   11
                PREV: [10,1]
                NEXT: 
                POS:  (1110,510)
              }
            }
          }
        }
      }
      ARCHITECTURE_DATA {
        ID:   1
        PREV: [2,1]
        NEXT: [0,1]
        POS:  (690,405)
      }
    }
    ARCHITECTURE_ELEMENT {
      TYPE: INPUT
      INTERNAL_DATA {
        NAME:       INPUT
        COMMENT:    
        INPUTS:     1
        OUTPUTS:    1
        INPUT_DIM:  (4,2)
        OUTPUT_DIM: (4,2)
        CLOCK:      1
        TIME:       10
      }
      LOGICAL_DATA {
        XY_PLANE_DATA {
          NUMBER: 8
          PLANES {
            MATRIX {
              DIMENSION: (4,2)
              DATA {
                0000
                0000
              }
            }
            MATRIX {
              DIMENSION: (4,2)
              DATA {
                0000
                0000
              }
            }
            MATRIX {
              DIMENSION: (4,2)
              DATA {
                0000
                0000
              }
            }
            MATRIX {
              DIMENSION: (4,2)
              DATA {
                0000
                0000
              }
            }
            MATRIX {
              DIMENSION: (4,2)
              DATA {
                0100
                0000
              }
            }
            MATRIX {
              DIMENSION: (4,2)
              DATA {
                1000
                0111
              }
            }
            MATRIX {
              DIMENSION: (4,2)
              DATA {
                0001
                1101
              }
            }
            MATRIX {
              DIMENSION: (4,2)
              DATA {
                0011
                0110
              }
            }
          }
        }
      }
      ARCHITECTURE_DATA {
        ID:   2
        PREV: [-,-]
        NEXT: [1,1]
        POS:  (600,405)
      }
    }
  }
}

