#
# HADLOP Pro written by Guido Grimm and Marko Degenkolb
#

REMARKS {
}

OPTIONS {
  GRID {
    VISIBLE:   ON
    DIMENSION: (15,15)
    RASTERIZE: ON
  }
}

GLOBAL_ARCHITECTURE_DATA {
  DIMENSION:        (16,2)
  CLOCKS {
    NUMBER: 1
    CLOCK {
      TIME:   100
      OFFSET: 0
    }
  }
  SIMULATION_DATA {
    MODE:     CLOCKS
    CLOCK_NR: 1
    CLOCKS:   16
  }
}

ARCHITECTURE_ELEMENTS {
  NUMBER: 9
  ELEMENTS {
    ARCHITECTURE_ELEMENT {
      TYPE: MACRO
      INTERNAL_DATA {
        NAME:       4 RCA 2
        COMMENT:    4 x 16x2 - Macro of a Ripple Carry Adder, 16 internal clocks required
        INPUTS:     4
        OUTPUTS:    4
        INPUT_DIM:  (16,2)(16,2)(16,2)(16,2)
        OUTPUT_DIM: (16,1)(16,1)(16,1)(16,1)
        CLOCK:      0
        TIME:       0
      }
      LOGICAL_DATA {
        REMARKS {
        }

        OPTIONS {
          GRID {
            VISIBLE:   ON
            DIMENSION: (15,15)
            RASTERIZE: ON
          }
        }

        ARCHITECTURE_ELEMENTS {
          NUMBER: 19
          ELEMENTS {
            ARCHITECTURE_ELEMENT {
              TYPE: JOIN
              INTERNAL_DATA {
                NAME:       JOIN
                COMMENT:    
                INPUTS:     4
                OUTPUTS:    1
                INPUT_DIM:  (16,8)(16,8)(16,8)(16,8)
                OUTPUT_DIM: (16,8)
                CLOCK:      0
                TIME:       0
              }
              LOGICAL_DATA{
                RULE: OR
              }
              ARCHITECTURE_DATA {
                ID:   0
                PREV: [2,1][3,1][4,1][5,1]
                NEXT: [9,1]
                POS:  (600,480)
              }
            }
            ARCHITECTURE_ELEMENT {
              TYPE: MACRO_INPUT
              INTERNAL_DATA {
                NAME:       MACRO_INPUT
                COMMENT:    
                INPUTS:     0
                OUTPUTS:    1
                INPUT_DIM:  (-,-)
                OUTPUT_DIM: (16,2)
                CLOCK:      0
                TIME:       0
              }
              LOGICAL_DATA {
                INPUT_NR: 1
              }
              ARCHITECTURE_DATA {
                ID:   1
                PREV: 
                NEXT: [3,1]
                POS:  (435,480)
              }
            }
            ARCHITECTURE_ELEMENT {
              TYPE: PERM
              INTERNAL_DATA {
                NAME:       PERM
                COMMENT:    
                INPUTS:     1
                OUTPUTS:    1
                INPUT_DIM:  (16,2)
                OUTPUT_DIM: (16,8)
                CLOCK:      0
                TIME:       0
              }
              LOGICAL_DATA {
                CONNECTIONS {
                  (0,0)  -> (0,6)
                  (0,1)  -> (0,7)
                  (1,0)  -> (1,6)
                  (1,1)  -> (1,7)
                  (2,0)  -> (2,6)
                  (2,1)  -> (2,7)
                  (3,0)  -> (3,6)
                  (3,1)  -> (3,7)
                  (4,0)  -> (4,6)
                  (4,1)  -> (4,7)
                  (5,0)  -> (5,6)
                  (5,1)  -> (5,7)
                  (6,0)  -> (6,6)
                  (6,1)  -> (6,7)
                  (7,0)  -> (7,6)
                  (7,1)  -> (7,7)
                  (8,0)  -> (8,6)
                  (8,1)  -> (8,7)
                  (9,0)  -> (9,6)
                  (9,1)  -> (9,7)
                  (10,0) -> (10,6)
                  (10,1) -> (10,7)
                  (11,0) -> (11,6)
                  (11,1) -> (11,7)
                  (12,0) -> (12,6)
                  (12,1) -> (12,7)
                  (13,0) -> (13,6)
                  (13,1) -> (13,7)
                  (14,0) -> (14,6)
                  (14,1) -> (14,7)
                  (15,0) -> (15,6)
                  (15,1) -> (15,7)
                }
              }
              ARCHITECTURE_DATA {
                ID:   2
                PREV: [6,1]
                NEXT: [0,1]
                POS:  (510,435)
              }
            }
            ARCHITECTURE_ELEMENT {
              TYPE: PERM
              INTERNAL_DATA {
                NAME:       PERM
                COMMENT:    
                INPUTS:     1
                OUTPUTS:    1
                INPUT_DIM:  (16,2)
                OUTPUT_DIM: (16,8)
                CLOCK:      0
                TIME:       0
              }
              LOGICAL_DATA {
                CONNECTIONS {
                  (0,0)  -> (0,4)
                  (0,1)  -> (0,5)
                  (1,0)  -> (1,4)
                  (1,1)  -> (1,5)
                  (2,0)  -> (2,4)
                  (2,1)  -> (2,5)
                  (3,0)  -> (3,4)
                  (3,1)  -> (3,5)
                  (4,0)  -> (4,4)
                  (4,1)  -> (4,5)
                  (5,0)  -> (5,4)
                  (5,1)  -> (5,5)
                  (6,0)  -> (6,4)
                  (6,1)  -> (6,5)
                  (7,0)  -> (7,4)
                  (7,1)  -> (7,5)
                  (8,0)  -> (8,4)
                  (8,1)  -> (8,5)
                  (9,0)  -> (9,4)
                  (9,1)  -> (9,5)
                  (10,0) -> (10,4)
                  (10,1) -> (10,5)
                  (11,0) -> (11,4)
                  (11,1) -> (11,5)
                  (12,0) -> (12,4)
                  (12,1) -> (12,5)
                  (13,0) -> (13,4)
                  (13,1) -> (13,5)
                  (14,0) -> (14,4)
                  (14,1) -> (14,5)
                  (15,0) -> (15,4)
                  (15,1) -> (15,5)
                }
              }
              ARCHITECTURE_DATA {
                ID:   3
                PREV: [1,1]
                NEXT: [0,2]
                POS:  (510,480)
              }
            }
            ARCHITECTURE_ELEMENT {
              TYPE: PERM
              INTERNAL_DATA {
                NAME:       PERM
                COMMENT:    
                INPUTS:     1
                OUTPUTS:    1
                INPUT_DIM:  (16,2)
                OUTPUT_DIM: (16,8)
                CLOCK:      0
                TIME:       0
              }
              LOGICAL_DATA {
                CONNECTIONS {
                  (0,0)  -> (0,2)
                  (0,1)  -> (0,3)
                  (1,0)  -> (1,2)
                  (1,1)  -> (1,3)
                  (2,0)  -> (2,2)
                  (2,1)  -> (2,3)
                  (3,0)  -> (3,2)
                  (3,1)  -> (3,3)
                  (4,0)  -> (4,2)
                  (4,1)  -> (4,3)
                  (5,0)  -> (5,2)
                  (5,1)  -> (5,3)
                  (6,0)  -> (6,2)
                  (6,1)  -> (6,3)
                  (7,0)  -> (7,2)
                  (7,1)  -> (7,3)
                  (8,0)  -> (8,2)
                  (8,1)  -> (8,3)
                  (9,0)  -> (9,2)
                  (9,1)  -> (9,3)
                  (10,0) -> (10,2)
                  (10,1) -> (10,3)
                  (11,0) -> (11,2)
                  (11,1) -> (11,3)
                  (12,0) -> (12,2)
                  (12,1) -> (12,3)
                  (13,0) -> (13,2)
                  (13,1) -> (13,3)
                  (14,0) -> (14,2)
                  (14,1) -> (14,3)
                  (15,0) -> (15,2)
                  (15,1) -> (15,3)
                }
              }
              ARCHITECTURE_DATA {
                ID:   4
                PREV: [8,1]
                NEXT: [0,3]
                POS:  (510,525)
              }
            }
            ARCHITECTURE_ELEMENT {
              TYPE: PERM
              INTERNAL_DATA {
                NAME:       PERM
                COMMENT:    
                INPUTS:     1
                OUTPUTS:    1
                INPUT_DIM:  (16,2)
                OUTPUT_DIM: (16,8)
                CLOCK:      0
                TIME:       0
              }
              LOGICAL_DATA {
                CONNECTIONS {
                  (0,0)  -> (0,0)
                  (0,1)  -> (0,1)
                  (1,0)  -> (1,0)
                  (1,1)  -> (1,1)
                  (2,0)  -> (2,0)
                  (2,1)  -> (2,1)
                  (3,0)  -> (3,0)
                  (3,1)  -> (3,1)
                  (4,0)  -> (4,0)
                  (4,1)  -> (4,1)
                  (5,0)  -> (5,0)
                  (5,1)  -> (5,1)
                  (6,0)  -> (6,0)
                  (6,1)  -> (6,1)
                  (7,0)  -> (7,0)
                  (7,1)  -> (7,1)
                  (8,0)  -> (8,0)
                  (8,1)  -> (8,1)
                  (9,0)  -> (9,0)
                  (9,1)  -> (9,1)
                  (10,0) -> (10,0)
                  (10,1) -> (10,1)
                  (11,0) -> (11,0)
                  (11,1) -> (11,1)
                  (12,0) -> (12,0)
                  (12,1) -> (12,1)
                  (13,0) -> (13,0)
                  (13,1) -> (13,1)
                  (14,0) -> (14,0)
                  (14,1) -> (14,1)
                  (15,0) -> (15,0)
                  (15,1) -> (15,1)
                }
              }
              ARCHITECTURE_DATA {
                ID:   5
                PREV: [7,1]
                NEXT: [0,4]
                POS:  (510,570)
              }
            }
            ARCHITECTURE_ELEMENT {
              TYPE: MACRO_INPUT
              INTERNAL_DATA {
                NAME:       MACRO_INPUT
                COMMENT:    
                INPUTS:     0
                OUTPUTS:    1
                INPUT_DIM:  (-,-)
                OUTPUT_DIM: (16,2)
                CLOCK:      0
                TIME:       0
              }
              LOGICAL_DATA {
                INPUT_NR: 0
              }
              ARCHITECTURE_DATA {
                ID:   6
                PREV: 
                NEXT: [2,1]
                POS:  (435,435)
              }
            }
            ARCHITECTURE_ELEMENT {
              TYPE: MACRO_INPUT
              INTERNAL_DATA {
                NAME:       MACRO_INPUT
                COMMENT:    
                INPUTS:     0
                OUTPUTS:    1
                INPUT_DIM:  (-,-)
                OUTPUT_DIM: (16,2)
                CLOCK:      0
                TIME:       0
              }
              LOGICAL_DATA {
                INPUT_NR: 3
              }
              ARCHITECTURE_DATA {
                ID:   7
                PREV: 
                NEXT: [5,1]
                POS:  (435,570)
              }
            }
            ARCHITECTURE_ELEMENT {
              TYPE: MACRO_INPUT
              INTERNAL_DATA {
                NAME:       MACRO_INPUT
                COMMENT:    
                INPUTS:     0
                OUTPUTS:    1
                INPUT_DIM:  (-,-)
                OUTPUT_DIM: (16,2)
                CLOCK:      0
                TIME:       0
              }
              LOGICAL_DATA {
                INPUT_NR: 2
              }
              ARCHITECTURE_DATA {
                ID:   8
                PREV: 
                NEXT: [4,1]
                POS:  (435,525)
              }
            }
            ARCHITECTURE_ELEMENT {
              TYPE: MACRO
              INTERNAL_DATA {
                NAME:       RCA 4
                COMMENT:    16x4 - Macro of the Ripple Carry Adder, 16 internal clocks required
                INPUTS:     1
                OUTPUTS:    1
                INPUT_DIM:  (16,8)
                OUTPUT_DIM: (16,8)
                CLOCK:      0
                TIME:       0
              }
              LOGICAL_DATA {
                REMARKS {
                }

                OPTIONS {
                  GRID {
                    VISIBLE:   ON
                    DIMENSION: (15,15)
                    RASTERIZE: ON
                  }
                }

                ARCHITECTURE_ELEMENTS {
                  NUMBER: 6
                  ELEMENTS {
                    ARCHITECTURE_ELEMENT {
                      TYPE: MACRO_OUTPUT
                      INTERNAL_DATA {
                        NAME:       MACRO_OUTPUT
                        COMMENT:    
                        INPUTS:     1
                        OUTPUTS:    0
                        INPUT_DIM:  (16,8)
                        OUTPUT_DIM: (-,-)
                        CLOCK:      0
                        TIME:       0
                      }
                      LOGICAL_DATA {
                        OUTPUT_NR: 0
                      }
                      ARCHITECTURE_DATA {
                        ID:   0
                        PREV: [1,1]
                        NEXT: 
                        POS:  (960,450)
                      }
                    }
                    ARCHITECTURE_ELEMENT {
                      TYPE: SPLIT
                      INTERNAL_DATA {
                        NAME:       SPLIT
                        COMMENT:    
                        INPUTS:     1
                        OUTPUTS:    2
                        INPUT_DIM:  (16,8)
                        OUTPUT_DIM: (16,8)(16,8)
                        CLOCK:      0
                        TIME:       0
                      }
                      LOGICAL_DATA {
                      }
                      ARCHITECTURE_DATA {
                        ID:   1
                        PREV: [3,1]
                        NEXT: [0,1][4,1]
                        POS:  (720,375)
                      }
                    }
                    ARCHITECTURE_ELEMENT {
                      TYPE: LOGIC
                      INTERNAL_DATA {
                        NAME:       LOGIC
                        COMMENT:    
                        INPUTS:     1
                        OUTPUTS:    1
                        INPUT_DIM:  (16,8)
                        OUTPUT_DIM: (16,8)
                        CLOCK:      1
                        TIME:       20
                      }
                      LOGICAL_DATA {
                        PE_DIMENSION: (1,2)
                        PE_DATA {
                          NAMES {
                            A
                            B
                          }
                        }
                        EXTERNAL_DATA {
                          NUMBER: 0
                          NAMES {
                          }
                        }
                        INTERNAL_DATA {
                          NUMBER: 0
                          NAMES {
                          }
                        }
                        EQUATION_DATA {
                          NUMBER: 2
                          EQUATIONS {
                            A = A xor B
                            B = A and B
                          }
                          COMPUTE_PARALLEL: OFF
                        }
                      }
                      ARCHITECTURE_DATA {
                        ID:   2
                        PREV: [4,1]
                        NEXT: [3,1]
                        POS:  (720,480)
                      }
                    }
                    ARCHITECTURE_ELEMENT {
                      TYPE: PERM
                      INTERNAL_DATA {
                        NAME:       PERM
                        COMMENT:    
                        INPUTS:     1
                        OUTPUTS:    1
                        INPUT_DIM:  (16,8)
                        OUTPUT_DIM: (16,8)
                        CLOCK:      0
                        TIME:       0
                      }
                      LOGICAL_DATA {
                        CONNECTIONS {
                          (0,0)  -> (0,0)
                          (0,1)  -> (-,-)
                          (0,2)  -> (0,2)
                          (0,3)  -> (-,-)
                          (0,4)  -> (0,4)
                          (0,5)  -> (-,-)
                          (0,6)  -> (0,6)
                          (0,7)  -> (-,-)
                          (1,0)  -> (1,0)
                          (1,1)  -> (0,1)
                          (1,2)  -> (1,2)
                          (1,3)  -> (0,3)
                          (1,4)  -> (1,4)
                          (1,5)  -> (0,5)
                          (1,6)  -> (1,6)
                          (1,7)  -> (0,7)
                          (2,0)  -> (2,0)
                          (2,1)  -> (1,1)
                          (2,2)  -> (2,2)
                          (2,3)  -> (1,3)
                          (2,4)  -> (2,4)
                          (2,5)  -> (1,5)
                          (2,6)  -> (2,6)
                          (2,7)  -> (1,7)
                          (3,0)  -> (3,0)
                          (3,1)  -> (2,1)
                          (3,2)  -> (3,2)
                          (3,3)  -> (2,3)
                          (3,4)  -> (3,4)
                          (3,5)  -> (2,5)
                          (3,6)  -> (3,6)
                          (3,7)  -> (2,7)
                          (4,0)  -> (4,0)
                          (4,1)  -> (3,1)
                          (4,2)  -> (4,2)
                          (4,3)  -> (3,3)
                          (4,4)  -> (4,4)
                          (4,5)  -> (3,5)
                          (4,6)  -> (4,6)
                          (4,7)  -> (3,7)
                          (5,0)  -> (5,0)
                          (5,1)  -> (4,1)
                          (5,2)  -> (5,2)
                          (5,3)  -> (4,3)
                          (5,4)  -> (5,4)
                          (5,5)  -> (4,5)
                          (5,6)  -> (5,6)
                          (5,7)  -> (4,7)
                          (6,0)  -> (6,0)
                          (6,1)  -> (5,1)
                          (6,2)  -> (6,2)
                          (6,3)  -> (5,3)
                          (6,4)  -> (6,4)
                          (6,5)  -> (5,5)
                          (6,6)  -> (6,6)
                          (6,7)  -> (5,7)
                          (7,0)  -> (7,0)
                          (7,1)  -> (6,1)
                          (7,2)  -> (7,2)
                          (7,3)  -> (6,3)
                          (7,4)  -> (7,4)
                          (7,5)  -> (6,5)
                          (7,6)  -> (7,6)
                          (7,7)  -> (6,7)
                          (8,0)  -> (8,0)
                          (8,1)  -> (7,1)
                          (8,2)  -> (8,2)
                          (8,3)  -> (7,3)
                          (8,4)  -> (8,4)
                          (8,5)  -> (7,5)
                          (8,6)  -> (8,6)
                          (8,7)  -> (7,7)
                          (9,0)  -> (9,0)
                          (9,1)  -> (8,1)
                          (9,2)  -> (9,2)
                          (9,3)  -> (8,3)
                          (9,4)  -> (9,4)
                          (9,5)  -> (8,5)
                          (9,6)  -> (9,6)
                          (9,7)  -> (8,7)
                          (10,0) -> (10,0)
                          (10,1) -> (9,1)
                          (10,2) -> (10,2)
                          (10,3) -> (9,3)
                          (10,4) -> (10,4)
                          (10,5) -> (9,5)
                          (10,6) -> (10,6)
                          (10,7) -> (9,7)
                          (11,0) -> (11,0)
                          (11,1) -> (10,1)
                          (11,2) -> (11,2)
                          (11,3) -> (10,3)
                          (11,4) -> (11,4)
                          (11,5) -> (10,5)
                          (11,6) -> (11,6)
                          (11,7) -> (10,7)
                          (12,0) -> (12,0)
                          (12,1) -> (11,1)
                          (12,2) -> (12,2)
                          (12,3) -> (11,3)
                          (12,4) -> (12,4)
                          (12,5) -> (11,5)
                          (12,6) -> (12,6)
                          (12,7) -> (11,7)
                          (13,0) -> (13,0)
                          (13,1) -> (12,1)
                          (13,2) -> (13,2)
                          (13,3) -> (12,3)
                          (13,4) -> (13,4)
                          (13,5) -> (12,5)
                          (13,6) -> (13,6)
                          (13,7) -> (12,7)
                          (14,0) -> (14,0)
                          (14,1) -> (13,1)
                          (14,2) -> (14,2)
                          (14,3) -> (13,3)
                          (14,4) -> (14,4)
                          (14,5) -> (13,5)
                          (14,6) -> (14,6)
                          (14,7) -> (13,7)
                          (15,0) -> (15,0)
                          (15,1) -> (14,1)
                          (15,2) -> (15,2)
                          (15,3) -> (14,3)
                          (15,4) -> (15,4)
                          (15,5) -> (14,5)
                          (15,6) -> (15,6)
                          (15,7) -> (14,7)
                        }
                      }
                      ARCHITECTURE_DATA {
                        ID:   3
                        PREV: [2,1]
                        NEXT: [1,1]
                        POS:  (810,480)
                      }
                    }
                    ARCHITECTURE_ELEMENT {
                      TYPE: JOIN
                      INTERNAL_DATA {
                        NAME:       JOIN
                        COMMENT:    
                        INPUTS:     2
                        OUTPUTS:    1
                        INPUT_DIM:  (16,8)(16,8)
                        OUTPUT_DIM: (16,8)
                        CLOCK:      0
                        TIME:       0
                      }
                      LOGICAL_DATA{
                        RULE: OR
                      }
                      ARCHITECTURE_DATA {
                        ID:   4
                        PREV: [1,2][5,1]
                        NEXT: [2,1]
                        POS:  (630,480)
                      }
                    }
                    ARCHITECTURE_ELEMENT {
                      TYPE: MACRO_INPUT
                      INTERNAL_DATA {
                        NAME:       MACRO_INPUT
                        COMMENT:    
                        INPUTS:     0
                        OUTPUTS:    1
                        INPUT_DIM:  (-,-)
                        OUTPUT_DIM: (16,8)
                        CLOCK:      0
                        TIME:       0
                      }
                      LOGICAL_DATA {
                        INPUT_NR: 0
                      }
                      ARCHITECTURE_DATA {
                        ID:   5
                        PREV: 
                        NEXT: [4,2]
                        POS:  (510,450)
                      }
                    }
                  }
                }
              }
              ARCHITECTURE_DATA {
                ID:   9
                PREV: [0,1]
                NEXT: [10,1]
                POS:  (705,480)
              }
            }
            ARCHITECTURE_ELEMENT {
              TYPE: SPLIT
              INTERNAL_DATA {
                NAME:       SPLIT
                COMMENT:    
                INPUTS:     1
                OUTPUTS:    4
                INPUT_DIM:  (16,8)
                OUTPUT_DIM: (16,8)(16,8)(16,8)(16,8)
                CLOCK:      0
                TIME:       0
              }
              LOGICAL_DATA {
              }
              ARCHITECTURE_DATA {
                ID:   10
                PREV: [9,1]
                NEXT: [11,1][12,1][13,1][18,1]
                POS:  (810,480)
              }
            }
            ARCHITECTURE_ELEMENT {
              TYPE: PERM
              INTERNAL_DATA {
                NAME:       PERM
                COMMENT:    
                INPUTS:     1
                OUTPUTS:    1
                INPUT_DIM:  (16,8)
                OUTPUT_DIM: (16,1)
                CLOCK:      0
                TIME:       0
              }
              LOGICAL_DATA {
                CONNECTIONS {
                  (0,0)  -> (-,-)
                  (0,1)  -> (-,-)
                  (0,2)  -> (-,-)
                  (0,3)  -> (-,-)
                  (0,4)  -> (-,-)
                  (0,5)  -> (-,-)
                  (0,6)  -> (0,0)
                  (0,7)  -> (-,-)
                  (1,0)  -> (-,-)
                  (1,1)  -> (-,-)
                  (1,2)  -> (-,-)
                  (1,3)  -> (-,-)
                  (1,4)  -> (-,-)
                  (1,5)  -> (-,-)
                  (1,6)  -> (1,0)
                  (1,7)  -> (-,-)
                  (2,0)  -> (-,-)
                  (2,1)  -> (-,-)
                  (2,2)  -> (-,-)
                  (2,3)  -> (-,-)
                  (2,4)  -> (-,-)
                  (2,5)  -> (-,-)
                  (2,6)  -> (2,0)
                  (2,7)  -> (-,-)
                  (3,0)  -> (-,-)
                  (3,1)  -> (-,-)
                  (3,2)  -> (-,-)
                  (3,3)  -> (-,-)
                  (3,4)  -> (-,-)
                  (3,5)  -> (-,-)
                  (3,6)  -> (3,0)
                  (3,7)  -> (-,-)
                  (4,0)  -> (-,-)
                  (4,1)  -> (-,-)
                  (4,2)  -> (-,-)
                  (4,3)  -> (-,-)
                  (4,4)  -> (-,-)
                  (4,5)  -> (-,-)
                  (4,6)  -> (4,0)
                  (4,7)  -> (-,-)
                  (5,0)  -> (-,-)
                  (5,1)  -> (-,-)
                  (5,2)  -> (-,-)
                  (5,3)  -> (-,-)
                  (5,4)  -> (-,-)
                  (5,5)  -> (-,-)
                  (5,6)  -> (5,0)
                  (5,7)  -> (-,-)
                  (6,0)  -> (-,-)
                  (6,1)  -> (-,-)
                  (6,2)  -> (-,-)
                  (6,3)  -> (-,-)
                  (6,4)  -> (-,-)
                  (6,5)  -> (-,-)
                  (6,6)  -> (6,0)
                  (6,7)  -> (-,-)
                  (7,0)  -> (-,-)
                  (7,1)  -> (-,-)
                  (7,2)  -> (-,-)
                  (7,3)  -> (-,-)
                  (7,4)  -> (-,-)
                  (7,5)  -> (-,-)
                  (7,6)  -> (7,0)
                  (7,7)  -> (-,-)
                  (8,0)  -> (-,-)
                  (8,1)  -> (-,-)
                  (8,2)  -> (-,-)
                  (8,3)  -> (-,-)
                  (8,4)  -> (-,-)
                  (8,5)  -> (-,-)
                  (8,6)  -> (8,0)
                  (8,7)  -> (-,-)
                  (9,0)  -> (-,-)
                  (9,1)  -> (-,-)
                  (9,2)  -> (-,-)
                  (9,3)  -> (-,-)
                  (9,4)  -> (-,-)
                  (9,5)  -> (-,-)
                  (9,6)  -> (9,0)
                  (9,7)  -> (-,-)
                  (10,0) -> (-,-)
                  (10,1) -> (-,-)
                  (10,2) -> (-,-)
                  (10,3) -> (-,-)
                  (10,4) -> (-,-)
                  (10,5) -> (-,-)
                  (10,6) -> (10,0)
                  (10,7) -> (-,-)
                  (11,0) -> (-,-)
                  (11,1) -> (-,-)
                  (11,2) -> (-,-)
                  (11,3) -> (-,-)
                  (11,4) -> (-,-)
                  (11,5) -> (-,-)
                  (11,6) -> (11,0)
                  (11,7) -> (-,-)
                  (12,0) -> (-,-)
                  (12,1) -> (-,-)
                  (12,2) -> (-,-)
                  (12,3) -> (-,-)
                  (12,4) -> (-,-)
                  (12,5) -> (-,-)
                  (12,6) -> (12,0)
                  (12,7) -> (-,-)
                  (13,0) -> (-,-)
                  (13,1) -> (-,-)
                  (13,2) -> (-,-)
                  (13,3) -> (-,-)
                  (13,4) -> (-,-)
                  (13,5) -> (-,-)
                  (13,6) -> (13,0)
                  (13,7) -> (-,-)
                  (14,0) -> (-,-)
                  (14,1) -> (-,-)
                  (14,2) -> (-,-)
                  (14,3) -> (-,-)
                  (14,4) -> (-,-)
                  (14,5) -> (-,-)
                  (14,6) -> (14,0)
                  (14,7) -> (-,-)
                  (15,0) -> (-,-)
                  (15,1) -> (-,-)
                  (15,2) -> (-,-)
                  (15,3) -> (-,-)
                  (15,4) -> (-,-)
                  (15,5) -> (-,-)
                  (15,6) -> (15,0)
                  (15,7) -> (-,-)
                }
              }
              ARCHITECTURE_DATA {
                ID:   11
                PREV: [10,1]
                NEXT: [15,1]
                POS:  (900,435)
              }
            }
            ARCHITECTURE_ELEMENT {
              TYPE: PERM
              INTERNAL_DATA {
                NAME:       PERM
                COMMENT:    
                INPUTS:     1
                OUTPUTS:    1
                INPUT_DIM:  (16,8)
                OUTPUT_DIM: (16,1)
                CLOCK:      0
                TIME:       0
              }
              LOGICAL_DATA {
                CONNECTIONS {
                  (0,0)  -> (-,-)
                  (0,1)  -> (-,-)
                  (0,2)  -> (-,-)
                  (0,3)  -> (-,-)
                  (0,4)  -> (0,0)
                  (0,5)  -> (-,-)
                  (0,6)  -> (-,-)
                  (0,7)  -> (-,-)
                  (1,0)  -> (-,-)
                  (1,1)  -> (-,-)
                  (1,2)  -> (-,-)
                  (1,3)  -> (-,-)
                  (1,4)  -> (1,0)
                  (1,5)  -> (-,-)
                  (1,6)  -> (-,-)
                  (1,7)  -> (-,-)
                  (2,0)  -> (-,-)
                  (2,1)  -> (-,-)
                  (2,2)  -> (-,-)
                  (2,3)  -> (-,-)
                  (2,4)  -> (2,0)
                  (2,5)  -> (-,-)
                  (2,6)  -> (-,-)
                  (2,7)  -> (-,-)
                  (3,0)  -> (-,-)
                  (3,1)  -> (-,-)
                  (3,2)  -> (-,-)
                  (3,3)  -> (-,-)
                  (3,4)  -> (3,0)
                  (3,5)  -> (-,-)
                  (3,6)  -> (-,-)
                  (3,7)  -> (-,-)
                  (4,0)  -> (-,-)
                  (4,1)  -> (-,-)
                  (4,2)  -> (-,-)
                  (4,3)  -> (-,-)
                  (4,4)  -> (4,0)
                  (4,5)  -> (-,-)
                  (4,6)  -> (-,-)
                  (4,7)  -> (-,-)
                  (5,0)  -> (-,-)
                  (5,1)  -> (-,-)
                  (5,2)  -> (-,-)
                  (5,3)  -> (-,-)
                  (5,4)  -> (5,0)
                  (5,5)  -> (-,-)
                  (5,6)  -> (-,-)
                  (5,7)  -> (-,-)
                  (6,0)  -> (-,-)
                  (6,1)  -> (-,-)
                  (6,2)  -> (-,-)
                  (6,3)  -> (-,-)
                  (6,4)  -> (6,0)
                  (6,5)  -> (-,-)
                  (6,6)  -> (-,-)
                  (6,7)  -> (-,-)
                  (7,0)  -> (-,-)
                  (7,1)  -> (-,-)
                  (7,2)  -> (-,-)
                  (7,3)  -> (-,-)
                  (7,4)  -> (7,0)
                  (7,5)  -> (-,-)
                  (7,6)  -> (-,-)
                  (7,7)  -> (-,-)
                  (8,0)  -> (-,-)
                  (8,1)  -> (-,-)
                  (8,2)  -> (-,-)
                  (8,3)  -> (-,-)
                  (8,4)  -> (8,0)
                  (8,5)  -> (-,-)
                  (8,6)  -> (-,-)
                  (8,7)  -> (-,-)
                  (9,0)  -> (-,-)
                  (9,1)  -> (-,-)
                  (9,2)  -> (-,-)
                  (9,3)  -> (-,-)
                  (9,4)  -> (9,0)
                  (9,5)  -> (-,-)
                  (9,6)  -> (-,-)
                  (9,7)  -> (-,-)
                  (10,0) -> (-,-)
                  (10,1) -> (-,-)
                  (10,2) -> (-,-)
                  (10,3) -> (-,-)
                  (10,4) -> (10,0)
                  (10,5) -> (-,-)
                  (10,6) -> (-,-)
                  (10,7) -> (-,-)
                  (11,0) -> (-,-)
                  (11,1) -> (-,-)
                  (11,2) -> (-,-)
                  (11,3) -> (-,-)
                  (11,4) -> (11,0)
                  (11,5) -> (-,-)
                  (11,6) -> (-,-)
                  (11,7) -> (-,-)
                  (12,0) -> (-,-)
                  (12,1) -> (-,-)
                  (12,2) -> (-,-)
                  (12,3) -> (-,-)
                  (12,4) -> (12,0)
                  (12,5) -> (-,-)
                  (12,6) -> (-,-)
                  (12,7) -> (-,-)
                  (13,0) -> (-,-)
                  (13,1) -> (-,-)
                  (13,2) -> (-,-)
                  (13,3) -> (-,-)
                  (13,4) -> (13,0)
                  (13,5) -> (-,-)
                  (13,6) -> (-,-)
                  (13,7) -> (-,-)
                  (14,0) -> (-,-)
                  (14,1) -> (-,-)
                  (14,2) -> (-,-)
                  (14,3) -> (-,-)
                  (14,4) -> (14,0)
                  (14,5) -> (-,-)
                  (14,6) -> (-,-)
                  (14,7) -> (-,-)
                  (15,0) -> (-,-)
                  (15,1) -> (-,-)
                  (15,2) -> (-,-)
                  (15,3) -> (-,-)
                  (15,4) -> (15,0)
                  (15,5) -> (-,-)
                  (15,6) -> (-,-)
                  (15,7) -> (-,-)
                }
              }
              ARCHITECTURE_DATA {
                ID:   12
                PREV: [10,2]
                NEXT: [14,1]
                POS:  (900,480)
              }
            }
            ARCHITECTURE_ELEMENT {
              TYPE: PERM
              INTERNAL_DATA {
                NAME:       PERM
                COMMENT:    
                INPUTS:     1
                OUTPUTS:    1
                INPUT_DIM:  (16,8)
                OUTPUT_DIM: (16,1)
                CLOCK:      0
                TIME:       0
              }
              LOGICAL_DATA {
                CONNECTIONS {
                  (0,0)  -> (-,-)
                  (0,1)  -> (-,-)
                  (0,2)  -> (0,0)
                  (0,3)  -> (-,-)
                  (0,4)  -> (-,-)
                  (0,5)  -> (-,-)
                  (0,6)  -> (-,-)
                  (0,7)  -> (-,-)
                  (1,0)  -> (-,-)
                  (1,1)  -> (-,-)
                  (1,2)  -> (1,0)
                  (1,3)  -> (-,-)
                  (1,4)  -> (-,-)
                  (1,5)  -> (-,-)
                  (1,6)  -> (-,-)
                  (1,7)  -> (-,-)
                  (2,0)  -> (-,-)
                  (2,1)  -> (-,-)
                  (2,2)  -> (2,0)
                  (2,3)  -> (-,-)
                  (2,4)  -> (-,-)
                  (2,5)  -> (-,-)
                  (2,6)  -> (-,-)
                  (2,7)  -> (-,-)
                  (3,0)  -> (-,-)
                  (3,1)  -> (-,-)
                  (3,2)  -> (3,0)
                  (3,3)  -> (-,-)
                  (3,4)  -> (-,-)
                  (3,5)  -> (-,-)
                  (3,6)  -> (-,-)
                  (3,7)  -> (-,-)
                  (4,0)  -> (-,-)
                  (4,1)  -> (-,-)
                  (4,2)  -> (4,0)
                  (4,3)  -> (-,-)
                  (4,4)  -> (-,-)
                  (4,5)  -> (-,-)
                  (4,6)  -> (-,-)
                  (4,7)  -> (-,-)
                  (5,0)  -> (-,-)
                  (5,1)  -> (-,-)
                  (5,2)  -> (5,0)
                  (5,3)  -> (-,-)
                  (5,4)  -> (-,-)
                  (5,5)  -> (-,-)
                  (5,6)  -> (-,-)
                  (5,7)  -> (-,-)
                  (6,0)  -> (-,-)
                  (6,1)  -> (-,-)
                  (6,2)  -> (6,0)
                  (6,3)  -> (-,-)
                  (6,4)  -> (-,-)
                  (6,5)  -> (-,-)
                  (6,6)  -> (-,-)
                  (6,7)  -> (-,-)
                  (7,0)  -> (-,-)
                  (7,1)  -> (-,-)
                  (7,2)  -> (7,0)
                  (7,3)  -> (-,-)
                  (7,4)  -> (-,-)
                  (7,5)  -> (-,-)
                  (7,6)  -> (-,-)
                  (7,7)  -> (-,-)
                  (8,0)  -> (-,-)
                  (8,1)  -> (-,-)
                  (8,2)  -> (8,0)
                  (8,3)  -> (-,-)
                  (8,4)  -> (-,-)
                  (8,5)  -> (-,-)
                  (8,6)  -> (-,-)
                  (8,7)  -> (-,-)
                  (9,0)  -> (-,-)
                  (9,1)  -> (-,-)
                  (9,2)  -> (9,0)
                  (9,3)  -> (-,-)
                  (9,4)  -> (-,-)
                  (9,5)  -> (-,-)
                  (9,6)  -> (-,-)
                  (9,7)  -> (-,-)
                  (10,0) -> (-,-)
                  (10,1) -> (-,-)
                  (10,2) -> (10,0)
                  (10,3) -> (-,-)
                  (10,4) -> (-,-)
                  (10,5) -> (-,-)
                  (10,6) -> (-,-)
                  (10,7) -> (-,-)
                  (11,0) -> (-,-)
                  (11,1) -> (-,-)
                  (11,2) -> (11,0)
                  (11,3) -> (-,-)
                  (11,4) -> (-,-)
                  (11,5) -> (-,-)
                  (11,6) -> (-,-)
                  (11,7) -> (-,-)
                  (12,0) -> (-,-)
                  (12,1) -> (-,-)
                  (12,2) -> (12,0)
                  (12,3) -> (-,-)
                  (12,4) -> (-,-)
                  (12,5) -> (-,-)
                  (12,6) -> (-,-)
                  (12,7) -> (-,-)
                  (13,0) -> (-,-)
                  (13,1) -> (-,-)
                  (13,2) -> (13,0)
                  (13,3) -> (-,-)
                  (13,4) -> (-,-)
                  (13,5) -> (-,-)
                  (13,6) -> (-,-)
                  (13,7) -> (-,-)
                  (14,0) -> (-,-)
                  (14,1) -> (-,-)
                  (14,2) -> (14,0)
                  (14,3) -> (-,-)
                  (14,4) -> (-,-)
                  (14,5) -> (-,-)
                  (14,6) -> (-,-)
                  (14,7) -> (-,-)
                  (15,0) -> (-,-)
                  (15,1) -> (-,-)
                  (15,2) -> (15,0)
                  (15,3) -> (-,-)
                  (15,4) -> (-,-)
                  (15,5) -> (-,-)
                  (15,6) -> (-,-)
                  (15,7) -> (-,-)
                }
              }
              ARCHITECTURE_DATA {
                ID:   13
                PREV: [10,3]
                NEXT: [17,1]
                POS:  (900,525)
              }
            }
            ARCHITECTURE_ELEMENT {
              TYPE: MACRO_OUTPUT
              INTERNAL_DATA {
                NAME:       MACRO_OUTPUT
                COMMENT:    
                INPUTS:     1
                OUTPUTS:    0
                INPUT_DIM:  (16,1)
                OUTPUT_DIM: (-,-)
                CLOCK:      0
                TIME:       0
              }
              LOGICAL_DATA {
                OUTPUT_NR: 1
              }
              ARCHITECTURE_DATA {
                ID:   14
                PREV: [12,1]
                NEXT: 
                POS:  (990,480)
              }
            }
            ARCHITECTURE_ELEMENT {
              TYPE: MACRO_OUTPUT
              INTERNAL_DATA {
                NAME:       MACRO_OUTPUT
                COMMENT:    
                INPUTS:     1
                OUTPUTS:    0
                INPUT_DIM:  (16,1)
                OUTPUT_DIM: (-,-)
                CLOCK:      0
                TIME:       0
              }
              LOGICAL_DATA {
                OUTPUT_NR: 0
              }
              ARCHITECTURE_DATA {
                ID:   15
                PREV: [11,1]
                NEXT: 
                POS:  (990,435)
              }
            }
            ARCHITECTURE_ELEMENT {
              TYPE: MACRO_OUTPUT
              INTERNAL_DATA {
                NAME:       MACRO_OUTPUT
                COMMENT:    
                INPUTS:     1
                OUTPUTS:    0
                INPUT_DIM:  (16,1)
                OUTPUT_DIM: (-,-)
                CLOCK:      0
                TIME:       0
              }
              LOGICAL_DATA {
                OUTPUT_NR: 3
              }
              ARCHITECTURE_DATA {
                ID:   16
                PREV: [18,1]
                NEXT: 
                POS:  (990,570)
              }
            }
            ARCHITECTURE_ELEMENT {
              TYPE: MACRO_OUTPUT
              INTERNAL_DATA {
                NAME:       MACRO_OUTPUT
                COMMENT:    
                INPUTS:     1
                OUTPUTS:    0
                INPUT_DIM:  (16,1)
                OUTPUT_DIM: (-,-)
                CLOCK:      0
                TIME:       0
              }
              LOGICAL_DATA {
                OUTPUT_NR: 2
              }
              ARCHITECTURE_DATA {
                ID:   17
                PREV: [13,1]
                NEXT: 
                POS:  (990,525)
              }
            }
            ARCHITECTURE_ELEMENT {
              TYPE: PERM
              INTERNAL_DATA {
                NAME:       PERM
                COMMENT:    
                INPUTS:     1
                OUTPUTS:    1
                INPUT_DIM:  (16,8)
                OUTPUT_DIM: (16,1)
                CLOCK:      0
                TIME:       0
              }
              LOGICAL_DATA {
                CONNECTIONS {
                  (0,0)  -> (0,0)
                  (0,1)  -> (-,-)
                  (0,2)  -> (-,-)
                  (0,3)  -> (-,-)
                  (0,4)  -> (-,-)
                  (0,5)  -> (-,-)
                  (0,6)  -> (-,-)
                  (0,7)  -> (-,-)
                  (1,0)  -> (1,0)
                  (1,1)  -> (-,-)
                  (1,2)  -> (-,-)
                  (1,3)  -> (-,-)
                  (1,4)  -> (-,-)
                  (1,5)  -> (-,-)
                  (1,6)  -> (-,-)
                  (1,7)  -> (-,-)
                  (2,0)  -> (2,0)
                  (2,1)  -> (-,-)
                  (2,2)  -> (-,-)
                  (2,3)  -> (-,-)
                  (2,4)  -> (-,-)
                  (2,5)  -> (-,-)
                  (2,6)  -> (-,-)
                  (2,7)  -> (-,-)
                  (3,0)  -> (3,0)
                  (3,1)  -> (-,-)
                  (3,2)  -> (-,-)
                  (3,3)  -> (-,-)
                  (3,4)  -> (-,-)
                  (3,5)  -> (-,-)
                  (3,6)  -> (-,-)
                  (3,7)  -> (-,-)
                  (4,0)  -> (4,0)
                  (4,1)  -> (-,-)
                  (4,2)  -> (-,-)
                  (4,3)  -> (-,-)
                  (4,4)  -> (-,-)
                  (4,5)  -> (-,-)
                  (4,6)  -> (-,-)
                  (4,7)  -> (-,-)
                  (5,0)  -> (5,0)
                  (5,1)  -> (-,-)
                  (5,2)  -> (-,-)
                  (5,3)  -> (-,-)
                  (5,4)  -> (-,-)
                  (5,5)  -> (-,-)
                  (5,6)  -> (-,-)
                  (5,7)  -> (-,-)
                  (6,0)  -> (6,0)
                  (6,1)  -> (-,-)
                  (6,2)  -> (-,-)
                  (6,3)  -> (-,-)
                  (6,4)  -> (-,-)
                  (6,5)  -> (-,-)
                  (6,6)  -> (-,-)
                  (6,7)  -> (-,-)
                  (7,0)  -> (7,0)
                  (7,1)  -> (-,-)
                  (7,2)  -> (-,-)
                  (7,3)  -> (-,-)
                  (7,4)  -> (-,-)
                  (7,5)  -> (-,-)
                  (7,6)  -> (-,-)
                  (7,7)  -> (-,-)
                  (8,0)  -> (8,0)
                  (8,1)  -> (-,-)
                  (8,2)  -> (-,-)
                  (8,3)  -> (-,-)
                  (8,4)  -> (-,-)
                  (8,5)  -> (-,-)
                  (8,6)  -> (-,-)
                  (8,7)  -> (-,-)
                  (9,0)  -> (9,0)
                  (9,1)  -> (-,-)
                  (9,2)  -> (-,-)
                  (9,3)  -> (-,-)
                  (9,4)  -> (-,-)
                  (9,5)  -> (-,-)
                  (9,6)  -> (-,-)
                  (9,7)  -> (-,-)
                  (10,0) -> (10,0)
                  (10,1) -> (-,-)
                  (10,2) -> (-,-)
                  (10,3) -> (-,-)
                  (10,4) -> (-,-)
                  (10,5) -> (-,-)
                  (10,6) -> (-,-)
                  (10,7) -> (-,-)
                  (11,0) -> (11,0)
                  (11,1) -> (-,-)
                  (11,2) -> (-,-)
                  (11,3) -> (-,-)
                  (11,4) -> (-,-)
                  (11,5) -> (-,-)
                  (11,6) -> (-,-)
                  (11,7) -> (-,-)
                  (12,0) -> (12,0)
                  (12,1) -> (-,-)
                  (12,2) -> (-,-)
                  (12,3) -> (-,-)
                  (12,4) -> (-,-)
                  (12,5) -> (-,-)
                  (12,6) -> (-,-)
                  (12,7) -> (-,-)
                  (13,0) -> (13,0)
                  (13,1) -> (-,-)
                  (13,2) -> (-,-)
                  (13,3) -> (-,-)
                  (13,4) -> (-,-)
                  (13,5) -> (-,-)
                  (13,6) -> (-,-)
                  (13,7) -> (-,-)
                  (14,0) -> (14,0)
                  (14,1) -> (-,-)
                  (14,2) -> (-,-)
                  (14,3) -> (-,-)
                  (14,4) -> (-,-)
                  (14,5) -> (-,-)
                  (14,6) -> (-,-)
                  (14,7) -> (-,-)
                  (15,0) -> (15,0)
                  (15,1) -> (-,-)
                  (15,2) -> (-,-)
                  (15,3) -> (-,-)
                  (15,4) -> (-,-)
                  (15,5) -> (-,-)
                  (15,6) -> (-,-)
                  (15,7) -> (-,-)
                }
              }
              ARCHITECTURE_DATA {
                ID:   18
                PREV: [10,4]
                NEXT: [16,1]
                POS:  (900,570)
              }
            }
          }
        }
      }
      ARCHITECTURE_DATA {
        ID:   0
        PREV: [1,1][2,1][3,1][4,1]
        NEXT: [5,1][6,1][7,1][8,1]
        POS:  (735,465)
      }
    }
    ARCHITECTURE_ELEMENT {
      TYPE: INPUT
      INTERNAL_DATA {
        NAME:       INPUT
        COMMENT:    
        INPUTS:     1
        OUTPUTS:    1
        INPUT_DIM:  (16,2)
        OUTPUT_DIM: (16,2)
        CLOCK:      1
        TIME:       10
      }
      LOGICAL_DATA {
        XY_PLANE_DATA {
          NUMBER: 1
          PLANES {
            MATRIX {
              DIMENSION: (16,2)
              DATA {
                0000000010001001
                0000000100000010
              }
            }
          }
        }
      }
      ARCHITECTURE_DATA {
        ID:   1
        PREV: [-,-]
        NEXT: [0,1]
        POS:  (585,420)
      }
    }
    ARCHITECTURE_ELEMENT {
      TYPE: INPUT
      INTERNAL_DATA {
        NAME:       INPUT
        COMMENT:    
        INPUTS:     1
        OUTPUTS:    1
        INPUT_DIM:  (16,2)
        OUTPUT_DIM: (16,2)
        CLOCK:      1
        TIME:       10
      }
      LOGICAL_DATA {
        XY_PLANE_DATA {
          NUMBER: 1
          PLANES {
            MATRIX {
              DIMENSION: (16,2)
              DATA {
                0011000001100011
                0101001011011111
              }
            }
          }
        }
      }
      ARCHITECTURE_DATA {
        ID:   2
        PREV: [-,-]
        NEXT: [0,2]
        POS:  (585,465)
      }
    }
    ARCHITECTURE_ELEMENT {
      TYPE: INPUT
      INTERNAL_DATA {
        NAME:       INPUT
        COMMENT:    
        INPUTS:     1
        OUTPUTS:    1
        INPUT_DIM:  (16,2)
        OUTPUT_DIM: (16,2)
        CLOCK:      1
        TIME:       10
      }
      LOGICAL_DATA {
        XY_PLANE_DATA {
          NUMBER: 1
          PLANES {
            MATRIX {
              DIMENSION: (16,2)
              DATA {
                1110111001001000
                0000000000000000
              }
            }
          }
        }
      }
      ARCHITECTURE_DATA {
        ID:   3
        PREV: [-,-]
        NEXT: [0,3]
        POS:  (585,510)
      }
    }
    ARCHITECTURE_ELEMENT {
      TYPE: INPUT
      INTERNAL_DATA {
        NAME:       INPUT
        COMMENT:    
        INPUTS:     1
        OUTPUTS:    1
        INPUT_DIM:  (16,2)
        OUTPUT_DIM: (16,2)
        CLOCK:      1
        TIME:       10
      }
      LOGICAL_DATA {
        XY_PLANE_DATA {
          NUMBER: 1
          PLANES {
            MATRIX {
              DIMENSION: (16,2)
              DATA {
                0100110001110100
                0000000000000001
              }
            }
          }
        }
      }
      ARCHITECTURE_DATA {
        ID:   4
        PREV: [-,-]
        NEXT: [0,4]
        POS:  (585,555)
      }
    }
    ARCHITECTURE_ELEMENT {
      TYPE: OUTPUT
      INTERNAL_DATA {
        NAME:       OUTPUT
        COMMENT:    
        INPUTS:     1
        OUTPUTS:    1
        INPUT_DIM:  (16,1)
        OUTPUT_DIM: (16,1)
        CLOCK:      1
        TIME:       10
      }
      LOGICAL_DATA {
        NUMBER_PLANES: 1
      }
      ARCHITECTURE_DATA {
        ID:   5
        PREV: [0,1]
        NEXT: [-,-]
        POS:  (885,420)
      }
    }
    ARCHITECTURE_ELEMENT {
      TYPE: OUTPUT
      INTERNAL_DATA {
        NAME:       OUTPUT
        COMMENT:    
        INPUTS:     1
        OUTPUTS:    1
        INPUT_DIM:  (16,1)
        OUTPUT_DIM: (16,1)
        CLOCK:      1
        TIME:       10
      }
      LOGICAL_DATA {
        NUMBER_PLANES: 1
      }
      ARCHITECTURE_DATA {
        ID:   6
        PREV: [0,2]
        NEXT: [-,-]
        POS:  (885,465)
      }
    }
    ARCHITECTURE_ELEMENT {
      TYPE: OUTPUT
      INTERNAL_DATA {
        NAME:       OUTPUT
        COMMENT:    
        INPUTS:     1
        OUTPUTS:    1
        INPUT_DIM:  (16,1)
        OUTPUT_DIM: (16,1)
        CLOCK:      1
        TIME:       10
      }
      LOGICAL_DATA {
        NUMBER_PLANES: 1
      }
      ARCHITECTURE_DATA {
        ID:   7
        PREV: [0,3]
        NEXT: [-,-]
        POS:  (885,510)
      }
    }
    ARCHITECTURE_ELEMENT {
      TYPE: OUTPUT
      INTERNAL_DATA {
        NAME:       OUTPUT
        COMMENT:    
        INPUTS:     1
        OUTPUTS:    1
        INPUT_DIM:  (16,1)
        OUTPUT_DIM: (16,1)
        CLOCK:      1
        TIME:       10
      }
      LOGICAL_DATA {
        NUMBER_PLANES: 1
      }
      ARCHITECTURE_DATA {
        ID:   8
        PREV: [0,4]
        NEXT: [-,-]
        POS:  (885,555)
      }
    }
  }
}

