#
# HADLOP Pro written by Guido Grimm and Marko Degenkolb
#

REMARKS {
}

OPTIONS {
  GRID {
    VISIBLE:   ON
    DIMENSION: (10,10)
    RASTERIZE: ON
  }
}

GLOBAL_ARCHITECTURE_DATA {
  DIMENSION:        (8,8)
  CLOCKS {
    NUMBER: 5
    CLOCK {
      TIME:   100
      OFFSET: 0
    }
    CLOCK {
      TIME:   100
      OFFSET: 50
    }
    CLOCK {
      TIME:   100
      OFFSET: 100
    }
    CLOCK {
      TIME:   100
      OFFSET: 200
    }
    CLOCK {
      TIME:   100
      OFFSET: 300
    }
  }
  SIMULATION_DATA {
    MODE:     CLOCKS
    CLOCK_NR: 1
    CLOCKS:   4
  }
}

ARCHITECTURE_ELEMENTS {
  NUMBER: 11
  ELEMENTS {
    ARCHITECTURE_ELEMENT {
      TYPE: INPUT
      INTERNAL_DATA {
        NAME:       INPUT
        COMMENT:    
        INPUTS:     1
        OUTPUTS:    1
        INPUT_DIM:  (8,8)
        OUTPUT_DIM: (8,8)
        CLOCK:      1
        TIME:       10
      }
      LOGICAL_DATA {
        XY_PLANE_DATA {
          NUMBER: 1
          PLANES {
            MATRIX {
              DIMENSION: (8,8)
              DATA {
                00100111
                00011000
                00100111
                00011000
                00100111
                00011000
                00100111
                00011000
              }
            }
          }
        }
      }
      ARCHITECTURE_DATA {
        ID:   0
        PREV: [-,-]
        NEXT: [1,1]
        POS:  (140,450)
      }
    }
    ARCHITECTURE_ELEMENT {
      TYPE: PERM
      INTERNAL_DATA {
        NAME:       PERM
        COMMENT:    (8x8) -> (24x8)
        INPUTS:     1
        OUTPUTS:    1
        INPUT_DIM:  (8,8)
        OUTPUT_DIM: (24,8)
        CLOCK:      0
        TIME:       1
      }
      LOGICAL_DATA {
        CONNECTIONS {
          (0,0) -> (2,0)
          (0,1) -> (2,1)
          (0,2) -> (2,2)
          (0,3) -> (2,3)
          (0,4) -> (2,4)
          (0,5) -> (2,5)
          (0,6) -> (2,6)
          (0,7) -> (2,7)
          (1,0) -> (5,0)
          (1,1) -> (5,1)
          (1,2) -> (5,2)
          (1,3) -> (5,3)
          (1,4) -> (5,4)
          (1,5) -> (5,5)
          (1,6) -> (5,6)
          (1,7) -> (5,7)
          (2,0) -> (8,0)
          (2,1) -> (8,1)
          (2,2) -> (8,2)
          (2,3) -> (8,3)
          (2,4) -> (8,4)
          (2,5) -> (8,5)
          (2,6) -> (8,6)
          (2,7) -> (8,7)
          (3,0) -> (11,0)
          (3,1) -> (11,1)
          (3,2) -> (11,2)
          (3,3) -> (11,3)
          (3,4) -> (11,4)
          (3,5) -> (11,5)
          (3,6) -> (11,6)
          (3,7) -> (11,7)
          (4,0) -> (14,0)
          (4,1) -> (14,1)
          (4,2) -> (14,2)
          (4,3) -> (14,3)
          (4,4) -> (14,4)
          (4,5) -> (14,5)
          (4,6) -> (14,6)
          (4,7) -> (14,7)
          (5,0) -> (17,0)
          (5,1) -> (17,1)
          (5,2) -> (17,2)
          (5,3) -> (17,3)
          (5,4) -> (17,4)
          (5,5) -> (17,5)
          (5,6) -> (17,6)
          (5,7) -> (17,7)
          (6,0) -> (20,0)
          (6,1) -> (20,1)
          (6,2) -> (20,2)
          (6,3) -> (20,3)
          (6,4) -> (20,4)
          (6,5) -> (20,5)
          (6,6) -> (20,6)
          (6,7) -> (20,7)
          (7,0) -> (23,0)
          (7,1) -> (23,1)
          (7,2) -> (23,2)
          (7,3) -> (23,3)
          (7,4) -> (23,4)
          (7,5) -> (23,5)
          (7,6) -> (23,6)
          (7,7) -> (23,7)
        }
      }
      ARCHITECTURE_DATA {
        ID:   1
        PREV: [0,1]
        NEXT: [2,1]
        POS:  (210,450)
      }
    }
    ARCHITECTURE_ELEMENT {
      TYPE: LOGIC
      INTERNAL_DATA {
        NAME:       LOGIC
        COMMENT:    Stage1, calculating of sum and carry
        INPUTS:     1
        OUTPUTS:    1
        INPUT_DIM:  (24,8)
        OUTPUT_DIM: (24,8)
        CLOCK:      2
        TIME:       20
      }
      LOGICAL_DATA {
        PE_DIMENSION: (3,2)
        PE_DATA {
          NAMES {
            S1
            C1
            S0
            C0
            B
            A
          }
        }
        EXTERNAL_DATA {
          NUMBER: 0
          NAMES {
          }
        }
        INTERNAL_DATA {
          NUMBER: 0
          NAMES {
          }
        }
        EQUATION_DATA {
          NUMBER: 5
          EQUATIONS {
            S0=~A&B|A&~B
            C0=A&B
            S1=~A&~B|A&B
            C1=A|B
            B = 1
          }
          COMPUTE_PARALLEL: OFF
        }
      }
      ARCHITECTURE_DATA {
        ID:   2
        PREV: [1,1]
        NEXT: [3,1]
        POS:  (280,450)
      }
    }
    ARCHITECTURE_ELEMENT {
      TYPE: PERM
      INTERNAL_DATA {
        NAME:       PERM
        COMMENT:    Stage2, Broadcast
        INPUTS:     1
        OUTPUTS:    1
        INPUT_DIM:  (24,8)
        OUTPUT_DIM: (24,8)
        CLOCK:      0
        TIME:       0
      }
      LOGICAL_DATA {
        CONNECTIONS {
          (0,0)  -> (0,0)
          (0,1)  -> (0,1)
          (0,2)  -> (0,2)
          (0,3)  -> (0,3)
          (0,4)  -> (0,4)
          (0,5)  -> (0,5)
          (0,6)  -> (0,6)
          (0,7)  -> (0,7)
          (1,0)  -> (1,0)
          (1,1)  -> (1,1)
          (1,2)  -> (1,2)
          (1,3)  -> (1,3)
          (1,4)  -> (1,4)
          (1,5)  -> (1,5)
          (1,6)  -> (1,6)
          (1,7)  -> (1,7)
          (2,0)  -> (-,-)
          (2,1)  -> (-,-)
          (2,2)  -> (-,-)
          (2,3)  -> (-,-)
          (2,4)  -> (-,-)
          (2,5)  -> (-,-)
          (2,6)  -> (-,-)
          (2,7)  -> (-,-)
          (3,0)  -> (3,0)
          (3,1)  -> (2,0)(3,1)
          (3,2)  -> (3,2)
          (3,3)  -> (2,2)(3,3)
          (3,4)  -> (3,4)
          (3,5)  -> (2,4)(3,5)
          (3,6)  -> (3,6)
          (3,7)  -> (2,6)(3,7)
          (4,0)  -> (4,0)
          (4,1)  -> (2,1)(4,1)
          (4,2)  -> (4,2)
          (4,3)  -> (2,3)(4,3)
          (4,4)  -> (4,4)
          (4,5)  -> (2,5)(4,5)
          (4,6)  -> (4,6)
          (4,7)  -> (2,7)(4,7)
          (5,0)  -> (5,0)
          (5,1)  -> (-,-)
          (5,2)  -> (5,2)
          (5,3)  -> (-,-)
          (5,4)  -> (5,4)
          (5,5)  -> (-,-)
          (5,6)  -> (5,6)
          (5,7)  -> (-,-)
          (6,0)  -> (6,0)
          (6,1)  -> (6,1)
          (6,2)  -> (6,2)
          (6,3)  -> (6,3)
          (6,4)  -> (6,4)
          (6,5)  -> (6,5)
          (6,6)  -> (6,6)
          (6,7)  -> (6,7)
          (7,0)  -> (7,0)
          (7,1)  -> (7,1)
          (7,2)  -> (7,2)
          (7,3)  -> (7,3)
          (7,4)  -> (7,4)
          (7,5)  -> (7,5)
          (7,6)  -> (7,6)
          (7,7)  -> (7,7)
          (8,0)  -> (-,-)
          (8,1)  -> (-,-)
          (8,2)  -> (-,-)
          (8,3)  -> (-,-)
          (8,4)  -> (-,-)
          (8,5)  -> (-,-)
          (8,6)  -> (-,-)
          (8,7)  -> (-,-)
          (9,0)  -> (9,0)
          (9,1)  -> (8,0)(9,1)
          (9,2)  -> (9,2)
          (9,3)  -> (8,2)(9,3)
          (9,4)  -> (9,4)
          (9,5)  -> (8,4)(9,5)
          (9,6)  -> (9,6)
          (9,7)  -> (8,6)(9,7)
          (10,0) -> (10,0)
          (10,1) -> (8,1)(10,1)
          (10,2) -> (10,2)
          (10,3) -> (8,3)(10,3)
          (10,4) -> (10,4)
          (10,5) -> (8,5)(10,5)
          (10,6) -> (10,6)
          (10,7) -> (8,7)(10,7)
          (11,0) -> (11,0)
          (11,1) -> (-,-)
          (11,2) -> (11,2)
          (11,3) -> (-,-)
          (11,4) -> (11,4)
          (11,5) -> (-,-)
          (11,6) -> (11,6)
          (11,7) -> (-,-)
          (12,0) -> (12,0)
          (12,1) -> (12,1)
          (12,2) -> (12,2)
          (12,3) -> (12,3)
          (12,4) -> (12,4)
          (12,5) -> (12,5)
          (12,6) -> (12,6)
          (12,7) -> (12,7)
          (13,0) -> (13,0)
          (13,1) -> (13,1)(14,1)
          (13,2) -> (13,2)
          (13,3) -> (13,3)(14,3)
          (13,4) -> (13,4)
          (13,5) -> (13,5)(14,5)
          (13,6) -> (13,6)
          (13,7) -> (13,7)(14,7)
          (14,0) -> (-,-)
          (14,1) -> (-,-)
          (14,2) -> (-,-)
          (14,3) -> (-,-)
          (14,4) -> (-,-)
          (14,5) -> (-,-)
          (14,6) -> (-,-)
          (14,7) -> (-,-)
          (15,0) -> (15,0)
          (15,1) -> (14,0)(15,1)
          (15,2) -> (15,2)
          (15,3) -> (14,2)(15,3)
          (15,4) -> (15,4)
          (15,5) -> (14,4)(15,5)
          (15,6) -> (15,6)
          (15,7) -> (14,6)(15,7)
          (16,0) -> (16,0)
          (16,1) -> (14,1)(16,1)
          (16,2) -> (16,2)
          (16,3) -> (14,3)(16,3)
          (16,4) -> (16,4)
          (16,5) -> (14,5)(16,5)
          (16,6) -> (16,6)
          (16,7) -> (14,7)(16,7)
          (17,0) -> (17,0)
          (17,1) -> (-,-)
          (17,2) -> (17,2)
          (17,3) -> (-,-)
          (17,4) -> (17,4)
          (17,5) -> (-,-)
          (17,6) -> (17,6)
          (17,7) -> (-,-)
          (18,0) -> (18,0)
          (18,1) -> (18,1)
          (18,2) -> (18,2)
          (18,3) -> (18,3)
          (18,4) -> (18,4)
          (18,5) -> (18,5)
          (18,6) -> (18,6)
          (18,7) -> (18,7)
          (19,0) -> (19,0)
          (19,1) -> (19,1)
          (19,2) -> (19,2)
          (19,3) -> (19,3)
          (19,4) -> (19,4)
          (19,5) -> (19,5)
          (19,6) -> (19,6)
          (19,7) -> (19,7)
          (20,0) -> (-,-)
          (20,1) -> (-,-)
          (20,2) -> (-,-)
          (20,3) -> (-,-)
          (20,4) -> (-,-)
          (20,5) -> (-,-)
          (20,6) -> (-,-)
          (20,7) -> (-,-)
          (21,0) -> (21,0)
          (21,1) -> (20,0)(21,1)
          (21,2) -> (21,2)
          (21,3) -> (20,2)(21,3)
          (21,4) -> (21,4)
          (21,5) -> (20,4)(21,5)
          (21,6) -> (21,6)
          (21,7) -> (20,6)(21,7)
          (22,0) -> (22,0)
          (22,1) -> (20,1)(22,1)
          (22,2) -> (22,2)
          (22,3) -> (20,3)(22,3)
          (22,4) -> (22,4)
          (22,5) -> (20,5)(22,5)
          (22,6) -> (22,6)
          (22,7) -> (20,7)(22,7)
          (23,0) -> (23,0)
          (23,1) -> (-,-)
          (23,2) -> (23,2)
          (23,3) -> (-,-)
          (23,4) -> (23,4)
          (23,5) -> (-,-)
          (23,6) -> (23,6)
          (23,7) -> (-,-)
        }
      }
      ARCHITECTURE_DATA {
        ID:   3
        PREV: [2,1]
        NEXT: [4,1]
        POS:  (350,450)
      }
    }
    ARCHITECTURE_ELEMENT {
      TYPE: LOGIC
      INTERNAL_DATA {
        NAME:       LOGIC
        COMMENT:    Stage 2, selecting right values of sum and carry
        INPUTS:     1
        OUTPUTS:    1
        INPUT_DIM:  (24,8)
        OUTPUT_DIM: (24,8)
        CLOCK:      2
        TIME:       0
      }
      LOGICAL_DATA {
        PE_DIMENSION: (3,2)
        PE_DATA {
          NAMES {
            S1
            C1
            S0
            C0
            B
            A
          }
        }
        EXTERNAL_DATA {
          NUMBER: 0
          NAMES {
          }
        }
        INTERNAL_DATA {
          NUMBER: 0
          NAMES {
          }
        }
        EQUATION_DATA {
          NUMBER: 5
          EQUATIONS {
            S0=S0&~A|S1&A
            C0=C0&~A|C1&A
            S1=S0&~B|S1&B
            C1=C0&~B|C1&B
            B = 1
          }
          COMPUTE_PARALLEL: OFF
        }
      }
      ARCHITECTURE_DATA {
        ID:   4
        PREV: [3,1]
        NEXT: [5,1]
        POS:  (420,450)
      }
    }
    ARCHITECTURE_ELEMENT {
      TYPE: PERM
      INTERNAL_DATA {
        NAME:       PERM
        COMMENT:    Stage3, Broadcast
        INPUTS:     1
        OUTPUTS:    1
        INPUT_DIM:  (24,8)
        OUTPUT_DIM: (24,8)
        CLOCK:      0
        TIME:       0
      }
      LOGICAL_DATA {
        CONNECTIONS {
          (0,0)  -> (0,0)
          (0,1)  -> (0,1)
          (0,2)  -> (0,2)
          (0,3)  -> (0,3)
          (0,4)  -> (0,4)
          (0,5)  -> (0,5)
          (0,6)  -> (0,6)
          (0,7)  -> (0,7)
          (1,0)  -> (1,0)
          (1,1)  -> (1,1)
          (1,2)  -> (1,2)
          (1,3)  -> (1,3)
          (1,4)  -> (1,4)
          (1,5)  -> (1,5)
          (1,6)  -> (1,6)
          (1,7)  -> (1,7)
          (2,0)  -> (-,-)
          (2,1)  -> (-,-)
          (2,2)  -> (-,-)
          (2,3)  -> (-,-)
          (2,4)  -> (-,-)
          (2,5)  -> (-,-)
          (2,6)  -> (-,-)
          (2,7)  -> (-,-)
          (3,0)  -> (3,0)
          (3,1)  -> (3,1)
          (3,2)  -> (3,2)
          (3,3)  -> (3,3)
          (3,4)  -> (3,4)
          (3,5)  -> (3,5)
          (3,6)  -> (3,6)
          (3,7)  -> (3,7)
          (4,0)  -> (4,0)
          (4,1)  -> (4,1)
          (4,2)  -> (4,2)
          (4,3)  -> (4,3)
          (4,4)  -> (4,4)
          (4,5)  -> (4,5)
          (4,6)  -> (4,6)
          (4,7)  -> (4,7)
          (5,0)  -> (-,-)
          (5,1)  -> (-,-)
          (5,2)  -> (-,-)
          (5,3)  -> (-,-)
          (5,4)  -> (-,-)
          (5,5)  -> (-,-)
          (5,6)  -> (-,-)
          (5,7)  -> (-,-)
          (6,0)  -> (6,0)
          (6,1)  -> (5,0)(2,0)(6,1)
          (6,2)  -> (6,2)
          (6,3)  -> (5,2)(2,2)(6,3)
          (6,4)  -> (6,4)
          (6,5)  -> (5,4)(2,4)(6,5)
          (6,6)  -> (6,6)
          (6,7)  -> (5,6)(2,6)(6,7)
          (7,0)  -> (7,0)
          (7,1)  -> (5,1)(2,1)(7,1)
          (7,2)  -> (7,2)
          (7,3)  -> (5,3)(2,3)(7,3)
          (7,4)  -> (7,4)
          (7,5)  -> (5,5)(2,5)(7,5)
          (7,6)  -> (7,6)
          (7,7)  -> (5,7)(2,7)(7,7)
          (8,0)  -> (8,0)
          (8,1)  -> (8,1)
          (8,2)  -> (8,2)
          (8,3)  -> (8,3)
          (8,4)  -> (8,4)
          (8,5)  -> (8,5)
          (8,6)  -> (8,6)
          (8,7)  -> (8,7)
          (9,0)  -> (9,0)
          (9,1)  -> (9,1)
          (9,2)  -> (9,2)
          (9,3)  -> (9,3)
          (9,4)  -> (9,4)
          (9,5)  -> (9,5)
          (9,6)  -> (9,6)
          (9,7)  -> (9,7)
          (10,0) -> (10,0)
          (10,1) -> (10,1)
          (10,2) -> (10,2)
          (10,3) -> (10,3)
          (10,4) -> (10,4)
          (10,5) -> (10,5)
          (10,6) -> (10,6)
          (10,7) -> (10,7)
          (11,0) -> (11,0)
          (11,1) -> (11,1)
          (11,2) -> (11,2)
          (11,3) -> (11,3)
          (11,4) -> (11,4)
          (11,5) -> (11,5)
          (11,6) -> (11,6)
          (11,7) -> (11,7)
          (12,0) -> (12,0)
          (12,1) -> (12,1)
          (12,2) -> (12,2)
          (12,3) -> (12,3)
          (12,4) -> (12,4)
          (12,5) -> (12,5)
          (12,6) -> (12,6)
          (12,7) -> (12,7)
          (13,0) -> (13,0)
          (13,1) -> (13,1)
          (13,2) -> (13,2)
          (13,3) -> (13,3)
          (13,4) -> (13,4)
          (13,5) -> (13,5)
          (13,6) -> (13,6)
          (13,7) -> (13,7)
          (14,0) -> (-,-)
          (14,1) -> (-,-)
          (14,2) -> (-,-)
          (14,3) -> (-,-)
          (14,4) -> (-,-)
          (14,5) -> (-,-)
          (14,6) -> (-,-)
          (14,7) -> (-,-)
          (15,0) -> (15,0)
          (15,1) -> (15,1)
          (15,2) -> (15,2)
          (15,3) -> (15,3)
          (15,4) -> (15,4)
          (15,5) -> (15,5)
          (15,6) -> (15,6)
          (15,7) -> (15,7)
          (16,0) -> (16,0)
          (16,1) -> (16,1)
          (16,2) -> (16,2)
          (16,3) -> (16,3)
          (16,4) -> (16,4)
          (16,5) -> (16,5)
          (16,6) -> (16,6)
          (16,7) -> (16,7)
          (17,0) -> (-,-)
          (17,1) -> (-,-)
          (17,2) -> (-,-)
          (17,3) -> (-,-)
          (17,4) -> (-,-)
          (17,5) -> (-,-)
          (17,6) -> (-,-)
          (17,7) -> (-,-)
          (18,0) -> (18,0)
          (18,1) -> (17,0)(14,0)(18,1)
          (18,2) -> (18,2)
          (18,3) -> (14,2)(17,2)(18,3)
          (18,4) -> (18,4)
          (18,5) -> (17,4)(14,4)(18,5)
          (18,6) -> (18,6)
          (18,7) -> (17,6)(14,6)(18,7)
          (19,0) -> (19,0)
          (19,1) -> (17,1)(14,1)(19,1)
          (19,2) -> (19,2)
          (19,3) -> (17,3)(14,3)(19,3)
          (19,4) -> (19,4)
          (19,5) -> (17,5)(14,5)(19,5)
          (19,6) -> (19,6)
          (19,7) -> (17,7)(14,7)(19,7)
          (20,0) -> (20,0)
          (20,1) -> (20,1)
          (20,2) -> (20,2)
          (20,3) -> (20,3)
          (20,4) -> (20,4)
          (20,5) -> (20,5)
          (20,6) -> (20,6)
          (20,7) -> (20,7)
          (21,0) -> (21,0)
          (21,1) -> (21,1)
          (21,2) -> (21,2)
          (21,3) -> (21,3)
          (21,4) -> (21,4)
          (21,5) -> (21,5)
          (21,6) -> (21,6)
          (21,7) -> (21,7)
          (22,0) -> (22,0)
          (22,1) -> (22,1)
          (22,2) -> (22,2)
          (22,3) -> (22,3)
          (22,4) -> (22,4)
          (22,5) -> (22,5)
          (22,6) -> (22,6)
          (22,7) -> (22,7)
          (23,0) -> (23,0)
          (23,1) -> (23,1)
          (23,2) -> (23,2)
          (23,3) -> (23,3)
          (23,4) -> (23,4)
          (23,5) -> (23,5)
          (23,6) -> (23,6)
          (23,7) -> (23,7)
        }
      }
      ARCHITECTURE_DATA {
        ID:   5
        PREV: [4,1]
        NEXT: [6,1]
        POS:  (490,450)
      }
    }
    ARCHITECTURE_ELEMENT {
      TYPE: LOGIC
      INTERNAL_DATA {
        NAME:       LOGIC
        COMMENT:    Stage 2, selecting right values of sum and carry
        INPUTS:     1
        OUTPUTS:    1
        INPUT_DIM:  (24,8)
        OUTPUT_DIM: (24,8)
        CLOCK:      2
        TIME:       0
      }
      LOGICAL_DATA {
        PE_DIMENSION: (3,2)
        PE_DATA {
          NAMES {
            S1
            C1
            S0
            C0
            B
            A
          }
        }
        EXTERNAL_DATA {
          NUMBER: 0
          NAMES {
          }
        }
        INTERNAL_DATA {
          NUMBER: 0
          NAMES {
          }
        }
        EQUATION_DATA {
          NUMBER: 5
          EQUATIONS {
            S0=S0&~A|S1&A
            C0=C0&~A|C1&A
            S1=S0&~B|S1&B
            C1=C0&~B|C1&B
            B = 1
          }
          COMPUTE_PARALLEL: OFF
        }
      }
      ARCHITECTURE_DATA {
        ID:   6
        PREV: [5,1]
        NEXT: [7,1]
        POS:  (560,450)
      }
    }
    ARCHITECTURE_ELEMENT {
      TYPE: PERM
      INTERNAL_DATA {
        NAME:       PERM
        COMMENT:    Stage4, Broadcast
        INPUTS:     1
        OUTPUTS:    1
        INPUT_DIM:  (24,8)
        OUTPUT_DIM: (24,8)
        CLOCK:      0
        TIME:       0
      }
      LOGICAL_DATA {
        CONNECTIONS {
          (0,0)  -> (0,0)
          (0,1)  -> (0,1)
          (0,2)  -> (0,2)
          (0,3)  -> (0,3)
          (0,4)  -> (0,4)
          (0,5)  -> (0,5)
          (0,6)  -> (0,6)
          (0,7)  -> (0,7)
          (1,0)  -> (1,0)
          (1,1)  -> (1,1)
          (1,2)  -> (1,2)
          (1,3)  -> (1,3)
          (1,4)  -> (1,4)
          (1,5)  -> (1,5)
          (1,6)  -> (1,6)
          (1,7)  -> (1,7)
          (2,0)  -> (2,0)
          (2,1)  -> (2,1)
          (2,2)  -> (2,2)
          (2,3)  -> (2,3)
          (2,4)  -> (2,4)
          (2,5)  -> (2,5)
          (2,6)  -> (-,-)
          (2,7)  -> (-,-)
          (3,0)  -> (3,0)
          (3,1)  -> (3,1)
          (3,2)  -> (3,2)
          (3,3)  -> (3,3)
          (3,4)  -> (3,4)
          (3,5)  -> (3,5)
          (3,6)  -> (3,6)
          (3,7)  -> (3,7)
          (4,0)  -> (4,0)
          (4,1)  -> (4,1)
          (4,2)  -> (4,2)
          (4,3)  -> (4,3)
          (4,4)  -> (4,4)
          (4,5)  -> (4,5)
          (4,6)  -> (4,6)
          (4,7)  -> (4,7)
          (5,0)  -> (-,-)
          (5,1)  -> (-,-)
          (5,2)  -> (-,-)
          (5,3)  -> (-,-)
          (5,4)  -> (-,-)
          (5,5)  -> (-,-)
          (5,6)  -> (-,-)
          (5,7)  -> (-,-)
          (6,0)  -> (6,0)
          (6,1)  -> (6,1)
          (6,2)  -> (6,2)
          (6,3)  -> (6,3)
          (6,4)  -> (6,4)
          (6,5)  -> (6,5)
          (6,6)  -> (6,6)
          (6,7)  -> (6,7)
          (7,0)  -> (7,0)
          (7,1)  -> (7,1)
          (7,2)  -> (7,2)
          (7,3)  -> (7,3)
          (7,4)  -> (7,4)
          (7,5)  -> (7,5)
          (7,6)  -> (7,6)
          (7,7)  -> (7,7)
          (8,0)  -> (-,-)
          (8,1)  -> (-,-)
          (8,2)  -> (-,-)
          (8,3)  -> (-,-)
          (8,4)  -> (-,-)
          (8,5)  -> (-,-)
          (8,6)  -> (-,-)
          (8,7)  -> (-,-)
          (9,0)  -> (9,0)
          (9,1)  -> (9,1)
          (9,2)  -> (9,2)
          (9,3)  -> (9,3)
          (9,4)  -> (9,4)
          (9,5)  -> (9,5)
          (9,6)  -> (9,6)
          (9,7)  -> (9,7)
          (10,0) -> (10,0)
          (10,1) -> (10,1)
          (10,2) -> (10,2)
          (10,3) -> (10,3)
          (10,4) -> (10,4)
          (10,5) -> (10,5)
          (10,6) -> (10,6)
          (10,7) -> (10,7)
          (11,0) -> (-,-)
          (11,1) -> (-,-)
          (11,2) -> (-,-)
          (11,3) -> (-,-)
          (11,4) -> (-,-)
          (11,5) -> (-,-)
          (11,6) -> (-,-)
          (11,7) -> (-,-)
          (12,0) -> (12,0)
          (12,1) -> (2,0)(5,0)(8,0)(11,0)(12,1)
          (12,2) -> (12,2)
          (12,3) -> (2,2)(5,2)(8,2)(11,2)(12,3)
          (12,4) -> (12,4)
          (12,5) -> (2,4)(5,4)(8,4)(11,4)(12,5)
          (12,6) -> (12,6)
          (12,7) -> (2,6)(5,6)(8,6)(11,6)(12,7)
          (13,0) -> (13,0)
          (13,1) -> (2,1)(5,1)(8,1)(11,1)(13,1)
          (13,2) -> (13,2)
          (13,3) -> (2,3)(5,3)(8,3)(11,3)(13,3)
          (13,4) -> (13,4)
          (13,5) -> (2,5)(5,5)(8,5)(11,5)(13,5)
          (13,6) -> (13,6)
          (13,7) -> (2,7)(5,7)(8,7)(11,7)(13,7)
          (14,0) -> (14,0)
          (14,1) -> (14,1)
          (14,2) -> (14,2)
          (14,3) -> (14,3)
          (14,4) -> (14,4)
          (14,5) -> (14,5)
          (14,6) -> (14,6)
          (14,7) -> (14,7)
          (15,0) -> (15,0)
          (15,1) -> (15,1)
          (15,2) -> (15,2)
          (15,3) -> (15,3)
          (15,4) -> (15,4)
          (15,5) -> (15,5)
          (15,6) -> (15,6)
          (15,7) -> (15,7)
          (16,0) -> (16,0)
          (16,1) -> (16,1)
          (16,2) -> (16,2)
          (16,3) -> (16,3)
          (16,4) -> (16,4)
          (16,5) -> (16,5)
          (16,6) -> (16,6)
          (16,7) -> (16,7)
          (17,0) -> (17,0)
          (17,1) -> (17,1)
          (17,2) -> (17,2)
          (17,3) -> (17,3)
          (17,4) -> (17,4)
          (17,5) -> (17,5)
          (17,6) -> (17,6)
          (17,7) -> (17,7)
          (18,0) -> (18,0)
          (18,1) -> (18,1)
          (18,2) -> (18,2)
          (18,3) -> (18,3)
          (18,4) -> (18,4)
          (18,5) -> (18,5)
          (18,6) -> (18,6)
          (18,7) -> (18,7)
          (19,0) -> (19,0)
          (19,1) -> (19,1)
          (19,2) -> (19,2)
          (19,3) -> (19,3)
          (19,4) -> (19,4)
          (19,5) -> (19,5)
          (19,6) -> (19,6)
          (19,7) -> (19,7)
          (20,0) -> (20,0)
          (20,1) -> (20,1)
          (20,2) -> (20,2)
          (20,3) -> (20,3)
          (20,4) -> (20,4)
          (20,5) -> (20,5)
          (20,6) -> (20,6)
          (20,7) -> (20,7)
          (21,0) -> (21,0)
          (21,1) -> (21,1)
          (21,2) -> (21,2)
          (21,3) -> (21,3)
          (21,4) -> (21,4)
          (21,5) -> (21,5)
          (21,6) -> (21,6)
          (21,7) -> (21,7)
          (22,0) -> (22,0)
          (22,1) -> (22,1)
          (22,2) -> (22,2)
          (22,3) -> (22,3)
          (22,4) -> (22,4)
          (22,5) -> (22,5)
          (22,6) -> (22,6)
          (22,7) -> (22,7)
          (23,0) -> (23,0)
          (23,1) -> (23,1)
          (23,2) -> (23,2)
          (23,3) -> (23,3)
          (23,4) -> (23,4)
          (23,5) -> (23,5)
          (23,6) -> (23,6)
          (23,7) -> (23,7)
        }
      }
      ARCHITECTURE_DATA {
        ID:   7
        PREV: [6,1]
        NEXT: [8,1]
        POS:  (630,450)
      }
    }
    ARCHITECTURE_ELEMENT {
      TYPE: LOGIC
      INTERNAL_DATA {
        NAME:       LOGIC
        COMMENT:    Stage 4, selecting right values of sum and carry
        INPUTS:     1
        OUTPUTS:    1
        INPUT_DIM:  (24,8)
        OUTPUT_DIM: (24,8)
        CLOCK:      2
        TIME:       0
      }
      LOGICAL_DATA {
        PE_DIMENSION: (3,2)
        PE_DATA {
          NAMES {
            S1
            C1
            S0
            C0
            B
            A
          }
        }
        EXTERNAL_DATA {
          NUMBER: 0
          NAMES {
          }
        }
        INTERNAL_DATA {
          NUMBER: 0
          NAMES {
          }
        }
        EQUATION_DATA {
          NUMBER: 4
          EQUATIONS {
            S0=S0&~A|S1&A
            C0=C0&~A|C1&A
            S1=S0&~B|S1&B
            C1=C0&~B|C1&B
          }
          COMPUTE_PARALLEL: OFF
        }
      }
      ARCHITECTURE_DATA {
        ID:   8
        PREV: [7,1]
        NEXT: [9,1]
        POS:  (700,450)
      }
    }
    ARCHITECTURE_ELEMENT {
      TYPE: PERM
      INTERNAL_DATA {
        NAME:       PERM
        COMMENT:    (24x8) -> (8x8)
        INPUTS:     1
        OUTPUTS:    1
        INPUT_DIM:  (24,8)
        OUTPUT_DIM: (8,8)
        CLOCK:      0
        TIME:       0
      }
      LOGICAL_DATA {
        CONNECTIONS {
          (0,0)  -> (-,-)
          (0,1)  -> (-,-)
          (0,2)  -> (-,-)
          (0,3)  -> (-,-)
          (0,4)  -> (-,-)
          (0,5)  -> (-,-)
          (0,6)  -> (-,-)
          (0,7)  -> (-,-)
          (1,0)  -> (0,0)
          (1,1)  -> (0,1)
          (1,2)  -> (0,2)
          (1,3)  -> (0,3)
          (1,4)  -> (0,4)
          (1,5)  -> (0,5)
          (1,6)  -> (0,6)
          (1,7)  -> (0,7)
          (2,0)  -> (-,-)
          (2,1)  -> (-,-)
          (2,2)  -> (-,-)
          (2,3)  -> (-,-)
          (2,4)  -> (-,-)
          (2,5)  -> (-,-)
          (2,6)  -> (-,-)
          (2,7)  -> (-,-)
          (3,0)  -> (-,-)
          (3,1)  -> (-,-)
          (3,2)  -> (-,-)
          (3,3)  -> (-,-)
          (3,4)  -> (-,-)
          (3,5)  -> (-,-)
          (3,6)  -> (-,-)
          (3,7)  -> (-,-)
          (4,0)  -> (1,0)
          (4,1)  -> (1,1)
          (4,2)  -> (1,2)
          (4,3)  -> (1,3)
          (4,4)  -> (1,4)
          (4,5)  -> (1,5)
          (4,6)  -> (1,6)
          (4,7)  -> (1,7)
          (5,0)  -> (-,-)
          (5,1)  -> (-,-)
          (5,2)  -> (-,-)
          (5,3)  -> (-,-)
          (5,4)  -> (-,-)
          (5,5)  -> (-,-)
          (5,6)  -> (-,-)
          (5,7)  -> (-,-)
          (6,0)  -> (-,-)
          (6,1)  -> (-,-)
          (6,2)  -> (-,-)
          (6,3)  -> (-,-)
          (6,4)  -> (-,-)
          (6,5)  -> (-,-)
          (6,6)  -> (-,-)
          (6,7)  -> (-,-)
          (7,0)  -> (2,0)
          (7,1)  -> (2,1)
          (7,2)  -> (2,2)
          (7,3)  -> (2,3)
          (7,4)  -> (2,4)
          (7,5)  -> (2,5)
          (7,6)  -> (2,6)
          (7,7)  -> (2,7)
          (8,0)  -> (-,-)
          (8,1)  -> (-,-)
          (8,2)  -> (-,-)
          (8,3)  -> (-,-)
          (8,4)  -> (-,-)
          (8,5)  -> (-,-)
          (8,6)  -> (-,-)
          (8,7)  -> (-,-)
          (9,0)  -> (-,-)
          (9,1)  -> (-,-)
          (9,2)  -> (-,-)
          (9,3)  -> (-,-)
          (9,4)  -> (-,-)
          (9,5)  -> (-,-)
          (9,6)  -> (-,-)
          (9,7)  -> (-,-)
          (10,0) -> (3,0)
          (10,1) -> (3,1)
          (10,2) -> (3,2)
          (10,3) -> (3,3)
          (10,4) -> (3,4)
          (10,5) -> (3,5)
          (10,6) -> (3,6)
          (10,7) -> (3,7)
          (11,0) -> (-,-)
          (11,1) -> (-,-)
          (11,2) -> (-,-)
          (11,3) -> (-,-)
          (11,4) -> (-,-)
          (11,5) -> (-,-)
          (11,6) -> (-,-)
          (11,7) -> (-,-)
          (12,0) -> (-,-)
          (12,1) -> (-,-)
          (12,2) -> (-,-)
          (12,3) -> (-,-)
          (12,4) -> (-,-)
          (12,5) -> (-,-)
          (12,6) -> (-,-)
          (12,7) -> (-,-)
          (13,0) -> (4,0)
          (13,1) -> (4,1)
          (13,2) -> (4,2)
          (13,3) -> (4,3)
          (13,4) -> (4,4)
          (13,5) -> (4,5)
          (13,6) -> (4,6)
          (13,7) -> (4,7)
          (14,0) -> (-,-)
          (14,1) -> (-,-)
          (14,2) -> (-,-)
          (14,3) -> (-,-)
          (14,4) -> (-,-)
          (14,5) -> (-,-)
          (14,6) -> (-,-)
          (14,7) -> (-,-)
          (15,0) -> (-,-)
          (15,1) -> (-,-)
          (15,2) -> (-,-)
          (15,3) -> (-,-)
          (15,4) -> (-,-)
          (15,5) -> (-,-)
          (15,6) -> (-,-)
          (15,7) -> (-,-)
          (16,0) -> (5,0)
          (16,1) -> (5,1)
          (16,2) -> (5,2)
          (16,3) -> (5,3)
          (16,4) -> (5,4)
          (16,5) -> (5,5)
          (16,6) -> (5,6)
          (16,7) -> (5,7)
          (17,0) -> (-,-)
          (17,1) -> (-,-)
          (17,2) -> (-,-)
          (17,3) -> (-,-)
          (17,4) -> (-,-)
          (17,5) -> (-,-)
          (17,6) -> (-,-)
          (17,7) -> (-,-)
          (18,0) -> (-,-)
          (18,1) -> (-,-)
          (18,2) -> (-,-)
          (18,3) -> (-,-)
          (18,4) -> (-,-)
          (18,5) -> (-,-)
          (18,6) -> (-,-)
          (18,7) -> (-,-)
          (19,0) -> (6,0)
          (19,1) -> (6,1)
          (19,2) -> (6,2)
          (19,3) -> (6,3)
          (19,4) -> (6,4)
          (19,5) -> (6,5)
          (19,6) -> (6,6)
          (19,7) -> (6,7)
          (20,0) -> (-,-)
          (20,1) -> (-,-)
          (20,2) -> (-,-)
          (20,3) -> (-,-)
          (20,4) -> (-,-)
          (20,5) -> (-,-)
          (20,6) -> (-,-)
          (20,7) -> (-,-)
          (21,0) -> (-,-)
          (21,1) -> (-,-)
          (21,2) -> (-,-)
          (21,3) -> (-,-)
          (21,4) -> (-,-)
          (21,5) -> (-,-)
          (21,6) -> (-,-)
          (21,7) -> (-,-)
          (22,0) -> (7,0)
          (22,1) -> (7,1)
          (22,2) -> (7,2)
          (22,3) -> (7,3)
          (22,4) -> (7,4)
          (22,5) -> (7,5)
          (22,6) -> (7,6)
          (22,7) -> (7,7)
          (23,0) -> (-,-)
          (23,1) -> (-,-)
          (23,2) -> (-,-)
          (23,3) -> (-,-)
          (23,4) -> (-,-)
          (23,5) -> (-,-)
          (23,6) -> (-,-)
          (23,7) -> (-,-)
        }
      }
      ARCHITECTURE_DATA {
        ID:   9
        PREV: [8,1]
        NEXT: [10,1]
        POS:  (770,450)
      }
    }
    ARCHITECTURE_ELEMENT {
      TYPE: OUTPUT
      INTERNAL_DATA {
        NAME:       OUTPUT
        COMMENT:    
        INPUTS:     1
        OUTPUTS:    1
        INPUT_DIM:  (8,8)
        OUTPUT_DIM: (8,8)
        CLOCK:      1
        TIME:       0
      }
      LOGICAL_DATA {
        NUMBER_PLANES: 1
      }
      ARCHITECTURE_DATA {
        ID:   10
        PREV: [9,1]
        NEXT: [-,-]
        POS:  (840,450)
      }
    }
  }
}

