--
--  PICA-Style Output for Class A
--  (combinational-output Mealy)
--  Low Pass Filter FSM Example
--  Tom Mayo - 6-15-95
--

ENTITY lpf IS
  PORT ( clk : IN bit;
    rstn : IN bit;
    ena : IN bit;
    din : IN bit;
    dout : OUT bit
  );
END lpf;

ARCHITECTURE pica_a OF lpf IS
  SIGNAL present_state, next_state : bitvec;
  LABEL registers, transitions;
BEGIN

  registers : PROCESS ( clk, rstn )
  BEGIN
    IF ( rstn = '0' ) THEN
      present_state <= "00"; -- s0
    ELSIF ( clk'RISING ) THEN
      present_state <= next_state;
    END IF;
  END PROCESS;

  transitions : PROCESS ( present_state, ena, din )
  BEGIN
    CASE present_state IS
      WHEN "00" => -- s0
        IF ( ena = '1' AND din = '1' ) THEN
          dout <= '0';
          next_state <= "01"; -- s0x
        ELSE
          dout <= '0';
          next_state <= "00"; -- s0
        END IF;
      WHEN "01" => -- s0x
        IF ( ena = '1' AND din = '1' ) THEN
          dout <= '1';
          next_state <= "10"; -- s1
        ELSIF ( ena = '1' AND din = '0' ) THEN
          dout <= '0';
          next_state <= "00"; -- s0
        ELSE
          dout <= '0';
          next_state <= "01"; -- s0x
        END IF;
      WHEN "10" => -- s1
        IF ( ena = '1' AND din = '0' ) THEN
          dout <= '1';
          next_state <= "11"; -- s1x
        ELSE
          dout <= '1';
          next_state <= "10"; -- s1
        END IF;
      WHEN "11" => -- s1x
        IF ( ena = '1' AND din = '0' ) THEN
          dout <= '0';
          next_state <= "00"; -- s0
        ELSIF ( ena = '1' AND din = '1' ) THEN
          dout <= '1';
          next_state <= "10"; -- s1
        ELSE
          dout <= '1';
          next_state <= "11"; -- s1x
        END IF;
    END CASE;
  END PROCESS;
END pica_a;
