--
-- The following VHDL code was generated by
-- WAND - PIC to VHDL Parser - v2.1
-- Copyright (C) 1995 by Tom Mayo
--
-- To contact the author:  tcmayo@dsinfo.psf.lmco.com
--
--                         Tom Mayo
--                         67 Wilson St.
--                         Pittsfield, MA  01201
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of version 2 of the GNU General Public License as
-- published by the Free Software Foundation.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
--
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;

ENTITY your_entity IS
  PORT (
    clk : IN std_logic;
    ena : IN std_logic;
    din : IN std_logic;
    rstn : IN std_logic;
    dout : OUT std_logic
  );
END your_entity;

ARCHITECTURE exemplar OF your_entity IS

  TYPE state_type IS ( s0x, s0, s1x, s1 );
  SIGNAL current_state, next_state : state_type;
  SIGNAL next_dout : std_logic;

BEGIN

  registers : PROCESS ( clk, rstn )
  BEGIN
    IF ( rstn = '0' ) THEN
      dout <= '0';
      current_state <= s0;
    ELSIF ( clk'EVENT AND clk = '1' ) THEN
      dout <= next_dout;
      current_state <= next_state;
    END IF;
  END PROCESS;

  transitions : PROCESS ( current_state, ena, din )
  BEGIN
    CASE current_state IS
      WHEN s0x =>
        IF ( ena = '1' AND din = '0'  ) THEN
          next_dout <= '0';
          next_state <= s0;
        ELSIF ( ena = '1' AND din = '1'  ) THEN
          next_dout <= '1';
          next_state <= s1;
        ELSE
          next_dout<='0';
          next_state <= s0x;
        END IF;
      WHEN s0 =>
        IF ( ena = '1' AND din = '1'  ) THEN
          next_dout <= '0';
          next_state <= s0x;
        ELSE
          next_dout<='0';
          next_state <= s0;
        END IF;
      WHEN s1x =>
        IF ( ena = '1' AND din = '1' ) THEN
          next_dout <= '1';
          next_state <= s1;
        ELSIF ( ena = '1' AND din = '0' ) THEN
          next_dout <= '0';
          next_state <= s0;
        ELSE
          next_dout<='1';
          next_state <= s1x;
        END IF;
      WHEN s1 =>
        IF ( ena = '1' AND din = '0'  ) THEN
          next_dout <= '1';
          next_state <= s1x;
        ELSE
          next_dout<='1';
          next_state <= s1;
        END IF;
    END CASE;
  END PROCESS;
END exemplar;
