/*
 *  b20trav - function to continue processing the state diagram
 *            data base and provide vhdl output.
 *
 *  Tom Mayo - 7-3-95
 */

#include "b20.h"

static int compar_prio(const void *tp1, const void *tp2) {

	typedef transition_s_t *transition_s_t_p;
	transition_s_t_p t1;
	transition_s_t_p t2;
	int p1;
  int p2;

	t1 = *((transition_s_t_p *)tp1);
	t2 = *((transition_s_t_p *)tp2);

	p1 = t1->priority;
	p2 = t2->priority;

	if (p1 > p2)
		return(1);
	else
		return(-1);
}


void b20trav(void)
{
	io_s_t *in_ptr, *out_ptr;
	int io_printed, t, ts;
	char *wkspaceptr;
	char wkspace[LARGE_STRING];
	transition_s_t *default_transition;
	typedef transition_s_t *transition_s_t_p;

	transition_s_t_p *t_sort;

/*
 *  ----- Begin VHDL code generation ------
 */

	fprintf(outfp, "--\n");
	fprintf(outfp, "-- The following VHDL code was generated by\n");
	fprintf(outfp, version);

	fprintf(outfp, "LIBRARY ieee;\n");
	fprintf(outfp, "USE ieee.std_logic_1164.ALL;\n");
	fprintf(outfp, "\n");

/*
 *  Output ENTITY description with ports.
 */

	fprintf(outfp, "ENTITY your_entity IS\n");
    fprintf(outfp, "  PORT (\n");
	fprintf(outfp, "    clk : IN std_logic");

/*
 *  Handle INs and INOUTs.
 */
	in_ptr = first_in;

	while (in_ptr != (io_s_t *)NULL)
	{
		out_ptr = first_out;
		io_printed = 0;

		while (out_ptr != (io_s_t *)NULL)
		{
			if (!strcmp(in_ptr->name, out_ptr->name))
			{
				fprintf(outfp, ";\n    %s : INOUT std_logic", out_ptr->name);
				io_printed = 1;
				break;
			}
				
			out_ptr = out_ptr->next;
		}

		if (!io_printed)
			fprintf(outfp, ";\n    %s : IN std_logic", in_ptr->name);

		in_ptr = in_ptr->next;
	}
/*
 *  Handle OUTs.
 */
	out_ptr = first_out;

	while (out_ptr != (io_s_t *)NULL)
	{
		in_ptr = first_in;
		io_printed = 0;

		while (in_ptr != (io_s_t *)NULL)
		{
			if (!strcmp(in_ptr->name, out_ptr->name))
			{
				io_printed = 1;
				break;
			}
				
			in_ptr = in_ptr->next;
		}

		if (!io_printed)
			fprintf(outfp, ";\n    %s : OUT std_logic", out_ptr->name);

		out_ptr = out_ptr->next;
	}

	fprintf(outfp, "\n  );\n");
	fprintf(outfp, "END your_entity;\n");

/*
 *  ----- Exemplar Architecture -------
 */

/*
 *  Output ARCHITECTURE header with type and signal statements.
 */
	fprintf(outfp, "\nARCHITECTURE exemplar OF your_entity IS\n\n");

	fprintf(outfp, "  TYPE state_type IS (");

	current_state = first_state;

	while (current_state->next_overall != (state_s_t *)NULL)
	{
		fprintf(outfp, " %s,", current_state->name->text);
		current_state = current_state->next_overall;
	}

	fprintf(outfp, " %s );\n", current_state->name->text);

	fprintf(outfp, "  SIGNAL current_state, next_state : state_type;\n");

/*
 *  Create combinational inputs for output registers if necessary.
 */
 	current_out = first_out;

	while(current_out != (io_s_t *)NULL)
	{
		if (!current_out->async)
			fprintf(outfp, "  SIGNAL next_%s : std_logic;\n",
				current_out->name);

		current_out = current_out->next;
	}

	fprintf(outfp, "\nBEGIN\n");

/*
 *  Output PROCESS for asynchronous reset and state advancement.
 */
	fprintf(outfp, "\n  registers : PROCESS ( clk");

/*
 *  Look for asynchronous inputs to add to the list.
 */
 	current_in = first_in;

	while (current_in->next != (io_s_t *)NULL)
	{
		if (current_in->async)
			fprintf(outfp, ", %s", current_in->name);

		current_in = current_in->next;
	}
	
	if (current_in->async)
		fprintf(outfp, ", %s )\n", current_in->name);
	else
		fprintf(outfp, " )\n");

	fprintf(outfp, "  BEGIN\n");

/*
 *  Output the asynchronous transition condition and
 *    the associated events.
 */

	if (asynch_transition != (transition_s_t *)NULL)
	{
		strcpy(wkspace, asynch_transition->condition->text);

		if ((wkspaceptr = strtok(wkspace, "|")) != (char *)NULL)
		{
			fprintf(outfp, "    IF ( %s) THEN\n", wkspaceptr);

			while(1)
			{
				wkspaceptr = strtok((char *)NULL, ";");

				if (wkspaceptr == (char *)NULL)
					break;

				while (*wkspaceptr == ' ')
					wkspaceptr++;
            
				fprintf(outfp, "      %s;\n", wkspaceptr);
			}
		}   

		fprintf(outfp, "      current_state <= %s;\n",
			asynch_transition->to_state->name->text);

		fprintf(outfp, "    ELSIF ( clk'EVENT AND clk = '1' ) THEN\n");
	}
	else
	{
		fprintf(outfp, "-- WARNING:\n"
			"--   There is no asynchronous reset in this machine.\n");

		fprintf(outfp, "    IF ( clk'EVENT AND clk = '1' ) THEN\n");
	}

/*
 *  Clock output registers here.
 */
 	current_out = first_out;

	while(current_out != (io_s_t *)NULL)
	{
		if (!current_out->async)
			fprintf(outfp, "      %s <= next_%s;\n",
				current_out->name, current_out->name);

		current_out = current_out->next;
	}

	fprintf(outfp, "      current_state <= next_state;\n");
	fprintf(outfp, "    END IF;\n");
	fprintf(outfp, "  END PROCESS;\n");

/*
 *  Output PROCESS header for transitions.
 */
 	
	fprintf(outfp, "\n  transitions : PROCESS ( current_state");
	
 	current_in = first_in;

	while (current_in->next != (io_s_t *)NULL)
	{
		if (!current_in->async)
			fprintf(outfp, ", %s", current_in->name);

		current_in = current_in->next;
	}
	
	if (!current_in->async)
		fprintf(outfp, ", %s )\n", current_in->name);
	else
		fprintf(outfp, " )\n");

	fprintf(outfp, "  BEGIN\n");
/*
 *  Output CASE statement.
 */
	fprintf(outfp, "    CASE current_state IS\n");

/*
 *  Output WHEN statement for each state.
 */
	current_state = first_state;

	while (current_state != (state_s_t *)NULL)
	{
		fprintf(outfp, "      WHEN %s =>\n", current_state->name->text);

/*
 *  Handle Moore outputs from this state.
 */
		current_string = current_state->first_output;

		while (current_string != (string_s_t *)NULL)
		{
			sift_assignment(current_string, SIFT_NORMAL);
			current_string = current_string->next_this_state;
		}

/*
 *  Sort transitions by priority here.
 */

/* Count transitions for this state. */

		ts = 0;

 		for (current_transition = current_state->first_transition;
			current_transition != (transition_s_t *)NULL;
			current_transition = current_transition->next_this_state) {
			ts++;
		}

		if (ts > 1) {

/* Make and fill a temporary array */

			t_sort = (void *)malloc(sizeof(transition_s_t_p) * ts);

			current_transition = current_state->first_transition;

 			for (t = 0; t < ts; t++) {
				t_sort[t] = current_transition;
				current_transition = current_transition->next_this_state;
			}

/* Sort by priority */

			qsort(t_sort, ts, sizeof(*t_sort), compar_prio);

/* Rebuild linked list in sorted order. */

			current_state->first_transition = t_sort[0];
			current_transition = t_sort[0];

 			for (t = 1; t < ts; t++) {
			  current_transition->next_this_state = t_sort[t];
				current_transition = t_sort[t];
			}

			current_transition->next_this_state = (transition_s_t *)NULL;

			free(t_sort);
		}

/*
 *  Handle transitions and their outputs.
 */
		current_transition = current_state->first_transition;
		default_transition = (transition_s_t *)NULL;

		sift_expression((transition_s_t *)NULL, SIFT_RESET);

		while(current_transition != (transition_s_t *)NULL)
		{
			if (sift_expression(current_transition, SIFT_NORMAL)
				== SIFT_DEFAULT)
			{
				default_transition = current_transition;
			}

			current_transition = current_transition->next_this_state;
		}
	
		sift_expression(default_transition, SIFT_DEFAULT);

		sift_expression((transition_s_t *)NULL, SIFT_CAP);

		current_state = current_state->next_overall;
	}

/*
 *  Output END statements.
 */

	fprintf(outfp, "    END CASE;\n");
	fprintf(outfp, "  END PROCESS;\n");
	fprintf(outfp, "END exemplar;\n");

	fflush(stderr);
	fflush(outfp);
}
