/*
 *  b20.l - flex input file for scanning pic input files
 *
 *  Tom Mayo - 6-15-95
 */

%{

#include "b20.h"
#include "b20.tab.h"

extern int mylineno;	/* Keep track for error reporting. */
extern YYSTYPE yylval;	/*	This is a structure from b20.tab.h. */

%}

%s INSTRING
%s DONESTRING

%%

<INSTRING>\\s[0-9]+ |						/* Size specifier. */
<INSTRING>\\f[HPBR] { return(FORMAT); }		/* Font specifier. */

<INSTRING>[^\\]+	{		/* The first backslash ends the string. */
	BEGIN DONESTRING;		/* Enter the end of string state. */
	strncpy (yylval.sval, yytext, 128);	/* Put string into structure. */
	return(STRING); }		/* Return the string token. */

<DONESTRING>.*\"	{		/* Find quote ending the whole string. */
	BEGIN 0;				/* Return to the default state. */
	return(ENDQUOTE); }		/* Return the end of whole string token. */

[\r\t ]+			;		/* Dump whitespace. */

\.PS([\t ]+[0-9]+)*		|	/* Ignore PIC formatting keywords. */
\.ps([\t ]+[0-9]+)*		|
\.PE					|
\.pe					;

arc				{ return(ARC); }	/* Return arc token. */

circle			{ return(CIRCLE); }	/* etc... */

line			{ return(LINE); }

rjust			{ return(RJUST); }

ljust			{ return(LJUST); }

\<\-			{ return(LEFT_ARROW); }

\-\>			{ return(RIGHT_ARROW); }

at				{ return(AT); }

from			{ return(FROM); }

to				{ return(TO); }

rad				{ return(RAD); }

cw				{ return(CW); }

\"				{ BEGIN INSTRING; }	/* Enter lexer "in string" state. */

[0-9]+			|			/* Found a number, return its value. */
[0-9]+\.[0-9]+	|
\.[0-9]+		{ yylval.dval = atof(yytext); return(NUMBER); }

\,				{ return(COMMA); }

\n				{ mylineno++; return(EOL); }	/* End of line. */

%%
