/*
 *  b20.h - Header file defining constants, structures
 *          for holding state machine data base information,
 *          function prototypes, and global variable declarations.
 *
 *  Tom Mayo - 6-15-95
 */

#ifdef SUNOS
#  define _POSIX_SOURCE
#  ifndef PI
#    define PI 3.14159265359
#  endif
#  include <alloca.h>
#endif

#ifdef _AIX
#  ifndef PI
#    define PI 3.14159265359
#  endif
#  pragma alloca
#endif

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>


#define STATE_SNAP_RATIO 0.2
#define STRING_SNAP_DIST 0.5
#define TRANS_SNAP_DIST 0.1
#define OUTPUT_MARGIN_DIST 0.1
#define ARC_CCW 1
#define ARC_CW -1
#define LARGE_STRING 128
#define SIFT_NORMAL		0x00
#define SIFT_ADD_NEXT 	0x01
#define SIFT_INDENT_FAR 0x02
#define SIFT_DEFAULT 	0x04
#define SIFT_CAP 		0x08
#define SIFT_RESET		0x10

/*
 *  xy_s_t - structure type to hold an x, y coordinate
 */

typedef struct xy_s
{
	double x;
	double y;
}
xy_s_t;

/*
 *  just_t - enumerated type to hold the justification scheme for a string
 */

typedef enum { JUST_LEFT, JUST_CENTER, JUST_RIGHT } just_t;

/*
 *  string_s_t - structure type to hold all information about a string
 *    and / or output value
 */
	
typedef struct string_s
{
	struct xy_s		origin_xy;
	just_t			just;
	char			*text;
	struct string_s	*next_overall;
	struct string_s	*next_this_state;
}
string_s_t;

/*
 *  transition_s_t - structure type to hold all information about
 *    a transtion between two states
 */

typedef struct transition_s
{
	struct xy_s		center_xy;
	struct xy_s		from_xy;
	struct state_s	*from_state;
	struct xy_s		to_xy;
	struct state_s	*to_state;
	struct string_s	*condition;
	int priority;
	struct transition_s	*next_overall;
	struct transition_s	*next_this_state;
}
transition_s_t;

/*
 *  state_s_t - structure type to hold all information about
 *    a machine state
 */

typedef struct state_s
{
	struct string_s	*name;
	struct xy_s		center_xy;
	double			radius;
	struct transition_s	*first_transition;
	struct string_s	*first_output;
	struct state_s	*next_overall;
}
state_s_t;

typedef struct io_s
{
	int async;	/* input:  1 => asynchronous reset input */
	            /*         0 => normal mild-mannered input */
	            /* output: 0 => registered output */
				/*         1 => combinational */
	char *name;
	struct io_s *next;
}
io_s_t;

/*
 *  function prototypes (see b20func.c)
 */

void preamble(FILE *fp);
void usage();
void fatal_error(char *s);
string_s_t *create_string(void);
transition_s_t *create_transition(void);
state_s_t *create_state(void);
void fill_string(xy_s_t *origin_xy, just_t just, char *text);
void fill_transition(xy_s_t *center_xy, xy_s_t *from_xy, xy_s_t *to_xy);
xy_s_t *line_center(xy_s_t *start_xy, xy_s_t *end_xy);
xy_s_t *arc_center(xy_s_t *start_xy, xy_s_t *end_xy,
	xy_s_t *origin_xy, int dir);
void fill_state(xy_s_t *center_xy, double radius);
void destroy_string(string_s_t *destroy);
void destroy_transition(transition_s_t *destroy);
void destroy_state(state_s_t *destroy);
double distance(xy_s_t *start_xy, xy_s_t *end_xy);
void b20fill(void);
void b20trav(void);
void yyerror(char *s);
void vvverror(char *s);
void b20iofind(void);
/*
 *  The second parm to the following functions is a flag
 *  which allows the program to:
 *
 *  place the proper inputs on the sensitivity list of the
 *  registered process to allow asynchronous resetting of
 *  the machine.
 *  
 *  or create registered outputs.
 */
void add_input(char *s, int async);
void add_output(char *s, int async);
void set_priority(int p);

/*
 *  global variables
 */

extern int mylineno;
extern int prio;
extern int debug_parse, debug_fill, debug_exp, debug_iofind, debug_vhdl;
extern int sync_outputs, sync_reset, explicit_def;
extern int yydebug;
extern transition_s_t *first_transition, *current_transition,
	*asynch_transition;
extern state_s_t *first_state, *current_state;
extern string_s_t *first_string, *current_string;
extern int states, transitions, strings;
extern char vvv_lex_string[], *vvv_lex_ptr, *vvv_lex_end;
extern io_s_t *current_in, *first_in;
extern io_s_t *current_out, *first_out;
extern int inputs_async, outputs_async;
void sift_assignment(string_s_t *string, int sift_type);
int sift_expression(transition_s_t *string, int sift_type);
char *version;
extern char outfilename[], infilename[];
extern FILE *outfp, *infp;
