/*$Id: u_statu2.cc,v 19.6 2001/01/16 05:58:44 al Exp $ -*- C++ -*-
 * Displays the status of the system.  Makes all the calculations associated
 * with allocating memory but does not actually allocate it, unless necessary
 * to make the rest of the calculations.
 *
 *   If "allocate" is changed, this must also be changed.
 */
#include "d_subckt.h"
#include "d_logic.h"
#include "d_mos_base.h"
#include "ap.h"
#include "u_status.h"
/*--------------------------------------------------------------------------*/
//	void	STATUS::command(CS& cmd);
/*--------------------------------------------------------------------------*/
void STATUS::command(CS& cmd)
{ 
  IO::mstdout << "ACS   System status\n";
  init();
  
  if (!cmd.pmatch("Notime")){  
    overhead = total - advance - evaluate - load - lud - back - output 
      - review - accept;
    IO::mstdout
      << "command      --------  last  --------    --------  total  --------\n"
      << "               user      sys    total       user      sys    total\n"
      << get
      << op
      << dc
      << tran
      << four
      << ac
      << "function     --------  last  --------    --------  total  --------\n"
      << "               user      sys    total       user      sys    total\n"
      << set_up
      << order
      << "function     --------  last  --------    --------  total  --------\n"
      << "               user      sys    total       user      sys    total\n"
      << advance
      << evaluate
      << load
      << lud
      << back
      << review
      << accept
      << output
      << overhead;
    if (OPT::showall){
      IO::mstdout << aux1 << aux2 << aux3;
    }
    IO::mstdout << total;
  }

  IO::mstdout.form(
	  "iterations: op=%d, dc=%d, tran=%d, fourier=%d, total=%d\n",
	  iter[sOP], iter[sDC], iter[sTRAN], iter[sFOURIER], iter[iTOTAL]);
  IO::mstdout.form(
	  "nodes: user=%d, subckt=%d, model=%d, total=%d\n",
	  user_nodes, subckt_nodes, model_nodes, total_nodes);
  IO::mstdout.form(
	  "devices: diodes=%d, mosfets=%d, gates=%d, subckts=%d\n",
	  DEV_DIODE::count(), DEV_MOS::count(),
	  DEV_LOGIC::count(), DEV_SUBCKT::count());
  IO::mstdout.form(
	  "commons: diodes=%d, mosfets=%d, gates=%d, subckts=%d\n",
	  COMMON_DIODE::count(), COMMON_MOS::count(),
	  COMMON_LOGIC::count(), COMMON_SUBCKT::count());
  IO::mstdout.form(
	  "models:  diodes=%d, mosfets=%d, gates=%d, subckts=%d\n",
	  MODEL_DIODE::count(), MODEL_MOS_BASE::count(),
	  MODEL_LOGIC::count(), MODEL_SUBCKT::count());
  IO::mstdout.form("density=%.1f%%\n", aa.density()*100.);
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
