/*$Id: u_sdp.h,v 18.4 2000/07/09 05:58:31 al Exp $ -*- C++ -*-
 * A class for Size Dependent Parameters, like those used in Spice BSIM models
 * A single read gets the nominal, and length and width dependencies.
 * A single print prints them all.
 * operator() returns the value to use, adjusted for L and W.
 */
#ifndef U_SDP_H
#define U_SDP_H
#include "ap.h"
/*--------------------------------------------------------------------------*/
class OMSTREAM;
/*--------------------------------------------------------------------------*/
class SDP {
  friend CS& get(CS& cmd, const std::string& key, SDP* value,
		 AP_MOD mod=mNONE, double scale=0);
private:
  double _nom;	// nominal value
  double _ld;	// length dependency
  double _wd;	// width dependency
  double _pd;	// cross-term dependency (p is for product)
public:
  explicit SDP(double nom) :_nom(nom), _ld(0.), _wd(0.), _pd(0.) {}
  void print(OMSTREAM& o, const std::string& name)const;
  double operator()(double L, double W)const {
    return _nom + _ld/L + _wd/W + _pd/(W*L);}
  double nom()const {return _nom;}
  void set_nom(double n) {_nom = n;}
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
