/*$Id: u_sdp.cc,v 18.4 2000/07/09 05:58:31 al Exp $ -*- C++ -*-
 * A class for Size Dependent Parameters, like those used in Spice BSIM models
 */
#include "io_.h"
#include "u_sdp.h"
/*--------------------------------------------------------------------------*/
CS& get(CS& cmd, const std::string& key, SDP* value, AP_MOD mod, double scale)
{
  get(cmd, key,	      &value->_nom, mod, scale);
  get(cmd, "W" + key, &value->_wd);
  get(cmd, "L" + key, &value->_ld);
  get(cmd, "P" + key, &value->_pd);
  return cmd;
}
/*--------------------------------------------------------------------------*/
void SDP::print(OMSTREAM& o, const std::string& name)const
{
  o << ("  " + name + '=') << _nom;
  if (_wd != 0){
    o << (" w" + name + '=') << _wd;
  }
  if (_ld != 0){
    o << (" l" + name + '=') << _ld;
  }
  if (_pd != 0){
    o << (" p" + name + '=') << _pd;
  }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
