/*$Id: u_cardst.h,v 19.26 2001/06/30 07:20:53 al Exp $ -*- C++ -*-
 * a structure to stash a "card" for fault. sweep, etc.
 */
#ifndef U_CARDST_H
#define U_CARDST_H
#include "e_compon.h"
/*--------------------------------------------------------------------------*/
class CARDSTASH {
private:
  COMPONENT*		_brh;
  double		_value;
  COMMON_COMPONENT*	_c;
public:
  explicit CARDSTASH()		:_brh(0), _value(0.), _c(0) {}
  explicit CARDSTASH(CARD* b);
	   CARDSTASH(const CARDSTASH& p);
	   ~CARDSTASH()		{detach_common(&_c);}
  void	   operator=(CARD* b);
  void	   restore()		{assert(_brh); _brh->set_value(_value, _c);}
  bool operator==(const CARDSTASH&)const
	{incomplete();unreachable();return false;}
  bool operator!=(const CARDSTASH&)const
	{incomplete();unreachable();return false;}
  bool operator<(const CARDSTASH&)const
	{incomplete();unreachable();return false;}
  bool operator>(const CARDSTASH&)const
	{incomplete();unreachable();return false;}
  // comparisons here because MS list requires them, even though not used here.
};
/*--------------------------------------------------------------------------*/
inline void CARDSTASH::operator=(CARD* b)
{
  assert(b);
  _brh = prechecked_cast<COMPONENT*>(b);
  assert(_brh);
  _value = _brh->value();
  detach_common(&_c);
  attach_common(_brh->mutable_common(), &_c);
}
/*--------------------------------------------------------------------------*/
inline CARDSTASH::CARDSTASH(CARD* b)
  :_brh(0),
   _value(NOT_VALID),
   _c(0)  
{
  *this = b;
}
/*--------------------------------------------------------------------------*/
inline CARDSTASH::CARDSTASH(const CARDSTASH& p)
  :_brh(p._brh),
   _value(p._value),
   _c(0)
{
  attach_common(p._c, &_c);
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
