/*$Id: mode.h,v 18.7 2000/07/25 16:07:21 al Exp $ -*- C++ -*-
 * several enumerated types to identify various modes
 */
#ifndef MODE_H
#define MODE_H
#include "io_.h"
/*--------------------------------------------------------------------------*/
enum smode_t   {moUNKNOWN=0, moANALOG=1, moDIGITAL, moMIXED};
inline OMSTREAM& operator<<(OMSTREAM& o, smode_t t){
  const char* s[] = {"unknown", "analog", "digital", "mixed"};
  assert(t >= int(moUNKNOWN));
  assert(t <= int(moMIXED));
  return (o << s[t]);
}

enum SIM_MODE { // simulation types
  sNONE,	/* not doing anything, reset by cmd interpreter	*/
  sAC,  	/* AC analysis					*/
  sOP,  	/* op command					*/
  sDC,  	/* dc sweep command				*/
  sTRAN,	/* transient command				*/
  sFOURIER	/* fourier command				*/
};
const int sSTART = sNONE;
const int sCOUNT = sFOURIER + 1;
inline OMSTREAM& operator<<(OMSTREAM& o, SIM_MODE t){
  const char* s[] = {"ALL", "AC", "OP", "DC", "TRAN", "FOURIER"};
  assert(t >= int(sNONE));
  assert(t <= int(sFOURIER));
  return (o << s[t]);
}

enum PROBE_INDEX { // iter probes (continue after SIM_MODE)
  iPRINTSTEP = sCOUNT,	/* iterations for this printed step		*/
  iSTEP,		/* iterations this internal step		*/
  iTOTAL		/* total iterations since startup		*/
};
const int iCOUNT = iTOTAL + 1;	/* number of iteration counters		*/

/* control probes							*/
#define cSTEPCAUSE (0)	/* what caused this time step			*/
#define cSTEPS	   (1)	/* count of hidden steps (+ this unhidden)	*/
#define cCOUNT	   (2)	/* number of control probes			*/
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
