/*$Id: md.cc,v 18.4 2000/07/09 05:58:31 al Exp $ -*- C++ -*-
 * Non-portable functions.  Do all portability patches here.
 */
#include "md.h"
#include <errno.h>
#include <signal.h>
#if defined(WIN32)
#include <dos.h>
#include <process.h>
#include <time.h>
#endif
/*--------------------------------------------------------------------------*/
	void    setup_traps(void);
static	void	new_ex_handler();
extern "C" {
  static void	sig_int(SIGNALARGS);
  static void	sig_fpe(SIGNALARGS);
}
	int	getrusage(int,struct rusage*);
/*--------------------------------------------------------------------------*/
void setup_traps(void)
{
  signal(SIGFPE,sig_fpe);
  signal(SIGINT,sig_int);
#if !defined(NEW_IS_BROKEN)
  set_new_handler(new_ex_handler);
#endif
}
/*--------------------------------------------------------------------------*/
#if !defined(NEW_IS_BROKEN)
static void new_ex_handler()
{
  untested();
  error(bERROR, "out of memory\n");
}
#endif
/*--------------------------------------------------------------------------*/
/* sig_int: what to do on receipt of interrupt signal (SIGINT)
 * cancel batch files, then back to command mode.
 * (actually, control-c trap)
 */
extern "C" {
  static void sig_int(SIGNALARGS)
  {
    signal(SIGINT,sig_int);
    error(bERROR, "\n");
  }
}
/*--------------------------------------------------------------------------*/
extern "C" {
  static void sig_fpe(SIGNALARGS)
  {
    untested();
    signal(SIGFPE,sig_fpe);
    error(bDANGER, "floating point error\n");
  }
}
/*--------------------------------------------------------------------------*/
#if defined(NEEDS_GETRUSAGE)
int getrusage(int /*who*/, struct rusage *rusage)
{
  double ticks = (double)clock();
  rusage->ru_stime.tv_sec = rusage->ru_stime.tv_usec = 0;
  rusage->ru_utime.tv_usec =
    (long)fmod(ticks, (double)CLK_TCK) * (1000000./(double)CLK_TCK);
  rusage->ru_utime.tv_sec = (long)(ticks/(double)CLK_TCK);
  return 0;
}
#endif
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
