/*$Id: m_wave.h,v 19.24 2001/05/11 21:35:03 al Exp $ -*- C++ -*-
 * "wave" class, for transmission lines and delays
 */
#include "l_denoise.h"
#include "m_interp.h"
/*--------------------------------------------------------------------------*/
class WAVE {
private:
  std::deque<std::pair<double,double> > _w;
  double _delay;
  explicit WAVE(const WAVE&);
public:
  explicit WAVE(double d=0);
  void	   set_delay(double d);
  void	   initialize();
  void	   push(double t, double v);
  double   v_out(double t)const;
  double   v_reflect(double t, double v_total)const;
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
inline void WAVE::push(double t, double v)
{
  _w.push_back(std::pair<double,double>(t+_delay, v));
}
/*--------------------------------------------------------------------------*/
inline void WAVE::initialize()
{
  _w.clear();
  push(0-_delay, 0.);
  push(0., 0.);
}
/*--------------------------------------------------------------------------*/
inline WAVE::WAVE(double d)
  :_w(),
   _delay(d)
{
  initialize();
}
/*--------------------------------------------------------------------------*/
inline void WAVE::set_delay(double d) 
{
  _delay = d; 
  initialize();
}
/*--------------------------------------------------------------------------*/
inline double WAVE::v_out(double t)const
{
  FPOLY1 rv=interpolate(_w.begin(), _w.end(), t, 0., 0.);
  return rv.f0;
}
/*--------------------------------------------------------------------------*/
inline double WAVE::v_reflect(double t, double v_total)const
{
  return dn_diff(v_total*2, v_out(t));
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
