/*$Id: m_spline.h,v 19.2 2000/11/14 20:37:58 al Exp $ -*- C++ -*-
 * piecewise polynomial interpolation
 * Constructor args:
 * table : a vector of xy pairs, all of the data points.
 * d0, dn: boundary conditions -- value of the first derivative at boundaries.
 * order : order of interpolating polynomial, must be in {0, 1, 2, 3}.
 *
 * Outside the range, the result is linearly extrapolated with slope d0, dn.
 * ("clamped" splines)
 * 
 * If d0 or dn is set to NOT_INPUT, it is a "natural" spline, with the 
 * derivative being determined by the data.
 * See any numerical analysis text for explanation.
 */
#ifndef M_SPLINE_H
#define M_SPLINE_H
#include "m_cpoly.h"
/*--------------------------------------------------------------------------*/
class SPLINE {
private:
  int _n;
  double* _x;
  double* _f0;
  double* _f1;
  double* _f2;
  double* _f3;
  int	  _order;
  double  _d0;

  void construct_order_3(double* h, double d0, double dn);
  void construct_order_2(double* h, double d0, double dn);
  void construct_order_1(double* h, double d0, double dn);
public:
  SPLINE(const std::vector<std::pair<double,double> >& table,
	 double d0, double dn, int order);
  ~SPLINE();
  FPOLY1 at(double x)const;
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
