/*$Id: m_interp.cc,v 18.17 2000/09/04 09:45:33 al Exp $ -*- C++ -*-
 * interpolation
 */
#include "constant.h"
#include "m_interp.h"
/*--------------------------------------------------------------------------*/
/* interpolate:  linear interpolation on a table.
 * Keys must be sorted in increasing order.
 */
template <class Iterator>
FPOLY1 interpolate(Iterator begin, Iterator end, double x,
		   double below, double above)
{
  double f1 = NOT_VALID;
  double f0 = NOT_VALID;
  if (begin == end){
    untested();
    error(bERROR, "interpolate table is empty\n");
  }
  --end;
  {if (begin == end){ // only 1 entry -- constant
    untested();
    f1 = (x < (*begin).first)
      ? ((below != NOT_INPUT) ? below : 0.)
      : ((above != NOT_INPUT) ? above : 0.);
    f0 = (*begin).second + (x - (*begin).first) * f1;
  }else{
    ++begin;
    std::pair<double,double> xx(x,BIGBIG);
    Iterator upper = std::upper_bound(begin, end, xx);
    Iterator lower = upper-1;
    {if ((upper == end) && (x > (*upper).first) && (above != NOT_INPUT)){
      lower = upper;
      if (above != 0.) {untested();}
      f1 = above;
    }else if ((upper == begin) && (x < (*lower).first) && (below!=NOT_INPUT)){
      untested();
      if (below != 0.) {untested();}
      f1 = below;
    }else if ((*upper).first <= (*lower).first){
      error(bERROR, "interpolate table is not sorted or has duplicate keys\n");
      f1 = 0.;
    }else{
      assert((*upper).first != (*lower).first);
      f1 = ((*upper).second-(*lower).second) / ((*upper).first-(*lower).first);
    }}
    f0 = (*lower).second + (x - (*lower).first) * f1;
  }}
  assert(f1 != NOT_VALID);
  assert(f0 != NOT_VALID);
  return FPOLY1(x, f0, f1);
}
/*--------------------------------------------------------------------------*/
#if defined(MANUAL_TEMPLATES)
template
FPOLY1 interpolate(const std::pair<double,double>*,
		   const std::pair<double,double>*, 
		   double, double, double);
template 
FPOLY1 interpolate(std::deque<std::pair<double,double> >::const_iterator,
		   std::deque<std::pair<double,double> >::const_iterator,
		   double, double, double);	      
#endif
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
