/*$Id: l_stlextra.h,v 19.17 2001/04/28 22:47:17 al Exp $ -*- C++ -*-
 * extra functions in the STL style
 * Things that ought to be there, but are not
 */
#ifndef L_STLEXTRA_H
#define L_STLEXTRA_H
#include "md.h"
/*--------------------------------------------------------------------------*/
/* find_ptr: like the stl find, except that the list contains pointers
   Dereference the pointer in the list, then compare */
template <class InputIterator, class T>
InputIterator find_ptr(InputIterator first,InputIterator last,const T& value)
{
  while (first != last && **first != value)
    ++first;
  return first;
}
/*--------------------------------------------------------------------------*/
inline void to_lower(std::string* s)
{
  assert(s);
  for (std::string::iterator i = s->begin(); i != s->end(); ++i) {
    *i = tolower(*i);
  }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
