/*$Id: l_denoise.h,v 17.22 2000/05/12 10:31:53 al Exp $ -*- C++ -*-
 * functions to "de-noise" arithmetic
 * attempt to get rid of noise due to roundoff
 */
#ifndef L_DENOISE_H
#define L_DENOISE_H
#include "u_opt.h"
/*--------------------------------------------------------------------------*/
/* fixzero: force numbers near zero to zero - changes thru pointer */
inline void fixzero(double *z, double r)
{
  if (abs(*z) < abs(r*OPT::roundofftol)) {
    *z=0.;
  }
}
/*--------------------------------------------------------------------------*/
/* fixzero: force numbers near zero to zero - returns value */
inline double fixzero(double z, double r)
{
  return (abs(z) < abs(r*OPT::roundofftol)) ? 0. : z;
}
/*--------------------------------------------------------------------------*/
/* dn_diff: de-noised difference */
inline double dn_diff(double a, double b)
{
  return fixzero(a-b, a);
}
/*--------------------------------------------------------------------------*/
/* dn_sum: de-noised sum */
inline double dn_sum(double a, double b)
{
  return fixzero(a+b, a);
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
