/*$Id: l_compar.h,v 19.4 2001/01/13 21:33:15 al Exp $ -*- C++ -*-
 * inline utility functions, general purpose
 */
#ifndef L_UTIL_H
#define L_UTIL_H
#include "md.h"
/*--------------------------------------------------------------------------*/
/* uporder: returns true if a,b,c are in non-decreasing order */
template <class T>
inline bool up_order(T a, T b, T c)
   {return (a<=b) && (b<=c);}

/* inorder: returns true if b is between a and c */
template <class T>
inline bool in_order(T a, T b, T c)
   {return up_order(a,b,c) || up_order(c,b,a);}

/* torange: returns b, clipped to range a..c */
template <class T>
inline T to_range(T a, T b, T c)
   {return std::min(std::max(a,b),c);}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
