/*$Id: io_contr.cc,v 19.14 2001/04/06 00:55:33 al Exp $ -*- C++ -*-
 * Sets up output direction and format for most commands
 * updates pointers into the string
 * outreset starts it all over
 */
#include "io_.h"
#include "ap.h"
/*--------------------------------------------------------------------------*/
	void	initio(OMSTREAM&);
	void	decipher(char*);
	void	outreset(void);
	OMSTREAM* outset(CS&,OMSTREAM*);
static	FILE*	file_open(CS&,const char*,const char*,FILE*);
/*--------------------------------------------------------------------------*/
static FILE *fn;		/* write file				    */
/*--------------------------------------------------------------------------*/
/* initio: initialize file encryption, etc
 */
void initio(OMSTREAM& Where)
{
  const char* tag = "''''";
  if (Where.cipher())			/* if writing an encrypted file,    */
    Where << tag << '\n';		/* mark it as encrypted		    */
#if 0
  if (Whence){
    char buf[BUFLEN];
    if (!fgets(buf, BUFLEN, Whence))	/* if the first line deciphers to   */
      return;				/* the cipher tag, it is encrypted  */
    IO::incipher = true;		/* otherwise,			    */
    decipher(buf);			/*	 rewind and read normally   */
    if (strcmp(buf,tag) != 0){		/* mismatch */
      IO::incipher = false;
      fseek(Whence,0L,SEEK_SET);
    }
  }
#endif
}
/*--------------------------------------------------------------------------*/
/* decipher: un-encrypt a line of text in place
 */
void decipher(char *buf)
{
  untested();
  if (IO::incipher){
    for ( ; isprint(buf[1]); buf++ ){
      int fixed = static_cast<int>(buf[1]) - static_cast<int>(buf[0]);
      while (!isascii(fixed) || !isprint(fixed))
	fixed += (0x7f-0x20);
      buf[0] = static_cast<char>(fixed);
    }
    buf[0] = '\0';
  }
}
/*--------------------------------------------------------------------------*/
/* outreset: close files and set i/o flags to standard values
 */
void outreset(void)
{
  xclose(&fn);
  IO::formaat = 0;
  IO::incipher = false;
  IO::mstdout.reset();
}
/*--------------------------------------------------------------------------*/
/* outset: set up i/o for a command
 * return whether or not it did anything
 */
OMSTREAM* outset(CS& cmd, OMSTREAM* out)
{
  for (;;){
    if (cmd.pmatch("Basic")){
      IO::formaat = ftos_EXP;
      (*out).setformat(ftos_EXP);
    }else if (cmd.pmatch("Cipher")){
      (*out).setcipher().setpack();
    }else if (cmd.pmatch("Pack")){
      (*out).setpack();
    }else if (cmd.pmatch("Quiet")){
      (*out).detach(IO::mstdout);
    }else if (cmd.pmatch("Echo") || cmd.pmatch("List")){
      (*out).attach(IO::mstdout);
    }else if (cmd.pmatch("SAve")){
      fn = file_open(cmd,"","w",fn);
      (*out).attach(fn);
    }else if (cmd.pmatch(">$$")){
      const char *rwaflag;
      rwaflag = (cmd.pmatch(">$$")) ? "a" : "w";
      fn = file_open(cmd,"",rwaflag,fn);
      (*out).attach(fn);
      IO::formaat = ftos_EXP;
      (*out).setformat(ftos_EXP);
    }else{
      break;
    }
  }
  return out;
}
/*--------------------------------------------------------------------------*/
/* file_open: a different interface for xopen
 */
static FILE *file_open(
	CS& cmd,
	const char *ext,
	const char *rwaflag,
	FILE *fileptr)
{
  xclose(&fileptr);
  fileptr = xopen(cmd,ext,rwaflag);
  if (!fileptr)
    error(bERROR, "");
  return fileptr;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
