/*$Id: e_model.cc,v 19.6 2001/01/16 05:58:44 al Exp $ -*- C++ -*-
 * base class for all models
 */
#include "ap.h"
#include "e_model.h"
/*--------------------------------------------------------------------------*/
MODEL_CARD::MODEL_CARD()
  :CARD(),
   _tnom(NOT_INPUT)
{
  root_model_list.push_back(this);
}
/*--------------------------------------------------------------------------*/
MODEL_CARD::~MODEL_CARD()
{
  root_model_list.erase(
	std::remove(root_model_list.begin(), root_model_list.end(), this),
	root_model_list.end());
}
/*--------------------------------------------------------------------------*/
void MODEL_CARD::parse(CS& cmd)
{
  cmd.reset();
  cmd.skiparg();	/* skip known ".model" */
  parse_label(cmd);
  parse_front(cmd);
  cmd.skiplparen();
  int here = cmd.cursor();
  do{
    parse_params(cmd);
  }while (cmd.more() && !cmd.stuck(&here));
  cmd.skiprparen();
  cmd.check(bWARNING, "what's this?");
  parse_finish();
}
/*--------------------------------------------------------------------------*/
void MODEL_CARD::print(OMSTREAM& where, int)const
{
  where.setfloatwidth(7);
  where << ".model  " << short_label();
  print_front(where);
  where << "  (";
  print_params(where);
  where << ")\n*+(";
  print_calculated(where);
  where << ")\n";
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
