/*$Id: d_vs.cc,v 18.17 2000/09/04 09:45:33 al Exp $ -*- C++ -*-
 * functions for fixed voltage sources
 * temporary kluge: it has resistance
 */
#include "d_vs.h"
/*--------------------------------------------------------------------------*/
void DEV_VS::precalc()
{
  _loss1 = _loss0 = 1./OPT::shortckt;
  _y0.x  = 0.;
  _y0.f0 = 0.;
  _y0.f1 = value();
  _y1 = _y0;
  _m0.x  = 0.;
  _m0.c0 = -_loss0 * _y0.f1;
  _m0.c1 = 0.;
  _m1 = _m0;
  set_constant(!has_tr_eval());
  set_converged(!has_tr_eval());
}
/*--------------------------------------------------------------------------*/
void DEV_VS::dc_begin()
{
  _loss1 = _loss0 = 1./OPT::shortckt;
  if (!has_tr_eval()){
    set_limit(value());
    assert(_y0.x == 0.);
    assert(_y0.f0 == 0.);
    assert(_y0.f1 == value());
    assert(_m0.x == 0.);
    _m0.c0 = -_loss0 * _y0.f1;
    assert(_m0.c1 == 0.);
    assert(_m1 == _m0);
  }
}
/*--------------------------------------------------------------------------*/
bool DEV_VS::do_tr()
{
  assert(_m0.x == 0.);
  {if (has_tr_eval()){
    _y0.x = SIM::time0;
    tr_eval();
    set_limit(_y0.f1);
    store_values();
    q_load();
    _m0.c0 = -_loss0 * _y0.f1;
    assert(_m0.c1 == 0.);
  }else{
    assert(conchk(_loss0, 1./OPT::shortckt));
    assert(_y0.x == 0.);
    assert(_y0.f0 == 0.);
    assert(_y0.f1 == value());
    assert(_m0.x == 0.);
    assert(conchk(_m0.c0, -_loss0 * _y0.f1));
    assert(_m0.c1 == 0.);
    assert(_y1 == _y0);
    assert(converged());
  }}
  return converged();
}
/*--------------------------------------------------------------------------*/
void DEV_VS::do_ac()
{
  {if (has_ac_eval()){
    ac_eval();
    _acg = -_loss0 * _ev;
  }else{
    assert(_acg == 0.);
  }}
  ac_load();
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
