/*$Id: d_subckt.h,v 19.23 2001/05/11 21:30:50 al Exp $ -*- C++ -*-
 * data structures for subcircuits
 */
#ifndef D_SUBCKT_H
#define D_SUBCKT_H
#include "e_subckt.h"
/*--------------------------------------------------------------------------*/
#define NODESPERSUBCKT 1000
#define PORTSPERSUBCKT 100
/*--------------------------------------------------------------------------*/
class DEV_SUBCKT : public BASE_SUBCKT {
private:
  explicit	DEV_SUBCKT(const DEV_SUBCKT&);
public:
  explicit	DEV_SUBCKT();
		~DEV_SUBCKT()	{--_count;}
private: // override virtual
  char		id_letter()const	{return 'X';}
  const char*	dev_type()const		{untested(); return "subckt";}
  int		numnodes()const		{untested(); return 0;}
  CARD*		clone()const		{return new DEV_SUBCKT(*this);}
  void		parse(CS&);
  void		print(OMSTREAM&,int)const;
  void		expand();
  double	tr_probe_num(CS&)const;
public:
  static int	count()			{return _count;}
private:
  static int	_count;
  node_t	_nodes[PORTSPERSUBCKT+1];
};
/*--------------------------------------------------------------------------*/
class COMMON_SUBCKT : public COMMON_COMPONENT {
private:
  explicit COMMON_SUBCKT(const COMMON_SUBCKT& p):COMMON_COMPONENT(p){++_count;}
public:
  explicit COMMON_SUBCKT(int c=0)	:COMMON_COMPONENT(c){++_count;}
	   ~COMMON_SUBCKT()		{--_count;}
  bool operator==(const COMMON_COMPONENT&)const;
  COMMON_COMPONENT* clone()const	{return new COMMON_SUBCKT(*this);}
  const char*	name()const		{untested(); return "subckt";}
  static int	count()			{return _count;}
private:
  static int	_count;
};
/*--------------------------------------------------------------------------*/
class MODEL_SUBCKT : public COMPONENT {
private:
  explicit	MODEL_SUBCKT(const MODEL_SUBCKT&p):COMPONENT(p){unreachable();}
public:
  explicit	MODEL_SUBCKT();
		~MODEL_SUBCKT();
private: // override virtual
  char		id_letter()const	{return '\0';}
  const char*   dev_type()const	{untested(); return "";}
  int	        numnodes()const	{untested(); return 0;}
  CARD*		clone()const	{untested(); return new MODEL_SUBCKT(*this);}
  void		parse(CS&);
  void		print(OMSTREAM&,int)const;
  bool		is_device()const	{return false;}
  void		map_nodes()		{}
public:
  static int	count()			{return _count;}
private:
  node_t	_nodes[PORTSPERSUBCKT+1];
  static int	_count;
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
