/*$Id: d_mosc.cc,v 19.6 2001/01/16 05:58:44 al Exp $ -*- C++ -*-
 * mos model subcircuit functions
 */
#include "d_cap.h"
#include "d_mos_base.h"
/*--------------------------------------------------------------------------*/
//	void	EVAL_MOS_Cgb::tr_eval(ELEMENT*)const;
//	void	EVAL_MOS_Cgd::tr_eval(ELEMENT*)const;
//	void	EVAL_MOS_Cgs::tr_eval(ELEMENT*)const;
/*--------------------------------------------------------------------------*/
/* gate capacitors.  Meyer model.  
 * Refs: Antognetti, Divekar, Spice 2 & 3 code
 * final ref was Spice 2g6 code.
 * all except spice 3 agree except for typos and smoothing.  (yup!!)
 * (smoothing is different)
 * Spice 3 ignores substrate voltage, and returns half the value of Cgs
 *
 * Cgd and Cgs are identical except for one line (if (p->reversed()))
 */
/*--------------------------------------------------------------------------*/
void EVAL_MOS_Cgb::tr_eval(ELEMENT* d)const
{
  assert(d);
  DEV_CAPACITANCE* brh = prechecked_cast<DEV_CAPACITANCE*>(d);
  assert(brh);
  DEV_MOS* p = prechecked_cast<DEV_MOS*>(brh->owner());
  assert(p);
  const COMMON_MOS* c = prechecked_cast<const COMMON_MOS*>(p->common());
  assert(c);
  const SDP_MOS_BASE* b = prechecked_cast<const SDP_MOS_BASE*>(c->sdp);
  assert(b);

  double cap = brh->value();
  {if (p->vgst < - b->phi) { 			/* accumulation */
    cap += b->cgate;
  }else if (p->vgst < 0.) {			/* depletion */
    cap += b->cgate * (-p->vgst) / b->phi;
  }else{					/* active, overlap only */
  }}

  brh->_y0.f1 = cap;
  {if (SIM::phase == SIM::pTRAN) {
    cap = (brh->_y0.f1 + brh->_q[1].f1) / 2;
    brh->_y0.f0 = (brh->_y0.x - brh->_q[1].x) * cap + brh->_q[1].f0;
  }else{
    brh->_y0.f0 = brh->_y0.x * brh->_y0.f1;
  }}
  trace3(brh->long_label().c_str(), brh->_y0.x, brh->_y0.f0, brh->_y0.f1);
}
/*--------------------------------------------------------------------------*/
void EVAL_MOS_Cgd::tr_eval(ELEMENT* d)const
{
  assert(d);
  DEV_CAPACITANCE* brh = prechecked_cast<DEV_CAPACITANCE*>(d);
  assert(brh);
  DEV_MOS* p = prechecked_cast<DEV_MOS*>(brh->owner());
  assert(p);
  const COMMON_MOS* c = prechecked_cast<const COMMON_MOS*>(p->common());
  assert(c);
  const SDP_MOS_BASE* b = prechecked_cast<const SDP_MOS_BASE*>(c->sdp);
  assert(b);
  const MODEL_MOS_BASE* m = prechecked_cast<const MODEL_MOS_BASE*>(c->model());
  if (!m) {brh->_y0.f1= brh->_y0.f0 = 0; return;}
  assert(m);

  assert(p->vdsat >= 0.);
  assert(p->vds >= 0.);
  double vbs    = (m->cmodel == 3) ? 0. : p->vbs;
  double vdbsat = p->vdsat - vbs;
  double vdb    = p->vds   - vbs;
  double ddif   = 2. * vdbsat - vdb;
  
  double cap = 0;
  {if (!p->reversed) { // treat as Cgd
    if (p->vgst >= 0.) {
      if (p->vdsat > p->vds) {		/* linear */
	cap = (2./3.) * b->cgate * (1. - (vdbsat*vdbsat)/(ddif*ddif));
	if (p->vgst <= .1) {
	  cap *= 10. * p->vgst;	// smooth discontinuity
	}
      }
    }
  }else{ // treat as Cgs
    if (p->vgst >= -b->phi/2.) {		/* depletion  or active */
      cap = (2./3.) * b->cgate;
      if (p->vdsat > p->vds) {			/* linear */
	double ndif   = p->vdsat - p->vds;
	cap *= 1. - (ndif*ndif)/(ddif*ddif);
      }
      if (p->vgst <= 0) {
	cap *= 1. + p->vgst / (b->phi);
	cap *= 1. + p->vgst / (b->phi);
      }
    }
  }}
  cap += brh->value();		/* else overlap only */
  
  brh->_y0.f1 = cap;
  {if (SIM::phase == SIM::pTRAN) {
    cap = (brh->_y0.f1 + brh->_q[1].f1) / 2;
    brh->_y0.f0 = (brh->_y0.x - brh->_q[1].x) * cap + brh->_q[1].f0;
  }else{
    brh->_y0.f0 = brh->_y0.x * brh->_y0.f1;
  }}
  trace3(brh->long_label().c_str(), brh->_y0.x, brh->_y0.f0, brh->_y0.f1);
}
/*--------------------------------------------------------------------------*/
void EVAL_MOS_Cgs::tr_eval(ELEMENT* d)const
{
  assert(d);
  DEV_CAPACITANCE* brh = prechecked_cast<DEV_CAPACITANCE*>(d);
  assert(brh);
  DEV_MOS* p = prechecked_cast<DEV_MOS*>(brh->owner());
  assert(p);
  const COMMON_MOS* c = prechecked_cast<const COMMON_MOS*>(p->common());
  assert(c);
  const SDP_MOS_BASE* b = prechecked_cast<const SDP_MOS_BASE*>(c->sdp);
  assert(b);
  const MODEL_MOS_BASE* m = prechecked_cast<const MODEL_MOS_BASE*>(c->model());
  if (!m) {brh->_y0.f1= brh->_y0.f0 = 0; return;}
  assert(m);

  assert(p->vdsat >= 0.);
  assert(p->vds >= 0.);
  double vbs    = (m->cmodel == 3) ? 0. : p->vbs;
  double vdbsat = p->vdsat - vbs;
  double vdb    = p->vds   - vbs;
  double ddif   = 2. * vdbsat - vdb;
  
  double cap = 0;
  {if (p->reversed) { // treat as Cgd
    if (p->vgst >= 0.) {
      if (p->vdsat > p->vds) {		/* linear */
	cap = (2./3.) * b->cgate * (1. - (vdbsat*vdbsat)/(ddif*ddif));
	if (p->vgst <= .1) {
	  cap *= 10. * p->vgst;	// smooth discontinuity
	}
      }
    }
  }else{ // treat as Cgs
    if (p->vgst >= -b->phi/2.) {		/* depletion  or active */
      cap = (2./3.) * b->cgate;
      if (p->vdsat > p->vds) {			/* linear */
	double ndif   = p->vdsat - p->vds;
	cap *= 1. - (ndif*ndif)/(ddif*ddif);
      }
      if (p->vgst <= 0) {
	cap *= 1. + p->vgst / (b->phi);
	cap *= 1. + p->vgst / (b->phi);
      }
    }
  }}
  cap += brh->value();		/* else overlap only */
  
  brh->_y0.f1 = cap;
  {if (SIM::phase == SIM::pTRAN) {
    cap = (brh->_y0.f1 + brh->_q[1].f1) / 2;
    brh->_y0.f0 = (brh->_y0.x - brh->_q[1].x) * cap + brh->_q[1].f0;
  }else{
    brh->_y0.f0 = brh->_y0.x * brh->_y0.f1;
  }}
  trace3(brh->long_label().c_str(), brh->_y0.x, brh->_y0.f0, brh->_y0.f1);
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
