/*$Id: d_mos.h,v 19.23 2001/05/11 21:30:50 al Exp $ -*- C++ -*-
 * data structures and defaults for mos model.
 * internal units all mks (meters)
 * but some user input parameters are in cm.
 */
#ifndef D_MOS_H
#define D_MOS_H
#include "e_subckt.h"
#include "d_diode.h"
/*--------------------------------------------------------------------------*/
class DEV_MOS;			/* this file */
class COMMON_MOS;
class EVAL_MOS_Cgb;
class EVAL_MOS_Cgd;
class EVAL_MOS_Cgs;
/*--------------------------------------------------------------------------*/
class DEV_DIODE;		/* external */
class DEV_CAPACITANCE;
class DEV_POLY_G;
class DEV_RESISTANCE;
class MODEL_MOS_BASE;
class SDP_MOS_BASE;
enum {mNUM_INIT_COND = 3};
/*--------------------------------------------------------------------------*/
class DEV_MOS : public BASE_SUBCKT {
private:
  explicit  DEV_MOS(const DEV_MOS& p);
public:
  explicit  DEV_MOS();
	    ~DEV_MOS()	{--_count;}
private: // override virtual
  char	    id_letter()const	{return 'M';}
  const char* dev_type()const	{return "mosfet";}
  int	    numnodes()const	{return 4;}
  CARD*	    clone()const	{return new DEV_MOS(*this);}
  void	    parse(CS&);
  void	    print(OMSTREAM&,int)const;
  void	    expand();
  void	    map_nodes()
		{sourcenode.map();drainnode.map();BASE_SUBCKT::map_nodes();}
  //void    precalc();		//BASE_SUBCKT
  //void    dc_begin();		//BASE_SUBCKT
  //void    tr_begin();		//BASE_SUBCKT
  //void    tr_restore();	//BASE_SUBCKT
  void      dc_advance()      {set_not_converged(); BASE_SUBCKT::dc_advance();}
  void      tr_advance()      {set_not_converged(); BASE_SUBCKT::tr_advance();}
  bool	    tr_needs_eval();
  void	    tr_queue_eval()	{if(tr_needs_eval()){q_eval();}}
  bool	    do_tr();
  //void    tr_load();		//BASE_SUBCKT
  //double  tr_review();	//BASE_SUBCKT
  //void    tr_accept();	//BASE_SUBCKT
  //void    tr_unload();	//BASE_SUBCKT
  double    tr_probe_num(CS&)const;

  //void    ac_begin();		//BASE_SUBCKT
  //void    do_ac();		//BASE_SUBCKT
  //void    ac_load();		//BASE_SUBCKT
  //XPROBE  ac_probe_ext(CS&)const;//CKT_BASE/nothing
public:
  static int count()		{return _count;}
private:
  void	    limit_mos(double,double,double);
private:
  enum {IDS, GDS, GMF, GMR, GMBF, GMBR};
  enum {IDS_TERMS = GMBR+1};
  double ids_y0[IDS_TERMS];
  double ids_y1[IDS_TERMS];
  node_t ids_nodes[IDS_TERMS*2-1];

  enum {ISUB, GBB, GBGF, GBGR, GBDF, GBDR};
  enum {ISUB_TERMS = GBDR+1};
  double isub_y0[ISUB_TERMS];
  double isub_y1[ISUB_TERMS];
  node_t isub_nodes[ISUB_TERMS*2-1];
public:
  double ids;		/* iterated parameters, latest		*/
  double gds;	// dids/dvds
  double gm;	// dids/dvgs
  double gmb;	// dids/dvbs

  double isub;
  double gbbs;	// disub/dvbs
  double gbgs;	// disub/dvgs
  double gbds;	// disub/dvds

  double qgate;
  double cggb;
  double cgsb;
  double cgdb;

  double qdrn;
  double cdgb;
  double cdsb;
  double cddb;

  double qbulk;
  double cbgb;
  double cbsb;
  double cbdb;

  double gtau;
  double cqgb;
  double cqsb;
  double cqdb;
  double cqbb;

  double tconst;
  //double   cgb;	/* capacitors and charges		*/
  //double   qgb;
  double   qgd;
  double   cgd;
  double   qgs;
  double   cgs;

  double   vgs;		/* terminal voltages			*/
  double   vds;
  double   vbs;

  double   vdsat;	/* saturation voltage			*/
  double   vgst;	/* vgs - von.				*/
  double   von;		/* actual threshold voltage		*/
  bool     reversed;	/* flag: Vgs < 0, reverse s & d		*/
  bool     cutoff;	/* flag: in cut off region		*/
  bool     subthreshold;/* flag: subthreshold region (L2 only)	*/
  bool     saturated;	/* flag: in saturation region		*/
  bool     sbfwd;	/* flag: sb diode fwd biased		*/
  bool     dbfwd;	/* flag: db diode fwd biased		*/
  bool     punchthru;	/* flag: punch thru region		*/
  node_t   drainnode;	/* internal drain node			*/
  node_t   sourcenode;	/* internal source node			*/
  DEV_RESISTANCE*  Rs;	/* subckt elements, for probe		*/
  DEV_RESISTANCE*  Rd;
  DEV_DIODE*	   Ddb;
  DEV_DIODE*	   Dsb;
  DEV_CAPACITANCE* Cgs;
  DEV_CAPACITANCE* Cgd;
  DEV_CAPACITANCE* Cgb;
  DEV_POLY_G*	   G;
  static int _count;
};
/*--------------------------------------------------------------------------*/
class COMMON_MOS : public COMMON_COMPONENT {
private:
  explicit	COMMON_MOS(const COMMON_MOS& p);
public:
  explicit	COMMON_MOS(int c=0);
		~COMMON_MOS();
  bool		operator==(const COMMON_COMPONENT&)const;
  COMMON_COMPONENT* clone()const	{return new COMMON_MOS(*this);}
  void		parse(CS&);
  void		print(OMSTREAM&)const;
  void		expand();
  const char*	name()const		{untested(); return "mos";}
  static int	count()			{return _count;}
public:
  const SDP_CARD* sdp;
  double   lo;		/* drawn (optical) channel length	*/
  double   wo;		/* channel width (drawn)		*/
  double   ad_in;	/* drain area, drawn			*/
  double   as_in;	/* source area, drawn			*/
  double   pd;		/* drain perimeter			*/
  double   ps;		/* source perimeter			*/
  double   nrd;		/* drain # squares			*/
  double   nrs;		/* source # squares			*/
  double   ic[mNUM_INIT_COND];	/* initial conditions		*/
  int	   off;		/* off flag				*/
  int	   icset;	/* flag: initial conditions set		*/
   			/* up to here initialized		*/
  COMMON_COMPONENT* _sb;
  COMMON_COMPONENT* _db;
private:
  static int _count;
};
/*--------------------------------------------------------------------------*/
class EVAL_MOS_Cgb : public COMMON_COMPONENT {
private:
  explicit EVAL_MOS_Cgb(const EVAL_MOS_Cgb& p) 
    :COMMON_COMPONENT(p) {unreachable();}
public:
  explicit EVAL_MOS_Cgb(int c=0) :COMMON_COMPONENT(c) {}
  bool operator==(const COMMON_COMPONENT&)const {incomplete(); return false;}
  COMMON_COMPONENT* clone()const {untested(); return new EVAL_MOS_Cgb(*this);}
  const char* name()const	 {untested(); return "EVAL_MOS_Cgb";}
  void	tr_eval(ELEMENT*d)const;
  bool	has_tr_eval()const	 {return true;}
  bool	has_ac_eval()const	 {return false;}
};
/*--------------------------------------------------------------------------*/
class EVAL_MOS_Cgd : public COMMON_COMPONENT {
private:
  explicit EVAL_MOS_Cgd(const EVAL_MOS_Cgd& p) 
    :COMMON_COMPONENT(p) {unreachable();}
public:
  explicit EVAL_MOS_Cgd(int c=0) :COMMON_COMPONENT(c) {}
  bool operator==(const COMMON_COMPONENT&)const {incomplete(); return false;}
  COMMON_COMPONENT* clone()const {untested(); return new EVAL_MOS_Cgd(*this);}
  const char* name()const	 {untested(); return "EVAL_MOS_Cgd";}
  void	tr_eval(ELEMENT*d)const;
  bool	has_tr_eval()const	 {return true;}
  bool	has_ac_eval()const	 {return false;}
};
/*--------------------------------------------------------------------------*/
class EVAL_MOS_Cgs : public COMMON_COMPONENT {
private:
  explicit EVAL_MOS_Cgs(const EVAL_MOS_Cgs& p) 
    :COMMON_COMPONENT(p) {unreachable();}
public:
  explicit EVAL_MOS_Cgs(int c=0) :COMMON_COMPONENT(c) {}
  bool operator==(const COMMON_COMPONENT&)const {incomplete(); return false;}
  COMMON_COMPONENT* clone()const {untested(); return new EVAL_MOS_Cgs(*this);}
  const char* name()const	 {untested(); return "EVAL_MOS_Cgs";}
  void	tr_eval(ELEMENT*d)const;
  bool	has_tr_eval()const	 {return true;}
  bool	has_ac_eval()const	 {return false;}
};
/*--------------------------------------------------------------------------*/
#define nDRAIN	_n[0]	/* nodes */
#define	nGATE	_n[1]
#define nSOURCE	_n[2]
#define	nBULK	_n[3]
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
