/*$Id: d_cs.cc,v 16.15 1999/12/20 09:18:34 al Exp $ -*- C++ -*-
 * functions for fixed current source
 * x = 0, y.f0 = nothing, ev = y.f1 = amps.
 */
#include "d_cs.h"
/*--------------------------------------------------------------------------*/
void DEV_CS::precalc()
{
  assert(_loss0 == 0.);
  assert(_loss1 == 0.);
  _y0.x  = 0.;
  _y0.f0 = 0.;
  _y0.f1 = value();
  _y1 = _y0;
  _m0.x  = 0.;
  _m0.c0 = _y0.f1;
  _m0.c1 = 0.;
  _m1 = _m0;
  set_constant(!has_tr_eval());
  set_converged(!has_tr_eval());
}
/*--------------------------------------------------------------------------*/
void DEV_CS::dc_begin()
{
  if (!has_tr_eval()){
    assert(_loss0 == 0.);
    assert(_loss1 == 0.);
    assert(_y0.x  == 0.);
    assert(_y0.f0 == 0.);
    assert(_y0.f1 == value());
    assert(_m0.x  == 0.);
    assert(_m0.c0 == _y0.f1);
    assert(_m0.c1 == 0.);
    assert(_m1 == _m0);
  }
}
/*--------------------------------------------------------------------------*/
bool DEV_CS::do_tr()
{
  assert(_m0.x == 0.);
  {if (has_tr_eval()){
    _y0.x = SIM::time0;
    tr_eval();
    store_values();
    q_load();
    _m0.c0 = _y0.f1;
    assert(_m0.c1 == 0.);
  }else{
    untested();
    assert(_y0.x  == 0.);
    assert(_y0.f0 == 0.);
    assert(_y0.f1 == value());
    assert(_m0.x  == 0.);
    assert(_m0.c0 == _y0.f1);
    assert(_m0.c1 == 0.);
    assert(_y1 == _y0);
    assert(converged());
  }}
  return converged();
}
/*--------------------------------------------------------------------------*/
void DEV_CS::do_ac()
{
  {if (has_ac_eval()){
    ac_eval();
    _acg = _ev;
  }else{
    assert(_acg == 0.);
  }}
  ac_load();
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
