/*$Id: c_genrat.cc,v 18.7 2000/07/25 16:07:21 al Exp $ -*- C++ -*-
 * set up generator for transient analysis
 */
#include "constant.h"
#include "s__.h"
#include "ap.h"
#include "c_comand.h"
// testing=nonstrict
/*--------------------------------------------------------------------------*/
//	void	CMD::generator(CS&);
	double	gen();
/*--------------------------------------------------------------------------*/
static double freq = 0;
static double ampl = 1;
static double phaz = 0.;
static double maxv = 1.;
static double minv = 0.;
static double offset = 0.;
static double init = 0.;
static double rise = 1e-12;
static double fall = 1e-12;
static double delay = 0.;
static double width = 0.;
static double period = 0.;
/*--------------------------------------------------------------------------*/
void CMD::generator(CS& cmd)
{
  OMSTREAM where = (cmd.more())  ?  OMSTREAM()  :  IO::mstdout;
  int here = cmd.cursor();
  do{
    ::get(cmd, "Frequency", &freq,	mPOSITIVE);
    ::get(cmd, "Amplitude", &ampl);
    ::get(cmd, "Phase",	    &phaz);
    ::get(cmd, "MAx",	    &maxv);
    ::get(cmd, "MIn",	    &minv);
    ::get(cmd, "Offset",    &offset);
    ::get(cmd, "Init",	    &init);
    ::get(cmd, "Rise",	    &rise,	mPOSITIVE);
    ::get(cmd, "Fall",	    &fall,	mPOSITIVE);
    ::get(cmd, "Delay",	    &delay,	mPOSITIVE);
    ::get(cmd, "Width",	    &width,	mPOSITIVE);
    ::get(cmd, "PEriod",    &period,	mPOSITIVE);
  }while (cmd.more() && !cmd.stuck(&here));
  cmd.check(bWARNING, "what's this");

  where.setfloatwidth(7);
  where <<   "freq="	<< freq;
  where << "  ampl="	<< ampl;
  where << "  phase="	<< phaz;
  where << "  max="	<< maxv;
  where << "  min="	<< minv;
  where << "  offset="	<< offset;
  where << "  init="	<< init;
  where << "  rise="	<< rise;
  where << "  fall="	<< fall;
  where << "  delay="	<< delay;
  where << "  width="	<< width;
  where << "  period="	<< period;
  where << "\n";
}
/*--------------------------------------------------------------------------*/
double gen()
{
  if (SIM::time0 <= delay){
    return init;
  }
  double loctime = SIM::time0 - delay;
  if (period > 0.){
    loctime = fmod(loctime, period);
  }

  double level;
  {if (SIM::time0 <= delay + rise){			/* initial rise */
    level = (maxv - 0) * (loctime/rise) + 0;
  }else if (loctime <= rise){                           /* rising       */
    level = (maxv - minv) * (loctime/rise) + minv;
  }else if (width==0.  ||  (loctime-=rise) <= width){	/* pulse on     */
    level = maxv;
  }else if ((loctime-=width) <= fall){                  /* falling      */
    level = (minv - maxv) * (loctime/fall) + maxv;
  }else{                                                /* pulse off    */
    level = minv;
  }}
  level *= (freq == 0.) 
    ? ampl
    : ampl * sin(kPIx2*freq*(SIM::time0-delay) + phaz*DTOR);
  return (SIM::time0 <= delay + rise)
    ? level + (offset - init) * (loctime/rise) + init
    : level + offset;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
