/*$Id: c_fanout.cc,v 19.14 2001/04/06 00:55:33 al Exp $ -*- C++ -*-
 * Prints out a list of all node connections.
 */
#include "ap.h"
#include "e_card.h"
#include "c_comand.h"
/*--------------------------------------------------------------------------*/
//	void	CMD::fanout(CS&);
static	void	checklist(const CARD_LIST&,int,OMSTREAM);
/*--------------------------------------------------------------------------*/
void CMD::fanout(CS& cmd)
{
  OMSTREAM out = IO::mstdout;
  int start = -1;
  int stop  = -1;
  for (;;){
    {if (cmd.is_digit()){
      int temp = cmd.ctoi();
      {if (cmd.match1('-')){
	untested();
	cmd.skip();
	start = temp;
      }else if (start < 0){
	start = temp;
	{if (stop < 0){
	  stop = start;
	}else{
	  untested();
	}}
      }else{
	untested();
	stop = temp;
      }}
    }else if (cmd.match1('-')){
      cmd.skip();
      cmd.skipbl();
      {if (cmd.is_digit()){
	untested();
	stop = cmd.ctoi();
      }else{
	untested();
      }}
    }else{
      outset(cmd,&out);
      cmd.check(bWARNING, "what's this");
      break;
    }}
  }
  
  if (start < 0){
    start = 0;
  }
  if (stop < 0  ||  stop > STATUS::total_nodes){
    stop = STATUS::user_nodes;
  }
  if (start>STATUS::total_nodes){
    untested();
    error(bERROR, "%u nodes\n", STATUS::total_nodes);
  }
  
  out << "Node:  Branches\n";
  for (int ii = start;  ii <= stop;  ++ii){
    out.form("%4u:",ii);
    checklist(CARD_LIST::card_list, ii, out);
    out << '\n';
  }
}
/*--------------------------------------------------------------------------*/
/* checklist: print a list of all elements connecting to a node
 *	recursive, for subckts
 */
static void checklist(const CARD_LIST& cl, int node, OMSTREAM out)
{
  for (CARD_LIST::const_iterator ci = cl.begin(); ci != cl.end(); ++ci){
    if ((**ci).is_device()){
      if ((**ci).connects_to(node)){
	out << ' ' << (**ci).long_label();
      }
      checklist((**ci).subckt(), node, out);
    }
  }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
