/*$Id: bmm_table.h,v 19.22 2001/05/08 04:10:27 al Exp $ -*- C++ -*-
 * behavioral modeling
 * Spice3 compatible "semiconductor resistor and capacitor""
 */
#include "e_model.h" 
#include "bm.h"
/*--------------------------------------------------------------------------*/
class SPLINE;
/*--------------------------------------------------------------------------*/
class EVAL_BM_TABLE : public EVAL_BM_ACTION_BASE {
protected:
  explicit EVAL_BM_TABLE(const EVAL_BM_TABLE& p);
public:
  explicit EVAL_BM_TABLE(int c=0);
  ~EVAL_BM_TABLE() {}
private: // override virtual
  COMMON_COMPONENT* clone()const {untested(); return new EVAL_BM_TABLE(*this);}
  const char*	name()const	{untested();return modelname().c_str();}
  bool ac_too()const		{untested();return false;}
  void parse(CS&);
  void print(OMSTREAM&)const;
  void expand();
  void tr_eval(ELEMENT*)const;
};
/*--------------------------------------------------------------------------*/
class MODEL_TABLE : public MODEL_CARD {
public:
  int	 _order;
  double _below;
  double _above;
  std::vector<std::pair<double,double> > _table;
  SPLINE* _spline;
public:
  explicit MODEL_TABLE();
private: // override virtual
  COMMON_COMPONENT* new_common()const {return new EVAL_BM_TABLE;}
  bool parse_front(CS&);
  void parse_params(CS&);
  void parse_finish();
  void print_front(OMSTREAM&)const;
  void print_params(OMSTREAM&)const;
  void print_calculated(OMSTREAM&)const {}
  void tr_eval(COMPONENT*)const;
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
