/*$Id: bmm_semi.h,v 19.21 2001/05/06 02:09:44 al Exp $ -*- C++ -*-
 * behavioral modeling
 * Spice3 compatible "semiconductor resistor and capacitor""
 */
#include "e_model.h" 
#include "bm.h"
/*--------------------------------------------------------------------------*/
class EVAL_BM_SEMI_BASE : public EVAL_BM_ACTION_BASE {
protected:
  double _length;
  double _width;
  double _temp;
  double _value;
  explicit EVAL_BM_SEMI_BASE(const EVAL_BM_SEMI_BASE& p);
protected:
  explicit EVAL_BM_SEMI_BASE(int c=0);
  ~EVAL_BM_SEMI_BASE() {}
private: // override virtual
  COMMON_COMPONENT* clone()const = 0;
  const char*	name()const	{untested();return modelname().c_str();}
  bool ac_too()const		{untested();return false;}
  void parse(CS&);
  void print(OMSTREAM&)const;
  void expand() = 0;
  void tr_eval(ELEMENT*)const;
};
/*--------------------------------------------------------------------------*/
class EVAL_BM_SEMI_CAPACITOR : public EVAL_BM_SEMI_BASE {
private:
  explicit EVAL_BM_SEMI_CAPACITOR(const EVAL_BM_SEMI_CAPACITOR& p)
    :EVAL_BM_SEMI_BASE(p) {untested();}
public:
  explicit EVAL_BM_SEMI_CAPACITOR(int c=0)
    :EVAL_BM_SEMI_BASE(c) {}
  ~EVAL_BM_SEMI_CAPACITOR() {}
private: // override virtual
  COMMON_COMPONENT* clone()const 
			{untested(); return new EVAL_BM_SEMI_CAPACITOR(*this);}
  void expand();
};
/*--------------------------------------------------------------------------*/
class EVAL_BM_SEMI_RESISTOR : public EVAL_BM_SEMI_BASE {
private:
  explicit EVAL_BM_SEMI_RESISTOR(const EVAL_BM_SEMI_RESISTOR& p)
    :EVAL_BM_SEMI_BASE(p) {untested();}
public:
  explicit EVAL_BM_SEMI_RESISTOR(int c=0)
    :EVAL_BM_SEMI_BASE(c) {}
  ~EVAL_BM_SEMI_RESISTOR() {}
private: // override virtual
  COMMON_COMPONENT* clone()const
			{untested(); return new EVAL_BM_SEMI_RESISTOR(*this);}
  void expand();
};
/*--------------------------------------------------------------------------*/
class MODEL_SEMI_CAPACITOR : public MODEL_CARD {
public:
  double _cj;
  double _cjsw;
  double _narrow;
  double _defw;
  double _tc1;
  double _tc2;
public:
  explicit MODEL_SEMI_CAPACITOR();
private: // override virtual
  COMMON_COMPONENT* new_common()const {return new EVAL_BM_SEMI_CAPACITOR;}
  bool parse_front(CS&);
  void parse_params(CS&);
  void parse_finish() {}
  void print_front(OMSTREAM&)const;
  void print_params(OMSTREAM&)const;
  void print_calculated(OMSTREAM&)const {}
};
/*--------------------------------------------------------------------------*/
class MODEL_SEMI_RESISTOR : public MODEL_CARD {
public:
  double _rsh;
  double _narrow;
  double _defw;
  double _tc1;
  double _tc2;
public:
  explicit MODEL_SEMI_RESISTOR();
private: // override virtual
  COMMON_COMPONENT* new_common()const {return new EVAL_BM_SEMI_RESISTOR;}
  bool parse_front(CS&);
  void parse_params(CS&);
  void parse_finish() {}
  void print_front(OMSTREAM&)const;
  void print_params(OMSTREAM&)const;
  void print_calculated(OMSTREAM&)const {}
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
