/*$Id: bm_model.cc,v 19.20 2001/05/05 07:42:40 al Exp $ -*- C++ -*-
 * behavioral modeling ".model" stub
 * accepts an unknown name for later linking to a .model
 */
#include "e_model.h"
#include "ap.h"
#include "bm.h"
/*--------------------------------------------------------------------------*/
EVAL_BM_MODEL::EVAL_BM_MODEL(int c)
  :EVAL_BM_ACTION_BASE(c),
   _arglist(),
   _func(0)
{
}
/*--------------------------------------------------------------------------*/
EVAL_BM_MODEL::EVAL_BM_MODEL(const EVAL_BM_MODEL& p)
  :EVAL_BM_ACTION_BASE(p),
   _arglist(p._arglist),
   _func(0)
{
  untested();
  attach_common(p._func, &_func);
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_MODEL::parse(CS& cmd)
{
  assert(!has_model());
  parse_modelname(cmd);
  _arglist = cmd.ctos("", '(', ')');
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_MODEL::print(OMSTREAM& where)const
{
  {if (_func) {
    _func->print(where);
  }else{
    where << "  " << modelname() << " (" << _arglist << ")";
  }}
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_MODEL::expand()
{
  const MODEL_CARD* m = attach_model();
  if (!m) {
    untested();
    error(bERROR, "can't find model " + modelname());
  }
  EVAL_BM_ACTION_BASE* c = dynamic_cast<EVAL_BM_ACTION_BASE*>(m->new_common());
  if (!c) {
    error(bERROR, "model type mismatch");
  }
  c->set_modelname(modelname());
  CS args(_arglist);
  c->parse(args);
  c->expand();
  attach_common(c, &_func);
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
