/*$Id: bm_complex.cc,v 19.17 2001/04/28 22:47:17 al Exp $ -*- C++ -*-
 * behavioral modeling complex value
 * used with tc, etc, and conditionals
 */
#include "ap.h"
#include "bm.h"
/*--------------------------------------------------------------------------*/
EVAL_BM_COMPLEX::EVAL_BM_COMPLEX(int c)
  :EVAL_BM_ACTION_BASE(c),
   _value(NOT_INPUT)
{
}
/*--------------------------------------------------------------------------*/
EVAL_BM_COMPLEX::EVAL_BM_COMPLEX(const EVAL_BM_COMPLEX& p)
  :EVAL_BM_ACTION_BASE(p),
   _value(p._value)
{
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_COMPLEX::parse(CS& cmd)
{
  int here = cmd.cursor();
  do{
    int paren = cmd.skiplparen();
    double real = NOT_VALID;
    double imag = 0.;
    cmd >> real >> imag;
    {if (cmd.gotit(here)){
      _value = COMPLEX(real,imag);
    }else{
      untested();
    }}
    paren -= cmd.skiprparen();
    if (paren != 0){
      untested();
      cmd.warn(bWARNING, "need )");
    }
    parse_base(cmd);
  }while (cmd.more() && !cmd.stuck(&here));
  parse_base_finish();
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_COMPLEX::print(OMSTREAM& where)const
{
  where << "  " << name() << '(' 
	<< _value.real() << ',' << _value.imag() << ')';
  print_base(where);
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_COMPLEX::tr_eval(ELEMENT* d)const
{
  tr_finish_tdv(d, _value.real());
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_COMPLEX::ac_eval(ELEMENT* d)const
{
  d->_ev = _value;
  ac_final_adjust_with_temp(&(d->_ev));
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
