/*$Id: mg_out_root.cc,v 19.23 2001/05/11 21:28:46 al Exp $ -*- C++ -*-
 */
#include "mg_out.h"
/*--------------------------------------------------------------------------*/
static void make_header(std::ofstream& out, const File& in, 
			const std::string& dump_name)
{
  out << in.head()
      << "/* This file is automatically generated. DO NOT EDIT */\n"
      << in.cc_headers()
      << "#include \"ap.h\"\n"
    "#include \"" << dump_name << ".h\"\n"
    "/*--------------------------------------"
    "------------------------------------*/\n"
    "const double NA(NOT_INPUT);\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_tail(std::ofstream& out, const File& in)
{
  out << in.cc_direct() <<
    "/*--------------------------------------"
    "------------------------------------*/\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
void make_cc_file(const File& in)
{
  std::string dump_name = in.name();
  dump_name.erase(dump_name.rfind(".model"));
  std::ofstream out((dump_name+".cc").c_str());
  if (!out) {
    untested();
    os_error(dump_name);
  }
  dump_name.erase(dump_name.find("../"),3);

  make_header(out, in, dump_name);

  {for (Model_List::const_iterator
	 m = in.models().begin();  m != in.models().end();  ++m) {
    make_cc_model(out, **m);
  }}
  {for (Device_List::const_iterator
	 m = in.devices().begin();  m != in.devices().end();  ++m) {
    out << "int DEV_" << (**m).name() << "::_count = 0;\n"
      "int COMMON_" << (**m).name() << "::_count = -1;\n"
      "static COMMON_" << (**m).name() << " Default_" << (**m).name() 
	<< "(CC_STATIC);\n"
      "/*--------------------------------------"
      "------------------------------------*/\n";
    make_cc_dev(out, **m);
    make_cc_common(out, **m);
  }}
  make_tail(out, in);
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
