/*$Id: mg_out_model.cc,v 19.23 2001/05/11 21:28:46 al Exp $ -*- C++ -*-
 */
#include "mg_out.h"
/*--------------------------------------------------------------------------*/
static void make_sdp_constructor(std::ofstream& out, const Model& m)
{
  out << "SDP_" << m.name() << "::SDP_" << m.name() 
      << "(const COMMON_COMPONENT* cc)\n"
      << "  :SDP_" << m.inherit() << "(cc)\n"
      << "{\n";
  if (!m.size_dependent().is_empty()) {
    out << "  assert(cc);\n"
      "  const COMMON_" << m.root() << "* c = prechecked_cast<const COMMON_"
	<< m.root() << "*>(cc);\n"
      "  assert(c);\n"
	<< "  const MODEL_" << m.name() 
	<< "* m = prechecked_cast<const MODEL_" 
	<< m.name() << "*>(c->model());\n"
      "  assert(m);\n"
	<< m.size_dependent().code_front();

    make_final_adjust_parameter_list(out, m.size_dependent().override());
    {for (Parameter_List::const_iterator
	   p = m.size_dependent().raw().begin();
	 p != m.size_dependent().raw().end(); ++p) {
      {if (!((**p).final_default().empty())) {
	out << "  " << (**p).code_name() 
	    << " = ((m->" << (**p).code_name() << ".nom() == NA)\n"
	  "    ? " << (**p).final_default() <<"\n"
	  "    : m->" << (**p).code_name() << "(L, W));\n";
      }else{
	out << "  " << (**p).code_name() << " = m->" << (**p).code_name()
	    << "(L, W);\n";
	make_final_adjust_parameter(out, **p);
      }}
    }}
    make_final_adjust_parameter_list(out, m.size_dependent().calculated());
    out << m.size_dependent().code();
  }
  
  out << "}\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_tdp_constructor(std::ofstream& out, const Model& m)
{
  out << "TDP_" << m.name() << "::TDP_" << m.name() 
      << "(const DEV_" << m.root() << '*';
  if (!m.is_base() || !m.temperature().is_empty()) {
    out << " d";
  }
  out << ")\n";
  if (!m.is_base()) {
    out << "  :TDP_" << m.inherit() << "(d)\n";
  }
  out << "{\n";
  if (!m.temperature().is_empty()) {
    out << "  assert(d);\n"
      "  const COMMON_" << m.root() << "* c = prechecked_cast<const COMMON_" 
	<< m.root() << "*>(d->common());\n"
      "  assert(c);\n"
      "  const SDP_" << m.name() << "* b = prechecked_cast<const SDP_" 
	<< m.name() << "*>(c->sdp);\n"
      "  assert(b);\n"
      "  const MODEL_" << m.name() << "* m = prechecked_cast<const MODEL_" 
	<< m.name() << "*>(c->model());\n"
      "  assert(m);\n";
    make_final_adjust(out, m.temperature());
  }

  out << "}\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_model_constructor(std::ofstream& out, const Model& m)
{
  out << "MODEL_" << m.name() << "::MODEL_" << m.name() << "()\n"
    "  :MODEL_" << m.inherit() << "()";

  make_construct_parameter_list(out, m.size_dependent().raw());
  make_construct_parameter_list(out, m.independent().raw());
  make_construct_parameter_list(out, m.independent().calculated());
  out << "\n{\n"
    "  ++_count;\n";
  {for (Parameter_List::const_iterator
	 p = m.independent().override().begin();
       p != m.independent().override().end();
       ++p) {
    if (!((**p).final_default().empty())) {
      out << "  " << (**p).code_name() << " = NA;\n";
    }
    if (!((**p).default_val().empty())) {
      out << "  " << (**p).code_name() << " = " << (**p).default_val() <<";\n";
    }
  }}
  out << "}\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_model_parse_front(std::ofstream& out, const Model& m)
{
  out << "bool MODEL_" << m.name() << "::parse_front(CS& cmd)\n"
    "{\n";
  {if (!m.key_list().is_empty()) {
    out << "  return ";
    Key_List::const_iterator k = m.key_list().begin();
    {for (;;) {
      out << "set(cmd, \"" << (**k).name() << "\", &" << (**k).var() << ", " 
	  << (**k).value() << ")";
      ++k;
      if (k == m.key_list().end()) {
	break;
      }
      out << "\n    || ";
    }}
    {if (!m.is_base()) {
      out << "\n    || MODEL_" << m.inherit() << "::parse_front(cmd);\n";
    }else{
      out << ";\n";
    }}
  }else{
    {if (!m.is_base()) {
      out << "  return MODEL_" << m.inherit() << "::parse_front(cmd);\n";
    }else{
      out << "  return true;\n";
    }}
  }}
  out << "}\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_model_parse_params(std::ofstream& out, const Model& m)
{
  out << "void MODEL_" << m.name() << "::parse_params(CS& cmd)\n{\n";
  make_get_param_list(out, m.independent().override());
  make_get_param_list(out, m.size_dependent().raw());
  make_get_param_list(out, m.independent().raw());
  if (!m.is_base()) {
    out << "  MODEL_" << m.inherit() << "::parse_params(cmd);\n";
  }
  out << "}\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_model_parse_finish(std::ofstream& out, const Model& m)
{
  out << "void MODEL_" << m.name() << "::parse_finish()\n{\n";
  if (!m.is_base()) {
    out << "  MODEL_" << m.inherit() << "::parse_finish();\n";
  }
  make_final_adjust(out, m.independent());
  out << "}\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_model_print_front(std::ofstream& out, const Model& m)
{
  out << "void MODEL_" << m.name() << "::print_front(OMSTREAM& o)const\n{\n";
  {if (!m.key_list().is_empty()) {
    out << "  {";
    Key_List::const_iterator k = m.key_list().begin();
    {for (;;) {
      out << "if (" << (**k).var() << " == " << (**k).value() << ") {\n"
	  << "    o << \"  " << to_lower((**k).name()) << "\";\n";
      ++k;
      if (k == m.key_list().end()) {
	break;
      }
      out << "  }else ";
    }}
    out << "  }else{\n";
    {if (!m.is_base()) {
      out << "    MODEL_" << m.inherit() << "::print_front(o);\n";
    }else{
      out << "    unreachable();\n";
    }}
    out << "  }}\n";
  }else{
    if (!m.is_base()) {
      out << "  MODEL_" << m.inherit() << "::print_front(o);\n";
    }
  }}
  out << "}\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_model_print_params(std::ofstream& out, const Model& m)
{
  out << "void MODEL_" << m.name() << "::print_params(OMSTREAM& o)const\n{\n";
  
  if (m.level() != "") {
    out << "  o << \"level=" << m.level() << "\";\n";
  }
  if (!m.is_base()) {
    out << "  MODEL_" << m.inherit() << "::print_params(o);\n";
  }
  make_print_param_list(out, m.independent().override());

  {for (Parameter_List::const_iterator
	 p = m.size_dependent().raw().begin();
       p != m.size_dependent().raw().end(); ++p) {
    if (!((**p).user_name().empty())) {
      out << "  " << (**p).code_name() << ".print(o, \"" 
	  << to_lower((**p).user_name()) << "\");\n";
    }
  }}

  make_print_param_list(out, m.independent().raw());
  out << "}\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_model_print_calculated(std::ofstream& out, const Model& m)
{
  out << "void MODEL_" << m.name() 
      << "::print_calculated(OMSTREAM& o)const\n{\n";
  {if (!m.is_base()) {
    out << "  MODEL_" << m.inherit() << "::print_calculated(o);\n";
  }else{
    out << "  o << \"\";\n"; // print nothing, suppresses a warning
  }}
  make_print_calc_param_list(out, m.independent().override());
  make_print_calc_param_list(out, m.independent().raw());
  make_print_calc_param_list(out, m.independent().calculated());
  out << "}\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_tr_eval(std::ofstream& out, const Model& m)
{
  out << "void MODEL_" << m.name() << "::tr_eval(COMPONENT*";
  {if (m.tr_eval().is_empty() && m.temperature().is_empty()) {
    out << ")const\n{\n";
  }else{
    out << " brh)const\n{\n"
      "  DEV_" << m.root() << "* d = prechecked_cast<DEV_"
	<< m.root() << "*>(brh);\n"
      "  assert(d);\n"
      "  const COMMON_" << m.root() << "* c = prechecked_cast<const COMMON_"
	<< m.root() << "*>(d->common());\n"
      "  assert(c);\n"
      "  const SDP_" << m.name() << "* b = prechecked_cast<const SDP_" 
	<< m.name() << "*>(c->sdp);\n"
      "  assert(b);\n"
      "  const MODEL_" << m.name() << "* m = this;\n";
    if (!m.temperature().is_empty()) {
      out << "  TDP_" << m.name() << " t(d);\n";
    }
    out << m.tr_eval();
  }}
  out << "}\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
void make_cc_model(std::ofstream& out, const Model& m)
{
  out << "int MODEL_" << m.name() << "::_count = 0;\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
  make_sdp_constructor(out, m);
  make_tdp_constructor(out, m);
  make_model_constructor(out, m);
  make_model_parse_front(out, m);
  make_model_parse_params(out, m);
  make_model_parse_finish(out, m);
  make_model_print_front(out, m);
  make_model_print_params(out, m);
  make_model_print_calculated(out, m);
  make_tr_eval(out, m);
  out << "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
