/*$Id: mg_out_lib.cc,v 19.23 2001/05/11 21:28:46 al Exp $ -*- C++ -*-
 */
#include "mg_out.h"
/*--------------------------------------------------------------------------*/
void make_final_adjust_parameter(std::ofstream& out, const Parameter& p)
{
  if (!(p.calculate().empty())) {
    out << "  " << p.code_name() << " = " << p.calculate() << ";\n";
  }
  if (!(p.final_default().empty())) {
    out << "  if (" << p.code_name() << " == NA) {\n"
      "    " << p.code_name() << " = " << p.final_default() << ";\n"
      "  }\n";
  }
  if (!(p.quiet_min().empty())) {
    out << "  " << p.code_name() << " = std::max(" 
	<< p.code_name() << ", " << p.quiet_min() << ");\n";
  }
  if (!(p.quiet_max().empty())) {
    out << "  " << p.code_name() << " = std::min(" 
	<< p.code_name() << ", " << p.quiet_max() << ");\n";
  }
}
/*--------------------------------------------------------------------------*/
void make_final_adjust_parameter_list(std::ofstream& out,
				      const Parameter_List& pl)
{
  {for (Parameter_List::const_iterator p = pl.begin(); p != pl.end(); ++p) {
    make_final_adjust_parameter(out, **p);
  }}
}
/*--------------------------------------------------------------------------*/
void make_final_adjust(std::ofstream& out, const Parameter_Block& b)
{
  out << b.code_front() << '\n';
  make_final_adjust_parameter_list(out, b.override());
  make_final_adjust_parameter_list(out, b.raw());
  make_final_adjust_parameter_list(out, b.calculated());
  out << b.code();
}
/*--------------------------------------------------------------------------*/
static void make_construct_parameter(std::ofstream& out, const Parameter& p)
{
  {if (!(p.default_val().empty())) {
    out << ",\n   " << p.code_name() << "(" << p.default_val() << ")";
  }else{
    out << ",\n   " << p.code_name() << "(NA)";
  }}
}
/*--------------------------------------------------------------------------*/
void make_construct_parameter_list(std::ofstream& out,
				   const Parameter_List& pl)
{
  {for (Parameter_List::const_iterator p = pl.begin(); p != pl.end(); ++p) {
    make_construct_parameter(out, **p);
  }}
}
/*--------------------------------------------------------------------------*/
static void make_get_one_param(std::ofstream& out, const Parameter& p,
		     const std::string& name)
{
  if (!(name.empty())) {
    out << "  get(cmd, \"" << name << "\", &" << p.code_name();
    {if (!(p.offset().empty())) {
      out << ", mOFFSET, " << p.offset() << ");\n";
    }else if (p.positive()) {
      out << ", mPOSITIVE);\n";
    }else if (p.octal()) {
      out << ", mOCTAL);\n";
    }else if (!(p.scale().empty())) {
      out << ", mSCALE, " << p.scale() << ");\n";
    }else{
      out << ");\n";
    }}
  }
}
/*--------------------------------------------------------------------------*/
void make_get_param_list(std::ofstream& out, const Parameter_List& pl)
{
  {for (Parameter_List::const_iterator p = pl.begin(); p != pl.end(); ++p) {
    make_get_one_param(out, **p, (**p).user_name());
    make_get_one_param(out, **p, (**p).alt_name());
  }}
}
/*--------------------------------------------------------------------------*/
static void make_print_one_param(std::ofstream& out, const Parameter& p)
{
  if (!(p.user_name().empty())) {
    {if (!(p.print_test().empty())) {
      out << "  if (" << p.print_test() << ")\n  ";
    }else if (p.default_val() == "NA") {
      out << "  if (" << p.code_name() << " != NA)\n  ";
    }}
    out << "  o << \"  " << to_lower(p.user_name()) << "=\" << " 
	<< p.code_name();
    if (!(p.offset().empty())) {
      out << "-(" << p.offset() << ")";
    }
    if (!(p.scale().empty())) {
      out << "/(" << p.scale() << ")";
    }
    out << ";\n";
  }
}
/*--------------------------------------------------------------------------*/
void make_print_param_list(std::ofstream& out, const Parameter_List& pl)
{
  {for (Parameter_List::const_iterator p = pl.begin(); p != pl.end(); ++p) {
    make_print_one_param(out, **p);
  }}
}
/*--------------------------------------------------------------------------*/
static void make_print_one_calc_param(std::ofstream& out, const Parameter& p)
{
  if (!(p.user_name().empty()) && !(p.calc_print_test().empty())) {
    out << "  if (" << p.calc_print_test() << ")\n  "
      "  o << \"* " << to_lower(p.user_name()) << "=\" << " 
	<< p.code_name();
    if (!(p.offset().empty())) {
      out << "-(" << p.offset() << ")";
    }
    if (!(p.scale().empty())) {
      out << "/(" << p.scale() << ")";
    }
    out << ";\n";
  }
}
/*--------------------------------------------------------------------------*/
void make_print_calc_param_list(std::ofstream& out, const Parameter_List& pl)
{
  {for (Parameter_List::const_iterator p = pl.begin(); p != pl.end(); ++p) {
    make_print_one_calc_param(out, **p);
  }}
}
/*--------------------------------------------------------------------------*/
static void make_copy_construct_parameter(std::ofstream& out,
					  const Parameter& p)
{
  out << ",\n   " << p.code_name() << "(p." << p.code_name() << ")";
}
/*--------------------------------------------------------------------------*/
void make_copy_construct_parameter_list(std::ofstream& out,
					const Parameter_List& pl)
{
  {for (Parameter_List::const_iterator p = pl.begin(); p != pl.end(); ++p) {
    make_copy_construct_parameter(out, **p);
  }}
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
