/*$Id: mg_out_h.cc,v 19.23 2001/05/11 21:28:46 al Exp $ -*- C++ -*-
 */
#include "mg_out.h"
/*--------------------------------------------------------------------------*/
static void make_header(std::ofstream& out, const File& in, 
			const std::string& dump_name)
{
  out << in.head()
      << "/* This file is automatically generated. DO NOT EDIT */\n"
    "#ifndef " << to_upper(dump_name) << "_H_INCLUDED\n"
    "#define " << to_upper(dump_name) << "_H_INCLUDED\n"
      << in.h_headers()
      << "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_sdp(std::ofstream& out, const Model& m)
{
  out << "class SDP_" << m.name()
      << "\n  :public SDP_" << m.inherit()
      << "{\n"
    "public:\n"
    "  explicit SDP_" << m.name() << "(const COMMON_COMPONENT*);\n"
    "public:\n";
  Parameter_List::const_iterator p = m.size_dependent().raw().begin();
  {for (;;) {
    if (p == m.size_dependent().raw().end()) {
      p = m.size_dependent().calculated().begin();
    }
    if (p == m.size_dependent().calculated().end()) {
      break;
    }
    out << "  " << (**p).type() << " " << (**p).code_name() 
	<< ";\t// " << (**p).comment() << '\n';
    ++p;
  }}
  out << "};\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_tdp(std::ofstream& out, const Model& m)
{
  out << "class TDP_" << m.name();
  if (!m.is_base()) {
    out << "\n  :public TDP_" << m.inherit();
  }
  out << "{\n"
    "public:\n"
    "  explicit TDP_"<< m.name() <<"(const DEV_" << m.root() << "*);\n"
    "public:\n";
  {for (Parameter_List::const_iterator
	 p = m.temperature().calculated().begin();
       p != m.temperature().calculated().end(); ++p) {
    out << "  " << (**p).type() << " " << (**p).code_name() 
	<< ";\t// " << (**p).comment() << '\n';
  }}
  out << "};\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/ static void make_model(std::ofstream& out, const Model& m)
{
  std::string class_name = "MODEL_" + m.name().string();
  out << "class " << class_name << "\n"
    "  :public MODEL_" << m.inherit() << "{\n"
    "public:\n"
    "  // using generated copy constructor, should be unreachable\n"
    "  explicit " << class_name << "();\n"
    "  ~" << class_name << "() {--_count;}\n"
    "public: // override virtual\n"
    "  bool      parse_front(CS&);\n"
    "  void      parse_params(CS&);\n"
    "  void      parse_finish();\n"
    "  SDP_CARD* new_sdp(const COMMON_COMPONENT* c)const {return new SDP_"
      << m.name() << "(c);}\n"
    "  void      print_front(OMSTREAM&)const;\n"
    "  void      print_params(OMSTREAM&)const;\n"
    "  void      print_calculated(OMSTREAM&)const;\n"
    "  void      tr_eval(COMPONENT*)const;\n"
    "public: // not virtual\n"
    "  static int count() {return _count;}\n"
    "public: // strictly internal\n";
  if (m.level() != "") {
    out << "  enum {LEVEL=" << m.level() <<"};\n";
  }
  out << "  static int _count;\n"
    "public: // input parameters\n";
  {for (Parameter_List::const_iterator
	 p = m.size_dependent().raw().begin();
       p != m.size_dependent().raw().end(); ++p) {
    out << "  " << "SDP" << " " << (**p).code_name()
	<< ";\t// " << (**p).comment() << '\n';
  }}
  {for (Parameter_List::const_iterator
	 p = m.independent().raw().begin();
       p != m.independent().raw().end(); ++p) {
    out << "  " << (**p).type() << " " << (**p).code_name()
	<< ";\t// " << (**p).comment() << '\n';
  }}
  out << "public: // calculated parameters\n";
  {for (Parameter_List::const_iterator
	 p = m.independent().calculated().begin();
       p != m.independent().calculated().end(); ++p) {
    out << "  " << (**p).type() << " " << (**p).code_name()
	<< ";\t// " << (**p).comment() << '\n';
  }}
  out << "};\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_common(std::ofstream& out, const Device& d)
{
  std::string class_name = "COMMON_" + d.name().string();
  out << "class " << class_name << "\n"
    "  :public COMMON_COMPONENT{\n"
    "public:\n"
    "  explicit " << class_name << "(const " << class_name 
      << "& p, int c=0);\n"
    "  explicit " << class_name << "(int c=0);\n"
    "           ~" << class_name << "() {--_count;}\n"
    "  bool        operator==(const COMMON_COMPONENT&)const;\n"
    "  COMMON_COMPONENT* clone()const {return new "<<class_name<<"(*this);}\n"
    "  void        parse(CS&);\n"
    "  void        print(OMSTREAM&)const;\n"
    "  void        expand();\n"
    "  const char* name()const {return \"" << d.parse_name() << "\";}\n"
    "  static int  count() {return _count;}\n"
    "private: // strictly internal\n"
    "  static int _count;\n"
    "public: // input parameters\n";
  {for (Parameter_List::const_iterator
	 p = d.common().raw().begin();
       p != d.common().raw().end(); ++p) {
    out << "  " << (**p).type() << " " << (**p).code_name()
	<< ";\t// " << (**p).comment() << '\n';
  }}
  out << "public: // calculated parameters\n";
  {for (Parameter_List::const_iterator
	 p = d.common().calculated().begin();
       p != d.common().calculated().end(); ++p) {
    out << "  " << (**p).type() << " " << (**p).code_name()
	<< ";\t// " << (**p).comment() << '\n';
  }}
  out << "};\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_device(std::ofstream& out, const Device& d)
{
  std::string class_name = "DEV_" + d.name().string();
  out << "class " << class_name << " : public BASE_SUBCKT {\n"
    "private:\n"
    "  explicit " << class_name << "(const " << class_name << "& p);\n"
    "public:\n"
    "  explicit " << class_name << "();\n"
    "           ~" << class_name << "() {--_count;}\n"
    "private: // override virtual\n"
    "  char      id_letter()const {return '" << d.id_letter() << "';}\n"
    "  const char* dev_type()const{return \"" << d.parse_name() << "\";}\n"
    "  int       numnodes()const  {return " << d.num_nodes() << ";}\n"
    "  CARD*     clone()const     {return new " << class_name << "(*this);}\n"
    "  void      parse(CS&);\n"
    "  void      print(OMSTREAM&,int)const;\n"
    "  void      expand();\n"
    "  //void    map_nodes();     //ELEMENT\n"
    "  //void    precalc();       //BASE_SUBCKT\n"
    "  //void    dc_begin();      //BASE_SUBCKT\n"
    "  //void    tr_begin();      //BASE_SUBCKT\n"
    "  //void    tr_restore();    //BASE_SUBCKT\n"
    "  //void    dc_advance();    //BASE_SUBCKT\n"
    "  //void    tr_advance();    //BASE_SUBCKT\n"
    "  //bool    tr_needs_eval(); //BASE_SUBCKT\n"
    "  //void    tr_queue_eval(); //BASE_SUBCKT\n"
    "  //bool    do_tr();         //BASE_SUBCKT\n"
    "  //void    tr_load();       //BASE_SUBCKT\n"
    "  //double  tr_review();     //BASE_SUBCKT\n"
    "  //void    tr_accept();     //BASE_SUBCKT\n"
    "  //void    tr_unload();     //BASE_SUBCKT\n"
    "  double    tr_probe_num(CS&)const;\n"
    "  //void    ac_begin();      //BASE_SUBCKT\n"
    "  //void    do_ac();         //BASE_SUBCKT\n"
    "  //void    ac_load();       //BASE_SUBCKT\n"
    "  //XPROBE  ac_probe_ext(CS&)const;//CKT_BASE/nothing\n"
    "public:\n"
    "  static int  count() {return _count;}\n"
    "public: // strictly internal\n"
    "  static int _count;\n"
    "public: // input parameters\n";
  {for (Parameter_List::const_iterator
	 p = d.device().raw().begin();
       p != d.device().raw().end(); ++p) {
    out << "  " << (**p).type() << " " << (**p).code_name()
	<< ";\t// " << (**p).comment() << '\n';
  }}
  out << "public: // calculated parameters\n";
  {for (Parameter_List::const_iterator
	 p = d.device().calculated().begin();
       p != d.device().calculated().end(); ++p) {
    out << "  " << (**p).type() << " " << (**p).code_name()
	<< ";\t// " << (**p).comment() << '\n';
  }}
  out << "public: // netlist\n";
  {for (Element_List::const_iterator
	 p = d.circuit().elements().begin();
       p != d.circuit().elements().end(); ++p) {
    out << "  " << (**p).class_name() << "* _" << (**p).name() << ";\n";
  }}
  out << "private: // node list\n"
    "  enum {";
  {for (Port_List::const_iterator
	 p = d.circuit().ports().begin();
       p != d.circuit().ports().end(); ++p) {
    if (p != d.circuit().ports().begin()) {
      out << ", ";
    }
    out << "n_" << (**p).name();
  }}
  out << "};\n"
    "};\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_eval(std::ofstream& out, const Eval& e,
		      const String_Arg& dev_name)
{
  std::string class_name = "EVAL_" +dev_name.string() +'_' +e.name().string();
  out << "class " << class_name << " : public COMMON_COMPONENT {\n"
    "private:\n"
    "  explicit "<< class_name << "(const "<< class_name << "& p)\n"
    "    :COMMON_COMPONENT(p) {unreachable();}\n"
    "public:\n"
    "  explicit "<< class_name << "(int c=0) :COMMON_COMPONENT(c) {}\n"
    "  bool operator==(const COMMON_COMPONENT&)const "
    "{incomplete(); return false;}\n"
    "  COMMON_COMPONENT* clone()const {untested(); return new " 
      << class_name << "(*this);}\n"
    "  const char* name()const {untested(); return \""<< class_name << "\";}\n"
    "  void tr_eval(ELEMENT*d)const;\n"
    "  bool has_tr_eval()const {return true;}\n"
    "  bool has_ac_eval()const {return false;}\n"
    "};\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_evals(std::ofstream& out, const Device& d)
{
  {for (Eval_List::const_iterator
	 e = d.eval_list().begin(); e != d.eval_list().end(); ++e) {
    make_eval(out, **e, d.name());
  }}
}
/*--------------------------------------------------------------------------*/
static void make_tail(std::ofstream& out, const File& in)
{
  out << in.h_direct() <<
    "/*--------------------------------------"
    "------------------------------------*/\n"
    "/*--------------------------------------"
    "------------------------------------*/\n"
    "#endif\n";
}
/*--------------------------------------------------------------------------*/
void make_h_file(const File& in)
{
  std::string dump_name = in.name();
  dump_name.erase(dump_name.rfind(".model"));
  std::ofstream out((dump_name+".h").c_str());
  if (!out) {
    untested();
    os_error(dump_name);
  }
  dump_name.erase(dump_name.find("../"),3);

  make_header(out, in, dump_name);

  {for (Model_List::const_iterator
	 m = in.models().begin();  m != in.models().end();  ++m) {
    make_sdp(out, **m);
    make_tdp(out, **m);
    make_model(out, **m);
  }}
  {for (Device_List::const_iterator
	 m = in.devices().begin();  m != in.devices().end();  ++m) {
    make_common(out, **m);
    make_device(out, **m);
    make_evals(out, **m);
  }}
  make_tail(out, in);
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
