/*$Id: mg_out_dev.cc,v 19.23 2001/05/11 21:28:46 al Exp $ -*- C++ -*-
 */
#include "mg_out.h"
/*--------------------------------------------------------------------------*/
static void make_dev_eval(std::ofstream& out, const Eval& e,
			  const String_Arg& dev_name)
{
  std::string class_name = "EVAL_" +dev_name.string() +'_' +e.name().string();
  out << "static " << class_name << " Eval_" << e.name().string() 
      << "(CC_STATIC);\n"
    "void " << class_name << "::tr_eval(ELEMENT* d)const\n"
    "{\n"
    "  assert(d);\n"
    "  DEV_" << dev_name << "* p = prechecked_cast<DEV_"
      << dev_name << "*>(d->owner());\n"
    "  assert(p);\n"
    "  const COMMON_" << dev_name << "* c = prechecked_cast<const COMMON_"
      << dev_name << "*>(p->common());\n"
    "  assert(c);\n"
    "  const MODEL_" << dev_name << "* m = prechecked_cast<const MODEL_"
      << dev_name << "*>(c->model());\n"
    "  assert(m);\n"
      << e.code() <<
    "};\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_dev_evals(std::ofstream& out, const Device& d)
{
  {for (Eval_List::const_iterator
	 e = d.eval_list().begin(); e != d.eval_list().end(); ++e) {
    make_dev_eval(out, **e, d.name());
  }}
}
/*--------------------------------------------------------------------------*/
void make_dev_default_constructor(std::ofstream& out,const Device& m)
{
  out << "DEV_" << m.name() << "::DEV_" << m.name() << "()\n"
    "  :BASE_SUBCKT()";
  make_construct_parameter_list(out, m.device().raw());
  make_construct_parameter_list(out, m.device().calculated());
  {for (Element_List::const_iterator
	 p = m.circuit().elements().begin();
       p != m.circuit().elements().end(); ++p) {
    out << ",\n   _" << (**p).name() << "(0)";
  }}
  out << "\n{\n"
    "  attach_common(&Default_" << m.name() << ");\n"
    "  ++_count;\n";
  {for (Parameter_List::const_iterator
	 p = m.device().override().begin();
       p != m.device().override().end();
       ++p) {
    if (!((**p).final_default().empty())) {
      out << "  " << (**p).code_name() << " = NA;\n";
    }
    if (!((**p).default_val().empty())) {
      out << "  " << (**p).code_name() << " = " << (**p).default_val() <<";\n";
    }
  }}
  out << "}\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
void make_dev_copy_constructor(std::ofstream& out, const Device& m)
{
  out << "DEV_" << m.name() << "::DEV_" << m.name()
      << "(const DEV_" << m.name() << "& p)\n"
    "  :BASE_SUBCKT(p)";
  make_copy_construct_parameter_list(out, m.device().raw());
  make_copy_construct_parameter_list(out, m.device().calculated());
  {for (Element_List::const_iterator
	 p = m.circuit().elements().begin();
       p != m.circuit().elements().end(); ++p) {
    out << ",\n   _" << (**p).name() << "(0)";
  }}
  out << "\n{\n"
    "  untested();\n"
    "  ++_count;\n";
  {for (Parameter_List::const_iterator
	 p = m.device().override().begin();
       p != m.device().override().end();
       ++p) {
    out << ",\n   " << (**p).code_name() << "(p." << (**p).code_name() << ")";
  }}
  out << "}\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_dev_parse(std::ofstream& out, const Device& m)
{
  out << "void DEV_" << m.name() << "::parse(CS& cmd)\n"
    "{\n"
    "  assert(has_common());\n"
    "  COMMON_" << m.name() << "* c = prechecked_cast<COMMON_"
      << m.name() << "*>(common()->clone());\n"
    "  assert(c);\n"
    "\n"
    "  parse_Label(cmd);\n"
    "  parse_nodes(cmd,numnodes(),numnodes());\n"
    "  c->parse(cmd);\n"
    "  attach_common(c);\n"
    "}\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_dev_print(std::ofstream& out, const Device& m)
{
  out << "void DEV_" << m.name() << "::print(OMSTREAM& o, int)const\n"
    "{\n"
    "  const COMMON_" << m.name() << "* c = prechecked_cast<const COMMON_"
      << m.name() << "*>(common());\n"
    "  assert(c);\n"
    "\n"
    "  o << short_label();\n"
    "  printnodes(o,numnodes());\n"
    "  c->print(o);\n"
    "}\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_dev_expand(std::ofstream& out, const Device& d)
{
  out << "void DEV_" << d.name() << "::expand()\n"
    "{\n"
    "  COMMON_" << d.name() << "* c = prechecked_cast<COMMON_"
      << d.name() << "*>(mutable_common());\n"
    "  assert(c);\n"
    "  c->expand();\n"
    "  const MODEL_" << d.name() << "* m = prechecked_cast<const MODEL_"
      << d.name() << "*>(c->model());\n"
    "  assert(m);\n"
    "\n";
  {for (Element_List::const_iterator
	 e = d.circuit().elements().begin();
       e != d.circuit().elements().end(); ++e) {
    {if (!((**e).omit().empty())) {
      out <<
	"  {if (" << (**e).omit() << ") {\n"
	"    if (_" << (**e).name() << ") {\n"
	"      subckt().erase(_" << (**e).name() << ");\n"
	"      _" << (**e).name() << " = NULL;\n"
	"      untested();\n"
	"    }\n"
	"  }else{\n";
    }else{
      out << "  {{\n";
    }}
    out <<
      "    if (!_" << (**e).name() << ") {\n"
      "      _" << (**e).name() << " = new " << (**e).class_name() << ";\n"
      "      subckt().push_front(_" << (**e).name() << ");\n"
      "    }\n"
      "    _" << (**e).name() << "->set(\"" << (**e).name() 
	<< "\", this, &Eval_" << (**e).name() 
	<< ", 0.";
    {for (Port_List::const_iterator
	   p = (**e).ports().begin();
	 p != (**e).ports().end(); ++p) {
      out << ", _n[n_" << (**p).name() << "]";
    }}
    out << ");\n"
      "  }}\n";
  }}
  out <<
    "  assert(subckt().exists());\n"
    "  subckt().expand();\n"
    "  assert(!constant());\n"
    "}\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static std::string fix_expression(const std::string& in)
{
  std::string out;

  CS x(in);
  {for (;;) {
    {if (x.peek() == '@') {
      x.skip1('@');
      std::string object(x.ctos("[,"));
      x.skip1('[');
      std::string attrib(x.ctos("]"));
      x.skip1(']');
      {if (object[0] == 'n') {
	out += " _n[" + object + "]";
	if (attrib != "") {
	  out += ".v0()";
	}
      }else{
	out += " CARD::probe(_" + object + ",\"" + attrib + "\")";
      }}
    }else if (x.more()) {
      //cout << x.ctos("@") << '\n';
      out += ' ' + x.ctos("@");
    }else{
      break;
    }}
  }}

  return out;
}
/*--------------------------------------------------------------------------*/
static void make_dev_probe(std::ofstream& out, const Device& d)
{
  out << "double DEV_" << d.name() << "::tr_probe_num(CS& cmd)const\n"
    "{\n  {";
  {for (Probe_List::const_iterator
	  p = d.probes().begin();
	p != d.probes().end(); ++p) {
    out << "if (cmd.pmatch(\"" << (**p).name() << "\")) {\n"
      "    return " << fix_expression((**p).expression()) << ";\n";
    out << "  }else ";
  }}
  out << "{\n"
    "    untested();\n"
    "    return BASE_SUBCKT::tr_probe_num(cmd);\n"
    "  }}\n"
    "}\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
void make_cc_dev(std::ofstream& out, const Device& d)
{
  make_dev_evals(out, d);
  make_dev_default_constructor(out, d);
  make_dev_copy_constructor(out, d);
  make_dev_parse(out, d);
  make_dev_print(out, d);
  make_dev_expand(out, d);
  make_dev_probe(out, d);
  out << "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
