/*$Id: mg_out_common.cc,v 19.23 2001/05/11 21:28:46 al Exp $ -*- C++ -*-
 */
#include "mg_out.h"
/*--------------------------------------------------------------------------*/
static void make_common_default_constructor(std::ofstream& out,const Device& m)
{
  out << "COMMON_" << m.name() << "::COMMON_" << m.name() << "(int c)\n"
    "  :COMMON_COMPONENT(c)";
  make_construct_parameter_list(out, m.common().raw());
  make_construct_parameter_list(out, m.common().calculated());
  out << "\n{\n"
    "  ++_count;\n";
  {for (Parameter_List::const_iterator
	 p = m.common().override().begin();
       p != m.common().override().end();
       ++p) {
    if (!((**p).final_default().empty())) {
      out << "  " << (**p).code_name() << " = NA;\n";
    }
    if (!((**p).default_val().empty())) {
      out << "  " << (**p).code_name() << " = " << (**p).default_val() <<";\n";
    }
  }}
  out << "}\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_common_copy_constructor(std::ofstream& out, const Device& m)
{
  out << "COMMON_" << m.name() << "::COMMON_" << m.name() 
      << "(const COMMON_" << m.name() << "& p, int c)\n"
    "  :COMMON_COMPONENT(p,c)";
  make_copy_construct_parameter_list(out, m.common().raw());
  make_copy_construct_parameter_list(out, m.common().calculated());
  out << "\n{\n"
    "  ++_count;\n";
  {for (Parameter_List::const_iterator
	 p = m.common().override().begin();
       p != m.common().override().end();
       ++p) {
    out << ",\n   " << (**p).code_name() << "(p." << (**p).code_name() << ")";
  }}
  out << "}\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_common_operator_equal(std::ofstream& out, const Device& m)
{
  out << "bool COMMON_" << m.name() 
      << "::operator==(const COMMON_COMPONENT& x)const\n"
    "{\n"
    "  const COMMON_" << m.name() << "* p = dynamic_cast<const COMMON_" 
      << m.name() << "*>(&x);\n"
    "  return (p\n";
  {for (Parameter_List::const_iterator
	  p = m.common().raw().begin();
	p != m.common().raw().end();
	++p) {
    out << "    && " << (**p).code_name() 
	<< " == p->" << (**p).code_name() << '\n';
  }}
  out << "    && is_equal(x));\n"
    "}\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_common_parse(std::ofstream& out, const Device& m)
{
  out << "void COMMON_" << m.name() << "::parse(CS& cmd)\n"
    "{\n"
    "  assert(!has_model());\n"
    "  parse_modelname(cmd);\n";
  if (!m.common().unnamed_value().is_empty()) {
    out << "  if (cmd.is_float()) {\n"
      "    cmd >> " << m.common().unnamed_value() << ";\n"
      "  }\n";
  }
  out << "  int here = cmd.cursor();\n"
    "  do{\n";
  make_get_param_list(out, m.common().raw());
  out << "  }while (cmd.more() && !cmd.stuck(&here));\n"
    "  cmd.check(bWARNING, \"what's this?\");\n"
    "}\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
void make_common_print(std::ofstream& out, const Device& m)
{
  out << "void COMMON_" << m.name() << "::print(OMSTREAM& o)const\n"
    "{\n"
    "  o << \"  \" << modelname();\n"
    "  o.setfloatwidth(7);\n";
  make_print_param_list(out, m.common().override());
  make_print_param_list(out, m.common().raw());
  out << "  o << '\\n';\n"
    "}\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
static void make_common_expand(std::ofstream& out, const Device& m)
{
  out << "void COMMON_" << m.name() << "::expand()\n"
    "{\n"
    "  const MODEL_" << m.name() << "* m = dynamic_cast<const MODEL_" 
      << m.name() << "*>(attach_model());\n"
    "  if (!m) {\n"
    "    untested();\n"
    "    error(bERROR, \"model \" + modelname() + \" is not a " 
      << m.name().lower() << " (" << m.id_letter() << ")\");\n"
    "  }\n";
  make_final_adjust(out, m.common());
  out << "}\n"
    "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
void make_cc_common(std::ofstream& out, const Device& d)
{
  make_common_default_constructor(out, d);
  make_common_copy_constructor(out, d);
  make_common_operator_equal(out, d);
  make_common_parse(out, d);
  make_common_print(out, d);
  make_common_expand(out, d);
  out << "/*--------------------------------------"
    "------------------------------------*/\n";
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
