/*$Id: mg_in.cc,v 19.16 2001/04/28 01:08:23 al Exp $ -*- C++ -*-
 */
#include <fcntl.h>
#include <stdio.h>
#include "mg_.h"
/*--------------------------------------------------------------------------*/
static C_Comment   dummy_c_comment;
static Cxx_Comment dummy_cxx_comment;
/*--------------------------------------------------------------------------*/
template <class T>
List_Base<T>::~List_Base()
{
  {for (std::list<T*>::iterator i = _list.begin(); i != _list.end(); ++i) {
    delete *i;
  }}
}
/*--------------------------------------------------------------------------*/
template <class T, char BEGIN, char END>
void List<T, BEGIN, END>::parse(CS& file)
{
  int paren = file.skip1b(BEGIN);
  int here = file.cursor();
  {for (;;) {
    get(file, "/*$$", &dummy_c_comment);
    get(file, "//$$", &dummy_cxx_comment);
    paren -= file.skip1b(END);
    if (paren == 0) {
      break;
    }
    T* p = new T(file);
    {if (!file.stuck(&here)) {
      _list.push_back(p);
    }else {
      delete p;
      file.warn(0, "not valid here");
      break;
    }}
  }}
}
/*--------------------------------------------------------------------------*/
template <class T>
void Collection<T>::parse(CS& file)
{
  int here = file.cursor();
  T* m = new T(file);
  {if (!file.stuck(&here)) {
    _list.push_back(m);
  }else{
    delete m;
    file.warn(0, "what's this??");
  }}
}
/*--------------------------------------------------------------------------*/
void Parameter::parse(CS& file)
{
  file >> _type >> _code_name >> _comment;
  int here = file.cursor();
  {for (;;) {
    get(file, "NAME",		&_user_name);
    get(file, "ALT_name",	&_alt_name);
    get(file, "DEFAult",	&_default_val);
    get(file, "OFFSet",		&_offset);
    set(file, "POSItive",	&_positive,	true);
    set(file, "OCTAl",		&_octal,	true);
    get(file, "PRINt_test",	&_print_test);
    get(file, "CALC_Print_test",&_calc_print_test);
    get(file, "SCALe",		&_scale);
    get(file, "CALCUlate",	&_calculate);
    get(file, "QUIET_MIn",	&_quiet_min);
    get(file, "QUIET_MAx",	&_quiet_max);
    get(file, "FINAl_default",	&_final_default);
    get(file, "/*$$",		&dummy_c_comment);
    get(file, "//$$",		&dummy_cxx_comment);
    {if (file.skip1(";")) {
      break;
    }else if (!file.more()) {
      file.warn(0, "premature EOF (Parameter)");
      break;
    }else if (file.stuck(&here)) {
      file.warn(0, "need ;");
      break;
    }}
  }}
}
/*--------------------------------------------------------------------------*/
void Code_Block::parse(CS& file) 
{
  int paren = file.skipbl().skip1("{");
  int here = file.cursor();
  _begin = file.tail();
  {for (;;) {
    paren -= file.skip1b("])");
    if (paren == 0) {
      file.warn(0, "unbalanced {}[]()");
      break;
    }
    _end = file.tail();
    paren -= file.skip1b("}");
    if (paren == 0) {
      while (*(--_end) != '\n' && _end >= _begin) {
      }
      ++_end;
      break;
    }
    if (file.stuck(&here)) {
      file.warn(0, "syntax error");
      break;
    }
    paren += file.skip1b("{[(");
    file.skip1b(";");
    std::string foo;
    file >> foo;
  }}
}
/*--------------------------------------------------------------------------*/
void Parameter_Block::parse(CS& file)
{ 
  int paren = file.skip1b("{");
  int here = file.cursor();
  {for (;;) {
    get(file, "UNNAmed",		&_unnamed_value);
    get(file, "OVERride",		&_override);
    get(file, "RAW_parameters",		&_raw);
    get(file, "CALCulated_parameters",	&_calculated);
    get(file, "CODE_Front",		&_code_front);
    get(file, "CODE",			&_code);
    get(file, "/*$$",			&dummy_c_comment);
    get(file, "//$$",			&dummy_cxx_comment);
    paren -= file.skip1b("}");
    {if (paren == 0) {
      break;
    }else if (!file.more()) {
      file.warn(0, "premature EOF (Parameter_Block)");
      break;
    }else if (file.stuck(&here)) {
      file.warn(0, "bad Parameter_Code_Block");
      break;
    }}
  }}
}
/*--------------------------------------------------------------------------*/
void Eval::parse(CS& file)
{
  file >> _name >> _code;
}
/*--------------------------------------------------------------------------*/
void Element::parse(CS& file)
{
  file >> _dev_type >> _name >> _port_list;
  int here = file.cursor();
  {for (;;) {
    get(file, "EVAL",	&_eval);
    get(file, "OMIT",	&_omit);
    get(file, "/*$$",	&dummy_c_comment);
    get(file, "//$$",	&dummy_cxx_comment);
    {if (file.skip1(";")) {
      break;
    }else if (!file.more()) {
      file.warn(0, "premature EOF (Element)");
      break;
    }else if (file.stuck(&here)) {
      file.warn(0, "neeed ;");
      break;
    }}
  }}
  _class_name = "DEV_" + to_upper(_dev_type);
}
/*--------------------------------------------------------------------------*/
void Circuit::parse(CS& file)
{
  int paren = file.skip1b("{");
  get(file, "/*$$",  &dummy_c_comment);
  get(file, "//$$",  &dummy_cxx_comment);
  int here = file.cursor();
  get(file, "PORts", &_port_list) || file.warn(0, "need Ports");
  {for (;;) {
    paren -= file.skip1b("}");
    {if (paren == 0) {
      break;
    }else if (!file.more()) {
      file.warn(0, "premature EOF (Circuit)");
      break;
    }else if (file.stuck(&here)) {
      file.warn(0, "bad Circuit");
      break;
    }}
    file >> _element_list;
    get(file, "/*$$",			&dummy_c_comment);
    get(file, "//$$",			&dummy_cxx_comment);
  }}
}
/*--------------------------------------------------------------------------*/
void Model::parse(CS& file)
{
  file >> _name;
  int paren = file.skip1b("{");
  int here = file.cursor();
  {for (;;) {
    get(file, "BASE",			&_is_base);
    get(file, "LEVEl",			&_level);
    get(file, "ROOT",			&_root);
    get(file, "INHErit",		&_inherit);
    get(file, "KEYS",			&_key_list);
    get(file, "INDEpendent",		&_independent);
    get(file, "SIZE_dependent",		&_size_dependent);
    get(file, "TEMPerature_dependent",	&_temperature);
    get(file, "TR_Eval",		&_tr_eval);
    get(file, "/*$$",			&dummy_c_comment);
    get(file, "//$$",			&dummy_cxx_comment);
    paren -= file.skip1b("}");
    {if (paren == 0) {
      break;
    }else if (!file.more()) {
      file.warn(0, "premature EOF (Model)");
      break;
    }else if (file.stuck(&here)) {
      file.warn(0, "bad Model");
      break;
    }}
  }}
}
/*--------------------------------------------------------------------------*/
void Device::parse(CS& file)
{
  file >> _name;
  int paren = file.skip1b("{");
  int here = file.cursor();
  {for (;;) {
    get(file, "PARSe_name",	&_parse_name);
    get(file, "ID_letter",	&_id_letter);
    get(file, "NUM_nodes",	&_num_nodes);
    get(file, "CIRcuit",	&_circuit);
    get(file, "TR_Probes",	&_probes);
    get(file, "DEVIce", 	&_device);
    get(file, "COMmon", 	&_common);
    get(file, "TR_Eval",	&_tr_eval);
    get(file, "EVAL",		&_eval_list);
    get(file, "/*$$",		&dummy_c_comment);
    get(file, "//$$",		&dummy_cxx_comment);
    paren -= file.skip1b("}");
    {if (paren == 0) {
      break;
    }else if (!file.more()) {
      file.warn(0, "premature EOF (Device)");
      break;
    }else if (file.stuck(&here)) {
      file.warn(0, "bad Device");
      break;
    }}
  }}
}
/*--------------------------------------------------------------------------*/
void C_Comment::parse(CS& file)
{
  int here = file.cursor();
  {for (;;) {
    file.skipto1('*');
    {if (file.pmatch("*/$$")) {
      break;  // done with comment
    }else if (file.stuck(&here)) {
      file.warn(0, "unterminated C comment");
      break;
    }else{
      file.skip();
    }}
  }}
}
/*--------------------------------------------------------------------------*/
void Cxx_Comment::parse(CS& file)
{
  int here = file.cursor();
  file.skipto1('\n');
  if (file.stuck(&here)) {
    file.warn(0, "unterminated C++ comment");
  }
}
/*--------------------------------------------------------------------------*/
void Head::parse(CS& file)
{
  int here = file.cursor();
  _begin = file.fullstring();
  {for (;;) {
    file.skipto1('*');
    {if (file.pmatch("*/$$")) {
      _end = file.tail();
      break;  // done with head
    }else if (file.stuck(&here)) {
      file.warn(0, "unterminated head");
      break;
    }else{
      file.skip();
    }}
  }}
}
/*--------------------------------------------------------------------------*/
File::File(const std::string& file_name)
  :_name(file_name),
   _file(CS_FILE(), file_name)
{
  get(_file, "/*$$",		&_head);
  int here = _file.cursor();
  {for (;;) {
    get(_file, "H_Headers",	&_h_headers);
    get(_file, "CC_Headers",	&_cc_headers);
    get(_file, "DEVice", 	&_device_list);
    get(_file, "MODel", 	&_model_list);
    get(_file, "H_Direct", 	&_h_direct);
    get(_file, "CC_Direct",	&_cc_direct);
    get(_file, "/*$$",		&dummy_c_comment);
    get(_file, "//$$",		&dummy_cxx_comment);
    {if (!_file.more()) {
      break;
    }else if (_file.stuck(&here)) {
      _file.warn(0, "syntax error, need head or model");
      break;
    }}
  }}
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
