/*$Id: mg_.h,v 19.15 2001/04/13 22:40:05 al Exp $ -*- C++ -*-
 */
#include <stdexcept>
#include "md.h"
#include "ap.h"
/*--------------------------------------------------------------------------*/
// defined here
class Base;
class C_Comment;
class Cxx_Comment;
class Parameter;
class Code_Block;
class Parameter_Block;
class String_Arg;
class Model;
class Head;
class File;
/*--------------------------------------------------------------------------*/
// external
class CS;
/*--------------------------------------------------------------------------*/
inline std::string to_lower(std::string s)
{
  {for (std::string::iterator i = s.begin(); i != s.end(); ++i) {
    *i = tolower(*i);
  }}
  return s;
}
/*--------------------------------------------------------------------------*/
inline std::string to_upper(std::string s)
{
  {for (std::string::iterator i = s.begin(); i != s.end(); ++i) {
    *i = toupper(*i);
  }}
  return s;
}
/*--------------------------------------------------------------------------*/
inline void error(const std::string& message)
{
  untested();
  std::cerr << message << '\n';
  exit(1);
}
/*--------------------------------------------------------------------------*/
inline void os_error(const std::string& name)
{
  untested();
  error(name + ':' + strerror(errno));
}
/*--------------------------------------------------------------------------*/
class Base
{
public:
  virtual void parse(CS&) = 0;
  virtual void print(std::ostream&)const {}
  virtual ~Base() {}
};
inline CS&	     operator>>(CS& f, Base& b)	{b.parse(f); return f;}
inline std::ostream& operator<<(std::ostream& f, const Base& d)
						{d.print(f); return f;}
/*--------------------------------------------------------------------------*/
template <class T>
class List_Base
  :public Base
{
protected:
  std::list<T*> _list;
  virtual void parse(CS& f) = 0;
  virtual ~List_Base();
public:
  typedef std::list<T*>::const_iterator const_iterator;
  const_iterator begin()const	{return _list.begin();}
  const_iterator end()const	{return _list.end();}
  bool		 is_empty()const{return _list.empty();}
};
/*--------------------------------------------------------------------------*/
template <class T, char, char>
class List
  :public List_Base<T>
{
  void parse(CS& f);
};
/*--------------------------------------------------------------------------*/
template <class T>
class Collection
  :public List_Base<T>
{
  void parse(CS& f);
};
/*--------------------------------------------------------------------------*/
class C_Comment
  :public Base
{
  void parse(CS& f);
};
/*--------------------------------------------------------------------------*/
class Cxx_Comment
  :public Base
{
  void parse(CS& f);
};
/*--------------------------------------------------------------------------*/
class Key
{
  std::string _name;
  std::string _var;
  std::string _value;
  void parse(CS& f) {f >> _name >> _var >> _value; f.skip1b(";");}
public:
  Key(CS& f) {parse(f);}
  const std::string& name()const	{return _name;}
  const std::string& var()const 	{return _var;}
  const std::string& value()const	{return _value;}
};
typedef List<Key, '{', '}'> Key_List;
/*--------------------------------------------------------------------------*/
class String_Arg
  :public Base
{
  std::string	_s;
  void parse(CS& f)	{f >> _s; f.skip1b(";");}
  void print(std::ostream& f)const {f << _s;}
public:
  bool operator!=(const std::string& s)const {return _s != s;}
  bool is_empty()const {return _s.empty();}
  std::string		lower()const	{return to_lower(_s);}
  const std::string&	string()const	{return _s;}
};
/*--------------------------------------------------------------------------*/
class Bool_Arg
  :public Base
{
  bool _s;
  void parse(CS& f)	{_s = true; f.skip1b(";");}
  void print(std::ostream& f)const {f << _s;}
public:
  Bool_Arg() :_s(false) {}
  operator bool()const {return _s;}
};
/*--------------------------------------------------------------------------*/
class Parameter
{
  std::string _type;
  std::string _code_name;
  std::string _user_name;
  std::string _alt_name;
  std::string _default_val;
  std::string _comment;
  std::string _print_test;
  std::string _calc_print_test;
  std::string _scale;
  std::string _offset;
  std::string _calculate;
  std::string _quiet_min;
  std::string _quiet_max;
  std::string _final_default;
  bool	      _positive;
  bool	      _octal;
  void parse(CS& f);
public:
  Parameter(CS& f) :_positive(false), _octal(false) {parse(f);}
  const std::string& type()const		{return _type;}
  const std::string& code_name()const		{return _code_name;}
  const std::string& user_name()const		{return _user_name;}
  const std::string& alt_name()const		{return _alt_name;}
  const std::string& comment()const		{return _comment;}
  const std::string& default_val()const 	{return _default_val;}
  const std::string& print_test()const		{return _print_test;}
  const std::string& calc_print_test()const	{return _calc_print_test;}
  const std::string& scale()const		{return _scale;}
  const std::string& offset()const		{return _offset;}
  const std::string& calculate()const		{return _calculate;}
  const std::string& quiet_min()const		{return _quiet_min;}
  const std::string& quiet_max()const		{return _quiet_max;}
  const std::string& final_default()const	{return _final_default;}
  bool		     positive()const		{return _positive;}
  bool		     octal()const		{return _octal;}
};
typedef List<Parameter, '{', '}'> Parameter_List;
/*--------------------------------------------------------------------------*/
class Code_Block
  :public Base
{
  const char* _begin;
  const char* _end;
  void parse(CS& f);
  void print(std::ostream& f)const
			{if (!is_empty()) f.write(_begin, _end-_begin);}
public:
  Code_Block() :_begin(0), _end(0) {}
  bool is_empty()const {return _end - _begin < 2;}
};
/*--------------------------------------------------------------------------*/
class Parameter_Block
  :public Base
{
  String_Arg	 _unnamed_value;
  Parameter_List _override;
  Parameter_List _raw;
  Parameter_List _calculated;
  Code_Block	 _code_front;
  Code_Block     _code;
  void parse(CS& f);
public:
  const String_Arg&	unnamed_value()const	{return _unnamed_value;}
  const Parameter_List& override()const		{return _override;}
  const Parameter_List& raw()const		{return _raw;}
  const Parameter_List& calculated()const	{return _calculated;}
  const Code_Block&	code_front()const	{return _code_front;}
  const Code_Block&	code()const		{return _code;}
  bool is_empty()const {return (calculated().is_empty() && code().is_empty()
				&& override().is_empty() && raw().is_empty()
				&& code_front().is_empty());}
};
/*--------------------------------------------------------------------------*/
class Eval
  :public Base
{
  String_Arg _name;
  Code_Block _code;
  void parse(CS& f);
public:
  Eval(CS& f) :_name(), _code() {parse(f);}
  const String_Arg&	name()const	{return _name;}
  const Code_Block&	code()const	{return _code;}
};
typedef Collection<Eval> Eval_List;
/*--------------------------------------------------------------------------*/
class Port
  :public Base
{
  std::string _name;
  void parse(CS& f) {f >> _name;}
public:
  Port() {}
  Port(CS& f) {parse(f);}
  const std::string& name()const	{return _name;}
};
typedef List<Port, '(', ')'> Port_List;
/*--------------------------------------------------------------------------*/
class Element
  :public Base
{
  std::string _dev_type;
  std::string _class_name;
  std::string _name;
  Port_List   _port_list;
  std::string _eval;
  std::string _omit;
  void parse(CS&);
public:
  Element() {}
  Element(CS& f) {parse(f);}
  const std::string& dev_type()const	{return _dev_type;}
  const std::string& class_name()const	{return _class_name;}
  const Port_List&   ports()const	{return _port_list;}
  const std::string& name()const	{return _name;}
  const std::string& eval()const	{return _eval;}
  const std::string& omit()const	{return _omit;}
};
typedef Collection<Element> Element_List;
/*--------------------------------------------------------------------------*/
class Circuit
  :public Base
{
  Port_List	_port_list;
  Element_List	_element_list;
  void parse(CS&);
public:
  const Port_List&	ports()const	{return _port_list;}
  const Element_List&	elements()const {return _element_list;}
};
/*--------------------------------------------------------------------------*/
class Probe
  :public Base
{
  std::string _name;
  std::string _expression;
  void parse(CS& f) {f >> _name >> _expression; f.skip1b(";");}
public:
  Probe() {}
  Probe(CS& f) {parse(f);}
  const std::string& name()const	{return _name;}
  const std::string& expression()const	{return _expression;}
};
typedef List<Probe, '{', '}'> Probe_List;
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
class Model
{
  String_Arg		_name;
  String_Arg		_level;
  String_Arg		_root;
  String_Arg		_inherit;
  Key_List		_key_list;
  Parameter_Block	_independent;
  Parameter_Block	_size_dependent;
  Parameter_Block	_temperature;
  Code_Block		_tr_eval;
  Bool_Arg		_is_base;
  void parse(CS& f);
public:
  Model(CS& f) {parse(f);}
  bool			 is_base()const		{return _is_base;}
  const String_Arg&	 name()const		{return _name;}
  const String_Arg&	 level()const		{return _level;}
  const String_Arg&	 root()const		{return _root;}
  const String_Arg&	 inherit()const		{return _inherit;}
  const Key_List&	 key_list()const	{return _key_list;}
  const Parameter_Block& independent()const	{return _independent;}
  const Parameter_Block& size_dependent()const	{return _size_dependent;}
  const Parameter_Block& temperature()const	{return _temperature;}
  const Code_Block&	 tr_eval()const		{return _tr_eval;}
};
typedef Collection<Model> Model_List;
/*--------------------------------------------------------------------------*/
class Device
{
  String_Arg		_name;
  String_Arg		_parse_name;
  String_Arg		_id_letter;
  String_Arg		_num_nodes;
  Circuit		_circuit;
  Probe_List		_probes;
  Parameter_Block	_device;
  Parameter_Block	_common;
  Code_Block		_tr_eval;
  Eval_List		_eval_list;
  void parse(CS& f);
public:
  Device(CS& f) {parse(f);}
  const String_Arg&	 name()const		{return _name;}
  const String_Arg&	 parse_name()const	{return _parse_name;}
  const String_Arg&	 id_letter()const	{return _id_letter;}
  const String_Arg&	 num_nodes()const 	{return _num_nodes;}
  const Circuit&	 circuit()const 	{return _circuit;}
  const Probe_List&	 probes()const  	{return _probes;}
  const Parameter_Block& device()const		{return _device;}
  const Parameter_Block& common()const		{return _common;}
  const Code_Block&	 tr_eval()const 	{return _tr_eval;}
  const Eval_List&	 eval_list()const	{return _eval_list;}
};
typedef Collection<Device> Device_List;
/*--------------------------------------------------------------------------*/
class Head
  :public Base
{
  const char* _begin;
  const char* _end;
  void parse(CS& f);
  void print(std::ostream& f)const
			{if (_begin!=_end) f.write(_begin, _end-_begin);}
public:
  Head() :_begin(0), _end(0) {}
};
/*--------------------------------------------------------------------------*/
class File
{
  std::string	_name;
  CS		_file;
  Head		_head;
  Code_Block	_h_headers;
  Code_Block	_cc_headers;
  Model_List	_model_list;
  Device_List	_device_list;
  Code_Block	_h_direct;
  Code_Block	_cc_direct;
public:
  File(const std::string& file_name);
  const std::string& name()const	{return _name;}
  const char*        c_str()const	{return _file.fullstring();}
  const Head&	     head()const	{return _head;}
  const Code_Block&  h_headers()const	{return _h_headers;}
  const Code_Block&  cc_headers()const	{return _cc_headers;}
  const Model_List&  models()const	{return _model_list;}
  const Device_List& devices()const	{return _device_list;}
  const Code_Block&  h_direct()const	{return _h_direct;}
  const Code_Block&  cc_direct()const	{return _cc_direct;}
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
