/*$Id: io_trace.h,v 19.23 2001/05/11 21:30:50 al Exp $ -*- C++ -*-
 * trace macros for model debugging
 */
/* allow multiple inclusions with different DO_TRACE */
#include <stdio.h>
#undef trace_line
#undef trace0
#undef trace1
#undef trace2
#undef trace3
#undef trace4
#undef untested
#undef unreachable
#undef incomplete
/*--------------------------------------------------------------------------*/
#ifdef DO_TRACE
#define trace_line() (printf("@@#\n@#@:%s:%u:%s\n", \
			   __FILE__, __LINE__, __FUNCTION__))
#define trace0(s) (printf("@#@%s\n", s))
#define trace1(s,x) (printf("@#@%s  %s=%g\n", s, #x, (double)(x)))
#define trace2(s,x,y) (printf("@#@%s  %s=%g  %s=%g\n",\
	s, #x, (double)(x), #y, (double)(y)))
#define trace3(s,x,y,z) (printf("@#@%s  %s=%g  %s=%g  %s=%g\n",\
	s, #x, (double)(x), #y, (double)(y), #z, (double)(z)))
#define trace4(s,w,x,y,z)(printf("@#@%s  %s=%g  %s=%g  %s=%g  %s=%g\n",\
	s, #w, (double)(w), #x, (double)(x), #y, (double)(y), #z, (double)(z)))
#else
#define trace_line()
#define trace0(s)
#define trace1(s,x)
#define trace2(s,x,y)
#define trace3(s,x,y,z)
#define trace4(s,w,x,y,z)
#endif

#define unreachable() (printf("@@#\n@@@unreachable:%s:%u:%s\n", \
			   __FILE__, __LINE__, __FUNCTION__))

#define incomplete() (printf("@@#\n@@@incomplete:%s:%u:%s\n", \
			   __FILE__, __LINE__, __FUNCTION__))

#ifdef TRACE_UNTESTED
#define untested() (printf("@@#\n@@@:%s:%u:%s\n", \
			   __FILE__, __LINE__, __FUNCTION__))
#else
#define untested()
#endif
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
