/*$Id: ap_construct.cc,v 19.14 2001/04/06 00:55:33 al Exp $ -*- C++ -*-
 * construction, copy, etc.
 */
#include <fcntl.h>
#include "ap.h"
/*--------------------------------------------------------------------------*/
CS::CS(CS_FILE, const std::string& name, int i)
  :_name(0),
   _cmd(0),
   _cnt(i),
   _ok(true),
   _length(0),
   _begin_match(0),
   _end_match(0)
{
  _name = new char[name.length()+1];
  strcpy(_name, name.c_str());
  int f = open(_name, O_RDONLY);
  if (f == EOF) {
    error(bERROR, name + ':' + strerror(errno));
  }
  _length = lseek(f, off_t(0), SEEK_END);
  lseek(f, off_t(0), SEEK_SET);
  _cmd = new char[_length+2];
  read(f, _cmd, _length);
  _cmd[_length++] = '\0';
  close(f);
  assert(_cmd);
}
/*--------------------------------------------------------------------------*/
CS::CS(const std::string& s, int i)
  :_name(0),
   _cmd(0),
   _cnt(i),
   _ok(true),
   _length(s.length()),
   _begin_match(0),
   _end_match(0)
{
  _cmd = new char[_length+1];
  strcpy(_cmd, s.c_str());
}
/*--------------------------------------------------------------------------*/
CS::CS(const CS& p)
  :_name(0),
   _cmd(0),
   _cnt(p._cnt),
   _ok(p._ok),
   _length(p._length),
   _begin_match(0),
   _end_match(0)
{
  if (p._name) {
    _name = new char[strlen(p._name)+1];
    strcpy(_name, p._name);
  }
  _cmd = new char[_length+1];
  strcpy(_cmd, p._cmd);
}
/*--------------------------------------------------------------------------*/
CS& CS::operator=(const std::string& s)
{
  if (_cmd){
    delete[] _cmd;
  }
  _cnt = 0;
  _ok = true;
  _length = s.length();
  _cmd = new char[_length+1];
  strcpy(_cmd, s.c_str());
  return *this;
}    
/*--------------------------------------------------------------------------*/
CS& CS::operator=(const CS& p)
{
  assert(&p != this);
  if (p._name) {
    if (_name) {
      delete[] _name;
    }
    _name = new char[strlen(p._name)+1];
    strcpy(_name, p._name);
  }
  if (_cmd){
    delete[] _cmd;
  }
  _cnt = p._cnt;
  _ok = p._ok;
  _length = p._length;
  _cmd = new char[_length+1];
  strcpy(_cmd, p._cmd);
  return *this;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
