/*$Id: u_xprobe.h,v 17.21 2000/05/02 09:32:08 al Exp $ -*- C++ -*-
 * extended probe data
 * used for AC analysis
 */
#ifndef U_XPROBE_H
#define U_XPROBE_H
#include "constant.h"
#include "l_compar.h"
/*--------------------------------------------------------------------------*/
typedef enum {mtNONE, mtMAG, mtPHASE, mtREAL, mtIMAG} mod_t;
/*--------------------------------------------------------------------------*/
class XPROBE{
private:
  COMPLEX _value;
  mod_t   _modifier; // default
  double  _dbscale;  // 20 for voltage, 10 for power, etc.
public:  
  //explicit XPROBE():
  //  _value(COMPLEX(NOT_VALID, NOT_VALID)),
  //  _modifier(mtNONE),
  //  _dbscale(20.) {}
  explicit XPROBE(COMPLEX v,mod_t m=mtMAG,double d=20.):
    _value(v),
    _modifier(m),
    _dbscale(d) {}
  explicit XPROBE(double v,mod_t m=mtREAL,double d=20.):
    _value(v),
    _modifier(m),
    _dbscale(d) {}
  bool OK()const {return _modifier != mtNONE;}
  double operator()(mod_t m=mtNONE, bool db = false)const{
    if (OK()){
      if (m == mtNONE) {
	m = _modifier;
      }
      double rv = NOT_VALID;
      switch (m){
      case mtNONE:  unreachable();		break;
      case mtMAG:   rv = std::abs(_value);	break;
      case mtPHASE: rv = std::arg(_value)*RTOD;	break;
      case mtREAL:  rv = std::real(_value);	break;
      case mtIMAG:  rv = std::imag(_value);	break;
      }
      return (db) ? _dbscale * log10(std::max(rv,VOLTMIN)) : rv;
    }else{
      return NOT_VALID;
    }
  }
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
