/*$Id: md.h,v 18.17 2000/09/04 09:45:33 al Exp $ -*- C++ -*-
 * Machine dependent, configuration, and standard includes
 */
#ifndef MD_H_INCLUDED
#define MD_H_INCLUDED
/*--------------------------------------------------------------------------*/
/* system dependent patches needed before the standard includes */
#if defined(__GNUG__)
  #define __HONOR_STD
#elif defined (WIN32)
  #pragma warning (disable: 4786) // id truncated to 255 characters
  #pragma warning (disable: 4800) // forcing ___ to bool (performance warning)
  #pragma warning (disable: 4660) // template already instantiated
  // lev 4
  #pragma warning (disable: 4514) // unreferenced inline removed
  #pragma warning (disable: 4710) // function not inlined
  #pragma warning (disable: 4512) // assignment op could not be generated
  #pragma warning (disable: 4244) // conversion from int to char (toupper)
  #pragma warning (disable: 4611) // setjmp/destructor interaction nonportable
  #pragma warning (push, 3)
#endif
/*--------------------------------------------------------------------------*/
/* std collection of includes */
// system
#include <cstdarg>
#include <cassert>
#include <cfloat>
#include <climits>
#include <cstdio>
#include <cerrno>
#include <csetjmp>
// types
#include <complex>
#include <string>
// containers
#include <list>
#include <vector>
#include <queue>
#include <map>
// algorithms
#include <typeinfo>
#include <algorithm>
/*--------------------------------------------------------------------------*/
#if defined(UNIX)
/* usual but non-standard collection of includes */
#include <unistd.h>	  /* chdir, access, getcwd */
#include <sys/time.h>	  /* struct timeval, may be needed by sys/resource */
#include <sys/resource.h> /* getrusage, used for timer  */
/* file names, etc. */
#define	ENDDIR		"/"
#define PATHSEP		':'
#define SYSTEMSTARTFILE	"acs.rc"
#define SYSTEMSTARTPATH	OS::getenv("PATH")
#define USERSTARTFILE	".acsrc"
#define	USERSTARTPATH	OS::getenv("HOME")
#define STEPFILE   	"/tmp/SXXXXXX"
#define PLOTFILE    	"acs.plot"
#define SHELL		OS::getenv("SHELL")
/* constants related to memory size, word size, etc */
enum {
  BUFLEN = 256,
  BIGBUFLEN = 2048
};
/* machine and compiler patches */
#define CONST const
#if defined(SUN)
  #define NEEDS_IS_INF
#endif
#if defined(__GNUG__)
  #define MANUAL_TEMPLATES
#elif defined(__SUNPRO_CC)
  #include <setjmp.h>
  #define LINK_TEMPLATES
  #define __FUNCTION__ ""
  #define NEW_IS_BROKEN
  #define NEEDS_COPY_N
  #define BROKEN_CONST_FOLD
  #define BROKEN_TEMPLATE_OVERLOAD
#endif
/*--------------------------------------------------------------------------*/
#elif defined(WIN32)
/* usual but non-standard collection of includes */
#include <windows.h>
#include <io.h>
#include <direct.h>
#include <time.h>
/* file names, etc. */
#define	ENDDIR		"/\\"
#define PATHSEP		';'
#define SYSTEMSTARTFILE	"acs.ini"
#define SYSTEMSTARTPATH	OS::getenv("PATH")
#define USERSTARTFILE	"acs.ini"
#define	USERSTARTPATH	OS::getenv("HOME")
#define STEPFILE   	"/tmp/SXXXXXX"
#define PLOTFILE    	"acs.plot"
#define SHELL		OS::getenv("COMSPEC")
/* constants related to memory size, word size, etc */
enum {
  BUFLEN = 256,
  BIGBUFLEN = 2048
};
/* machine and compiler patches */
#define MANUAL_TEMPLATES
#define NEEDS_COPY_N
#define NEEDS_GETRUSAGE
#define NEW_IS_BROKEN
#define ABS_IS_BROKEN
#define SIGNALARGS int
#undef  CONST
#define CONST
#define F_OK (00)		/* io.h */
#define X_OK (01)
#define W_OK (02)
#define R_OK (04)
#define MAXPATHLEN (1024)
#define RUSAGE_SELF	0
#define sigjmp_buf jmp_buf
#define siglongjmp(a,b) longjmp(a,b)
#define sigsetjmp(a,b) setjmp(a)
#define PATH_MAX 1024
#undef min
#undef max
namespace std{
  template <class T>
  inline const T& min(const T& a, const T& b) {
    return b < a ? b : a;
  }
  template <class T>
  inline const T& max(const T& a, const T& b) {
    return  a < b ? b : a;
  }
}
inline int strcasecmp(const char a[], const char b[]){
  return stricmp(a,b);
}
inline int isinf(double x){
  if (_fpclass(x) == _FPCLASS_PINF){
    return 1;
  }else if (_fpclass(x) == _FPCLASS_NINF){
    return -1;
  }else{
    return 0;
  }
}
inline int isnan(double x){
  return _isnan(x);
}
const char __FUNCTION__[] = "";
/*--------------------------------------------------------------------------*/
#else
#error what kind of system is this??
#endif
/*--------------------------------------------------------------------------*/
/* my standard collection of includes */
#include "io_error.h"
#include "io_trace.h"
/*--------------------------------------------------------------------------*/
typedef std::complex<double> COMPLEX;

#if defined(NDEBUG)
  #define prechecked_cast static_cast
#else
  #define prechecked_cast dynamic_cast
#endif

#if defined(NEEDS_COPY_N)
namespace std {
  template <class InputIter, class Size, class OutputIter>
  pair<InputIter, OutputIter> copy_n(InputIter first, Size count,
				       OutputIter result) {
    for ( ; count > 0; --count) {
      *result++ = *first++;
    }
    return pair<InputIter, OutputIter>(first, result);
  }
}
#endif

#if defined(NEEDS_FILL_N)
namespace std {
  template <class OutputIter, class Size, class Type>
  OutputIter fill_n(OutputIter first, Size count, Type value) {
    for ( ; count > 0; --count) {
      *first++ = value;
    }
    return first;
  }
}
#endif

#if defined(HAS_EXP_BUG)
  inline double Exp(double x){untested(); return (x>-200.) ? exp(x) : 0.;}
#else
  inline double Exp(double x){return exp(x);}
#endif

#if defined(NEEDS_IS_INF)
  inline int isinf(double x) {return (x != x);}
#endif

#if defined(NEEDS_IS_NAN)
  inline int isnan(double x) {untested(); return (x != x);}
#endif

#if defined(ABS_IS_BROKEN)
  inline double abs(double x) {return fabs(x);}
#endif

#if defined(NEEDS_GETRUSAGE)
struct	rusage {
  struct timeval ru_utime;	/* user time used */
  struct timeval ru_stime;	/* system time used */
};
int getrusage(int,struct rusage*);
#endif

#if !defined(SIGNALARGS)
  #define SIGNALARGS int
#endif
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
