/*$Id: m_spline.h,v 18.4 2000/07/09 05:58:31 al Exp $ -*- C++ -*-
 * cubic spline interpolation
 */
#ifndef M_SPLINE_H
#define M_SPLINE_H
#include "m_cpoly.h"
/*--------------------------------------------------------------------------*/
struct FPOLY3 {
  double   x;		/* the argument			*/
  double   f0;		/* the function (c0 + x*f1)	*/
  double   f1;		/* the first derivative		*/
  double   f2;
  double   f3;
  explicit FPOLY3() : x(0), f0(0), f1(0), f2(0), f3(0) {untested();}
           FPOLY3(const FPOLY3& p)
	     :x(p.x), f0(p.f0), f1(p.f1), f2(p.f2), f3(p.f3) {untested();}
  explicit FPOLY3(double X,double F0,double F1,double F2, double F3)
	     :x(X), f0(F0), f1(F1), f2(F2), f3(F3)  {untested();}

  bool	   operator==(const FPOLY3& p)const
  {untested();return (f3==p.f3 && f2==p.f2 && f1==p.f1 && f0==p.f0 && x==p.x);}
};
/*--------------------------------------------------------------------------*/
class SPLINE {
private:
  int _n;
  double* _x;
  double* _f0;
  double* _f1;
  double* _f2;
  double* _f3;
public:
  SPLINE(const std::vector<std::pair<double,double> >& table,
	 double d0, double dn);
  ~SPLINE();
  FPOLY1 at(double x)const;
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
